/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.storm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StormAnimationV2
extends AnimationHandler {
    private Map<Integer, PacketHologram> stormClouds = new HashMap<Integer, PacketHologram>();
    private List<PacketHologram> cloudLayers = new ArrayList<PacketHologram>();
    private int stormIntensity = 0;
    private List<Location> strikePattern = new ArrayList<Location>();
    private boolean storming = false;
    private List<PacketHologram> lightningRods = new ArrayList<PacketHologram>();

    public StormAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        this.setPlayerData(MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString()));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 8; ++j) {
                double d = (double)(j * 45) * Math.PI / 180.0;
                double d2 = 2.5 - (double)i * 0.3;
                Location location = this.getTargetLocation().clone().add(Math.cos(d) * d2 + 0.5, 5.0 + (double)i * 0.5, Math.sin(d) * d2 + 0.5);
                PacketHologram packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
                Material material = i == 0 ? Material.GRAY_WOOL : (i == 1 ? Material.LIGHT_GRAY_WOOL : Material.BLACK_WOOL);
                packetHologram.createEquipmentPacketHelmet(new ItemStack(material));
                packetHologram.setHeadPose(0.0f, j * 45, 0.0f);
                int n = i * 8 + j;
                this.stormClouds.put(n, packetHologram);
                this.cloudLayers.add(packetHologram);
                this.getAnimationHolograms().add(packetHologram);
                this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
        }
        this.createStrikePattern();
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.getCounter() < 40) {
            this.stormIntensity = Math.min(10, this.getCounter() / 4);
            int n = 0;
            for (Map.Entry<Integer, PacketHologram> location : this.stormClouds.entrySet()) {
                PacketHologram packetHologram2 = location.getValue();
                Location location2 = packetHologram2.getLocation();
                float f = 3.0f - (float)(n / 8) * 0.5f;
                location2.setYaw(location2.getYaw() + f);
                double d = this.getTargetLocation().getY() + 5.0 + (double)(n / 8) * 0.5 + Math.sin((double)this.getCounter() * 0.1 + (double)n) * 0.2;
                location2.setY(d);
                packetHologram2.teleport(location2);
                packetHologram2.createTeleportPacket();
                this.getPackets().add(packetHologram2.getTeleportPacket());
                packetHologram2.setHeadPose(0.0f, location.getKey() * 45 + this.getCounter() * 2, 0.0f);
                packetHologram2.createMetadataPacket();
                this.getPackets().add(packetHologram2.getMetadataPacket());
                if (this.getCounter() % 3 == 0) {
                    this.sendParticlesAndEffects(location2, null, "SMOKE_LARGE", 3);
                }
                ++n;
            }
            if (this.getCounter() % 15 == 0) {
                AnimationSound.PYRAMID_LIGHTNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
            }
            if (this.getCounter() % 2 == 0) {
                void packetHologram3;
                boolean i = false;
                while (packetHologram3 < 5) {
                    Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 5.0 + 0.5, 4.0, (Math.random() - 0.5) * 5.0 + 0.5);
                    this.sendParticlesAndEffects(location, null, "WATER_DROP", 5);
                    ++packetHologram3;
                }
            }
        } else if (this.getCounter() >= 40 && this.getCounter() < 100) {
            if (!this.storming) {
                this.storming = true;
                for (Location packetHologram4 : this.strikePattern) {
                    PacketHologram packetHologram3 = new PacketHologram("", packetHologram4.clone().add(0.0, -0.5, 0.0), packetHologram4.getY() - 0.5, this.getHandler());
                    packetHologram3.createEquipmentPacketHelmet(new ItemStack(Material.END_ROD));
                    packetHologram3.setHeadPose(0.0f, 0.0f, 180.0f);
                    this.lightningRods.add(packetHologram3);
                    this.getAnimationHolograms().add(packetHologram3);
                    this.getPackets().addAll(packetHologram3.getAllPackets(true));
                }
            }
            for (PacketHologram packetHologram4 : this.cloudLayers) {
                Location location = packetHologram4.getLocation();
                location.setYaw(location.getYaw() + 2.0f);
                packetHologram4.teleport(location);
                packetHologram4.createTeleportPacket();
                this.getPackets().add(packetHologram4.getTeleportPacket());
            }
            int n = (this.getCounter() - 40) / 10;
            if (n < this.strikePattern.size() && (this.getCounter() - 40) % 10 == 0) {
                void var3_22;
                Location location = this.strikePattern.get(n);
                if (n < this.lightningRods.size()) {
                    PacketHologram packetHologram5 = this.lightningRods.get(n);
                    packetHologram5.createEquipmentPacketHelmet(new ItemStack(Material.GLOWSTONE));
                    this.getPackets().addAll(packetHologram5.getEquipmentPacket());
                }
                this.getLightningPackets().add(this.getHandler().getLightningPacket(location));
                boolean bl = false;
                while (var3_22 < 3) {
                    void var4_26 = var3_22++;
                    this.sendParticlesAndEffects(location.clone().add(0.0, (double)var4_26, 0.0), null, "CRIT", 10);
                }
                this.sendParticlesAndEffects(location, null, "SMOKE_LARGE", 20);
                this.sendParticlesAndEffects(location, null, "FLAME", 10);
                if (n < this.getCrate().getSize()) {
                    List<Reward> list = this.getRandomRewards(1);
                    this.getRewards().addAll(list);
                    Reward reward = list.get(0);
                    Object object = this.getHandler().getEntityItem(location.clone().add(0.0, 1.0, 0.0), reward.getReward(), false, false);
                    this.getEntityItems().add(object);
                    this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                    this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                    this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
                    this.setSpawnItems(true);
                }
                AnimationSound.PYRAMID_LIGHTNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), location);
            }
        } else if (this.getCounter() >= 100 && this.getCounter() < 140) {
            if (this.getCounter() == 100) {
                this.lightningRods.forEach(packetHologram -> {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                    this.getPackets().add(packetHologram.getDestroyPacket());
                });
                new BukkitRunnable(){

                    public void run() {
                        StormAnimationV2.this.getCrate().getRewardsGiveQueue().put(StormAnimationV2.this.getTaskHelper().getUniqueOpeningID(), new GiveOutRewards(StormAnimationV2.this.getTaskHelper().getUniqueOpeningID(), StormAnimationV2.this.getPlayer(), StormAnimationV2.this.getRewards(), (Long)System.currentTimeMillis(), StormAnimationV2.this.getCrate()));
                        Utils.sendFinalMessages(StormAnimationV2.this.getCrate(), StormAnimationV2.this.getRewards(), StormAnimationV2.this.getPlayer());
                    }
                }.runTask((Plugin)MonthlyCrate.getInstance());
            }
            for (PacketHologram packetHologram6 : this.cloudLayers) {
                Location location = packetHologram6.getLocation();
                location.add(0.1, 0.05, 0.1);
                packetHologram6.teleport(location);
                packetHologram6.createTeleportPacket();
                this.getPackets().add(packetHologram6.getTeleportPacket());
                if (this.getCounter() != 139) continue;
                packetHologram6.setTimeToDestroy(true);
                packetHologram6.createDestroyPacket();
                this.getPackets().add(packetHologram6.getDestroyPacket());
            }
            if (this.getCounter() % 5 == 0) {
                Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 3.0 + 0.5, 3.0, (Math.random() - 0.5) * 3.0 + 0.5);
                this.sendParticlesAndEffects(location, null, "WATER_DROP", 2);
            }
        } else if (this.getCounter() >= 180) {
            this.clearRunnable();
        }
        this.counterIncrement();
        this.sendPackets();
        this.clearPackets();
    }

    private void createStrikePattern() {
        for (int i = 0; i < this.getCrate().getSize(); ++i) {
            double d = (double)i * (360.0 / (double)this.getCrate().getSize()) * Math.PI / 180.0;
            double d2 = 1.5 + (double)i * 0.2;
            Location location = this.getTargetLocation().clone().add(Math.cos(d) * d2 + 0.5, 0.0, Math.sin(d) * d2 + 0.5);
            this.strikePattern.add(location);
        }
    }

    public void clearRunnable() {
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null && !packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            }
        });
        if (this.getCrate().getDeletePacketForPlayer().containsKey(this.getPlayer())) {
            this.getCrate().getDeletePacketForPlayer().get(this.getPlayer()).addAll(this.getDestroyPackets());
        } else {
            this.getCrate().getDeletePacketForPlayer().put(this.getPlayer(), this.getDestroyPackets());
        }
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.getPlayer())) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.getPlayer());
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.getTargetLocation());
        --MonthlyCrate.GlobalCratesOpening;
        this.getPlayerData().setOpeningCrate(false, this.getTargetLocation());
        if (!this.getCrate().isRerollEnabled()) {
            this.getPlayerData().closeCrate();
        }
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }
}

