/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.split;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import com.cryptomorin.xseries.advancedcrates.XSound;
import com.cryptomorin.xseries.advancedcrates.particles.ParticleDisplay;
import com.cryptomorin.xseries.advancedcrates.particles.XParticle;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.locationHandler.LocationConfigInfo;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.SoundData;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SplitAnimation
extends BukkitRunnable {
    RepeatingTaskHelper taskHelper;
    private final Player pl;
    private final Location MainLoc;
    final String direction;
    private Crate crate;
    Set<Player> shownToPlayers = new HashSet<Player>();
    int proximityDistance = 5;
    int howFarShown = 5;
    private final INMSHandler handler;
    boolean individual = false;
    boolean all = false;
    Block block;
    HashMap<List<String>, List<Reward>> blacklistedPermissions;
    final Set<Reward> removeItems = new HashSet<Reward>();
    boolean rewardsDontRepeat = false;
    List<Reward> excludeRewards = new ArrayList<Reward>();
    List<PacketHologram> chestHolograms = new ArrayList<PacketHologram>();
    List<PacketHologram> rewardHolograms = new ArrayList<PacketHologram>();
    Location middleLoc;
    List<Location> locationsAroundMiddle = new ArrayList<Location>();
    List<Reward> guaranteedRewards = new ArrayList<Reward>();
    Map<PacketHologram, Location> locToGoAround = new HashMap<PacketHologram, Location>();
    List<PacketHologram> textHolograms = new ArrayList<PacketHologram>();
    boolean timeToSpawn = false;
    int soundHearingDistance = MonthlyCrate.soundsVolumes.getOrDefault("Sound_Hearing_Distance", 8);
    int index;
    int size = 0;
    private String uniqueOpeningID;
    private Set<Player> shownToPlayersAll = new HashSet<Player>();

    public SplitAnimation(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Material material, Crate crate, INMSHandler iNMSHandler, String string) {
        this.taskHelper = repeatingTaskHelper;
        this.uniqueOpeningID = this.taskHelper.getUniqueOpeningID();
        this.MainLoc = block.getLocation();
        this.direction = string;
        this.pl = player;
        this.handler = iNMSHandler;
        this.block = block;
        this.setCrate(crate);
        this.size = crate.getSize();
        if (this.size > 12) {
            this.size = 12;
        }
        this.guaranteedRewards.addAll(crate.getGuaranteedRewards());
        LocationConfigInfo locationConfigInfo = MonthlyCrate.getLocationHandler().getLocationInfo("world=" + block.getWorld().getName() + ",x=" + block.getLocation().getX() + ",y=" + block.getLocation().getY() + ",z=" + block.getLocation().getZ());
        if (locationConfigInfo != null) {
            string = locationConfigInfo.getDirection();
        }
        this.middleLoc = string.equalsIgnoreCase("South") ? this.MainLoc.clone().add(0.5, 0.0, -2.5) : (string.equalsIgnoreCase("East") ? this.MainLoc.clone().add(-2.5, 0.0, 0.5) : (string.equalsIgnoreCase("North") ? this.MainLoc.clone().add(0.5, 0.0, 3.5) : this.MainLoc.clone().add(3.5, 0.0, 0.5)));
        this.locationsAroundMiddle = Utils.getAllLocationsAroundCircle(this.middleLoc, 3.0);
        Location location = new Location(this.MainLoc.getWorld(), this.MainLoc.getX() + 0.5, this.MainLoc.getY() - 1.35, this.MainLoc.getZ() + 0.5);
        Vector vector = this.middleLoc.toVector().clone().subtract(location.toVector());
        location.setDirection(vector);
        for (int i = 0; i < 13; ++i) {
            this.chestHolograms.add(new PacketHologram("", location, location.getY(), iNMSHandler));
            this.chestHolograms.get(i).createEquipmentPacketHelmet(new ItemStack(Material.CHEST));
            this.chestHolograms.get(i).teleport(location);
            this.chestHolograms.get(i).createTeleportPacket();
        }
        Location location2 = this.locationsAroundMiddle.get(0);
        double d = location2.distanceSquared(this.MainLoc.clone().add(0.5, 0.0, 0.5));
        for (Location object : this.locationsAroundMiddle) {
            if (!(object.distanceSquared(this.MainLoc.clone().add(0.5, 0.0, 0.5)) < d)) continue;
            location2 = object;
            d = object.distanceSquared(this.MainLoc.clone().add(0.5, 0.0, 0.5));
        }
        this.index = this.locationsAroundMiddle.indexOf(location2);
        this.individual = crate.getVisibilityOption().equalsIgnoreCase("Individual") || crate.getVisibilityOption().equalsIgnoreCase("Opener");
        this.all = crate.getVisibilityOption().equalsIgnoreCase("All");
        this.howFarShown = MonthlyCrate.howFarShownPackets * MonthlyCrate.howFarShownPackets;
        this.proximityDistance = crate.getProximity() * crate.getProximity();
        this.rewardsDontRepeat = crate.getRewardsDontRepeat();
        this.blacklistedPermissions = crate.getBlacklistedPermissions();
        block2: for (List list : this.blacklistedPermissions.keySet()) {
            for (String string2 : list) {
                if (!player.hasPermission(string2)) continue;
                this.removeItems.addAll((Collection<Reward>)this.blacklistedPermissions.get(list));
                continue block2;
            }
        }
        this.excludeRewards.clear();
        this.excludeRewards.addAll(this.removeItems);
        new BukkitRunnable(){

            public void run() {
                if (SplitAnimation.this.taskHelper != null) {
                    Bukkit.getScheduler().cancelTask(SplitAnimation.this.taskHelper.getTaskID());
                }
            }
        }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 4200L);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        Object object;
        if (this.taskHelper.getCounter() > 0 && this.taskHelper.getCounter() < 17) {
            this.chestHolograms.forEach(packetHologram -> {
                packetHologram.teleport(packetHologram.getLocation().clone().add(0.0, 0.084375, 0.0));
                packetHologram.createTeleportPacket();
            });
        } else if (this.taskHelper.getCounter() >= 17 && this.taskHelper.getCounter() < 57) {
            int n2;
            for (n2 = (int)(1.0 + (double)(this.taskHelper.getCounter() - 16) / 6.65); n2 < 7; ++n2) {
                int n = this.index + (int)Math.ceil(4.6 * (double)(this.taskHelper.getCounter() - 16));
                if (n > this.locationsAroundMiddle.size()) {
                    n -= this.locationsAroundMiddle.size();
                } else if (n < 0) {
                    n += this.locationsAroundMiddle.size();
                }
                this.chestHolograms.get(n2).teleport(this.locationsAroundMiddle.get(n));
                this.chestHolograms.get(n2).createTeleportPacket();
            }
            for (n2 = (int)(7.0 + (double)(this.taskHelper.getCounter() - 16) / 6.65); n2 < 13; ++n2) {
                int i = this.index + (int)((double)(this.locationsAroundMiddle.size() - 1) - Math.ceil(4.6 * (double)(this.taskHelper.getCounter() - 16)));
                if (i > this.locationsAroundMiddle.size()) {
                    i -= this.locationsAroundMiddle.size();
                } else if (i < 0) {
                    i += this.locationsAroundMiddle.size();
                }
                this.chestHolograms.get(n2).teleport(this.locationsAroundMiddle.get(i));
                this.chestHolograms.get(n2).createTeleportPacket();
            }
        } else if (this.taskHelper.getCounter() >= 57 && this.taskHelper.getCounter() < 77) {
            Collection<PacketHologram> collection;
            if (this.taskHelper.getCounter() == 57) {
                void packetHologram3;
                Object object2 = this.chestHolograms.get(12).getLocation().toString();
                boolean bl = false;
                while (packetHologram3 < this.size) {
                    if (!this.guaranteedRewards.isEmpty()) {
                        object = this.guaranteedRewards.get(ThreadLocalRandom.current().nextInt(0, this.guaranteedRewards.size()));
                        this.guaranteedRewards.remove(object);
                    } else {
                        object = this.crate.getRandomRewardLow((List<Reward>)(this.rewardsDontRepeat ? this.excludeRewards : new ArrayList<Reward>(this.removeItems)));
                    }
                    if (this.rewardsDontRepeat) {
                        this.excludeRewards.add((Reward)object);
                    }
                    collection = new ArrayList<PacketHologram>(this.chestHolograms);
                    collection.removeAll(this.rewardHolograms);
                    int n = collection.size() > 1 ? ThreadLocalRandom.current().nextInt(0, collection.size() - 1) : 0;
                    PacketHologram packetHologram2 = (PacketHologram)collection.get(n);
                    if (object2 != null && packetHologram2.getLocation().toString().equalsIgnoreCase((String)object2)) {
                        if (this.chestHolograms.indexOf(packetHologram2) == this.chestHolograms.size() - 1) {
                            this.chestHolograms.get(this.chestHolograms.size() - 2).setTimeToDestroy(true);
                        } else {
                            this.chestHolograms.get(this.chestHolograms.size() - 1).setTimeToDestroy(true);
                        }
                        object2 = null;
                    }
                    this.rewardHolograms.add(packetHologram2);
                    packetHologram2.setReward((Reward)object);
                    ++packetHologram3;
                }
            }
            if (this.taskHelper.getCounter() >= 70 && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                for (PacketHologram n3 : this.rewardHolograms) {
                    object = ParticleDisplay.simple(n3.getLocation().clone().add(0.0, 4.0 - ((double)this.taskHelper.getCounter() - 57.0) / 10.0, 0.0), MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3) ? Particle.valueOf((String)"ENCHANTMENT_TABLE") : Particle.valueOf((String)"ENCHANT"));
                    collection = this.getNearbyEntities();
                    if (collection.isEmpty()) continue;
                    XParticle.circle(0.8, 50.0, (ParticleDisplay)object, new ArrayList<PacketHologram>(collection));
                }
            }
        } else if (this.taskHelper.getCounter() >= 77 && this.taskHelper.getCounter() < 117) {
            int n;
            if (this.taskHelper.getCounter() < 90) {
                for (PacketHologram n4 : this.rewardHolograms) {
                    if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                        object = ParticleDisplay.simple(n4.getLocation().clone().add(0.0, 4.0 - ((double)this.taskHelper.getCounter() - 57.0) / 10.0, 0.0), MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3) ? Particle.valueOf((String)"ENCHANTMENT_TABLE") : Particle.valueOf((String)"ENCHANT"));
                        XParticle.circle(0.8, 50.0, (ParticleDisplay)object, new ArrayList<Player>(this.getNearbyEntities()));
                    }
                    if (this.taskHelper.getCounter() != 83) continue;
                    n4.createEquipmentPacketHelmet(new ItemStack(Material.AIR));
                    if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                        this.sendParticlesAndEffects(n4.getLocation(), "SMOKE", null, 10);
                    }
                    if (Utils.checkIfContainsTools(n4.getReward().getReward().getType())) {
                        n4.setRightArmPose(260.0f, 315.0f, 0.0f);
                        n4.setItemOnHead(new ItemStack(Material.STICK));
                        continue;
                    }
                    if (Utils.checkIfContainsItems(n4.getReward().getReward().getType())) {
                        n4.setRightArmPose(275.0f, 320.0f, 0.0f);
                        continue;
                    }
                    if (n4.getReward().getReward() == null) continue;
                    n4.setRightArmPose(350.0f, 325.0f, 345.0f);
                }
            }
            if (this.taskHelper.getCounter() == 90) {
                for (PacketHologram packetHologram6 : this.rewardHolograms) {
                    this.locToGoAround.put(packetHologram6, Utils.getLocationAroundCircle(this.pl.getLocation().clone().add(0.0, packetHologram6.getItemOnHead() != null ? -0.54 : 0.0, 0.0), 2.3f, 0.0, this.rewardHolograms.size(), this.rewardHolograms.indexOf(packetHologram6)));
                    packetHologram6.createMetadataPacket();
                    packetHologram6.teleport(this.locToGoAround.get(packetHologram6));
                    packetHologram6.createTeleportPacket();
                }
            }
            if (this.taskHelper.getCounter() >= 86 && this.taskHelper.getCounter() < 112 && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                for (Location location : this.locToGoAround.values()) {
                    object = ParticleDisplay.simple(location.clone().add(0.0, 4.3 - ((double)this.taskHelper.getCounter() - 77.0) / 10.0, 0.0), MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3) ? Particle.valueOf((String)"ENCHANTMENT_TABLE") : Particle.valueOf((String)"ENCHANT"));
                    XParticle.circle(0.8, 50.0, (ParticleDisplay)object, new ArrayList<Player>(this.getNearbyEntities()));
                }
            }
            if (this.taskHelper.getCounter() >= 103) {
                for (PacketHologram packetHologram3 : this.rewardHolograms) {
                    packetHologram3.teleport(Utils.getLocationAroundCircle(this.locToGoAround.get(packetHologram3), 0.4355f, 0.2176 * (double)this.taskHelper.getCounter() * 2.0, 1, 0));
                    packetHologram3.createTeleportPacket();
                }
                if (this.taskHelper.getCounter() == 103) {
                    for (PacketHologram packetHologram4 : this.rewardHolograms) {
                        if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                            this.sendParticlesAndEffects(packetHologram4.getLocation(), "SMOKE", null, 10);
                        }
                        packetHologram4.createEquipmentPacket(packetHologram4.getReward().getReward());
                        this.textHolograms.add(new PacketHologram(packetHologram4.getReward().getItemBuilder().getDisplayName(), this.locToGoAround.get(packetHologram4), this.locToGoAround.get(packetHologram4).getY() + (packetHologram4.getItemOnHead() != null ? 2.14 : 1.6), this.handler));
                    }
                    this.timeToSpawn = true;
                }
            }
            for (n = (int)(6.0 - (this.taskHelper.getCounter() <= 81 ? 0.0 : ((double)this.taskHelper.getCounter() - 81.5) / 6.65)); n < 7; ++n) {
                if (this.rewardHolograms.contains(this.chestHolograms.get(n))) continue;
                int n2 = this.index + ((int)((double)(this.locationsAroundMiddle.size() - 1) - Math.ceil(4.6 * (double)(this.taskHelper.getCounter() - 36))) < 0 ? 0 : (int)((double)(this.locationsAroundMiddle.size() - 1) - Math.ceil(4.6 * (double)(this.taskHelper.getCounter() - 36))));
                if (n2 > this.locationsAroundMiddle.size()) {
                    n2 -= this.locationsAroundMiddle.size();
                } else if (n2 < 0) {
                    n2 += this.locationsAroundMiddle.size();
                }
                this.chestHolograms.get(n).teleport(this.locationsAroundMiddle.get(n2));
                this.chestHolograms.get(n).createTeleportPacket();
            }
            for (n = (int)(12.0 - (this.taskHelper.getCounter() <= 81 ? 0.0 : ((double)this.taskHelper.getCounter() - 81.5) / 6.65)); n < 13; ++n) {
                if (this.rewardHolograms.contains(this.chestHolograms.get(n))) continue;
                int n3 = this.index + ((int)Math.ceil(4.6 * (double)(this.taskHelper.getCounter() - 36)) > 360 ? 0 : (int)Math.ceil(4.6 * (double)(this.taskHelper.getCounter() - 36)));
                if (n3 > this.locationsAroundMiddle.size()) {
                    n3 -= this.locationsAroundMiddle.size();
                } else if (n3 < 0) {
                    n3 += this.locationsAroundMiddle.size();
                }
                this.chestHolograms.get(n).teleport(this.locationsAroundMiddle.get(n3));
                this.chestHolograms.get(n).createTeleportPacket();
            }
        } else if (this.taskHelper.getCounter() >= 117 && this.taskHelper.getCounter() < 133) {
            this.chestHolograms.forEach(packetHologram -> {
                if (!this.rewardHolograms.contains(packetHologram)) {
                    packetHologram.teleport(packetHologram.getLocation().clone().add(0.0, -0.084375, 0.0));
                    packetHologram.createTeleportPacket();
                }
            });
        }
        if (this.taskHelper.getCounter() >= 117 && this.taskHelper.getCounter() < 146) {
            for (PacketHologram packetHologram5 : this.rewardHolograms) {
                this.locToGoAround.put(packetHologram5, Utils.getLocationAroundCircle(this.pl.getLocation().clone().add(0.0, packetHologram5.getItemOnHead() != null ? -0.54 : 0.0, 0.0), 2.3f, 0.1 * (double)(this.taskHelper.getCounter() - 117), this.rewardHolograms.size(), this.rewardHolograms.indexOf(packetHologram5)));
                packetHologram5.teleport(Utils.getLocationAroundCircle(this.locToGoAround.get(packetHologram5), 0.4355f, 0.2176 * (double)(this.taskHelper.getCounter() - 117) * 2.0, 1, 0));
                packetHologram5.createTeleportPacket();
                this.textHolograms.get(this.rewardHolograms.indexOf(packetHologram5)).teleport(this.locToGoAround.get(packetHologram5).clone().add(0.0, packetHologram5.getItemOnHead() != null ? 2.14 : 1.6, 0.0));
                this.textHolograms.get(this.rewardHolograms.indexOf(packetHologram5)).createTeleportPacket();
            }
        }
        if (this.taskHelper.getCounter() >= 146 && this.taskHelper.getCounter() < 190) {
            for (PacketHologram packetHologram6 : this.rewardHolograms) {
                this.locToGoAround.put(packetHologram6, Utils.getLocationAroundCircle(this.pl.getLocation().clone().add(0.0, packetHologram6.getItemOnHead() != null ? -0.54 : 0.0, 0.0), 2.3f, 0.1 * (double)(this.taskHelper.getCounter() - 117), this.rewardHolograms.size(), this.rewardHolograms.indexOf(packetHologram6)));
                packetHologram6.teleport(Utils.getLocationAroundCircle(this.locToGoAround.get(packetHologram6), 0.4355f, 0.2176 * (double)(this.taskHelper.getCounter() - 117) * 2.0, 1, 0));
                packetHologram6.createTeleportPacket();
                this.textHolograms.get(this.rewardHolograms.indexOf(packetHologram6)).teleport(this.locToGoAround.get(packetHologram6).clone().add(0.0, packetHologram6.getItemOnHead() != null ? 2.14 : 1.6, 0.0));
                this.textHolograms.get(this.rewardHolograms.indexOf(packetHologram6)).createTeleportPacket();
            }
        } else if (this.taskHelper.getCounter() == 190) {
            this.rewardHolograms.forEach(packetHologram -> {
                Reward reward = packetHologram.getReward();
            });
            this.textHolograms.forEach(packetHologram -> packetHologram.setTimeToDestroy(true));
            this.chestHolograms.forEach(packetHologram -> packetHologram.setTimeToDestroy(true));
            this.sendPackets();
            this.clearRunnable();
            return;
        }
        this.taskHelper.increment();
        this.sendPackets();
    }

    public Location getMainLoc() {
        return this.MainLoc;
    }

    public void clearRunnable() {
        if (this.crate.getDeletePacketForPlayer().containsKey(this.pl)) {
            this.crate.getDeletePacketForPlayer().get(this.pl).addAll(this.getDestroyPackets());
        } else {
            this.crate.getDeletePacketForPlayer().put(this.pl, this.getDestroyPackets());
        }
        new BukkitRunnable(){

            public void run() {
                ArrayList<Reward> arrayList = new ArrayList<Reward>();
                SplitAnimation.this.rewardHolograms.forEach(packetHologram -> arrayList.add(packetHologram.getReward()));
                SplitAnimation.this.crate.getRewardsGiveQueue().put(SplitAnimation.this.uniqueOpeningID, new GiveOutRewards(SplitAnimation.this.uniqueOpeningID, SplitAnimation.this.pl, arrayList, (Long)System.currentTimeMillis(), SplitAnimation.this.crate));
                Utils.sendFinalMessages(SplitAnimation.this.crate, arrayList, SplitAnimation.this.pl);
            }
        }.runTask((Plugin)MonthlyCrate.getInstance());
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.pl)) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.pl);
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.MainLoc);
        Location location = (MonthlyCrate.sounds.containsKey("Quick_Animation_Sounds.On_Crate_Disappear") ? MonthlyCrate.sounds.get("Quick_Animation_Sounds.On_Crate_Disappear") : new ArrayList()).iterator();
        while (location.hasNext()) {
            String string = (String)location.next();
            if (string == null || string.isEmpty()) continue;
            SoundData soundData = new SoundData(XSound.matchXSound(string).get(), MonthlyCrate.soundsVolumes.get("Quick_Animation_Sounds.On_Crate_Disappear_Volume").intValue(), MonthlyCrate.soundsVolumes.get("Quick_Animation_Sounds.On_Crate_Disappear_Pitch").intValue());
            HashSet<Player> hashSet = new HashSet<Player>(this.getNearbyEntitiesSounds());
            if (this.pl != null && this.pl.isOnline()) {
                hashSet.add(this.pl);
            }
            hashSet.forEach(player -> soundData.playTo((Player)player, this.MainLoc));
        }
        if (this.crate.getHiddenHologramsLocations().containsKey(this.pl.getUniqueId()) && this.crate.getHiddenHologramsLocations().get(this.pl.getUniqueId()).contains(this.MainLoc)) {
            if (this.crate.getUnhideHologramLocations().containsKey(this.pl.getUniqueId())) {
                this.crate.getUnhideHologramLocations().get(this.pl.getUniqueId()).add(this.MainLoc);
            } else {
                this.crate.getUnhideHologramLocations().put(this.pl.getUniqueId(), new HashSet<Location>(Arrays.asList(this.MainLoc)));
            }
        }
        this.shownToPlayers.forEach(player -> this.unhidePublicHolograms((Player)player));
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) ? this.MainLoc.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial() : this.MainLoc.getBlock().getType() == Material.valueOf((String)"SKULL_ITEM")) {
            this.handler.sendPlayerHeadTexturePacket(this.pl, this.MainLoc);
        } else if (!this.crate.getItemsAdderEntityMap().containsKey(this.block.getLocation().toString())) {
            this.pl.sendBlockChange(this.block.getLocation(), this.block.getType(), this.block.getData());
        } else {
            this.crate.getItemsAdderEntityMap().get(this.block.getLocation().toString()).sendShowPacket(this.pl);
        }
        --MonthlyCrate.GlobalCratesOpening;
        if (!this.crate.getDisplayType().isEmpty() && (this.crate.getDisplayType().equalsIgnoreCase("NPC") || this.crate.getDisplayType().equalsIgnoreCase("MOB"))) {
            this.crate.getDynamicCratePlaceholder().place(this.MainLoc);
        }
        if (MonthlyCrate.PlayersPlacedCrates.containsKey(this.pl.getUniqueId()) && MonthlyCrate.PlayersPlacedCrates.get(this.pl.getUniqueId()) != 0) {
            MonthlyCrate.PlayersPlacedCrates.put(this.pl.getUniqueId(), MonthlyCrate.PlayersPlacedCrates.get(this.pl.getUniqueId()) - 1);
        }
        if (!MonthlyCrate.CratesLocations.remove(location = this.MainLoc.clone().add(-0.2, 0.0, 0.7))) {
            for (int i = 0; i < MonthlyCrate.CratesLocations.size(); ++i) {
                if (!MonthlyCrate.CratesLocations.get(i).getWorld().getName().equalsIgnoreCase(location.getWorld().getName()) || !(MonthlyCrate.CratesLocations.get(i).distance(location) < 0.01)) continue;
                MonthlyCrate.CratesLocations.remove(MonthlyCrate.CratesLocations.get(i));
                break;
            }
        }
        PlayerData playerData = MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(this.pl.getUniqueId().toString());
        playerData.setOpeningCrate(false, this.MainLoc);
        if (!this.crate.isRerollEnabled()) {
            playerData.closeCrate();
        }
        if (this.crate.getDeletePacketForPlayer().containsKey(this.pl)) {
            this.crate.getDeletePacketForPlayer().get(this.pl).addAll(this.getDestroyPackets());
        } else {
            this.crate.getDeletePacketForPlayer().put(this.pl, this.getDestroyPackets());
        }
        if (this.taskHelper != null) {
            Bukkit.getScheduler().cancelTask(this.taskHelper.getTaskID());
        }
    }

    public void unhidePublicHolograms(Player player) {
        if (this.crate.getHiddenHologramsLocations().containsKey(player.getUniqueId()) && this.crate.getHiddenHologramsLocations().get(player.getUniqueId()).contains(this.MainLoc)) {
            if (this.crate.getUnhideHologramLocations().containsKey(player.getUniqueId()) && !this.crate.getUnhideHologramLocations().get(player.getUniqueId()).contains(this.MainLoc)) {
                this.crate.getUnhideHologramLocations().get(player.getUniqueId()).add(this.MainLoc);
            } else {
                this.crate.getUnhideHologramLocations().put(player.getUniqueId(), new HashSet<Location>(Arrays.asList(this.MainLoc)));
            }
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) ? this.MainLoc.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial() : this.MainLoc.getBlock().getType() == Material.valueOf((String)"SKULL_ITEM")) {
            this.handler.sendPlayerHeadTexturePacket(this.pl, this.MainLoc);
        } else if (!this.crate.getItemsAdderEntityMap().containsKey(this.block.getLocation().toString())) {
            this.pl.sendBlockChange(this.block.getLocation(), this.block.getType(), this.block.getData());
        } else {
            this.crate.getItemsAdderEntityMap().get(this.block.getLocation().toString()).sendShowPacket(this.pl);
        }
    }

    public Set<Player> getNearbyEntitiesSounds() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.MainLoc.getWorld() || !((d = this.MainLoc.distanceSquared(player.getLocation())) < (double)this.soundHearingDistance)) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public void setCrate(Crate crate) {
        this.crate = crate;
    }

    public void sendPackets() {
        Set<Player> set = this.getNearbyEntities();
        if (this.pl != null && this.pl.isOnline()) {
            set.add(this.pl);
        }
        set.forEach(player -> {
            if (player != null && player.isOnline()) {
                if (this.shownToPlayers.contains(player)) {
                    this.getAllHolograms().forEach(packetHologram -> {
                        if (this.timeToSpawn && this.textHolograms.contains(packetHologram)) {
                            packetHologram.sendAllPackets((Player)player, true);
                        } else if (packetHologram.isTimeToDestroy()) {
                            this.handler.sendPacket((Player)player, packetHologram.getDestroyPacket());
                        } else {
                            packetHologram.sendAllPackets((Player)player);
                        }
                    });
                } else {
                    this.getAllHolograms().forEach(packetHologram -> {
                        if (this.timeToSpawn && this.textHolograms.contains(packetHologram)) {
                            packetHologram.sendAllPackets((Player)player, true);
                        } else if (packetHologram.isTimeToDestroy()) {
                            this.handler.sendPacket((Player)player, packetHologram.getDestroyPacket());
                        } else {
                            packetHologram.sendAllPackets((Player)player, true);
                        }
                    });
                    this.shownToPlayers.add((Player)player);
                }
            }
        });
        if (this.timeToSpawn) {
            this.timeToSpawn = false;
        }
        List<Object> list = this.getDestroyPackets();
        ArrayList arrayList = new ArrayList();
        this.shownToPlayers.forEach(player -> {
            Player player2;
            if (player != null && player.isOnline() && !set.contains(player2 = player)) {
                if (this.block.getType() == Material.AIR || this.block.getType() == XMaterial.BARRIER.parseMaterial()) {
                    if (!this.crate.getItemsAdderEntityMap().containsKey(this.block.getLocation().toString())) {
                        player2.sendBlockChange(this.block.getLocation(), this.block.getType(), this.block.getData());
                    } else {
                        this.crate.getItemsAdderEntityMap().get(this.block.getLocation().toString()).sendShowPacket(player2);
                    }
                }
                list.forEach(object -> this.handler.sendPacket(player2, object));
                arrayList.add(player);
            }
        });
        this.shownToPlayersAll.addAll(this.shownToPlayers);
        this.shownToPlayers.removeAll(arrayList);
    }

    public List<PacketHologram> getAllHolograms() {
        ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
        arrayList.addAll(this.chestHolograms);
        arrayList.addAll(this.textHolograms);
        return arrayList;
    }

    public Set<Player> getNearbyEntities() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.MainLoc.getWorld() || !((d = this.MainLoc.distanceSquared(player.getLocation())) < (double)this.howFarShown) || !(d > (double)this.proximityDistance) && !this.all) continue;
            hashSet.add(player);
        }
        hashSet.add(this.pl);
        return hashSet;
    }

    public void sendParticlesAndEffects(Location location, String string, String string2, int n) {
        Set<Player> set = this.getNearbyEntities();
        if (this.pl != null && this.pl.isOnline()) {
            set.add(this.pl);
        }
        set.forEach(player -> {
            if (player != null && player.isOnline()) {
                if (string != null) {
                    player.playEffect(location, Effect.valueOf((String)string), n);
                } else {
                    player.spawnParticle(Particle.valueOf((String)string2), location, n);
                }
            }
        });
    }

    public List<Object> getDestroyPackets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getAllHolograms().forEach(packetHologram -> arrayList.add(packetHologram.getDestroyPacket()));
        return arrayList;
    }
}

