/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.round;

import com.cryptomorin.xseries.advancedcrates.XSound;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.SoundData;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Round2Ending
extends BukkitRunnable {
    RepeatingTaskHelper taskhelper;
    Location toWhere;
    String crateName;
    List<PacketHologram> stands = null;
    PacketHologram stand = null;
    PacketHologram smallStand = null;
    List<Location> locations = new ArrayList<Location>();
    Player pl;
    Location standLoc;
    Crate crate;
    final ItemStack item;
    INMSHandler handler;
    double addY = 0.0;
    Float yaw = Float.valueOf(0.0f);
    int whichStandHas;
    double smallStandY = 0.8;
    Location blockLoc;
    int howFarShown = 64;
    int proximityDistance;
    Set<Player> shownToPlayers;
    boolean individual = false;
    boolean all = false;
    int soundHearingDistance = MonthlyCrate.soundsVolumes.getOrDefault("Sound_Hearing_Distance", 8);
    Reward reward;
    private String uniqueOpeningID;
    private double randomNumber = 1.0;

    public Round2Ending(RepeatingTaskHelper repeatingTaskHelper, String string, Location location, List<PacketHologram> list, PacketHologram packetHologram2, Player player, Reward reward, Crate crate, Location location2, INMSHandler iNMSHandler, int n, Location location3, int n2, Set<Player> set, double d) {
        this.taskhelper = repeatingTaskHelper;
        this.uniqueOpeningID = this.taskhelper.getUniqueOpeningID();
        this.toWhere = location;
        this.randomNumber = d;
        this.crateName = string;
        this.stands = list;
        this.smallStand = packetHologram2;
        this.reward = reward;
        this.pl = player;
        this.item = reward.getReward();
        this.crate = crate;
        this.individual = crate.getVisibilityOption().equalsIgnoreCase("Individual") || crate.getVisibilityOption().equalsIgnoreCase("Opener");
        this.all = crate.getVisibilityOption().equalsIgnoreCase("All");
        this.howFarShown = MonthlyCrate.howFarShownPackets * MonthlyCrate.howFarShownPackets;
        n2 = crate.getProximity() * crate.getProximity();
        this.standLoc = location2;
        this.handler = iNMSHandler;
        this.whichStandHas = n;
        this.stand = this.stands.stream().filter(packetHologram -> packetHologram.getItemInHand() != null && packetHologram.getItemInHand().getType() != Material.AIR).findAny().get();
        this.blockLoc = location3;
        this.shownToPlayers = set;
        this.addY = n == 0 ? -1.45 : (n == 1 ? -1.2 : -0.46);
        this.yaw = Float.valueOf(this.stand.getLocation().getYaw());
        this.locations = MonthlyCrate.getLocationsToBlock(this.stand.getLocation(), location.add(0.0, this.addY / 2.0, 0.0), 21);
        for (Location location4 : this.locations) {
            location4.setYaw(this.yaw.floatValue());
        }
    }

    public Round2Ending(RepeatingTaskHelper repeatingTaskHelper, String string, Location location, List<PacketHologram> list, PacketHologram packetHologram, Player player, Reward reward, Crate crate, Location location2, INMSHandler iNMSHandler, int n, double d, Location location3, int n2, Set<Player> set, double d2) {
        this(repeatingTaskHelper, string, location, list, packetHologram, player, reward, crate, location2, iNMSHandler, n, location3, n2, set, d2);
        this.smallStandY = d;
        new BukkitRunnable(){

            public void run() {
                if (Round2Ending.this.taskhelper != null) {
                    Bukkit.getScheduler().cancelTask(Round2Ending.this.taskhelper.getTaskID());
                }
            }
        }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 4200L);
    }

    public void run() {
        if (this.taskhelper.getCounter() >= 21) {
            new BukkitRunnable(){

                public void run() {
                    for (String string : MonthlyCrate.sounds.get("Round2_Animation_Sounds.On_Spinning_Stop")) {
                        if (string == null || string.isEmpty()) continue;
                        SoundData soundData = new SoundData(XSound.matchXSound(string).get(), MonthlyCrate.soundsVolumes.get("Round2_Animation_Sounds.On_Spinning_Stop_Volume").intValue(), MonthlyCrate.soundsVolumes.get("Round2_Animation_Sounds.On_Spinning_Stop_Pitch").intValue());
                        Round2Ending.this.getNearbyEntitiesSounds().forEach(player -> soundData.playTo((Player)player, Round2Ending.this.standLoc));
                    }
                }
            }.runTaskAsynchronously((Plugin)MonthlyCrate.getInstance());
            this.crate.getRewardsGiveQueue().put(this.uniqueOpeningID, new GiveOutRewards(this.uniqueOpeningID, this.pl, this.reward, this.randomNumber, (Long)System.currentTimeMillis(), this.crate));
            this.stands.forEach(packetHologram -> {
                packetHologram.createDestroyPacket();
                packetHologram.setTimeToDestroy(true);
            });
            this.smallStand.createDestroyPacket();
            this.smallStand.setTimeToDestroy(true);
            this.sendPackets();
            this.clear();
            return;
        }
        this.stands.get(this.whichStandHas).teleport(this.locations.get(this.taskhelper.getCounter()));
        this.stands.get(this.whichStandHas).createTeleportPacket();
        this.smallStand.teleport(this.locations.get(this.taskhelper.getCounter()).clone().add(0.0, this.addY * -1.0 + this.smallStandY, 0.0));
        this.smallStand.createTeleportPacket();
        this.taskhelper.increment();
        this.sendPackets();
    }

    public void sendPackets() {
        CopyOnWriteArrayList<Player> copyOnWriteArrayList = new CopyOnWriteArrayList<Player>(this.getNearbyEntities());
        if (this.pl != null && this.pl.isOnline()) {
            copyOnWriteArrayList.add(this.pl);
        }
        List<List<Player>> list = this.partitionPlayers(new ArrayList<Player>(copyOnWriteArrayList), 10);
        list.forEach(this::processPlayerSublist);
        HashSet hashSet = new HashSet();
        this.shownToPlayers.stream().filter(player -> player != null && player.isOnline() && !copyOnWriteArrayList.contains(player)).forEach(hashSet::add);
        this.shownToPlayers.removeAll(hashSet);
    }

    private List<List<Player>> partitionPlayers(List<Player> list, int n) {
        return list.size() <= n ? Arrays.asList(list) : Lists.partition(list, (int)n);
    }

    private void processPlayerSublist(final List<Player> list) {
        new BukkitRunnable(){

            public void run() {
                list.forEach(player -> {
                    if (player != null && player.isOnline()) {
                        Round2Ending.this.processPlayer(player);
                    }
                });
            }
        }.runTaskAsynchronously((Plugin)MonthlyCrate.getInstance());
    }

    private void processPlayer(Player player) {
        if (this.shownToPlayers.contains(player)) {
            this.getAllHolograms().forEach(packetHologram -> {
                if (packetHologram.isTimeToDestroy()) {
                    this.handler.sendPacket(player, packetHologram.getDestroyPacket());
                } else {
                    packetHologram.sendAllPackets(player);
                }
            });
        } else {
            this.getAllHolograms().forEach(packetHologram -> {
                if (!packetHologram.isTimeToDestroy()) {
                    packetHologram.sendAllPackets(player, true);
                }
            });
            this.shownToPlayers.add(player);
        }
    }

    public List<PacketHologram> getAllHolograms() {
        ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
        arrayList.addAll(this.stands);
        arrayList.add(this.smallStand);
        return arrayList;
    }

    public Set<Player> getNearbyEntitiesSounds() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.blockLoc.getWorld() || !((d = this.blockLoc.distanceSquared(player.getLocation())) < (double)this.soundHearingDistance)) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    public void clear() {
        this.getAllHolograms().forEach(packetHologram -> packetHologram.getLivingEntity().remove());
        if (this.taskhelper != null) {
            Bukkit.getScheduler().cancelTask(this.taskhelper.getTaskID());
            this.taskhelper = null;
        }
    }

    public Set<Player> getNearbyEntities() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.blockLoc.getWorld() || !((d = this.blockLoc.distanceSquared(player.getLocation())) < (double)this.howFarShown) || !(d > (double)this.proximityDistance) && !this.all) continue;
            hashSet.add(player);
        }
        return hashSet;
    }
}

