/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PortalAnimationV2
extends AnimationHandler {
    private final List<PacketHologram> portalRings = new ArrayList<PacketHologram>();
    private final List<PacketHologram> rewardHolograms = new ArrayList<PacketHologram>();
    private double portalRadius = 0.1;
    private int portalPhase = 0;
    private final Map<Integer, Location> rewardLocations = new HashMap<Integer, Location>();

    public PortalAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        for (int i = 0; i < 3; ++i) {
            Location location = this.getTargetLocation().clone().add(0.5, 0.5 + (double)i * 0.7, 0.5);
            PacketHologram packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.ENDER_EYE));
            this.portalRings.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.prepareRewardLocations();
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimer((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 60) {
            int n;
            this.portalRadius = Math.min(2.5, this.portalRadius + 0.05);
            for (n = 0; n < this.portalRings.size(); ++n) {
                PacketHologram packetHologram2 = this.portalRings.get(n);
                double d = Math.toRadians(this.getCounter() * 6 + n * 120);
                double d2 = Math.cos(d) * this.portalRadius;
                double d3 = Math.sin(d) * this.portalRadius;
                Location location = this.getTargetLocation().clone().add(d2 + 0.5, 0.5 + (double)n * 0.7, d3 + 0.5);
                packetHologram2.teleport(location);
                packetHologram2.createTeleportPacket();
            }
            if (this.getCounter() % 2 == 0) {
                for (n = 0; n < 8; ++n) {
                    double d = Math.toRadians(n * 45);
                    Location location = this.getTargetLocation().clone().add(Math.cos(d) * this.portalRadius + 0.5, 1.5, Math.sin(d) * this.portalRadius + 0.5);
                    this.sendParticlesAndEffects(location, null, "PORTAL", 5);
                }
            }
            if (this.getCounter() % 20 == 0) {
                AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
            }
        } else if (this.getCounter() >= 60 && this.getCounter() < 160) {
            Object object;
            PacketHologram packetHologram32;
            Object object2;
            int n;
            if (this.portalPhase == 0) {
                this.portalPhase = 1;
                if (this.getRewards().isEmpty()) {
                    this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
                }
                for (n = 0; n < this.getRewards().size(); ++n) {
                    object2 = this.getRewards().get(n);
                    packetHologram32 = this.rewardLocations.get(n);
                    object = new PacketHologram("", (Location)packetHologram32, packetHologram32.getY(), this.getHandler());
                    if (Utils.checkIfContainsTools(((Reward)object2).getReward().getType())) {
                        ((PacketHologram)object).setRightArmPose(260.0f, 315.0f, 0.0f);
                    } else if (Utils.checkIfContainsItems(((Reward)object2).getReward().getType())) {
                        ((PacketHologram)object).setRightArmPose(275.0f, 320.0f, 0.0f);
                    } else {
                        ((PacketHologram)object).setRightArmPose(350.0f, 325.0f, 345.0f);
                    }
                    ((PacketHologram)object).createEquipmentPacket(((Reward)object2).getReward());
                    this.rewardHolograms.add((PacketHologram)object);
                    this.getAnimationHolograms().add((PacketHologram)object);
                    this.getPackets().addAll(((PacketHologram)object).getAllPackets(true));
                    this.getPackets().addAll(((PacketHologram)object).getEquipmentPacket());
                }
                this.sendParticlesAndEffects(this.getTargetLocation().clone().add(0.5, 2.0, 0.5), Utils.isVersionOld() ? "EXPLOSION_LARGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_LARGE", 3);
                AnimationSound.COSMIC_GIANT_APPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
            }
            if ((n = (this.getCounter() - 60) / 10) < this.rewardHolograms.size() && (this.getCounter() - 60) % 10 == 0) {
                object2 = this.rewardHolograms.get(n);
                packetHologram32 = this.getTargetLocation().clone().add(Math.cos((double)(n * 2) * Math.PI / (double)Math.max(1, this.getRewards().size())) * 1.5 + 0.5, 2.5, Math.sin((double)(n * 2) * Math.PI / (double)Math.max(1, this.getRewards().size())) * 1.5 + 0.5);
                this.sendParticlesAndEffects(((PacketHologram)object2).getLocation(), null, "SPELL_WITCH", 10);
                ((PacketHologram)object2).teleport((Location)packetHologram32);
                ((PacketHologram)object2).createTeleportPacket();
                AnimationSound.GIANT_REWARDS_FLY.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), (Location)packetHologram32);
            }
            for (PacketHologram packetHologram32 : this.portalRings) {
                object = packetHologram32.getLocation();
                object.setYaw(object.getYaw() + 5.0f);
                packetHologram32.teleport((Location)object);
                packetHologram32.createTeleportPacket();
            }
        } else if (this.getCounter() >= 160) {
            if (this.portalPhase == 1) {
                this.portalPhase = 2;
                this.getLightningPackets().add(this.getHandler().getLightningPacket(this.getTargetLocation().clone().add(0.5, 1.0, 0.5)));
                this.sendParticlesAndEffects(this.getTargetLocation().clone().add(0.5, 1.5, 0.5), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
                for (Reward reward : this.getRewards()) {
                    Object object = this.getHandler().getEntityItem(this.getTargetLocation().clone().add(0.5, 2.0, 0.5), reward.getReward(), false, true);
                    this.getEntityItems().add(object);
                    this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                    this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                    this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemVelocityPacket(object));
                    this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
                }
                this.setSpawnItems(true);
                this.portalRings.forEach(packetHologram -> {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                    this.getPackets().add(packetHologram.getDestroyPacket());
                });
                this.rewardHolograms.forEach(packetHologram -> {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                    this.getPackets().add(packetHologram.getDestroyPacket());
                });
                AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
                Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
            }
            if (this.getCounter() >= 200) {
                this.clearRunnable();
                return;
            }
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void prepareRewardLocations() {
        int n = Math.max(1, this.getCrate().getSize());
        for (int i = 0; i < n; ++i) {
            double d = (double)(i * 2) * Math.PI / (double)n;
            Location location = this.getTargetLocation().clone().add(Math.cos(d) * 0.3 + 0.5, 0.5, Math.sin(d) * 0.3 + 0.5);
            this.rewardLocations.put(i, location);
        }
    }

    public void clearRunnable() {
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            }
        });
        if (this.getCrate().getDeletePacketForPlayer().containsKey(this.getPlayer())) {
            this.getCrate().getDeletePacketForPlayer().get(this.getPlayer()).addAll(this.getDestroyPackets());
        } else {
            this.getCrate().getDeletePacketForPlayer().put(this.getPlayer(), this.getDestroyPackets());
        }
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.getPlayer())) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.getPlayer());
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.getTargetLocation());
        Location location = this.getTargetLocation().clone().add(-0.2, 0.0, 0.7);
        if (!MonthlyCrate.CratesLocations.remove(location)) {
            for (int i = 0; i < MonthlyCrate.CratesLocations.size(); ++i) {
                if (!MonthlyCrate.CratesLocations.get(i).getWorld().getName().equalsIgnoreCase(location.getWorld().getName()) || !(MonthlyCrate.CratesLocations.get(i).distance(location) < 0.01)) continue;
                MonthlyCrate.CratesLocations.remove(MonthlyCrate.CratesLocations.get(i));
                break;
            }
        }
        --MonthlyCrate.GlobalCratesOpening;
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }
}

