/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.phoenix;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PhoenixAnimationV2
extends AnimationHandler {
    private PacketHologram phoenixBody;
    private PacketHologram leftWing;
    private PacketHologram rightWing;
    private List<Location> flightPath = new ArrayList<Location>();
    private List<Location> fireTrail = new ArrayList<Location>();
    private boolean phoenixRisen = false;
    private int wingFlapCycle = 0;

    public PhoenixAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        Location location = this.getTargetLocation().clone().add(0.5, 0.0, 0.5);
        this.phoenixBody = new PacketHologram("", location, location.getY(), iNMSHandler);
        this.phoenixBody.createEquipmentPacketHelmet(new ItemStack(Material.BLAZE_POWDER));
        this.phoenixBody.setHeadPose(0.0f, 0.0f, 0.0f);
        this.phoenixBody.setInvisible(true);
        this.leftWing = new PacketHologram("", location.clone().add(-0.7, 0.0, 0.0), location.getY(), iNMSHandler);
        this.leftWing.createEquipmentPacket(new ItemStack(Material.ORANGE_BANNER));
        this.leftWing.setRightArmPose(0.0f, 45.0f, 90.0f);
        this.leftWing.setInvisible(true);
        this.rightWing = new PacketHologram("", location.clone().add(0.7, 0.0, 0.0), location.getY(), iNMSHandler);
        this.rightWing.createEquipmentPacket(new ItemStack(Material.ORANGE_BANNER));
        this.rightWing.setRightArmPose(0.0f, -45.0f, -90.0f);
        this.rightWing.setInvisible(true);
        this.getAnimationHolograms().add(this.phoenixBody);
        this.getAnimationHolograms().add(this.leftWing);
        this.getAnimationHolograms().add(this.rightWing);
        this.getPackets().addAll(this.phoenixBody.getAllPackets(true));
        this.getPackets().addAll(this.leftWing.getAllPackets(true));
        this.getPackets().addAll(this.rightWing.getAllPackets(true));
        this.createFlightPath();
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 30) {
            Location location = this.getTargetLocation().clone().add(0.5, 0.1, 0.5);
            this.sendParticlesAndEffects(location, null, "SMOKE_LARGE", 5);
            this.sendParticlesAndEffects(location, null, "SMOKE_NORMAL", 10);
            if (this.getCounter() % 5 == 0) {
                Location location2 = location.clone().add((Math.random() - 0.5) * 0.5, Math.random() * 0.2, (Math.random() - 0.5) * 0.5);
                this.sendParticlesAndEffects(location2, null, "FLAME", 1);
                this.sendParticlesAndEffects(location2, null, "LAVA", 1);
            }
            if (this.getCounter() > 20) {
                for (int i = 0; i < 360; i += 60) {
                    double d = (double)i * Math.PI / 180.0;
                    Location location3 = location.clone().add(Math.cos(d) * 0.3, 0.0, Math.sin(d) * 0.3);
                    this.sendParticlesAndEffects(location3, null, "FLAME", 1);
                }
            }
        } else if (this.getCounter() >= 30 && this.getCounter() < 80) {
            int n;
            if (!this.phoenixRisen) {
                this.phoenixRisen = true;
                Location location = this.getTargetLocation().clone().add(0.5, 0.5, 0.5);
                for (int i = 0; i < 360; i += 15) {
                    double d = (double)i * Math.PI / 180.0;
                    Location location4 = location.clone().add(Math.cos(d) * 1.0, 0.0, Math.sin(d) * 1.0);
                    this.sendParticlesAndEffects(location4, null, "FLAME", 10);
                    this.sendParticlesAndEffects(location4, null, "LAVA", 3);
                }
                this.phoenixBody.setInvisible(false);
                this.leftWing.setInvisible(false);
                this.rightWing.setInvisible(false);
                this.phoenixBody.createMetadataPacket();
                this.leftWing.createMetadataPacket();
                this.rightWing.createMetadataPacket();
                this.getPackets().add(this.phoenixBody.getMetadataPacket());
                this.getPackets().add(this.leftWing.getMetadataPacket());
                this.getPackets().add(this.rightWing.getMetadataPacket());
                AnimationSound.GIANT_REWARDS_FLY.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), location);
            }
            if ((n = this.getCounter() - 30) < this.flightPath.size()) {
                Location location = this.flightPath.get(n);
                this.phoenixBody.teleport(location);
                this.phoenixBody.createTeleportPacket();
                this.getPackets().add(this.phoenixBody.getTeleportPacket());
                this.animateWings(location);
                this.fireTrail.add(location.clone());
                if (this.fireTrail.size() > 10) {
                    this.fireTrail.remove(0);
                }
                for (int i = 0; i < this.fireTrail.size(); ++i) {
                    Location location5 = this.fireTrail.get(i);
                    int n2 = i * 5 / this.fireTrail.size();
                    this.sendParticlesAndEffects(location5, null, "FLAME", n2);
                    this.sendParticlesAndEffects(location5, null, "SMOKE_NORMAL", 2);
                }
                if (this.getCounter() % 20 == 0) {
                    AnimationSound.COSMIC_GIANT_CHEST_SPINNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), location);
                }
            }
        } else if (this.getCounter() == 80) {
            Reward reward;
            int n;
            Location location = this.phoenixBody.getLocation();
            this.sendParticlesAndEffects(location, null, "EXPLOSION_HUGE", 1);
            this.getLightningPackets().add(this.getHandler().getLightningPacket(location));
            this.phoenixBody.setTimeToDestroy(true);
            this.leftWing.setTimeToDestroy(true);
            this.rightWing.setTimeToDestroy(true);
            this.phoenixBody.createDestroyPacket();
            this.leftWing.createDestroyPacket();
            this.rightWing.createDestroyPacket();
            this.getPackets().add(this.phoenixBody.getDestroyPacket());
            this.getPackets().add(this.leftWing.getDestroyPacket());
            this.getPackets().add(this.rightWing.getDestroyPacket());
            this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
            for (n = 0; n < this.getRewards().size(); ++n) {
                reward = this.getRewards().get(n);
                double d = (double)n * (360.0 / (double)this.getRewards().size()) * Math.PI / 180.0;
                Location location6 = location.clone().add(Math.cos(d) * 1.5, 0.0, Math.sin(d) * 1.5);
                this.sendParticlesAndEffects(location6.clone().add(0.0, 1.0, 0.0), null, "FLAME", 20);
                Object object = this.getHandler().getEntityItem(location6, reward.getReward(), false, true);
                this.getEntityItems().add(object);
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemVelocityPacket(object));
                this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
            }
            this.setSpawnItems(true);
            for (n = 0; n < 50; ++n) {
                reward = location.clone().add((Math.random() - 0.5) * 4.0, Math.random() * 3.0, (Math.random() - 0.5) * 4.0);
                this.sendParticlesAndEffects((Location)reward, null, "FLAME", 1);
            }
            AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), location);
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 120) {
            this.clearRunnable();
        }
        this.counterIncrement();
        this.sendPackets();
        this.clearPackets();
    }

    private void createFlightPath() {
        Location location = this.getTargetLocation().clone().add(0.5, 0.0, 0.5);
        for (int i = 0; i < 50; ++i) {
            double d = (double)i / 50.0;
            double d2 = d * Math.PI * 4.0;
            double d3 = d * 2.0;
            double d4 = d * 5.0;
            Location location2 = location.clone().add(Math.cos(d2) * d3, d4, Math.sin(d2) * d3);
            this.flightPath.add(location2);
        }
    }

    private void animateWings(Location location) {
        ++this.wingFlapCycle;
        double d = Math.sin((double)this.wingFlapCycle * 0.3) * 30.0;
        Location location2 = location.clone().add(-0.7, 0.0, 0.0);
        Location location3 = location.clone().add(0.7, 0.0, 0.0);
        this.leftWing.teleport(location2);
        this.rightWing.teleport(location3);
        this.leftWing.setRightArmPose(0.0f, 45.0f + (float)d, 90.0f);
        this.rightWing.setRightArmPose(0.0f, -45.0f - (float)d, -90.0f);
        this.leftWing.createTeleportPacket();
        this.rightWing.createTeleportPacket();
        this.leftWing.createMetadataPacket();
        this.rightWing.createMetadataPacket();
        this.getPackets().add(this.leftWing.getTeleportPacket());
        this.getPackets().add(this.rightWing.getTeleportPacket());
        this.getPackets().add(this.leftWing.getMetadataPacket());
        this.getPackets().add(this.rightWing.getMetadataPacket());
    }

    public void clearRunnable() {
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null && !packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            }
        });
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }
}

