/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.mirrordimension;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class MirrorDimensionAnimation
extends AnimationHandler {
    private List<Reward> rewards;
    private double mirrorRotation = 0.0;
    private boolean shattered = false;

    public MirrorDimensionAnimation(RepeatingTaskHelper repeatingTaskHelper, Player player, Location location, Crate crate, INMSHandler iNMSHandler, List<Reward> list) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(location);
        this.rewards = list;
    }

    @Override
    public void run() {
        Location location;
        if (this.getCounter() < 120) {
            int n;
            this.mirrorRotation += 0.05;
            for (n = 0; n < 6; ++n) {
                double d = 1.0471975511965976 * (double)n + this.mirrorRotation;
                for (double d2 = 0.0; d2 < 2.0; d2 += 0.1) {
                    Location location2 = this.getTargetLocation().clone().add(Math.cos(d) * 1.5 + 0.5, d2, Math.sin(d) * 1.5 + 0.5);
                    location2.getWorld().spawnParticle(Particle.END_ROD, location2, 1, 0.0, 0.0, 0.0, 0.0);
                    if (this.getCounter() % 4 != 0) continue;
                    location2.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, location2, 1);
                }
            }
            if (this.getCounter() > 60) {
                Location location3 = this.getTargetLocation().clone().add(0.5, 1.0, 0.5);
                for (int i = 0; i < 5; ++i) {
                    location = location3.clone().add(ThreadLocalRandom.current().nextDouble(-1.0, 1.0), ThreadLocalRandom.current().nextDouble(-0.5, 1.0), ThreadLocalRandom.current().nextDouble(-1.0, 1.0));
                    location.getWorld().spawnParticle(Particle.REVERSE_PORTAL, location, 1);
                    location.getWorld().spawnParticle(Particle.PORTAL, location, 1);
                }
            }
            if (this.getCounter() == 100) {
                this.shattered = true;
            }
            if (this.shattered) {
                for (n = 0; n < 10; ++n) {
                    Location location4 = this.getTargetLocation().clone().add(ThreadLocalRandom.current().nextDouble(-2.0, 2.0) + 0.5, ThreadLocalRandom.current().nextDouble(0.0, 2.0), ThreadLocalRandom.current().nextDouble(-2.0, 2.0) + 0.5);
                    location4.getWorld().spawnParticle(Particle.BLOCK_CRUMBLE, location4, 1, (Object)Material.GLASS.createBlockData());
                }
            }
        }
        if (this.getCounter() == 120) {
            Location location5 = this.getTargetLocation().clone().add(0.5, 1.0, 0.5);
            location5.getWorld().spawnParticle(Particle.BLOCK_CRUMBLE, location5, 200, 1.0, 1.0, 1.0, (Object)Material.GLASS.createBlockData());
            for (int i = 0; i < 50; ++i) {
                location = location5.clone().add(ThreadLocalRandom.current().nextDouble(-1.0, 1.0), ThreadLocalRandom.current().nextDouble(-0.5, 1.0), ThreadLocalRandom.current().nextDouble(-1.0, 1.0));
                location.getWorld().spawnParticle(Particle.REVERSE_PORTAL, location, 1);
                location.getWorld().spawnParticle(Particle.END_ROD, location, 1);
            }
            this.giveRewards();
        }
        this.setCounter(this.getCounter() + 1);
    }

    private void giveRewards() {
        if (this.rewards != null && !this.rewards.isEmpty()) {
            for (Reward reward : this.rewards) {
                this.getWonPrizes().add(reward);
                double d = 0.0;
                if (reward.getRandomNumberMax() > 0.0) {
                    d = reward.isRandomNumberDoubleValue() ? ThreadLocalRandom.current().nextDouble(reward.getRandomNumberMin(), reward.getRandomNumberMax() + 0.01) : (double)ThreadLocalRandom.current().nextLong((long)reward.getRandomNumberMin(), (long)reward.getRandomNumberMax() + 1L);
                }
                reward.giveReward(this.getPlayer(), this.getCrate(), d);
            }
        }
    }
}

