/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.minion;

import com.cryptomorin.xseries.advancedcrates.SkullUtils;
import com.cryptomorin.xseries.advancedcrates.XMaterial;
import com.cryptomorin.xseries.advancedcrates.XSound;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.locationHandler.LocationConfigInfo;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.SoundData;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MinionAnimation
extends BukkitRunnable {
    RepeatingTaskHelper taskHelper;
    private final Player pl;
    private final Location MainLoc;
    final String direction;
    private Crate crate;
    Set<Player> shownToPlayers = new HashSet<Player>();
    int proximityDistance = 5;
    int howFarShown = 5;
    List<Object> lightningPackets = new ArrayList<Object>();
    private final INMSHandler handler;
    boolean individual = false;
    boolean all = false;
    Object chestOpenPacket;
    Object chestClosePacket;
    boolean timeToOpen = false;
    boolean timeToClose = false;
    Block block;
    HashMap<List<String>, List<Reward>> blacklistedPermissions;
    final Set<Reward> removeItems = new HashSet<Reward>();
    boolean rewardsDontRepeat = false;
    List<Reward> excludeRewards = new ArrayList<Reward>();
    final PacketHologram minion;
    PacketHologram pickaxeGhost = null;
    float headFinalPose = 347.0f;
    float bodyFinalPose = 347.0f;
    float rightArmFinalPose = 206.0f;
    float leftLegFinalPose = 326.0f;
    float rightLegFinalPose = 16.0f;
    float headFinalPose2 = 358.0f;
    float bodyFinalPose2 = 358.0f;
    float rightArmFinalPose2 = 14.0f;
    float leftLegFinalPose2 = 357.0f;
    boolean timeToSpawn = false;
    ItemStack headLock = XMaterial.PLAYER_HEAD.parseItem();
    float yaw;
    List<Item> droppedItems = new ArrayList<Item>();
    final List<Object> clothingPackets = new ArrayList<Object>();
    ItemStack playerHead = XMaterial.PLAYER_HEAD.parseItem();
    List<Object> entityItems = new ArrayList<Object>();
    List<Object> droppedItemsSpawnPackets = new ArrayList<Object>();
    List<Object> droppedItemsDestroyPackets = new ArrayList<Object>();
    boolean spawnItems = false;
    boolean despawnItems = false;
    int directionInteger;
    List<Reward> rewards = new ArrayList<Reward>();
    int soundHearingDistance = MonthlyCrate.soundsVolumes.getOrDefault("Sound_Hearing_Distance", 8);
    private String uniqueOpeningID;
    private Set<Player> shownToPlayersAll = new HashSet<Player>();

    public MinionAnimation(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Material material, Crate crate, INMSHandler iNMSHandler, String string) {
        Location location;
        Location location2;
        this.taskHelper = repeatingTaskHelper;
        this.uniqueOpeningID = this.taskHelper.getUniqueOpeningID();
        this.MainLoc = block.getLocation();
        this.direction = string;
        this.pl = player;
        this.handler = iNMSHandler;
        this.block = block;
        this.setCrate(crate);
        LocationConfigInfo locationConfigInfo = MonthlyCrate.getLocationHandler().getLocationInfo("world=" + block.getWorld().getName() + ",x=" + block.getLocation().getX() + ",y=" + block.getLocation().getY() + ",z=" + block.getLocation().getZ());
        string = locationConfigInfo == null ? MonthlyCrate.getPlayerDirection(player) : locationConfigInfo.getDirection();
        if (string.equalsIgnoreCase("South")) {
            this.directionInteger = 2;
            this.yaw = -90.0f;
            location2 = this.MainLoc.clone().add(-0.15, 1.0, -0.3);
            location2.setYaw(this.yaw);
            location = this.MainLoc.clone().add(0.5, 0.6, 0.0);
        } else if (string.equalsIgnoreCase("East")) {
            this.directionInteger = 4;
            this.yaw = 180.0f;
            location2 = this.MainLoc.clone().add(-0.25, 1.0, 1.15);
            location2.setYaw(this.yaw);
            location = this.MainLoc.clone().add(0.0, 0.6, 0.5);
        } else if (string.equalsIgnoreCase("North")) {
            this.directionInteger = 3;
            this.yaw = 90.0f;
            location2 = this.MainLoc.clone().add(1.15, 1.0, 1.3);
            location2.setYaw(this.yaw);
            location = this.MainLoc.clone().add(0.5, 0.6, 1.0);
        } else {
            this.directionInteger = 5;
            this.yaw = 0.0f;
            location2 = this.MainLoc.clone().add(1.2, 1.0, -0.05);
            location = this.MainLoc.clone().add(1.0, 0.6, 0.5);
        }
        if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_19_R3) || MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_21_R4)) {
            location2.add(0.0, -1.0, 0.0);
            location.add(0.0, -1.0, 0.0);
        }
        this.individual = crate.getVisibilityOption().equalsIgnoreCase("Individual") || crate.getVisibilityOption().equalsIgnoreCase("Opener");
        this.all = crate.getVisibilityOption().equalsIgnoreCase("All");
        this.howFarShown = MonthlyCrate.howFarShownPackets * MonthlyCrate.howFarShownPackets;
        this.proximityDistance = crate.getProximity() * crate.getProximity();
        this.rewardsDontRepeat = crate.getRewardsDontRepeat();
        this.blacklistedPermissions = crate.getBlacklistedPermissions();
        if (block.getType() == Material.CHEST || block.getType() == Material.AIR) {
            this.chestOpenPacket = iNMSHandler.getOpenChestPacket(block.getLocation(), true);
            this.chestClosePacket = iNMSHandler.getOpenChestPacket(block.getLocation(), false);
        } else if (block.getType() == Material.ENDER_CHEST) {
            this.chestOpenPacket = iNMSHandler.getOpenEnderChestPacket(block.getLocation(), true);
            this.chestClosePacket = iNMSHandler.getOpenEnderChestPacket(block.getLocation(), false);
        }
        this.minion = new PacketHologram("", location2, iNMSHandler, true, true);
        this.headLock.setItemMeta((ItemMeta)SkullUtils.applySkin(this.headLock.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGFkOTQzZDA2MzM0N2Y5NWFiOWU5ZmE3NTc5MmRhODRlYzY2NWViZDIyYjA1MGJkYmE1MTlmZjdkYTYxZGIifX19"));
        this.playerHead.setItemMeta(SkullUtils.getSkull(player.getUniqueId(), this.playerHead.getItemMeta()));
        block0: for (List<String> list : this.blacklistedPermissions.keySet()) {
            for (String string2 : list) {
                if (!player.hasPermission(string2)) continue;
                this.removeItems.addAll((Collection<Reward>)this.blacklistedPermissions.get(list));
                continue block0;
            }
        }
        this.excludeRewards.clear();
        this.excludeRewards.addAll(this.removeItems);
        location.setYaw(this.yaw - 90.0f);
        this.pickaxeGhost = new PacketHologram("", location, iNMSHandler, true, true);
        this.pickaxeGhost.teleport(location);
        this.pickaxeGhost.createTeleportPacket();
        this.minion.teleport(location2);
        this.minion.createTeleportPacket();
        new BukkitRunnable(){

            public void run() {
                new BukkitRunnable(){

                    public void run() {
                        MinionAnimation.this.timeToClose = true;
                        MinionAnimation.this.droppedItems.forEach(item -> item.remove());
                        MinionAnimation.this.minion.setTimeToDestroy(true);
                        MinionAnimation.this.sendPackets();
                    }
                }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 160L);
                new BukkitRunnable(){

                    public void run() {
                        MinionAnimation.this.timeToClose = true;
                        MinionAnimation.this.despawnItems = true;
                        MinionAnimation.this.clearRunnable();
                        MinionAnimation.this.sendPackets();
                    }
                }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 160L);
            }
        }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 14L);
        new BukkitRunnable(){

            public void run() {
                if (MinionAnimation.this.taskHelper != null) {
                    Bukkit.getScheduler().cancelTask(MinionAnimation.this.taskHelper.getTaskID());
                }
            }
        }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 4200L);
    }

    public void run() {
        if (this.taskHelper.getCounter() == 3) {
            this.minion.setInvisible(false);
            if (this.block.getType() == Material.AIR) {
                this.pl.sendBlockChange(this.block.getLocation(), Material.CHEST, (byte)this.directionInteger);
            }
            this.minion.createMetadataPacket();
            this.clothingPackets.add(this.minion.createAndGetEquipmentPacketHelmet(this.playerHead));
            this.clothingPackets.add(this.minion.createAndGetEquipmentPacketChest(XMaterial.DIAMOND_CHESTPLATE.parseItem()));
            this.clothingPackets.add(this.minion.createAndGetEquipmentPacketLegs(XMaterial.DIAMOND_LEGGINGS.parseItem()));
            this.clothingPackets.add(this.minion.createAndGetEquipmentPacketBoots(XMaterial.DIAMOND_BOOTS.parseItem()));
            this.clothingPackets.add(this.minion.createAndGetEquipmentPacketHand(XMaterial.WOODEN_PICKAXE.parseItem()));
            this.minion.setEquipmentPacket(this.clothingPackets);
            this.minion.setItemInHand(XMaterial.WOODEN_PICKAXE.parseItem());
            this.pickaxeGhost.createEquipmentPacketHelmet(this.headLock);
            this.pickaxeGhost.createMetadataPacket();
        }
        if (this.taskHelper.getCounter() <= 19) {
            this.minion.setRightArmPose(this.getNextPose(this.rightArmFinalPose, 1, this.taskHelper.getCounter(), 19, 360.0f, false), this.taskHelper.getCounter() <= 8 ? this.getNextPose(18.0f, 1, this.taskHelper.getCounter(), 11, 0.0f, true) : this.getNextPose(0.0f, 8, this.taskHelper.getCounter(), 19, 18.0f, false), 0.0f);
            this.minion.setLeftLegPose(this.getNextPose(this.leftLegFinalPose, 0, this.taskHelper.getCounter(), 19, 360.0f, false), 0.0f, 0.0f);
            this.minion.setRightLegPose(this.getNextPose(this.rightLegFinalPose, 0, this.taskHelper.getCounter(), 19, 0.0f, false), 0.0f, 0.0f);
            this.minion.setBodyPose(this.getNextPose(this.bodyFinalPose, 0, this.taskHelper.getCounter(), 19, 360.0f, false), 0.0f, 0.0f);
            this.minion.setHeadPose(this.getNextPose(this.headFinalPose, 0, this.taskHelper.getCounter(), 19, 360.0f, false), 0.0f, 0.0f);
        } else if (this.taskHelper.getCounter() <= 25) {
            this.minion.setRightArmPose(this.getNextPose(this.rightArmFinalPose2, 17, this.taskHelper.getCounter(), 25, this.rightArmFinalPose, true), 0.0f, 0.0f);
            this.minion.setLeftLegPose(this.getNextPose(this.leftLegFinalPose2, 17, this.taskHelper.getCounter(), 25, this.leftLegFinalPose, false), 0.0f, 0.0f);
            this.minion.setRightLegPose(this.getNextPose(0.0f, 17, this.taskHelper.getCounter(), 25, this.rightLegFinalPose, false), 0.0f, 0.0f);
            this.minion.setBodyPose(this.getNextPose(this.bodyFinalPose2, 17, this.taskHelper.getCounter(), 25, this.bodyFinalPose, false), 0.0f, 0.0f);
            this.minion.setHeadPose(this.getNextPose(this.headFinalPose2, 17, this.taskHelper.getCounter(), 25, this.headFinalPose, false), 0.0f, 0.0f);
        } else if (this.taskHelper.getCounter() <= 33) {
            this.minion.setRightArmPose(this.getNextPose(360.0f, 23, this.taskHelper.getCounter(), 33, this.rightArmFinalPose2, false), 0.0f, 0.0f);
            this.minion.setLeftLegPose(this.getNextPose(360.0f, 23, this.taskHelper.getCounter(), 33, this.leftLegFinalPose2, false), 0.0f, 0.0f);
            this.minion.setBodyPose(this.getNextPose(360.0f, 23, this.taskHelper.getCounter(), 33, this.bodyFinalPose2, false), 0.0f, 0.0f);
            this.minion.setHeadPose(this.getNextPose(360.0f, 23, this.taskHelper.getCounter(), 33, this.headFinalPose2, false), 0.0f, 0.0f);
        }
        if (this.taskHelper.getCounter() == 25) {
            this.pickaxeGhost.setTimeToDestroy(true);
            this.minion.createEquipmentPacket(new ItemStack(Material.STICK));
            if (this.block.getType() == Material.CHEST || this.block.getType() == Material.ENDER_CHEST || this.block.getType() == Material.AIR) {
                this.timeToOpen = true;
            }
        }
        if (this.minion != null) {
            this.minion.createMetadataPacket();
        }
        if (this.taskHelper.getCounter() == 33) {
            new BukkitRunnable(){

                public void run() {
                    for (int i = 0; i < MinionAnimation.this.crate.getSize(); ++i) {
                        MinionAnimation.this.rewards.add(MinionAnimation.this.crate.getRandomRewardLow());
                    }
                    for (Reward reward : MinionAnimation.this.rewards) {
                        Object object = MinionAnimation.this.handler.getEntityItem(MinionAnimation.this.MainLoc.clone().add(0.5, 1.0, 0.5), reward.getReward(), false, true);
                        MinionAnimation.this.entityItems.add(object);
                        MinionAnimation.this.droppedItemsSpawnPackets.add(MinionAnimation.this.handler.getItemSpawnPacket(object));
                        MinionAnimation.this.droppedItemsSpawnPackets.add(MinionAnimation.this.handler.getItemMetaDataPacket(object));
                        MinionAnimation.this.droppedItemsSpawnPackets.add(MinionAnimation.this.handler.getItemVelocityPacket(object));
                        MinionAnimation.this.droppedItemsDestroyPackets.add(MinionAnimation.this.handler.getItemDestroyPacket(object));
                    }
                    MinionAnimation.this.spawnItems = true;
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        }
        this.taskHelper.increment();
        this.sendPackets();
    }

    public Location getMainLoc() {
        return this.MainLoc;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public void setCrate(Crate crate) {
        this.crate = crate;
    }

    public void sendPackets() {
        Set<Player> set = this.getNearbyEntities();
        if (this.pl != null && this.pl.isOnline()) {
            set.add(this.pl);
        }
        set.forEach(player -> {
            if (player != null && player.isOnline()) {
                if (this.shownToPlayers.contains(player)) {
                    if (this.spawnItems) {
                        this.droppedItemsSpawnPackets.forEach(object -> this.handler.sendPacket((Player)player, object));
                    }
                    this.getAllHolograms().forEach(packetHologram -> {
                        if (packetHologram.isTimeToDestroy()) {
                            this.handler.sendPacket((Player)player, packetHologram.getDestroyPacket());
                        } else if (this.timeToSpawn) {
                            packetHologram.sendAllPackets((Player)player, true);
                        } else {
                            packetHologram.sendAllPackets((Player)player);
                        }
                    });
                } else {
                    this.getAllHolograms().forEach(packetHologram -> {
                        if (packetHologram.isTimeToDestroy()) {
                            this.handler.sendPacket((Player)player, packetHologram.getDestroyPacket());
                        } else {
                            packetHologram.sendAllPackets((Player)player, true);
                        }
                    });
                    this.shownToPlayers.add((Player)player);
                }
                if (this.timeToOpen) {
                    this.handler.sendPacket((Player)player, this.chestOpenPacket);
                }
                if (this.timeToClose) {
                    this.handler.sendPacket((Player)player, this.chestClosePacket);
                    if (this.block.getType() == Material.AIR) {
                        player.sendBlockChange(this.MainLoc, this.block.getType(), this.block.getData());
                    }
                }
                this.lightningPackets.forEach(object -> this.handler.sendPacket((Player)player, object));
                this.lightningPackets.clear();
                if (this.despawnItems) {
                    this.droppedItemsDestroyPackets.forEach(object -> this.handler.sendPacket((Player)player, object));
                }
            }
        });
        if (this.timeToOpen) {
            this.timeToOpen = false;
        }
        if (this.spawnItems) {
            this.spawnItems = false;
        }
        if (this.timeToClose) {
            this.timeToClose = false;
        }
        List<Object> list = this.getDestroyPackets();
        ArrayList arrayList = new ArrayList();
        this.shownToPlayers.forEach(player -> {
            Player player2;
            if (player != null && player.isOnline() && !set.contains(player2 = player)) {
                if (this.block.getType() == Material.AIR) {
                    player2.sendBlockChange(this.block.getLocation(), this.block.getType(), this.block.getData());
                }
                list.forEach(object -> this.handler.sendPacket(player2, object));
                this.droppedItemsDestroyPackets.forEach(object -> this.handler.sendPacket(player2, object));
                arrayList.add(player);
            }
        });
        this.shownToPlayersAll.addAll(this.shownToPlayers);
        this.shownToPlayers.removeAll(arrayList);
    }

    public List<PacketHologram> getAllHolograms() {
        ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
        if (this.pickaxeGhost != null) {
            arrayList.add(this.pickaxeGhost);
        }
        if (this.minion != null) {
            arrayList.add(this.minion);
        }
        return arrayList;
    }

    public Set<Player> getNearbyEntities() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.MainLoc.getWorld() || !((d = this.MainLoc.distanceSquared(player.getLocation())) < (double)this.howFarShown) || !(d > (double)this.proximityDistance) && !this.all) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    public void sendParticlesAndEffects(Location location, String string, String string2, int n) {
        Set<Player> set = this.getNearbyEntities();
        if (this.pl != null && this.pl.isOnline()) {
            set.add(this.pl);
        }
        set.forEach(player -> {
            if (player != null && player.isOnline()) {
                if (string != null) {
                    player.playEffect(location, Effect.valueOf((String)string), n);
                } else {
                    player.spawnParticle(Particle.valueOf((String)string2), location, n);
                }
            }
        });
    }

    public List<Object> getDestroyPackets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getAllHolograms().forEach(packetHologram -> arrayList.add(packetHologram.getDestroyPacket()));
        return arrayList;
    }

    public void clearRunnable() {
        if (this.crate.getDeletePacketForPlayer().containsKey(this.pl)) {
            this.crate.getDeletePacketForPlayer().get(this.pl).addAll(this.getDestroyPackets());
        } else {
            this.crate.getDeletePacketForPlayer().put(this.pl, this.getDestroyPackets());
        }
        new BukkitRunnable(){

            public void run() {
                MinionAnimation.this.crate.getRewardsGiveQueue().put(MinionAnimation.this.uniqueOpeningID, new GiveOutRewards(MinionAnimation.this.uniqueOpeningID, MinionAnimation.this.pl, MinionAnimation.this.rewards, (Long)System.currentTimeMillis(), MinionAnimation.this.crate));
                Utils.sendFinalMessages(MinionAnimation.this.crate, MinionAnimation.this.rewards, MinionAnimation.this.pl);
            }
        }.runTask((Plugin)MonthlyCrate.getInstance());
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.pl)) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.pl);
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.MainLoc);
        Location location = (MonthlyCrate.sounds.containsKey("Breakout_Animation_Sounds.On_Crate_Disappear") ? MonthlyCrate.sounds.get("Breakout_Animation_Sounds.On_Crate_Disappear") : new ArrayList()).iterator();
        while (location.hasNext()) {
            String string = (String)location.next();
            if (string == null || string.isEmpty()) continue;
            SoundData soundData = new SoundData(XSound.matchXSound(string).get(), MonthlyCrate.soundsVolumes.get("Breakout_Animation_Sounds.On_Crate_Disappear_Volume").intValue(), MonthlyCrate.soundsVolumes.get("Breakout_Animation_Sounds.On_Crate_Disappear_Pitch").intValue());
            HashSet<Player> hashSet = new HashSet<Player>(this.getNearbyEntitiesSounds());
            if (this.pl != null && this.pl.isOnline()) {
                hashSet.add(this.pl);
            }
            hashSet.forEach(player -> soundData.playTo((Player)player, this.MainLoc));
        }
        if (this.crate.getHiddenHologramsLocations().containsKey(this.pl.getUniqueId()) && this.crate.getHiddenHologramsLocations().get(this.pl.getUniqueId()).contains(this.MainLoc)) {
            if (this.crate.getUnhideHologramLocations().containsKey(this.pl.getUniqueId())) {
                this.crate.getUnhideHologramLocations().get(this.pl.getUniqueId()).add(this.MainLoc);
            } else {
                this.crate.getUnhideHologramLocations().put(this.pl.getUniqueId(), new HashSet<Location>(Arrays.asList(this.MainLoc)));
            }
        }
        this.shownToPlayers.forEach(player -> this.unhidePublicHolograms((Player)player));
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) ? this.MainLoc.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial() : this.MainLoc.getBlock().getType() == Material.valueOf((String)"SKULL_ITEM")) {
            this.handler.sendPlayerHeadTexturePacket(this.pl, this.MainLoc);
        } else {
            this.pl.sendBlockChange(this.MainLoc, this.MainLoc.getBlock().getType(), this.MainLoc.getBlock().getData());
        }
        if (this.getCrate().getVisibilityOption().equalsIgnoreCase("All")) {
            this.MainLoc.getBlock().getState().update(true, true);
        }
        --MonthlyCrate.GlobalCratesOpening;
        if (!this.crate.getDisplayType().isEmpty() && (this.crate.getDisplayType().equalsIgnoreCase("NPC") || this.crate.getDisplayType().equalsIgnoreCase("MOB"))) {
            this.crate.getDynamicCratePlaceholder().place(this.MainLoc);
        }
        if (MonthlyCrate.PlayersPlacedCrates.containsKey(this.pl.getUniqueId()) && MonthlyCrate.PlayersPlacedCrates.get(this.pl.getUniqueId()) != 0) {
            MonthlyCrate.PlayersPlacedCrates.put(this.pl.getUniqueId(), MonthlyCrate.PlayersPlacedCrates.get(this.pl.getUniqueId()) - 1);
        }
        if (!MonthlyCrate.CratesLocations.remove(location = this.MainLoc.clone().add(-0.2, 0.0, 0.7))) {
            for (int i = 0; i < MonthlyCrate.CratesLocations.size(); ++i) {
                if (!MonthlyCrate.CratesLocations.get(i).getWorld().getName().equalsIgnoreCase(location.getWorld().getName()) || !(MonthlyCrate.CratesLocations.get(i).distance(location) < 0.01)) continue;
                MonthlyCrate.CratesLocations.remove(MonthlyCrate.CratesLocations.get(i));
                break;
            }
        }
        PlayerData playerData = MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(this.pl.getUniqueId().toString());
        playerData.setOpeningCrate(false, this.MainLoc);
        if (!this.crate.isRerollEnabled()) {
            playerData.closeCrate();
        }
        this.despawnItems = true;
        if (this.crate.getDeletePacketForPlayer().containsKey(this.pl)) {
            this.crate.getDeletePacketForPlayer().get(this.pl).addAll(this.getDestroyPackets());
        } else {
            this.crate.getDeletePacketForPlayer().put(this.pl, this.getDestroyPackets());
        }
        if (this.taskHelper != null) {
            Bukkit.getScheduler().cancelTask(this.taskHelper.getTaskID());
        }
    }

    public void unhidePublicHolograms(Player player) {
        if (this.crate.getHiddenHologramsLocations().containsKey(player.getUniqueId()) && this.crate.getHiddenHologramsLocations().get(player.getUniqueId()).contains(this.MainLoc)) {
            if (this.crate.getUnhideHologramLocations().containsKey(player.getUniqueId()) && !this.crate.getUnhideHologramLocations().get(player.getUniqueId()).contains(this.MainLoc)) {
                this.crate.getUnhideHologramLocations().get(player.getUniqueId()).add(this.MainLoc);
            } else {
                this.crate.getUnhideHologramLocations().put(player.getUniqueId(), new HashSet<Location>(Arrays.asList(this.MainLoc)));
            }
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) ? this.MainLoc.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial() : this.MainLoc.getBlock().getType() == Material.valueOf((String)"SKULL_ITEM")) {
            this.handler.sendPlayerHeadTexturePacket(this.pl, this.MainLoc);
        } else {
            this.pl.sendBlockChange(this.MainLoc, this.MainLoc.getBlock().getType(), this.MainLoc.getBlock().getData());
        }
    }

    public Set<Player> getNearbyEntitiesSounds() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.MainLoc.getWorld() || !((d = this.MainLoc.distanceSquared(player.getLocation())) < (double)this.soundHearingDistance)) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    float getNextPose(float f, int n, int n2, int n3, float f2, boolean bl) {
        float f3 = (f - f2) / (float)(n3 - n) * (float)(n2 == n ? 1 : n2 - n);
        return bl ? f2 - f3 : f2 + f3;
    }
}

