/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.matrix;

import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MatrixRainAnimationV2
extends AnimationHandler {
    private List<List<PacketHologram>> codeColumns = new ArrayList<List<PacketHologram>>();
    private List<String> matrixChars = Arrays.asList("\u00a7a0", "\u00a7a1", "\u00a721", "\u00a720", "\u00a7a1", "\u00a720", "\u00a7a0", "\u00a721");
    private boolean decodingStarted = false;

    public MatrixRainAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 1.0, 0.5));
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                if (Math.abs(i) + Math.abs(j) > 4) continue;
                ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
                for (int k = 0; k < 10; ++k) {
                    Location location = this.getTargetLocation().clone().add((double)i * 0.5, (double)k * 0.3 + 5.0, (double)j * 0.5);
                    String string = this.matrixChars.get((int)(Math.random() * (double)this.matrixChars.size()));
                    PacketHologram packetHologram = new PacketHologram(string, location, location.getY(), iNMSHandler);
                    arrayList.add(packetHologram);
                    this.getAnimationHolograms().add(packetHologram);
                    this.getPackets().addAll(packetHologram.getAllPackets(true));
                }
                this.codeColumns.add(arrayList);
            }
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 100) {
            for (List<PacketHologram> list2 : this.codeColumns) {
                for (int i = 0; i < list2.size(); ++i) {
                    String string;
                    PacketHologram packetHologram2 = list2.get(i);
                    Location location = packetHologram2.getLocation();
                    location.subtract(0.0, 0.1, 0.0);
                    if (location.getY() < this.getTargetLocation().getY()) {
                        location.setY(this.getTargetLocation().getY() + 5.0);
                        string = this.matrixChars.get((int)(Math.random() * (double)this.matrixChars.size()));
                        packetHologram2.setCustomName(string);
                        packetHologram2.createMetadataPacket();
                    }
                    packetHologram2.teleport(location);
                    packetHologram2.createTeleportPacket();
                    if (!(Math.random() < 0.05)) continue;
                    string = this.matrixChars.get((int)(Math.random() * (double)this.matrixChars.size()));
                    packetHologram2.setCustomName(string);
                    packetHologram2.createMetadataPacket();
                }
            }
        } else if (this.getCounter() < 120) {
            this.decodingStarted = true;
            for (List<PacketHologram> list3 : this.codeColumns) {
                for (PacketHologram packetHologram3 : list3) {
                    if (!(Math.random() < 0.1)) continue;
                    packetHologram3.setCustomName("\u00a76\u2588");
                    packetHologram3.createMetadataPacket();
                }
            }
        } else if (this.getCounter() == 120) {
            this.codeColumns.forEach(list -> list.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            }));
            this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_21_R6) ? "instant_effect" : "SPELL_INSTANT") : null, Utils.isVersionOld() ? null : (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_21_R6) ? "instant_effect" : "SPELL_INSTANT"), 50);
            for (int i = 0; i < this.getRewards().size(); ++i) {
                Reward reward = this.getRewards().get(i);
                Location location = this.getTargetLocation().clone().add((double)(i % 3 - 1) * 1.5, (double)(i / 3) * 0.8 + 1.0, 0.0);
                for (int j = 0; j < 5; ++j) {
                    Location location2 = location.clone().add(0.0, (double)j * 0.2, 0.0);
                    final PacketHologram packetHologram4 = new PacketHologram("\u00a7a\u2591", location2, location2.getY(), this.getHandler());
                    this.getAnimationHolograms().add(packetHologram4);
                    this.getPackets().addAll(packetHologram4.getAllPackets(true));
                    new BukkitRunnable(){

                        public void run() {
                            packetHologram4.setCustomName("\u00a7a\u2593");
                            packetHologram4.createMetadataPacket();
                            new BukkitRunnable(){

                                public void run() {
                                    packetHologram4.setCustomName("\u00a7a\u2588");
                                    packetHologram4.createMetadataPacket();
                                    new BukkitRunnable(){

                                        public void run() {
                                            packetHologram4.setTimeToDestroy(true);
                                            packetHologram4.createDestroyPacket();
                                        }
                                    }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 5L);
                                }
                            }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 3L);
                        }
                    }.runTaskLater((Plugin)MonthlyCrate.getInstance(), (long)j * 2L);
                }
                PacketHologram packetHologram5 = new PacketHologram(reward.getItemBuilder().getDisplayName(), location, location.getY(), this.getHandler());
                packetHologram5.createEquipmentPacket(reward.getReward());
                this.getPackets().addAll(packetHologram5.getAllPackets(true));
                this.getAnimationHolograms().add(packetHologram5);
            }
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 160) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.cancel();
    }
}

