/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.heist;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HeistAnimationV2
extends AnimationHandler {
    private PacketHologram vaultDoor;
    private List<PacketHologram> lasers = new ArrayList<PacketHologram>();
    private List<PacketHologram> securityCameras = new ArrayList<PacketHologram>();
    private List<PacketHologram> goldBars = new ArrayList<PacketHologram>();
    private PacketHologram drill;
    private PacketHologram dynamite;
    private boolean alarmsTriggered = false;
    private int drillProgress = 0;
    private boolean vaultOpen = false;
    private List<Location> laserGrid = new ArrayList<Location>();
    private double drillRotation = 0.0;

    public HeistAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        Location location = this.getTargetLocation().clone().add(0.5, 1.0, 0.5);
        this.vaultDoor = new PacketHologram("", location, location.getY(), iNMSHandler);
        this.vaultDoor.createEquipmentPacketHelmet(new ItemStack(Material.IRON_BLOCK));
        this.vaultDoor.setHeadPose(0.0f, 0.0f, 0.0f);
        this.getAnimationHolograms().add(this.vaultDoor);
        this.getPackets().addAll(this.vaultDoor.getAllPackets(true));
        for (int i = 0; i < 4; ++i) {
            double d = (double)(i * 90) * Math.PI / 180.0;
            Location location2 = location.clone().add(Math.cos(d) * 2.0, 2.0, Math.sin(d) * 2.0);
            PacketHologram packetHologram = new PacketHologram("", location2, location2.getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.OBSERVER));
            packetHologram.setSmall(true);
            packetHologram.setHeadPose(30.0f, i * 90, 0.0f);
            this.securityCameras.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.createLaserGrid(location);
        this.drill = new PacketHologram("", location.clone().add(1.0, 0.0, 0.0), location.getY(), iNMSHandler);
        this.drill.createEquipmentPacket(new ItemStack(Material.IRON_PICKAXE));
        this.drill.setRightArmPose(90.0f, 0.0f, 0.0f);
        this.drill.setInvisible(true);
        this.getAnimationHolograms().add(this.drill);
        this.getPackets().addAll(this.drill.getAllPackets(true));
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 40) {
            for (int i = 0; i < this.securityCameras.size(); ++i) {
                PacketHologram packetHologram2 = this.securityCameras.get(i);
                packetHologram2.setHeadPose(30.0f, i * 90 + this.getCounter() * 3, 0.0f);
                packetHologram2.createMetadataPacket();
                this.getPackets().add(packetHologram2.getMetadataPacket());
                if (this.getCounter() % 10 != 0) continue;
                double d = (double)(i * 90 + this.getCounter() * 3) * Math.PI / 180.0;
                Location location = packetHologram2.getLocation().clone().add(Math.cos(d) * 2.0, -1.0, Math.sin(d) * 2.0);
                this.createScanBeam(packetHologram2.getLocation(), location, "REDSTONE");
            }
            this.animateLaserGrid();
            if (this.getCounter() % 20 == 0) {
                this.sendParticlesAndEffects(this.vaultDoor.getLocation(), null, "ENCHANTMENT_TABLE", 10);
            }
        } else if (this.getCounter() >= 40 && this.getCounter() < 80) {
            if (!this.alarmsTriggered) {
                this.alarmsTriggered = true;
                this.getLightningPackets().add(this.getHandler().getLightningPacket(this.vaultDoor.getLocation()));
                AnimationSound.PYRAMID_LIGHTNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.vaultDoor.getLocation());
                for (int i = 0; i < 360; i += 45) {
                    double d = (double)i * Math.PI / 180.0;
                    Location location = this.vaultDoor.getLocation().clone().add(Math.cos(d) * 3.0, 2.0, Math.sin(d) * 3.0);
                    this.sendParticlesAndEffects(location, null, "REDSTONE", 10);
                }
            }
            for (PacketHologram packetHologram3 : this.securityCameras) {
                packetHologram3.setHeadPose((float)(Math.random() * 60.0 - 30.0), (float)(Math.random() * 360.0), (float)(Math.random() * 30.0 - 15.0));
                packetHologram3.createMetadataPacket();
                this.getPackets().add(packetHologram3.getMetadataPacket());
                if (this.getCounter() % 5 != 0) continue;
                this.sendParticlesAndEffects(packetHologram3.getLocation(), null, "CRIT", 5);
            }
            if (this.getCounter() % 3 == 0) {
                this.animateLaserGrid();
            }
            if (this.getCounter() == 79) {
                this.securityCameras.forEach(packetHologram -> {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                    this.getPackets().add(packetHologram.getDestroyPacket());
                    this.sendParticlesAndEffects(packetHologram.getLocation(), null, "SMOKE_LARGE", 10);
                });
            }
        } else if (this.getCounter() >= 80 && this.getCounter() < 140) {
            if (this.drillProgress == 0) {
                this.drillProgress = 1;
                this.drill.setInvisible(false);
                this.drill.createMetadataPacket();
                this.getPackets().add(this.drill.getMetadataPacket());
                AnimationSound.COSMIC_GIANT_CHEST_SPINNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.drill.getLocation());
            }
            this.drillRotation += 20.0;
            this.drill.setRightArmPose(90.0f, (float)this.drillRotation, 0.0f);
            this.drill.createMetadataPacket();
            this.getPackets().add(this.drill.getMetadataPacket());
            double d = (double)(this.getCounter() - 80) / 60.0;
            Location location = this.vaultDoor.getLocation().clone().add(1.0 - d, 0.0, 0.0);
            this.drill.teleport(location);
            this.drill.createTeleportPacket();
            this.getPackets().add(this.drill.getTeleportPacket());
            this.sendParticlesAndEffects(location, null, "SMOKE_NORMAL", 5);
            this.sendParticlesAndEffects(location, null, "CRIT", 10);
            if (this.getCounter() % 3 == 0) {
                this.sendParticlesAndEffects(location.clone().subtract(0.0, 0.5, 0.0), null, "ITEM_CRACK", 3, new ItemStack(Material.IRON_INGOT));
            }
            if (this.getCounter() > 110) {
                this.vaultDoor.setHeadPose((float)(Math.random() * 5.0), (float)(Math.random() * 5.0), (float)(Math.random() * 5.0));
                this.vaultDoor.createMetadataPacket();
                this.getPackets().add(this.vaultDoor.getMetadataPacket());
            }
        } else if (this.getCounter() == 140) {
            Reward reward;
            int n;
            this.vaultOpen = true;
            this.sendParticlesAndEffects(this.vaultDoor.getLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            this.vaultDoor.setTimeToDestroy(true);
            this.drill.setTimeToDestroy(true);
            this.vaultDoor.createDestroyPacket();
            this.drill.createDestroyPacket();
            this.getPackets().add(this.vaultDoor.getDestroyPacket());
            this.getPackets().add(this.drill.getDestroyPacket());
            this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
            for (n = 0; n < this.getRewards().size(); ++n) {
                reward = this.getRewards().get(n);
                int n2 = n / 3;
                int n3 = n % 3;
                Location location = this.vaultDoor.getLocation().clone().add((double)(n3 - 1) * 0.5, (double)n2 * 0.3, 0.0);
                PacketHologram packetHologram4 = new PacketHologram("", location, location.getY(), this.getHandler());
                packetHologram4.createEquipmentPacketHelmet(new ItemStack(Material.GOLD_BLOCK));
                packetHologram4.setSmall(true);
                this.goldBars.add(packetHologram4);
                this.getAnimationHolograms().add(packetHologram4);
                this.getPackets().addAll(packetHologram4.getAllPackets(true));
                Object object = this.getHandler().getEntityItem(location.clone().add(0.0, 0.5, 0.0), reward.getReward(), false, false);
                this.getEntityItems().add(object);
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
            }
            this.setSpawnItems(true);
            for (n = 0; n < 20; ++n) {
                reward = this.vaultDoor.getLocation().clone().add((Math.random() - 0.5) * 3.0, 3.0, (Math.random() - 0.5) * 3.0);
                this.sendParticlesAndEffects((Location)reward, null, "VILLAGER_HAPPY", 5);
            }
            AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.vaultDoor.getLocation());
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 180) {
            this.goldBars.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            });
            this.clearRunnable();
        }
        this.counterIncrement();
        this.sendPackets();
        this.clearPackets();
    }

    private void createLaserGrid(Location location) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) != 2 && Math.abs(j) != 2) continue;
                this.laserGrid.add(location.clone().add((double)i * 0.5, 0.5, (double)j * 0.5));
            }
        }
    }

    private void animateLaserGrid() {
        for (int i = 0; i < this.laserGrid.size(); ++i) {
            if (i % 2 != this.getCounter() / 5 % 2) continue;
            Location location = this.laserGrid.get(i);
            this.sendColoredDust(location, Color.RED, 0.75f, 3);
            if (i >= this.laserGrid.size() - 1) continue;
            Location location2 = this.laserGrid.get(i + 1);
            this.createScanBeam(location, location2, "LASER");
        }
    }

    private void createScanBeam(Location location, Location location2, String string) {
        double d = location.distance(location2);
        for (double d2 = 0.0; d2 <= d; d2 += 0.2) {
            double d3 = d2 / d;
            Location location3 = new Location(location.getWorld(), location.getX() + (location2.getX() - location.getX()) * d3, location.getY() + (location2.getY() - location.getY()) * d3, location.getZ() + (location2.getZ() - location.getZ()) * d3);
            if (string.equals("REDSTONE")) {
                this.sendColoredDust(location3, Color.RED, 0.5f, 1);
                continue;
            }
            this.sendParticlesAndEffects(location3, null, string, 1);
        }
    }

    public void clearRunnable() {
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null && !packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            }
        });
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }
}

