/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.garden;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GardenParadiseAnimationV2
extends AnimationHandler {
    private PacketHologram seed;
    private final List<PacketHologram> roots = new ArrayList<PacketHologram>();
    private final List<PacketHologram> trunk = new ArrayList<PacketHologram>();
    private final List<PacketHologram> branches = new ArrayList<PacketHologram>();
    private final List<PacketHologram> leaves = new ArrayList<PacketHologram>();
    private final List<PacketHologram> butterflies = new ArrayList<PacketHologram>();
    private final List<PacketHologram> fruits = new ArrayList<PacketHologram>();
    private double growthStage = 0.0;
    private boolean blooming = false;

    public GardenParadiseAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 0.0, 0.5));
        this.seed = new PacketHologram("\u00a7a\u273f Magic Seed \u273f", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
        this.seed.createEquipmentPacketHelmet(new ItemStack(Material.WHEAT_SEEDS));
        this.getAnimationHolograms().add(this.seed);
        this.getPackets().addAll(this.seed.getAllPackets(true));
        for (int i = 0; i < 5; ++i) {
            Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 5.0, Math.random() * 3.0 + 2.0, (Math.random() - 0.5) * 5.0);
            PacketHologram packetHologram = new PacketHologram("\u00a7e\u2726", location, location.getY(), iNMSHandler);
            this.butterflies.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimer((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
        this.sendPackets();
        this.clearPackets();
    }

    @Override
    public void run() {
        if (this.getCounter() < 80) {
            String[] stringArray;
            this.growthStage = (double)this.getCounter() / 80.0;
            if (this.getCounter() < 20) {
                double d = Math.sin(this.getCounter()) * 0.1;
                this.seed.teleport(this.getTargetLocation().clone().add(d, 0.0, d));
                this.seed.createTeleportPacket();
            }
            if (this.getCounter() == 20) {
                for (int i = 0; i < 8; ++i) {
                    double d = 0.7853981633974483 * (double)i;
                    Location location = this.getTargetLocation().clone().add(Math.cos(d) * 0.5, -0.2, Math.sin(d) * 0.5);
                    PacketHologram packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler());
                    packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.BROWN_WOOL));
                    this.roots.add(packetHologram2);
                    this.getAnimationHolograms().add(packetHologram2);
                    this.getPackets().addAll(packetHologram2.getAllPackets(true));
                }
                this.seed.setTimeToDestroy(true);
                this.seed.createDestroyPacket();
            }
            if (this.getCounter() > 20 && this.getCounter() % 5 == 0) {
                int n = (this.getCounter() - 20) / 5;
                Location location = this.getTargetLocation().clone().add(0.0, (double)n * 0.5, 0.0);
                stringArray = new PacketHologram("", location, location.getY(), this.getHandler());
                stringArray.createEquipmentPacketHelmet(new ItemStack(Material.OAK_LOG));
                this.trunk.add((PacketHologram)stringArray);
                this.getAnimationHolograms().add((PacketHologram)stringArray);
                this.getPackets().addAll(stringArray.getAllPackets(true));
                this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "VILLAGER_HAPPY" : null, Utils.isVersionOld() ? null : "VILLAGER_HAPPY", 10);
            }
            if (this.getCounter() > 40 && this.getCounter() % 10 == 0) {
                for (int i = 0; i < 4; ++i) {
                    double d = 1.5707963267948966 * (double)i + (double)this.getCounter() * 0.1;
                    double d2 = Math.max(0.0, (double)this.trunk.size() * 0.5 - 0.5);
                    double d3 = 1.0 + (double)(this.getCounter() - 40) * 0.02;
                    Location location = this.getTargetLocation().clone().add(Math.cos(d) * d3, d2, Math.sin(d) * d3);
                    PacketHologram packetHologram3 = new PacketHologram("", location, location.getY(), this.getHandler());
                    packetHologram3.createEquipmentPacketHelmet(new ItemStack(Material.OAK_WOOD));
                    this.branches.add(packetHologram3);
                    this.getAnimationHolograms().add(packetHologram3);
                    this.getPackets().addAll(packetHologram3.getAllPackets(true));
                }
            }
            if (this.getCounter() > 50 && this.getCounter() % 2 == 0) {
                for (int i = 0; i < 3; ++i) {
                    Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 3.0, (double)this.trunk.size() * 0.5 + Math.random() * 2.0, (Math.random() - 0.5) * 3.0);
                    stringArray = new String[]{"\u00a72\ud83c\udf43", "\u00a7a\ud83c\udf3f", "\u00a72\ud83c\udf31"};
                    PacketHologram packetHologram4 = new PacketHologram(stringArray[(int)(Math.random() * (double)stringArray.length)], location, location.getY(), this.getHandler());
                    this.leaves.add(packetHologram4);
                    this.getAnimationHolograms().add(packetHologram4);
                    this.getPackets().addAll(packetHologram4.getAllPackets(true));
                }
            }
        } else if (this.getCounter() == 80) {
            this.blooming = true;
            for (PacketHologram packetHologram5 : this.branches) {
                Location location = packetHologram5.getLocation().clone().add((Math.random() - 0.5) * 0.5, -0.3, (Math.random() - 0.5) * 0.5);
                Material[] materialArray = new Material[]{Material.APPLE, Material.GOLDEN_APPLE, Material.SWEET_BERRIES, Material.GLOW_BERRIES, Material.MELON_SLICE};
                PacketHologram packetHologram6 = new PacketHologram("", location, location.getY(), this.getHandler());
                packetHologram6.createEquipmentPacketHelmet(new ItemStack(materialArray[(int)(Math.random() * (double)materialArray.length)]));
                this.fruits.add(packetHologram6);
                this.getAnimationHolograms().add(packetHologram6);
                this.getPackets().addAll(packetHologram6.getAllPackets(true));
            }
            this.sendParticlesAndEffects(this.getTargetLocation().clone().add(0.0, Math.max(0.5, (double)this.trunk.size() * 0.5), 0.0), Utils.isVersionOld() ? "VILLAGER_HAPPY" : null, Utils.isVersionOld() ? null : "VILLAGER_HAPPY", 100);
        } else if (this.getCounter() == 110) {
            this.roots.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.trunk.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.branches.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            for (int i = 0; i < Math.min(this.fruits.size(), this.getRewards().size()); ++i) {
                PacketHologram packetHologram7;
                Object object;
                PacketHologram packetHologram8 = this.fruits.get(i);
                Reward reward = this.getRewards().get(i);
                Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 3.0, 0.5, (Math.random() - 0.5) * 3.0);
                for (int j = 0; j < 3; ++j) {
                    object = packetHologram8.getLocation().clone().add(Math.random() - 0.5, Math.random(), Math.random() - 0.5);
                    packetHologram7 = new PacketHologram("\u00a72\ud83c\udf43", (Location)object, object.getY(), this.getHandler());
                    this.getAnimationHolograms().add(packetHologram7);
                    this.getPackets().addAll(packetHologram7.getAllPackets(true));
                }
                packetHologram8.setTimeToDestroy(true);
                packetHologram8.createDestroyPacket();
                PacketHologram packetHologram9 = new PacketHologram("", location.clone().subtract(0.0, 0.3, 0.0), location.getY() - 0.3, this.getHandler());
                packetHologram9.createEquipmentPacketHelmet(new ItemStack(Material.BARREL));
                this.getAnimationHolograms().add(packetHologram9);
                this.getPackets().addAll(packetHologram9.getAllPackets(true));
                object = new PacketHologram("\u00a76\u00a7lHARVEST BOUNTY", location.clone().add(0.0, 1.0, 0.0), location.getY() + 1.0, this.getHandler());
                this.getAnimationHolograms().add((PacketHologram)object);
                this.getPackets().addAll(((PacketHologram)object).getAllPackets(true));
                packetHologram7 = new PacketHologram("\u00a7a" + reward.getItemBuilder().getDisplayName(), location, location.getY(), this.getHandler());
                packetHologram7.createEquipmentPacket(reward.getReward());
                this.getAnimationHolograms().add(packetHologram7);
                this.getPackets().addAll(packetHologram7.getAllPackets(true));
            }
            this.leaves.forEach(packetHologram -> {
                if (Math.random() < 0.3) {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                }
            });
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 200) {
            this.cleanup();
            return;
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, object)));
        this.cancel();
    }
}

