/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.galaxy;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GalaxyFormationAnimationV2
extends AnimationHandler {
    private PacketHologram galacticCore;
    private List<PacketHologram> stars = new ArrayList<PacketHologram>();
    private List<PacketHologram> planets = new ArrayList<PacketHologram>();
    private List<SpiralArm> spiralArms = new ArrayList<SpiralArm>();
    private double galaxyRotation = 0.0;
    private boolean collapsing = false;

    public GalaxyFormationAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        PacketHologram packetHologram;
        int n;
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 3.0, 0.5));
        this.galacticCore = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
        this.galacticCore.createEquipmentPacketHelmet(new ItemStack(Material.NETHER_STAR));
        this.getAnimationHolograms().add(this.galacticCore);
        this.getPackets().addAll(this.galacticCore.getAllPackets(true));
        for (n = 0; n < 4; ++n) {
            this.spiralArms.add(new SpiralArm(1.5707963267948966 * (double)n));
        }
        for (n = 0; n < 50; ++n) {
            Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 10.0, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 10.0);
            packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.END_ROD));
            this.stars.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        Material[] materialArray = new Material[]{Material.MAGMA_BLOCK, Material.PACKED_ICE, Material.GRASS_BLOCK, Material.SAND, Material.MYCELIUM};
        for (int i = 0; i < 8; ++i) {
            packetHologram = this.getTargetLocation();
            PacketHologram packetHologram2 = new PacketHologram("", (Location)packetHologram, packetHologram.getY(), iNMSHandler);
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(materialArray[i % materialArray.length]));
            this.planets.add(packetHologram2);
            this.getAnimationHolograms().add(packetHologram2);
            this.getPackets().addAll(packetHologram2.getAllPackets(true));
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 150) {
            this.galaxyRotation += 0.02;
            this.spiralArms.forEach(spiralArm -> spiralArm.update(this.galaxyRotation));
            for (int i = 0; i < this.planets.size(); ++i) {
                double d = 2.0 + (double)i * 0.5;
                double d2 = 0.05 / (double)(i + 1);
                double d3 = this.galaxyRotation * d2 * 10.0 + Math.PI * 2 / (double)this.planets.size() * (double)i;
                Location location = this.getTargetLocation().clone().add(Math.cos(d3) * d, Math.sin(d3 * 3.0) * 0.3, Math.sin(d3) * d);
                this.planets.get(i).teleport(location);
                this.planets.get(i).createTeleportPacket();
            }
            this.stars.forEach(packetHologram -> {
                if (Math.random() < 0.02) {
                    packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.NETHER_STAR));
                    new BukkitRunnable((PacketHologram)packetHologram){
                        final /* synthetic */ PacketHologram val$star;
                        {
                            this.val$star = packetHologram;
                        }

                        public void run() {
                            this.val$star.createEquipmentPacketHelmet(new ItemStack(Material.END_ROD));
                        }
                    }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 2L);
                }
            });
            if (this.getCounter() % 10 == 0) {
                this.sendParticlesAndEffects(this.getTargetLocation().clone().add((Math.random() - 0.5) * 5.0, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 5.0), Utils.isVersionOld() ? "SPELL_WITCH" : null, Utils.isVersionOld() ? null : "SPELL_WITCH", 5);
            }
            if (this.getCounter() % 20 == 0) {
                this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "PORTAL" : null, Utils.isVersionOld() ? null : "PORTAL", 20);
            }
        } else if (this.getCounter() < 200) {
            this.collapsing = true;
            double d = (double)(this.getCounter() - 150) / 50.0;
            this.stars.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                Location location2 = this.getTargetLocation().clone().subtract(location);
                location2.multiply(d * 0.1);
                packetHologram.teleport(location.add(location2));
                packetHologram.createTeleportPacket();
            });
            this.planets.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                Location location2 = this.getTargetLocation().clone().subtract(location);
                location2.multiply(d * 0.15);
                packetHologram.teleport(location.add(location2));
                packetHologram.createTeleportPacket();
            });
            this.spiralArms.forEach(spiralArm -> {
                spiralArm.armCurvature += 0.05;
                spiralArm.update(this.galaxyRotation);
            });
            this.galaxyRotation += 0.1 * d;
        } else if (this.getCounter() == 200) {
            Object object;
            int n;
            this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            for (n = 0; n < 5; ++n) {
                object = this.getTargetLocation().clone().add((Math.random() - 0.5) * 4.0, 0.0, (Math.random() - 0.5) * 4.0);
                this.getLightningPackets().add(this.getHandler().getLightningPacket((Location)object));
            }
            this.galacticCore.setTimeToDestroy(true);
            this.galacticCore.createDestroyPacket();
            this.stars.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.planets.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.spiralArms.forEach(spiralArm -> spiralArm.stars.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            }));
            for (n = 0; n < this.getRewards().size(); ++n) {
                Object object2;
                object = this.getRewards().get(n);
                double d = Math.PI * 2 / (double)this.getRewards().size() * (double)n;
                Location location = this.getTargetLocation();
                Location location2 = this.getTargetLocation().clone().add(Math.cos(d) * 3.0, Math.sin(n) * 1.5, Math.sin(d) * 3.0);
                for (int i = 0; i < 10; ++i) {
                    object2 = location.clone().add(location2.clone().subtract(location).multiply((double)i / 10.0));
                    final PacketHologram packetHologram2 = new PacketHologram("", (Location)object2, object2.getY(), this.getHandler());
                    packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.ENDER_PEARL));
                    this.getAnimationHolograms().add(packetHologram2);
                    this.getPackets().addAll(packetHologram2.getAllPackets(true));
                    new BukkitRunnable(){

                        public void run() {
                            packetHologram2.setTimeToDestroy(true);
                            packetHologram2.createDestroyPacket();
                        }
                    }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 20L);
                }
                PacketHologram packetHologram3 = new PacketHologram(((Reward)object).getItemBuilder().getDisplayName(), location2, location2.getY(), this.getHandler());
                packetHologram3.createEquipmentPacket(((Reward)object).getReward());
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
                this.getAnimationHolograms().add(packetHologram3);
                object2 = new PacketHologram("", location2.clone().subtract(0.0, 0.5, 0.0), location2.getY() - 0.5, this.getHandler());
                ((PacketHologram)object2).createEquipmentPacketHelmet(new ItemStack(Material.PURPLE_STAINED_GLASS));
                this.getPackets().addAll(((PacketHologram)object2).getAllPackets(true));
                this.getAnimationHolograms().add((PacketHologram)object2);
            }
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 320) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.cancel();
    }

    private class SpiralArm {
        List<PacketHologram> stars = new ArrayList<PacketHologram>();
        double armAngle;
        double armCurvature = 0.2;

        SpiralArm(double d) {
            this.armAngle = d;
            for (int i = 0; i < 15; ++i) {
                Location location = GalaxyFormationAnimationV2.this.getTargetLocation();
                PacketHologram packetHologram = new PacketHologram("", location, location.getY(), GalaxyFormationAnimationV2.this.getHandler());
                packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.GLOWSTONE_DUST));
                this.stars.add(packetHologram);
                GalaxyFormationAnimationV2.this.getAnimationHolograms().add(packetHologram);
                GalaxyFormationAnimationV2.this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
        }

        void update(double d) {
            for (int i = 0; i < this.stars.size(); ++i) {
                double d2 = (double)(i + 1) * 0.3;
                double d3 = this.armAngle + d + d2 * this.armCurvature;
                double d4 = Math.cos(d3) * d2;
                double d5 = Math.sin(d3) * d2;
                double d6 = Math.sin(d * 2.0 + (double)i) * 0.2;
                Location location = GalaxyFormationAnimationV2.this.getTargetLocation().clone().add(d4, d6, d5);
                this.stars.get(i).teleport(location);
                this.stars.get(i).createTeleportPacket();
            }
        }
    }
}

