/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.galaxy;

import com.cryptomorin.xseries.advancedcrates.SkullUtils;
import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GalaxyAnimationV2
extends AnimationHandler {
    private PacketHologram sun;
    private List<PacketHologram> planets = new ArrayList<PacketHologram>();
    private List<PacketHologram> moons = new ArrayList<PacketHologram>();
    private List<PacketHologram> asteroids = new ArrayList<PacketHologram>();
    private List<PacketHologram> stars = new ArrayList<PacketHologram>();
    private List<PacketHologram> rewardShips = new ArrayList<PacketHologram>();
    private Map<PacketHologram, OrbitData> orbits = new HashMap<PacketHologram, OrbitData>();
    private boolean supernovaStarted = false;
    private boolean blackHoleFormed = false;
    private double blackHoleStrength = 0.0;
    private Location galaxyCenter;
    private List<Location> starField = new ArrayList<Location>();
    private int cosmicPhase = 0;

    public GalaxyAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        double d;
        PacketHologram packetHologram;
        Location location;
        int n;
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        this.galaxyCenter = this.getTargetLocation().clone().add(0.5, 3.0, 0.5);
        this.sun = new PacketHologram("", this.galaxyCenter, this.galaxyCenter.getY(), iNMSHandler);
        ItemStack itemStack = new ItemStack(Material.GLOWSTONE);
        this.sun.createEquipmentPacketHelmet(itemStack);
        this.sun.setHeadPose(0.0f, 0.0f, 0.0f);
        this.getAnimationHolograms().add(this.sun);
        this.getPackets().addAll(this.sun.getAllPackets(true));
        Material[] materialArray = new Material[]{Material.BLUE_CONCRETE, Material.RED_CONCRETE, Material.LIME_CONCRETE, Material.PURPLE_CONCRETE, Material.ORANGE_CONCRETE};
        for (n = 0; n < 5; ++n) {
            location = this.galaxyCenter.clone();
            packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
            ItemStack itemStack2 = XMaterial.PLAYER_HEAD.parseItem();
            String[] stringArray = new String[]{"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzY5MTk2YjMzMGM2Yjg5NjJmMjNhZDU2MjdmYjZlY2NlNDcyZWFmNWM5ZDQ0Zjc5MWY2NzA5YzdkMGY0ZGVjZSJ9fX0=", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNlZjlhYTE0ZTg4NDc3M2VhYzEzNGE0ZWU4OTcyMDYzZjQ2NmRlNjc4MzYzY2Y3YjFhMjFhODViNyJ9fX0=", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjE2YzMxMmM2MzM0YTFiMWVkNTkzZTY4MzBjNmZjYThiMGFhZDQ1MGVmMWJmMjgxY2VmOTI2NDk0ZTI0YjMifX19", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzRlNDkwZTIxNmY5ZjlmZDQ0ZmRmNjYzNmM4YzI4ZTQyNGY3MjEyMjY4OGVmYmY1ZjliYmU2ZTg4YTI2MDU2MCJ9fX0=", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTVjN2I5ZGRhNmY3MmNkY2FiYjJjNTljNTMxYWEwMjE0NGY1YTdhOWVjODMyM2Y4MmJhNzFjNTNlNWM3NjNmIn19fQ=="};
            itemStack2.setItemMeta((ItemMeta)SkullUtils.applySkin(itemStack2.getItemMeta(), stringArray[n]));
            packetHologram.createEquipmentPacketHelmet(itemStack2);
            this.planets.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            d = 2.0 + (double)n * 0.8;
            double d2 = 1.5 / (double)(n + 1);
            double d3 = n * 15;
            double d4 = Math.sin((double)n * 0.5) * 0.5;
            this.orbits.put(packetHologram, new OrbitData(d, d2, d3, d4));
            if (n % 2 != 0) continue;
            PacketHologram packetHologram2 = new PacketHologram("", location, location.getY(), iNMSHandler);
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.COBBLESTONE));
            packetHologram2.setSmall(true);
            this.moons.add(packetHologram2);
            this.getAnimationHolograms().add(packetHologram2);
            this.getPackets().addAll(packetHologram2.getAllPackets(true));
            this.orbits.put(packetHologram2, new OrbitData(0.5, 3.0, 0.0, 0.0));
        }
        for (n = 0; n < 15; ++n) {
            location = this.galaxyCenter.clone();
            packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.STONE));
            packetHologram.setSmall(true);
            this.asteroids.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            double d5 = 4.5 + Math.random() * 0.5;
            d = 0.5 + Math.random() * 0.3;
            this.orbits.put(packetHologram, new OrbitData(d5, d, Math.random() * 30.0, Math.random() * 0.3));
        }
        this.createStarField();
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 80) {
            double d = Math.min(1.0, (double)this.getCounter() / 80.0);
            this.sun.setHeadPose(0.0f, this.getCounter() * 3, 0.0f);
            this.sun.createMetadataPacket();
            this.getPackets().add(this.sun.getMetadataPacket());
            if (this.getCounter() % 10 == 0) {
                this.sendParticlesAndEffects(this.sun.getLocation(), null, "LAVA", 10);
                this.sendParticlesAndEffects(this.sun.getLocation(), null, "FLAME", 20);
            }
            this.updateOrbits(d);
            if (this.getCounter() % 3 == 0) {
                for (Location location : this.starField) {
                    if (!(Math.random() < 0.1)) continue;
                    this.sendParticlesAndEffects(location, null, "END_ROD", 1);
                }
            }
            for (int i = 0; i < 3; ++i) {
                Location location;
                location = this.galaxyCenter.clone().add((Math.random() - 0.5) * 8.0, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 8.0);
                this.sendParticlesAndEffects(location, null, "PORTAL", 3);
            }
        } else if (this.getCounter() >= 80 && this.getCounter() < 160) {
            if (this.cosmicPhase == 0) {
                this.cosmicPhase = 1;
                AnimationSound.COSMIC_GIANT_APPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.galaxyCenter);
                for (int i = 0; i < 360; i += 30) {
                    double d = (double)i * Math.PI / 180.0;
                    Location location = this.galaxyCenter.clone().add(Math.cos(d) * 3.0, 0.0, Math.sin(d) * 3.0);
                    this.sendParticlesAndEffects(location, null, "SPELL_WITCH", 5);
                }
            }
            double d = (double)(this.getCounter() - 80) / 80.0;
            this.updateOrbitsWithAlignment(d);
            if (this.getCounter() % 5 == 0) {
                double d2 = 1.0 + Math.sin((double)this.getCounter() * 0.1) * 0.5;
                for (int i = 0; i < 360; i += 45) {
                    double object = (double)i * Math.PI / 180.0;
                    Location location = this.sun.getLocation().clone().add(Math.cos(object) * d2, 0.0, Math.sin(object) * d2);
                    this.sendColoredDust(location, Color.RED, 1.0f, 5);
                }
            }
            if (this.getCounter() % 20 == 0 && this.getCounter() > 120) {
                for (int i = 0; i < this.planets.size() - 1; ++i) {
                    this.createEnergyBeam(this.planets.get(i).getLocation(), this.planets.get(i + 1).getLocation());
                }
            }
        } else if (this.getCounter() >= 160 && this.getCounter() < 200) {
            if (!this.supernovaStarted) {
                this.supernovaStarted = true;
                this.sun.createEquipmentPacketHelmet(new ItemStack(Material.MAGMA_BLOCK));
                this.getPackets().addAll(this.sun.getEquipmentPacket());
                this.getLightningPackets().add(this.getHandler().getLightningPacket(this.galaxyCenter));
                AnimationSound.GIANT_REWARDS_FLY.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.galaxyCenter);
            }
            double d = (double)(this.getCounter() - 160) / 10.0;
            for (int i = 0; i < 3; ++i) {
                double d4 = d - (double)i * 0.3;
                if (!(d4 > 0.0)) continue;
                for (int j = 0; j < 360; j += 15) {
                    double d2 = (double)j * Math.PI / 180.0;
                    Location location = this.galaxyCenter.clone().add(Math.cos(d2) * d4, (double)i * 0.2, Math.sin(d2) * d4);
                    this.sendParticlesAndEffects(location, null, "EXPLOSION_NORMAL", 1);
                    this.sendParticlesAndEffects(location, null, "FLAME", 3);
                }
            }
            for (PacketHologram packetHologram2 : this.planets) {
                OrbitData orbitData = this.orbits.get(packetHologram2);
                orbitData.radius += 0.05;
                Location location = this.calculateOrbitPosition(this.galaxyCenter, orbitData, 1.0);
                packetHologram2.teleport(location);
                packetHologram2.createTeleportPacket();
                this.getPackets().add(packetHologram2.getTeleportPacket());
                this.sendParticlesAndEffects(packetHologram2.getLocation(), null, "FLAME", 5);
            }
        } else if (this.getCounter() >= 200 && this.getCounter() < 250) {
            int n;
            Object object;
            OrbitData orbitData;
            if (!this.blackHoleFormed) {
                this.blackHoleFormed = true;
                this.sun.createEquipmentPacketHelmet(new ItemStack(Material.BLACK_CONCRETE));
                this.getPackets().addAll(this.sun.getEquipmentPacket());
                this.sendParticlesAndEffects(this.galaxyCenter, Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
                this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
                for (int i = 0; i < this.getRewards().size(); ++i) {
                    Reward object22 = this.getRewards().get(i);
                    orbitData = this.galaxyCenter.clone().add(0.0, 5.0, 0.0);
                    object = new PacketHologram("", (Location)orbitData, orbitData.getY(), this.getHandler());
                    ItemStack itemStack = XMaterial.PLAYER_HEAD.parseItem();
                    itemStack.setItemMeta((ItemMeta)SkullUtils.applySkin(itemStack.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGFhNTgzYjE0YjI1OTAyZmI5YzkzZTUxYmJmMTljMjc1ODQ4MTU0NjRhMGZlMzQxOGRkMWY3M2Y5MWY5YzhjNSJ9fX0="));
                    ((PacketHologram)object).createEquipmentPacketHelmet(itemStack);
                    ((PacketHologram)object).setRightArmPose(0.0f, i * (360 / this.getRewards().size()), 0.0f);
                    PacketHologram packetHologram2 = new PacketHologram("", orbitData.clone().subtract(0.0, 0.5, 0.0), orbitData.getY() - 0.5, this.getHandler());
                    if (Utils.checkIfContainsTools(object22.getReward().getType())) {
                        packetHologram2.setRightArmPose(260.0f, 315.0f, 0.0f);
                    } else if (Utils.checkIfContainsItems(object22.getReward().getType())) {
                        packetHologram2.setRightArmPose(275.0f, 320.0f, 0.0f);
                    } else {
                        packetHologram2.setRightArmPose(350.0f, 325.0f, 345.0f);
                    }
                    packetHologram2.createEquipmentPacket(object22.getReward());
                    packetHologram2.setSmall(true);
                    this.rewardShips.add((PacketHologram)object);
                    this.rewardShips.add(packetHologram2);
                    this.getAnimationHolograms().add((PacketHologram)object);
                    this.getAnimationHolograms().add(packetHologram2);
                    this.getPackets().addAll(((PacketHologram)object).getAllPackets(true));
                    this.getPackets().addAll(packetHologram2.getAllPackets(true));
                    this.getPackets().addAll(packetHologram2.getEquipmentPacket());
                    this.orbits.put((PacketHologram)object, new OrbitData(2.5, 2.0, i * 30, 0.0));
                    this.orbits.put(packetHologram2, new OrbitData(2.5, 2.0, i * 30, -0.5));
                }
                AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.galaxyCenter);
            }
            this.blackHoleStrength = Math.min(1.0, (double)(this.getCounter() - 200) / 50.0);
            for (PacketHologram reward : this.orbits.keySet()) {
                if (this.rewardShips.contains(reward)) continue;
                orbitData = this.orbits.get(reward);
                orbitData.radius = Math.max(0.1, orbitData.radius - this.blackHoleStrength * 0.02);
                object = this.calculateOrbitPosition(this.galaxyCenter, orbitData, 1.0);
                reward.teleport((Location)object);
                reward.createTeleportPacket();
                this.getPackets().add(reward.getTeleportPacket());
                if (!(orbitData.radius < 0.5)) continue;
                reward.setTimeToDestroy(true);
                reward.createDestroyPacket();
                this.getPackets().add(reward.getDestroyPacket());
            }
            for (n = 0; n < this.rewardShips.size(); ++n) {
                PacketHologram packetHologram3 = this.rewardShips.get(n);
                orbitData = this.orbits.get(packetHologram3);
                orbitData.currentAngle += orbitData.speed * 3.0;
                object = this.calculateOrbitPosition(this.galaxyCenter, orbitData, 1.0);
                packetHologram3.teleport((Location)object);
                packetHologram3.createTeleportPacket();
                this.getPackets().add(packetHologram3.getTeleportPacket());
                this.sendParticlesAndEffects((Location)object, null, "PORTAL", 5);
            }
            for (n = 0; n < 360; n += 10) {
                double d = (double)(n + this.getCounter() * 5) * Math.PI / 180.0;
                object = this.galaxyCenter.clone().add(Math.cos(d) * (1.5 - this.blackHoleStrength * 0.5), 0.0, Math.sin(d) * (1.5 - this.blackHoleStrength * 0.5));
                this.sendParticlesAndEffects((Location)object, null, "SMOKE_LARGE", 1);
                this.sendParticlesAndEffects((Location)object, null, "SPELL_WITCH", 1);
            }
        } else if (this.getCounter() == 250) {
            for (int i = 0; i < this.getRewards().size(); ++i) {
                Reward reward = this.getRewards().get(i);
                double d = (double)i * (360.0 / (double)this.getRewards().size()) * Math.PI / 180.0;
                Location location = this.galaxyCenter.clone().add(Math.cos(d) * 2.0, 1.0, Math.sin(d) * 2.0);
                Object object = this.getHandler().getEntityItem(location, reward.getReward(), false, true);
                this.getEntityItems().add(object);
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemVelocityPacket(object));
                this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
            }
            this.setSpawnItems(true);
            this.rewardShips.forEach(packetHologram -> {
                this.sendParticlesAndEffects(packetHologram.getLocation(), null, "PORTAL", 20);
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            });
            this.sun.setTimeToDestroy(true);
            this.sun.createDestroyPacket();
            this.getPackets().add(this.sun.getDestroyPacket());
            this.sendParticlesAndEffects(this.galaxyCenter, Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 300) {
            this.clearRunnable();
        }
        this.counterIncrement();
        this.sendPackets();
        this.clearPackets();
    }

    private void updateOrbits(double d) {
        for (Map.Entry<PacketHologram, OrbitData> entry : this.orbits.entrySet()) {
            PacketHologram packetHologram = entry.getKey();
            OrbitData orbitData = entry.getValue();
            orbitData.currentAngle += orbitData.speed;
            Location location = this.calculateOrbitPosition(this.galaxyCenter, orbitData, d);
            packetHologram.teleport(location);
            packetHologram.createTeleportPacket();
            this.getPackets().add(packetHologram.getTeleportPacket());
        }
    }

    private void updateOrbitsWithAlignment(double d) {
        for (Map.Entry<PacketHologram, OrbitData> entry : this.orbits.entrySet()) {
            PacketHologram packetHologram = entry.getKey();
            OrbitData orbitData = entry.getValue();
            double d2 = 0.0;
            orbitData.currentAngle += (d2 - orbitData.currentAngle) * d * 0.02;
            orbitData.currentAngle += orbitData.speed * (1.0 - d);
            Location location = this.calculateOrbitPosition(this.galaxyCenter, orbitData, 1.0);
            packetHologram.teleport(location);
            packetHologram.createTeleportPacket();
            this.getPackets().add(packetHologram.getTeleportPacket());
        }
    }

    private Location calculateOrbitPosition(Location location, OrbitData orbitData, double d) {
        double d2 = orbitData.currentAngle * Math.PI / 180.0;
        double d3 = orbitData.tilt * Math.PI / 180.0;
        double d4 = Math.cos(d2) * orbitData.radius * d;
        double d5 = Math.sin(d2) * orbitData.radius * d;
        double d6 = orbitData.height + Math.sin(d3) * Math.sin(d2) * orbitData.radius * 0.3 * d;
        return location.clone().add(d4, d6, d5);
    }

    private void createStarField() {
        for (int i = 0; i < 50; ++i) {
            Location location = this.galaxyCenter.clone().add((Math.random() - 0.5) * 12.0, (Math.random() - 0.5) * 6.0 + 3.0, (Math.random() - 0.5) * 12.0);
            this.starField.add(location);
        }
    }

    private void createEnergyBeam(Location location, Location location2) {
        double d = location.distance(location2);
        for (double d2 = 0.0; d2 <= d; d2 += 0.2) {
            double d3 = d2 / d;
            Location location3 = new Location(location.getWorld(), location.getX() + (location2.getX() - location.getX()) * d3, location.getY() + (location2.getY() - location.getY()) * d3, location.getZ() + (location2.getZ() - location.getZ()) * d3);
            this.sendParticlesAndEffects(location3, null, "END_ROD", 1);
        }
    }

    public void clearRunnable() {
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null && !packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            }
        });
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }

    private class OrbitData {
        double radius;
        double speed;
        double currentAngle;
        double tilt;
        double height;

        OrbitData(double d, double d2, double d3, double d4) {
            this.radius = d;
            this.speed = d2;
            this.tilt = d3;
            this.height = d4;
            this.currentAngle = Math.random() * 360.0;
        }
    }
}

