/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.dragon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DragonSummoningAnimationV2
extends AnimationHandler {
    private List<PacketHologram> fireCircle = new ArrayList<PacketHologram>();
    private PacketHologram phoenixHead;
    private PacketHologram phoenixBeak;
    private PacketHologram phoenixCrest;
    private PacketHologram phoenixEye1;
    private PacketHologram phoenixEye2;
    private List<PacketHologram> phoenixNeck = new ArrayList<PacketHologram>();
    private PacketHologram phoenixChest;
    private List<PacketHologram> phoenixBody = new ArrayList<PacketHologram>();
    private List<PacketHologram> phoenixBelly = new ArrayList<PacketHologram>();
    private List<PacketHologram> leftWingBones = new ArrayList<PacketHologram>();
    private List<PacketHologram> rightWingBones = new ArrayList<PacketHologram>();
    private List<List<PacketHologram>> leftWingFeathers = new ArrayList<List<PacketHologram>>();
    private List<List<PacketHologram>> rightWingFeathers = new ArrayList<List<PacketHologram>>();
    private List<PacketHologram> phoenixTailBase = new ArrayList<PacketHologram>();
    private List<List<PacketHologram>> phoenixTailFeathers = new ArrayList<List<PacketHologram>>();
    private List<PacketHologram> leftLeg = new ArrayList<PacketHologram>();
    private List<PacketHologram> rightLeg = new ArrayList<PacketHologram>();
    private PacketHologram leftTalon;
    private PacketHologram rightTalon;
    private List<PacketHologram> crystalPrisons = new ArrayList<PacketHologram>();
    private List<List<PacketHologram>> crystalLayers = new ArrayList<List<PacketHologram>>();
    private Map<Integer, Reward> crystalRewardMap = new HashMap<Integer, Reward>();
    private Map<Integer, Integer> crystalHealth = new HashMap<Integer, Integer>();
    private List<PacketHologram> fireBreath = new ArrayList<PacketHologram>();
    private List<PacketHologram> fireBlast = new ArrayList<PacketHologram>();
    private List<PacketHologram> fireAura = new ArrayList<PacketHologram>();
    private Location phoenixPosition;
    private double phoenixRotation = 0.0;
    private double wingFlap = 0.0;
    private double wingExtension = 0.0;
    private double tailSpread = 0.0;
    private double neckCurve = 0.0;
    private double bodyBreathing = 0.0;
    private boolean phoenixFlying = false;
    private boolean breathingFire = false;
    private int currentTargetCrystal = -1;
    private int fireIntensity = 0;

    public DragonSummoningAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 1.0, 0.5));
        this.phoenixPosition = this.getTargetLocation().clone();
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.createFireCircle();
        this.createCrystalPrisons();
        for (int i = 0; i < Math.min(this.crystalPrisons.size(), this.getRewards().size()); ++i) {
            this.crystalRewardMap.put(i, this.getRewards().get(i));
            this.crystalHealth.put(i, 100);
        }
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
        this.sendPackets();
        this.clearPackets();
    }

    private void createFireCircle() {
        String[] stringArray = new String[]{"\u00a76\u2726", "\u00a7c\ud83d\udd25", "\u00a76\u2727", "\u00a7c\ud83d\udd25", "\u00a76\u2726", "\u00a7c\ud83d\udd25", "\u00a76\u2727", "\u00a7c\ud83d\udd25"};
        for (int i = 0; i < 16; ++i) {
            double d = 0.39269908169872414 * (double)i;
            Location location = this.getTargetLocation().clone().add(Math.cos(d) * 4.0, 0.0, Math.sin(d) * 4.0);
            PacketHologram packetHologram = new PacketHologram(stringArray[i % stringArray.length], location, location.getY(), this.getHandler());
            this.fireCircle.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
    }

    private void createCrystalPrisons() {
        for (int i = 0; i < this.getRewards().size(); ++i) {
            double d = Math.PI * 2 / (double)this.getRewards().size() * (double)i;
            Location location = this.getTargetLocation().clone().add(Math.cos(d) * 3.5, 0.0, Math.sin(d) * 3.5);
            PacketHologram packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.DIAMOND_BLOCK));
            this.crystalPrisons.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
            for (int j = 1; j <= 3; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Location location2 = location.clone().add(0.0, (double)k * 0.3 * (double)j, 0.0);
                    PacketHologram packetHologram2 = new PacketHologram("", location2, location2.getY(), this.getHandler());
                    Material material = j == 1 ? Material.ICE : (j == 2 ? Material.PACKED_ICE : Material.BLUE_ICE);
                    packetHologram2.createEquipmentPacketHelmet(new ItemStack(material));
                    arrayList.add(packetHologram2);
                    this.getAnimationHolograms().add(packetHologram2);
                    this.getPackets().addAll(packetHologram2.getAllPackets(true));
                }
            }
            this.crystalLayers.add(arrayList);
            PacketHologram packetHologram3 = new PacketHologram("\u00a7b\u2745 Frozen Treasure \u2745", location.clone().add(0.0, 2.0, 0.0), location.getY() + 2.0, this.getHandler());
            this.getAnimationHolograms().add(packetHologram3);
            this.getPackets().addAll(packetHologram3.getAllPackets(true));
        }
    }

    @Override
    public void run() {
        if (this.getCounter() < 60) {
            this.animateFireCircle();
        } else if (this.getCounter() == 60) {
            this.createPhoenix();
            this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            this.getLightningPackets().add(this.getHandler().getLightningPacket(this.getTargetLocation()));
        } else if (this.getCounter() < 100) {
            double d = (double)(this.getCounter() - 60) / 40.0;
            this.phoenixPosition = this.getTargetLocation().clone().add(0.0, d * 6.0, 0.0);
            this.phoenixRotation = this.getCounter() * 2;
            this.animatePhoenix(false, false);
            if (this.getCounter() == 90) {
                this.phoenixCry();
            }
        } else if (this.getCounter() < 280) {
            this.phoenixFlying = true;
            double d = this.getCounter() - 100;
            double d2 = d * 0.03;
            double d3 = 5.0 + Math.sin(d2 * 0.5) * 2.0;
            double d4 = 6.0 + Math.sin(d2 * 2.0) * 2.0;
            this.phoenixRotation = d2 * 60.0;
            this.phoenixPosition = this.getTargetLocation().clone().add(Math.cos(d2) * d3, d4, Math.sin(d2) * d3);
            this.animatePhoenix(true, false);
            if (this.getCounter() % 60 == 0 && !this.crystalPrisons.isEmpty()) {
                this.currentTargetCrystal = (this.currentTargetCrystal + 1) % this.crystalPrisons.size();
            }
        } else if (this.getCounter() < 450) {
            this.phoenixFlying = false;
            if (!this.crystalPrisons.isEmpty()) {
                if (this.currentTargetCrystal < 0) {
                    this.currentTargetCrystal = 0;
                }
                if (this.currentTargetCrystal < this.crystalPrisons.size()) {
                    PacketHologram packetHologram2 = this.crystalPrisons.get(this.currentTargetCrystal);
                    this.phoenixPosition = packetHologram2.getLocation().clone().add(0.0, 4.0, -1.0);
                    double d = packetHologram2.getLocation().getX() - this.phoenixPosition.getX();
                    double d5 = packetHologram2.getLocation().getZ() - this.phoenixPosition.getZ();
                    this.phoenixRotation = Math.toDegrees(Math.atan2(d5, d));
                    this.animatePhoenix(false, true);
                    this.breathingFire = true;
                    this.fireIntensity = Math.min(this.fireIntensity + 2, 40);
                    this.breatheFireAtCrystal(this.currentTargetCrystal);
                    if (this.crystalHealth.containsKey(this.currentTargetCrystal) && this.crystalHealth.get(this.currentTargetCrystal) <= 0) {
                        this.revealReward(this.currentTargetCrystal);
                        ++this.currentTargetCrystal;
                        this.fireIntensity = 0;
                    }
                }
            } else {
                this.phoenixPosition = this.getTargetLocation().clone().add(0.0, 6.0, 0.0);
                this.animatePhoenix(false, false);
            }
        } else if (this.getCounter() < 500) {
            this.phoenixPosition = this.getTargetLocation().clone().add(0.0, 6.0, 0.0);
            this.phoenixRotation = this.getCounter() * 5;
            this.breathingFire = false;
            this.animatePhoenix(true, false);
        } else if (this.getCounter() == 500) {
            this.clearPhoenix();
        } else if (this.getCounter() >= 600) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void createPhoenix() {
        this.phoenixHead = new PacketHologram("", this.phoenixPosition, this.phoenixPosition.getY(), this.getHandler());
        this.phoenixHead.createEquipmentPacketHelmet(new ItemStack(Material.GOLD_BLOCK));
        this.getAnimationHolograms().add(this.phoenixHead);
        this.getPackets().addAll(this.phoenixHead.getAllPackets(true));
        this.phoenixBeak = new PacketHologram("", this.phoenixPosition.clone().add(0.0, -0.1, 0.5), this.phoenixPosition.getY() - 0.1, this.getHandler());
        this.phoenixBeak.createEquipmentPacketHelmet(new ItemStack(Material.ORANGE_TERRACOTTA));
        this.getAnimationHolograms().add(this.phoenixBeak);
        this.getPackets().addAll(this.phoenixBeak.getAllPackets(true));
        this.phoenixCrest = new PacketHologram("", this.phoenixPosition.clone().add(0.0, 0.3, 0.0), this.phoenixPosition.getY() + 0.3, this.getHandler());
        this.phoenixCrest.createEquipmentPacketHelmet(new ItemStack(Material.FIRE_CORAL));
        this.getAnimationHolograms().add(this.phoenixCrest);
        this.getPackets().addAll(this.phoenixCrest.getAllPackets(true));
        this.phoenixEye1 = new PacketHologram("\u00a76\u25c9", this.phoenixPosition.clone().add(0.2, 0.0, 0.2), this.phoenixPosition.getY(), this.getHandler());
        this.phoenixEye1.createEquipmentPacketHelmet(new ItemStack(Material.GLOWSTONE));
        this.getAnimationHolograms().add(this.phoenixEye1);
        this.getPackets().addAll(this.phoenixEye1.getAllPackets(true));
        this.phoenixEye2 = new PacketHologram("\u00a76\u25c9", this.phoenixPosition.clone().add(-0.2, 0.0, 0.2), this.phoenixPosition.getY(), this.getHandler());
        this.phoenixEye2.createEquipmentPacketHelmet(new ItemStack(Material.GLOWSTONE));
        this.getAnimationHolograms().add(this.phoenixEye2);
        this.getPackets().addAll(this.phoenixEye2.getAllPackets(true));
        this.createPhoenixBody();
    }

    private void createPhoenixBody() {
        Material material;
        PacketHologram packetHologram;
        Location location;
        int n;
        for (n = 0; n < 5; ++n) {
            location = this.phoenixPosition.clone().add(0.0, -0.2 * (double)(n + 1), -0.15 * (double)(n + 1));
            packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            material = n < 2 ? Material.GOLD_BLOCK : Material.ORANGE_WOOL;
            packetHologram.createEquipmentPacketHelmet(new ItemStack(material));
            this.phoenixNeck.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.phoenixChest = new PacketHologram("", this.phoenixPosition.clone().add(0.0, -1.2, -0.8), this.phoenixPosition.getY() - 1.2, this.getHandler());
        this.phoenixChest.createEquipmentPacketHelmet(new ItemStack(Material.RED_WOOL));
        this.getAnimationHolograms().add(this.phoenixChest);
        this.getPackets().addAll(this.phoenixChest.getAllPackets(true));
        for (n = 0; n < 8; ++n) {
            location = this.phoenixPosition.clone().add(0.0, -1.5 - (double)n * 0.2, -1.0 - (double)n * 0.3);
            packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            material = n < 3 ? Material.RED_WOOL : (n < 6 ? Material.ORANGE_WOOL : Material.YELLOW_WOOL);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(material));
            this.phoenixBody.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        for (n = 0; n < 4; ++n) {
            location = this.phoenixPosition.clone().add(0.0, -1.8 - (double)n * 0.2, -1.2 - (double)n * 0.2);
            packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.YELLOW_WOOL));
            this.phoenixBelly.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.createDetailedWings();
        this.createMajesticTail();
        this.createLegsAndTalons();
    }

    private void createDetailedWings() {
        for (int i = 0; i < 5; ++i) {
            Location location = this.phoenixPosition.clone().add(-(0.8 + (double)i * 0.5), -1.0 - (double)i * 0.1, -1.0);
            PacketHologram packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.BONE_BLOCK));
            this.leftWingBones.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            Location location2 = this.phoenixPosition.clone().add(0.8 + (double)i * 0.5, -1.0 - (double)i * 0.1, -1.0);
            PacketHologram packetHologram2 = new PacketHologram("", location2, location2.getY(), this.getHandler());
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.BONE_BLOCK));
            this.rightWingBones.add(packetHologram2);
            this.getAnimationHolograms().add(packetHologram2);
            this.getPackets().addAll(packetHologram2.getAllPackets(true));
            ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
            ArrayList<PacketHologram> arrayList2 = new ArrayList<PacketHologram>();
            for (int j = 0; j < 3; ++j) {
                Location location3 = location.clone().add((double)(-j) * 0.3, (double)(-j) * 0.1, 0.0);
                PacketHologram packetHologram3 = new PacketHologram("", location3, location3.getY(), this.getHandler());
                Material material = j == 0 ? Material.RED_STAINED_GLASS : (j == 1 ? Material.ORANGE_STAINED_GLASS : Material.YELLOW_STAINED_GLASS);
                packetHologram3.createEquipmentPacketHelmet(new ItemStack(material));
                arrayList.add(packetHologram3);
                this.getAnimationHolograms().add(packetHologram3);
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
                Location location4 = location2.clone().add((double)j * 0.3, (double)(-j) * 0.1, 0.0);
                PacketHologram packetHologram4 = new PacketHologram("", location4, location4.getY(), this.getHandler());
                packetHologram4.createEquipmentPacketHelmet(new ItemStack(material));
                arrayList2.add(packetHologram4);
                this.getAnimationHolograms().add(packetHologram4);
                this.getPackets().addAll(packetHologram4.getAllPackets(true));
            }
            this.leftWingFeathers.add(arrayList);
            this.rightWingFeathers.add(arrayList2);
        }
    }

    private void createMajesticTail() {
        for (int i = 0; i < 5; ++i) {
            Location location = this.phoenixPosition.clone().add(0.0, -2.5 - (double)i * 0.15, -3.0 - (double)i * 0.3);
            PacketHologram packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.GOLD_BLOCK));
            this.phoenixTailBase.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
            for (int j = 0; j < 5; ++j) {
                double d = (double)(j - 2) * 0.3;
                Location location2 = location.clone().add(d, -0.5 - (double)j * 0.2, -0.5 - (double)i * 0.2);
                PacketHologram packetHologram2 = new PacketHologram("\u00a76\u2726", location2, location2.getY(), this.getHandler());
                packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.FIRE_CORAL_FAN));
                arrayList.add(packetHologram2);
                this.getAnimationHolograms().add(packetHologram2);
                this.getPackets().addAll(packetHologram2.getAllPackets(true));
            }
            this.phoenixTailFeathers.add(arrayList);
        }
    }

    private void createLegsAndTalons() {
        PacketHologram packetHologram;
        Location location;
        int n;
        for (n = 0; n < 2; ++n) {
            location = this.phoenixPosition.clone().add(-0.3, -2.0 - (double)n * 0.3, -1.5);
            packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.ORANGE_TERRACOTTA));
            this.leftLeg.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.leftTalon = new PacketHologram("", this.phoenixPosition.clone().add(-0.3, -2.6, -1.5), this.phoenixPosition.getY() - 2.6, this.getHandler());
        this.leftTalon.createEquipmentPacketHelmet(new ItemStack(Material.IRON_BLOCK));
        this.getAnimationHolograms().add(this.leftTalon);
        this.getPackets().addAll(this.leftTalon.getAllPackets(true));
        for (n = 0; n < 2; ++n) {
            location = this.phoenixPosition.clone().add(0.3, -2.0 - (double)n * 0.3, -1.5);
            packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.ORANGE_TERRACOTTA));
            this.rightLeg.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.rightTalon = new PacketHologram("", this.phoenixPosition.clone().add(0.3, -2.6, -1.5), this.phoenixPosition.getY() - 2.6, this.getHandler());
        this.rightTalon.createEquipmentPacketHelmet(new ItemStack(Material.IRON_BLOCK));
        this.getAnimationHolograms().add(this.rightTalon);
        this.getPackets().addAll(this.rightTalon.getAllPackets(true));
    }

    private void animatePhoenix(boolean bl, boolean bl2) {
        double d = Math.toRadians(this.phoenixRotation);
        this.animateHeadAndNeck(d, bl2);
        this.bodyBreathing = Math.sin((double)this.getCounter() * 0.1) * 0.1;
        if (bl) {
            this.wingFlap = Math.sin((double)this.getCounter() * 0.25) * 60.0;
            this.wingExtension = 1.0;
        } else if (bl2) {
            this.wingFlap = Math.sin((double)this.getCounter() * 0.15) * 30.0;
            this.wingExtension = 1.2;
        } else {
            this.wingFlap = Math.sin((double)this.getCounter() * 0.1) * 15.0;
            this.wingExtension = 0.8;
        }
        this.animateWings(d);
        this.tailSpread = bl ? Math.sin((double)this.getCounter() * 0.12) * 0.8 : 0.3;
        this.animateTail(d);
        this.animateLegs(d, bl);
        if (bl || bl2) {
            this.createFireAura();
        }
    }

    private void animateHeadAndNeck(double d, boolean bl) {
        int n;
        Location location = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.0, 0.0, 0.3), d);
        Location location2 = this.phoenixPosition.clone().add(location);
        this.phoenixHead.teleport(location2);
        this.phoenixHead.createTeleportPacket();
        this.phoenixHead.setHeadPose(bl ? 30.0f : 0.0f, (float)this.phoenixRotation, 0.0f);
        double d2 = this.breathingFire ? 0.4 : 0.1;
        Location location3 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.0, -d2, 0.7), d);
        this.phoenixBeak.teleport(this.phoenixPosition.clone().add(location3));
        this.phoenixBeak.createTeleportPacket();
        Location location4 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.0, 0.3, 0.2), d);
        this.phoenixCrest.teleport(this.phoenixPosition.clone().add(location4));
        this.phoenixCrest.createTeleportPacket();
        String string = this.breathingFire ? "\u00a76\u00a7l\u25c9" : "\u00a76\u25c9";
        this.phoenixEye1.setCustomName(string);
        this.phoenixEye1.createMetadataPacket();
        this.phoenixEye2.setCustomName(string);
        this.phoenixEye2.createMetadataPacket();
        Location location5 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.2, 0.0, 0.4), d);
        this.phoenixEye1.teleport(this.phoenixPosition.clone().add(location5));
        this.phoenixEye1.createTeleportPacket();
        Location location6 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), -0.2, 0.0, 0.4), d);
        this.phoenixEye2.teleport(this.phoenixPosition.clone().add(location6));
        this.phoenixEye2.createTeleportPacket();
        this.neckCurve = Math.sin((double)this.getCounter() * 0.08) * 0.3;
        for (int i = 0; i < this.phoenixNeck.size(); ++i) {
            double d3 = this.neckCurve * (double)(i + 1) * 0.3;
            Location location7 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), d3, -0.2 * (double)(i + 1), -0.15 * (double)(i + 1)), d);
            this.phoenixNeck.get(i).teleport(this.phoenixPosition.clone().add(location7));
            this.phoenixNeck.get(i).createTeleportPacket();
        }
        Location location8 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.0, -1.2 + this.bodyBreathing, -0.8), d);
        this.phoenixChest.teleport(this.phoenixPosition.clone().add(location8));
        this.phoenixChest.createTeleportPacket();
        for (n = 0; n < this.phoenixBody.size(); ++n) {
            double d4 = Math.sin((double)this.getCounter() * 0.1 + (double)n * 0.3) * 0.1;
            Location location9 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), d4, -1.5 - (double)n * 0.2 + this.bodyBreathing, -1.0 - (double)n * 0.3), d);
            this.phoenixBody.get(n).teleport(this.phoenixPosition.clone().add(location9));
            this.phoenixBody.get(n).createTeleportPacket();
        }
        for (n = 0; n < this.phoenixBelly.size(); ++n) {
            Location location10 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.0, -1.8 - (double)n * 0.2 + this.bodyBreathing * 2.0, -1.2 - (double)n * 0.2), d);
            this.phoenixBelly.get(n).teleport(this.phoenixPosition.clone().add(location10));
            this.phoenixBelly.get(n).createTeleportPacket();
        }
    }

    private void animateWings(double d) {
        for (int i = 0; i < this.leftWingBones.size(); ++i) {
            double d2 = Math.toRadians(-this.wingFlap);
            double d3 = (0.8 + (double)i * 0.5) * this.wingExtension;
            Location location = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), -d3 * Math.cos(d2), -1.0 - (double)i * 0.1 + Math.sin(d2) * d3 * 0.3, -1.0), d);
            this.leftWingBones.get(i).teleport(this.phoenixPosition.clone().add(location));
            this.leftWingBones.get(i).createTeleportPacket();
            Location location2 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), d3 * Math.cos(-d2), -1.0 - (double)i * 0.1 + Math.sin(-d2) * d3 * 0.3, -1.0), d);
            this.rightWingBones.get(i).teleport(this.phoenixPosition.clone().add(location2));
            this.rightWingBones.get(i).createTeleportPacket();
            if (i >= this.leftWingFeathers.size()) continue;
            List<PacketHologram> list = this.leftWingFeathers.get(i);
            List<PacketHologram> list2 = this.rightWingFeathers.get(i);
            for (int j = 0; j < list.size(); ++j) {
                double d4 = Math.sin((double)this.getCounter() * 0.3 + (double)j) * 0.1;
                Location location3 = this.leftWingBones.get(i).getLocation().clone().add((double)(-j) * 0.3 + d4, (double)(-j) * 0.1, 0.0);
                list.get(j).teleport(location3);
                list.get(j).createTeleportPacket();
                Location location4 = this.rightWingBones.get(i).getLocation().clone().add((double)j * 0.3 - d4, (double)(-j) * 0.1, 0.0);
                list2.get(j).teleport(location4);
                list2.get(j).createTeleportPacket();
            }
        }
    }

    private void animateTail(double d) {
        for (int i = 0; i < this.phoenixTailBase.size(); ++i) {
            double d2 = this.tailSpread * (double)(i + 1) * 0.4;
            double d3 = Math.sin((double)this.getCounter() * 0.1 + (double)i * 0.5) * 0.3;
            Location location = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), d2 + d3, -2.5 - (double)i * 0.15, -3.0 - (double)i * 0.3), d);
            this.phoenixTailBase.get(i).teleport(this.phoenixPosition.clone().add(location));
            this.phoenixTailBase.get(i).createTeleportPacket();
            if (i >= this.phoenixTailFeathers.size()) continue;
            List<PacketHologram> list = this.phoenixTailFeathers.get(i);
            for (int j = 0; j < list.size(); ++j) {
                double d4 = Math.sin((double)this.getCounter() * 0.15 + (double)j + (double)i) * 0.5;
                double d5 = (double)(j - 2) * 0.3 + d4;
                Location location2 = this.phoenixTailBase.get(i).getLocation().clone().add(d5 * this.tailSpread, -0.5 - (double)j * 0.2 + Math.sin((double)this.getCounter() * 0.2) * 0.2, -0.5 - (double)i * 0.2);
                list.get(j).teleport(location2);
                list.get(j).createTeleportPacket();
                if (this.phoenixFlying) {
                    list.get(j).setCustomName("\u00a76\u00a7l\u2726");
                    list.get(j).createMetadataPacket();
                    continue;
                }
                list.get(j).setCustomName("\u00a76\u2726");
                list.get(j).createMetadataPacket();
            }
        }
    }

    private void animateLegs(double d, boolean bl) {
        double d2 = bl ? -0.8 : 0.0;
        double d3 = Math.sin((double)this.getCounter() * 0.1) * 0.1;
        for (int i = 0; i < this.leftLeg.size(); ++i) {
            Location location = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), -0.3 + d3, -2.0 - (double)i * 0.3 + d2, -1.5), d);
            this.leftLeg.get(i).teleport(this.phoenixPosition.clone().add(location));
            this.leftLeg.get(i).createTeleportPacket();
        }
        Location location = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), -0.3 + d3, -2.6 + d2, -1.5), d);
        this.leftTalon.teleport(this.phoenixPosition.clone().add(location));
        this.leftTalon.createTeleportPacket();
        for (int i = 0; i < this.rightLeg.size(); ++i) {
            Location location2 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.3 - d3, -2.0 - (double)i * 0.3 + d2, -1.5), d);
            this.rightLeg.get(i).teleport(this.phoenixPosition.clone().add(location2));
            this.rightLeg.get(i).createTeleportPacket();
        }
        Location location3 = this.rotateOffset(new Location(this.phoenixPosition.getWorld(), 0.3 - d3, -2.6 + d2, -1.5), d);
        this.rightTalon.teleport(this.phoenixPosition.clone().add(location3));
        this.rightTalon.createTeleportPacket();
    }

    private void createFireAura() {
        this.fireAura.forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
        });
        this.fireAura.clear();
        for (int i = 0; i < 12; ++i) {
            double d = 0.5235987755982988 * (double)i + (double)this.getCounter() * 0.1;
            double d2 = 1.5 + Math.sin((double)this.getCounter() * 0.2 + (double)i) * 0.5;
            Location location = this.phoenixPosition.clone().add(Math.cos(d) * d2, Math.sin(d) * 0.5 - 1.0, Math.sin(d) * d2);
            PacketHologram packetHologram2 = new PacketHologram("\u00a76\u2726", location, location.getY(), this.getHandler());
            this.fireAura.add(packetHologram2);
            this.getAnimationHolograms().add(packetHologram2);
            this.getPackets().addAll(packetHologram2.getAllPackets(true));
        }
        this.sendParticlesAndEffects(this.phoenixPosition, Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 30);
        this.sendParticlesAndEffects(this.phoenixPosition.clone().add(0.0, -1.0, 0.0), Utils.isVersionOld() ? "SMOKE_LARGE" : null, Utils.isVersionOld() ? null : "SMOKE_LARGE", 10);
    }

    private void breatheFireAtCrystal(int n) {
        double d;
        int n2;
        if (n >= this.crystalPrisons.size()) {
            return;
        }
        PacketHologram packetHologram2 = this.crystalPrisons.get(n);
        Location location = packetHologram2.getLocation();
        Location location2 = this.phoenixBeak.getLocation();
        this.fireBreath.forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
        });
        this.fireBreath.clear();
        for (n2 = 0; n2 < this.fireIntensity; ++n2) {
            d = (double)n2 * 0.05;
            double d2 = (double)n2 / (double)this.fireIntensity;
            Location location3 = location2.clone().add(location.clone().subtract(location2).multiply(d2)).add((Math.random() - 0.5) * d, (Math.random() - 0.5) * d, (Math.random() - 0.5) * d);
            PacketHologram packetHologram3 = new PacketHologram("", location3, location3.getY(), this.getHandler());
            Material[] materialArray = new Material[]{Material.MAGMA_BLOCK, Material.FIRE_CORAL_BLOCK, Material.ORANGE_CONCRETE};
            packetHologram3.createEquipmentPacketHelmet(new ItemStack(materialArray[n2 % 3]));
            this.fireBreath.add(packetHologram3);
            this.getAnimationHolograms().add(packetHologram3);
            this.getPackets().addAll(packetHologram3.getAllPackets(true));
        }
        if (this.getCounter() % 5 == 0) {
            for (n2 = 0; n2 < 360; n2 += 45) {
                d = Math.toRadians(n2);
                Location location4 = location.clone().add(Math.cos(d) * 1.0, 0.0, Math.sin(d) * 1.0);
                PacketHologram packetHologram4 = new PacketHologram("\u00a76\ud83d\udd25", location4, location4.getY(), this.getHandler());
                this.fireBlast.add(packetHologram4);
                this.getAnimationHolograms().add(packetHologram4);
                this.getPackets().addAll(packetHologram4.getAllPackets(true));
            }
        }
        this.fireBlast.removeIf(packetHologram -> {
            Location location2 = packetHologram.getLocation();
            Location location3 = location;
            Location location4 = location2.clone().subtract(location3).multiply(1.2);
            location2.add(location4.multiply(0.1));
            packetHologram.teleport(location2);
            packetHologram.createTeleportPacket();
            if (location2.distance(location3) > 3.0) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                return true;
            }
            return false;
        });
        n2 = this.crystalHealth.get(n);
        this.crystalHealth.put(n, n2 -= 3);
        if (n2 <= 75 && n2 > 50) {
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.PACKED_ICE));
        } else if (n2 <= 50 && n2 > 25) {
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.ICE));
        } else if (n2 <= 25 && n2 > 0) {
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.GLASS));
        }
        this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "WATER_SPLASH" : null, Utils.isVersionOld() ? null : "WATER_SPLASH", 20);
        this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 50);
        this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "SMOKE_LARGE" : null, Utils.isVersionOld() ? null : "SMOKE_LARGE", 10);
    }

    private void revealReward(int n) {
        if (!this.crystalRewardMap.containsKey(n)) {
            return;
        }
        PacketHologram packetHologram2 = this.crystalPrisons.get(n);
        Reward reward = this.crystalRewardMap.get(n);
        Location location = packetHologram2.getLocation();
        this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "EXPLOSION_LARGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_LARGE", 1);
        this.getLightningPackets().add(this.getHandler().getLightningPacket(location));
        packetHologram2.setTimeToDestroy(true);
        packetHologram2.createDestroyPacket();
        if (n < this.crystalLayers.size()) {
            this.crystalLayers.get(n).forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
        }
        int n2 = 0;
        while (n2 <= 15) {
            int n3 = n2++;
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                Location location2 = location.clone().add(0.0, (double)n3 * 0.1, 0.0);
                if (n3 == 15) {
                    PacketHologram packetHologram = new PacketHologram("\u00a76\u00a7l" + reward.getItemBuilder().getDisplayName(), location2, location2.getY(), this.getHandler());
                    packetHologram.createEquipmentPacket(reward.getReward());
                    this.getAnimationHolograms().add(packetHologram);
                    this.getPackets().addAll(packetHologram.getAllPackets(true));
                    PacketHologram packetHologram2 = new PacketHologram("\u00a76\u00a7l\u2726 PHOENIX'S GIFT \u2726", location2.clone().add(0.0, 1.5, 0.0), location2.getY() + 1.5, this.getHandler());
                    this.getAnimationHolograms().add(packetHologram2);
                    this.getPackets().addAll(packetHologram2.getAllPackets(true));
                    for (int i = 0; i < 8; ++i) {
                        double d = 0.7853981633974483 * (double)i;
                        Location location3 = location2.clone().add(Math.cos(d) * 1.0, 0.0, Math.sin(d) * 1.0);
                        PacketHologram packetHologram3 = new PacketHologram("\u00a76\ud83d\udd25", location3, location3.getY(), this.getHandler());
                        this.getAnimationHolograms().add(packetHologram3);
                        this.getPackets().addAll(packetHologram3.getAllPackets(true));
                    }
                }
                this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 10);
            }, (long)n3 * 2L);
        }
        n2 = 0;
        for (int n4 : this.crystalHealth.values()) {
            if (n4 > 0) continue;
            ++n2;
        }
        if (n2 >= this.crystalPrisons.size()) {
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer()), 40L);
        }
    }

    private void animateFireCircle() {
        for (int i = 0; i < this.fireCircle.size(); ++i) {
            PacketHologram packetHologram = this.fireCircle.get(i);
            double d = Math.PI * 2 / (double)this.fireCircle.size() * (double)i + (double)this.getCounter() * 0.1;
            double d2 = 4.0 - (double)this.getCounter() / 60.0;
            double d3 = Math.sin((double)this.getCounter() * 0.1 + (double)i * 0.4) * 0.5;
            Location location = this.getTargetLocation().clone().add(Math.cos(d) * d2, d3, Math.sin(d) * d2);
            packetHologram.teleport(location);
            packetHologram.createTeleportPacket();
            if (this.getCounter() % 5 != 0) continue;
            String[] stringArray = new String[]{"\u00a76", "\u00a7c", "\u00a7e", "\u00a76", "\u00a7c"};
            String string = packetHologram.getName().substring(2);
            packetHologram.setCustomName(stringArray[this.getCounter() / 5 % stringArray.length] + string);
            packetHologram.createMetadataPacket();
        }
        if (this.getCounter() % 2 == 0) {
            this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 40);
        }
    }

    private void phoenixCry() {
        this.sendParticlesAndEffects(this.phoenixHead.getLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
        for (int i = 1; i <= 7; ++i) {
            int n = i;
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                for (int i = 0; i < 360; i += 20) {
                    double d = Math.toRadians(i);
                    Location location = this.phoenixHead.getLocation().clone().add(Math.cos(d) * (double)n, 0.0, Math.sin(d) * (double)n);
                    this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 10);
                }
            }, (long)i * 2L);
        }
    }

    private Location rotateOffset(Location location, double d) {
        double d2 = location.getX();
        double d3 = location.getZ();
        double d4 = d2 * Math.cos(d) - d3 * Math.sin(d);
        double d5 = d2 * Math.sin(d) + d3 * Math.cos(d);
        return new Location(location.getWorld(), d4, location.getY(), d5);
    }

    private void clearPhoenix() {
        ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
        arrayList.add(this.phoenixHead);
        arrayList.add(this.phoenixBeak);
        arrayList.add(this.phoenixCrest);
        arrayList.add(this.phoenixEye1);
        arrayList.add(this.phoenixEye2);
        arrayList.add(this.phoenixChest);
        arrayList.addAll(this.phoenixNeck);
        arrayList.addAll(this.phoenixBody);
        arrayList.addAll(this.phoenixBelly);
        arrayList.addAll(this.leftWingBones);
        arrayList.addAll(this.rightWingBones);
        this.leftWingFeathers.forEach(arrayList::addAll);
        this.rightWingFeathers.forEach(arrayList::addAll);
        arrayList.addAll(this.phoenixTailBase);
        this.phoenixTailFeathers.forEach(arrayList::addAll);
        arrayList.addAll(this.leftLeg);
        arrayList.addAll(this.rightLeg);
        arrayList.add(this.leftTalon);
        arrayList.add(this.rightTalon);
        arrayList.addAll(this.fireCircle);
        arrayList.addAll(this.fireBreath);
        arrayList.addAll(this.fireBlast);
        arrayList.addAll(this.fireAura);
        arrayList.forEach(packetHologram -> {
            if (packetHologram != null) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            }
        });
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, object)));
        this.cancel();
    }
}

