/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.dragon;

import com.cryptomorin.xseries.advancedcrates.SkullUtils;
import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DragonAnimationV2
extends AnimationHandler {
    private PacketHologram dragonHead;
    private PacketHologram dragonWingLeft;
    private PacketHologram dragonWingRight;
    private List<Location> flightPath = new ArrayList<Location>();
    private int flightIndex = 0;
    private boolean breathingFire = false;
    private boolean rewardsSpawned = false;

    public DragonAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        this.setPlayerData(MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString()));
        Location location = this.getTargetLocation().clone().add(8.0, 10.0, 0.0);
        this.dragonHead = new PacketHologram("", location, location.getY(), iNMSHandler);
        ItemStack itemStack = XMaterial.PLAYER_HEAD.parseItem();
        itemStack.setItemMeta((ItemMeta)SkullUtils.applySkin(itemStack.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzRlY2MwNDA3ODVlNTQ2NjM1N2NhMWFhZTMzZWZhNjJmNjg5YzBlMzMxYmE5MmNkZDNkZTQ4NDVhMDViYjZmMSJ9fX0="));
        this.dragonHead.createEquipmentPacketHelmet(itemStack);
        this.dragonHead.setRightArmPose(0.0f, 0.0f, 0.0f);
        this.dragonWingLeft = new PacketHologram("", location.clone().add(-1.5, -0.3, 0.0), location.getY() - 0.3, iNMSHandler);
        this.dragonWingLeft.createEquipmentPacket(new ItemStack(Material.ELYTRA));
        this.dragonWingLeft.setRightArmPose(0.0f, 45.0f, 0.0f);
        this.dragonWingRight = new PacketHologram("", location.clone().add(1.5, -0.3, 0.0), location.getY() - 0.3, iNMSHandler);
        this.dragonWingRight.createEquipmentPacket(new ItemStack(Material.ELYTRA));
        this.dragonWingRight.setRightArmPose(0.0f, -45.0f, 0.0f);
        this.getAnimationHolograms().add(this.dragonHead);
        this.getAnimationHolograms().add(this.dragonWingLeft);
        this.getAnimationHolograms().add(this.dragonWingRight);
        this.getPackets().addAll(this.dragonHead.getAllPackets(true));
        this.getPackets().addAll(this.dragonWingLeft.getAllPackets(true));
        this.getPackets().addAll(this.dragonWingRight.getAllPackets(true));
        this.createFlightPath();
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 80 && this.flightIndex < this.flightPath.size()) {
            Location location = this.flightPath.get(this.flightIndex);
            this.dragonHead.teleport(location);
            this.dragonHead.createTeleportPacket();
            this.getPackets().add(this.dragonHead.getTeleportPacket());
            double d = Math.sin((double)this.getCounter() * 0.3) * 20.0;
            this.dragonWingLeft.setRightArmPose(0.0f, 45.0f + (float)d, 0.0f);
            this.dragonWingRight.setRightArmPose(0.0f, -45.0f - (float)d, 0.0f);
            this.dragonWingLeft.teleport(location.clone().add(-1.5, -0.3, 0.0));
            this.dragonWingRight.teleport(location.clone().add(1.5, -0.3, 0.0));
            this.dragonWingLeft.createTeleportPacket();
            this.dragonWingRight.createTeleportPacket();
            this.dragonWingLeft.createMetadataPacket();
            this.dragonWingRight.createMetadataPacket();
            this.getPackets().add(this.dragonWingLeft.getTeleportPacket());
            this.getPackets().add(this.dragonWingRight.getTeleportPacket());
            this.getPackets().add(this.dragonWingLeft.getMetadataPacket());
            this.getPackets().add(this.dragonWingRight.getMetadataPacket());
            if (this.getCounter() % 5 == 0) {
                this.sendParticlesAndEffects(location.clone().add(2.0, 0.0, 0.0), null, "CLOUD", 3);
                this.sendParticlesAndEffects(location.clone().add(-2.0, 0.0, 0.0), null, "CLOUD", 3);
            }
            if (this.getCounter() % 20 == 0) {
                AnimationSound.COSMIC_GIANT_CHEST_SPINNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), location);
            }
            ++this.flightIndex;
        } else if (this.getCounter() >= 80 && this.getCounter() < 120) {
            Location location;
            if (!this.breathingFire) {
                this.breathingFire = true;
                location = this.getTargetLocation().clone().add(0.5, 1.0, 0.5);
                this.dragonHead.setHeadPose(30.0f, 0.0f, 0.0f);
                this.dragonHead.createMetadataPacket();
                this.getPackets().add(this.dragonHead.getMetadataPacket());
                AnimationSound.GIANT_REWARDS_FLY.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), location);
            }
            location = this.dragonHead.getLocation().clone();
            Location location2 = this.getTargetLocation().clone().add(0.5, 0.5, 0.5);
            for (double d = 0.0; d <= 1.0; d += 0.1) {
                Location location3 = new Location(location2.getWorld(), location.getX() + (location2.getX() - location.getX()) * d, location.getY() + (location2.getY() - location.getY()) * d, location.getZ() + (location2.getZ() - location.getZ()) * d);
                this.sendParticlesAndEffects(location3, null, "FLAME", 5);
                this.sendParticlesAndEffects(location3, null, "SMOKE_LARGE", 2);
            }
            if (this.getCounter() % 3 == 0) {
                this.sendParticlesAndEffects(location2, null, "LAVA", 10);
                this.sendParticlesAndEffects(location2.clone().add(0.0, 0.5, 0.0), null, "FLAME", 20);
            }
        } else if (this.getCounter() == 120) {
            this.getLightningPackets().add(this.getHandler().getLightningPacket(this.getTargetLocation().clone().add(0.5, 1.0, 0.5)));
            this.sendParticlesAndEffects(this.getTargetLocation().clone().add(0.5, 1.0, 0.5), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
            for (Reward reward : this.getRewards()) {
                Object object = this.getHandler().getEntityItem(this.getTargetLocation().clone().add(0.5, 2.0, 0.5), reward.getReward(), false, true);
                this.getEntityItems().add(object);
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemVelocityPacket(object));
                this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
            }
            this.setSpawnItems(true);
            this.rewardsSpawned = true;
            AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        } else if (this.getCounter() > 120 && this.getCounter() < 180) {
            Location location = this.dragonHead.getLocation().clone().add(0.5, 0.3, -0.5);
            if (this.getCounter() == 121) {
                this.dragonHead.setHeadPose(0.0f, 0.0f, 0.0f);
                this.dragonHead.createMetadataPacket();
                this.getPackets().add(this.dragonHead.getMetadataPacket());
            }
            this.dragonHead.teleport(location);
            this.dragonHead.createTeleportPacket();
            this.getPackets().add(this.dragonHead.getTeleportPacket());
            double d = Math.sin((double)this.getCounter() * 0.4) * 25.0;
            this.dragonWingLeft.setRightArmPose(0.0f, 60.0f + (float)d, 0.0f);
            this.dragonWingRight.setRightArmPose(0.0f, -60.0f - (float)d, 0.0f);
            this.dragonWingLeft.teleport(location.clone().add(-1.5, -0.3, 0.0));
            this.dragonWingRight.teleport(location.clone().add(1.5, -0.3, 0.0));
            this.dragonWingLeft.createTeleportPacket();
            this.dragonWingRight.createTeleportPacket();
            this.dragonWingLeft.createMetadataPacket();
            this.dragonWingRight.createMetadataPacket();
            this.getPackets().add(this.dragonWingLeft.getTeleportPacket());
            this.getPackets().add(this.dragonWingRight.getTeleportPacket());
            this.getPackets().add(this.dragonWingLeft.getMetadataPacket());
            this.getPackets().add(this.dragonWingRight.getMetadataPacket());
            if (this.getCounter() == 179) {
                this.dragonHead.setTimeToDestroy(true);
                this.dragonWingLeft.setTimeToDestroy(true);
                this.dragonWingRight.setTimeToDestroy(true);
                this.dragonHead.createDestroyPacket();
                this.dragonWingLeft.createDestroyPacket();
                this.dragonWingRight.createDestroyPacket();
                this.getPackets().add(this.dragonHead.getDestroyPacket());
                this.getPackets().add(this.dragonWingLeft.getDestroyPacket());
                this.getPackets().add(this.dragonWingRight.getDestroyPacket());
            }
        } else if (this.getCounter() >= 240) {
            this.clearRunnable();
        }
        this.counterIncrement();
        this.sendPackets();
        this.clearPackets();
    }

    private void createFlightPath() {
        Location location = this.getTargetLocation().clone().add(10.0, 15.0, 0.0);
        Location location2 = this.getTargetLocation().clone().add(0.5, 5.0, 0.5);
        for (int i = 0; i <= 80; ++i) {
            double d = (double)i / 80.0;
            double d2 = location.getX() + (location2.getX() - location.getX()) * d;
            double d3 = location.getY() + (location2.getY() - location.getY()) * d * d;
            double d4 = location.getZ() + (location2.getZ() - location.getZ()) * d;
            Location location3 = new Location(this.getTargetLocation().getWorld(), d2, d3, d4);
            location3.setDirection(this.getTargetLocation().clone().add(0.5, 0.0, 0.5).subtract(location3).toVector());
            this.flightPath.add(location3);
        }
    }

    public void clearRunnable() {
        if (this.getCrate().getDeletePacketForPlayer().containsKey(this.getPlayer())) {
            this.getCrate().getDeletePacketForPlayer().get(this.getPlayer()).addAll(this.getDestroyPackets());
        } else {
            this.getCrate().getDeletePacketForPlayer().put(this.getPlayer(), this.getDestroyPackets());
        }
        new BukkitRunnable(){

            public void run() {
                if (DragonAnimationV2.this.rewardsSpawned) {
                    DragonAnimationV2.this.getCrate().getRewardsGiveQueue().put(DragonAnimationV2.this.getTaskHelper().getUniqueOpeningID(), new GiveOutRewards(DragonAnimationV2.this.getTaskHelper().getUniqueOpeningID(), DragonAnimationV2.this.getPlayer(), DragonAnimationV2.this.getRewards(), (Long)System.currentTimeMillis(), DragonAnimationV2.this.getCrate()));
                    Utils.sendFinalMessages(DragonAnimationV2.this.getCrate(), DragonAnimationV2.this.getRewards(), DragonAnimationV2.this.getPlayer());
                }
            }
        }.runTask((Plugin)MonthlyCrate.getInstance());
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.getPlayer())) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.getPlayer());
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.getTargetLocation());
        --MonthlyCrate.GlobalCratesOpening;
        this.getPlayerData().setOpeningCrate(false, this.getTargetLocation());
        if (!this.getCrate().isRerollEnabled()) {
            this.getPlayerData().closeCrate();
        }
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }
}

