/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.dnahelix;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DNAHelixAnimationV2
extends AnimationHandler {
    private List<PacketHologram> strand1 = new ArrayList<PacketHologram>();
    private List<PacketHologram> strand2 = new ArrayList<PacketHologram>();
    private List<PacketHologram> connectors = new ArrayList<PacketHologram>();
    private double helixHeight = 0.0;
    private boolean unwinding = false;

    public DNAHelixAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 1.0, 0.5));
        for (int i = 0; i < 20; ++i) {
            PacketHologram packetHologram = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.REDSTONE_BLOCK));
            this.strand1.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            PacketHologram packetHologram2 = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.LAPIS_BLOCK));
            this.strand2.add(packetHologram2);
            this.getAnimationHolograms().add(packetHologram2);
            this.getPackets().addAll(packetHologram2.getAllPackets(true));
            if (i % 3 != 0) continue;
            PacketHologram packetHologram3 = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
            packetHologram3.createEquipmentPacketHelmet(new ItemStack(Material.QUARTZ_BLOCK));
            this.connectors.add(packetHologram3);
            this.getAnimationHolograms().add(packetHologram3);
            this.getPackets().addAll(packetHologram3.getAllPackets(true));
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 100) {
            int n;
            this.helixHeight = (double)this.getCounter() * 0.04;
            for (n = 0; n < this.strand1.size(); ++n) {
                double d = (double)n * 0.2;
                double d2 = (double)n * 0.5 + (double)this.getCounter() * 0.05;
                double d3 = d2 + Math.PI;
                double d4 = Math.cos(d2) * 1.5;
                double d5 = Math.sin(d2) * 1.5;
                double d6 = Math.cos(d3) * 1.5;
                double d7 = Math.sin(d3) * 1.5;
                if (!(d <= this.helixHeight)) continue;
                this.strand1.get(n).teleport(this.getTargetLocation().clone().add(d4, d, d5));
                this.strand1.get(n).createTeleportPacket();
                this.strand2.get(n).teleport(this.getTargetLocation().clone().add(d6, d, d7));
                this.strand2.get(n).createTeleportPacket();
            }
            for (n = 0; n < this.connectors.size(); ++n) {
                int n2 = n * 3;
                if (n2 >= this.strand1.size()) continue;
                Location location = this.strand1.get(n2).getLocation();
                Location location2 = this.strand2.get(n2).getLocation();
                Location location3 = location.clone().add(location2).multiply(0.5);
                this.connectors.get(n).teleport(location3);
                this.connectors.get(n).createTeleportPacket();
            }
        } else if (this.getCounter() < 150) {
            this.unwinding = true;
            double d = (double)(this.getCounter() - 100) * 0.02;
            for (int i = 0; i < this.strand1.size(); ++i) {
                double d8 = (double)i * 0.2;
                double d9 = (double)i * 0.5 + (double)this.getCounter() * 0.05 - d;
                double d10 = d9 + Math.PI + d * 2.0;
                double d11 = 1.5 + d * 2.0;
                double d12 = Math.cos(d9) * d11;
                double d13 = Math.sin(d9) * d11;
                double d14 = Math.cos(d10) * d11;
                double d15 = Math.sin(d10) * d11;
                this.strand1.get(i).teleport(this.getTargetLocation().clone().add(d12, d8, d13));
                this.strand1.get(i).createTeleportPacket();
                this.strand2.get(i).teleport(this.getTargetLocation().clone().add(d14, d8, d15));
                this.strand2.get(i).createTeleportPacket();
            }
            this.connectors.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
        } else if (this.getCounter() == 150) {
            this.strand1.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.strand2.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            for (int i = 0; i < this.getRewards().size(); ++i) {
                Reward reward = this.getRewards().get(i);
                Location location = this.getTargetLocation().clone().add(0.0, (double)i * 0.5 + 1.0, 0.0);
                PacketHologram packetHologram2 = new PacketHologram(reward.getItemBuilder().getDisplayName(), location, location.getY(), this.getHandler());
                packetHologram2.createEquipmentPacket(reward.getReward());
                this.getAnimationHolograms().add(packetHologram2);
                this.getPackets().addAll(packetHologram2.getAllPackets(true));
            }
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 200) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.cancel();
    }
}

