/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.cosmic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.PM2.AdvancedCrates.ArmorStands;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CosmicAnimationHologramRemove
extends BukkitRunnable {
    RepeatingTaskHelper taskhelper;
    List<PacketHologram> stands;
    List<ArmorStands> standsReal;
    String text;
    String coloring = "";
    INMSHandler handler;
    Location targetLoc;
    int howFarShown = MonthlyCrate.howFarShownPackets ^ 2;
    int proximityDistance = 7;
    Player pl;
    Set<Player> shownToPlayers;
    boolean individual = false;
    boolean all = false;
    boolean timeToSkip = false;
    boolean playPackets = true;

    public CosmicAnimationHologramRemove(RepeatingTaskHelper repeatingTaskHelper, List<PacketHologram> list, INMSHandler iNMSHandler, Location location, Player player, Crate crate, boolean bl, List<ArmorStands> list2) {
        this.taskhelper = repeatingTaskHelper;
        this.stands = list;
        this.playPackets = bl;
        this.handler = iNMSHandler;
        this.targetLoc = location;
        this.standsReal = list2;
        this.shownToPlayers = repeatingTaskHelper.getShownToPlayers();
        this.pl = player;
        this.individual = crate.getVisibilityOption().equalsIgnoreCase("Individual") || crate.getVisibilityOption().equalsIgnoreCase("Opener");
        this.all = crate.getVisibilityOption().equalsIgnoreCase("All");
        if (bl) {
            this.sendPackets();
        }
        this.howFarShown = MonthlyCrate.howFarShownPackets * MonthlyCrate.howFarShownPackets;
        this.proximityDistance = crate.getProximity() * crate.getProximity();
    }

    public void run() {
        if (this.taskhelper.getCounter() % 3 == 0) {
            if (this.playPackets) {
                for (PacketHologram packetHologram : this.stands) {
                    if (packetHologram.getName() == null || packetHologram.getName().length() == 0) {
                        packetHologram.setTimeToDestroy(true);
                        packetHologram.createDestroyPacket();
                        continue;
                    }
                    this.text = packetHologram.getName();
                    this.text = this.text.replaceAll("\ufffd", "&");
                    if (this.text.length() <= 1) {
                        packetHologram.setTimeToDestroy(true);
                        packetHologram.createDestroyPacket();
                        continue;
                    }
                    if (this.text.length() == 2) {
                        if ((this.text.charAt(this.text.length() - 1) + "").equals("&")) {
                            packetHologram.setTimeToDestroy(true);
                            packetHologram.createDestroyPacket();
                            continue;
                        }
                        packetHologram.setCustomName(Common.colorize(this.text.substring(0, this.text.length() - 1)));
                        packetHologram.createMetadataPacket();
                        continue;
                    }
                    if ((this.text.charAt(0) + "").equals("&")) {
                        this.coloring = "" + this.text.charAt(0) + this.text.charAt(1);
                        if (this.text.length() >= 4 && (this.text.charAt(2) + "").equals("&")) {
                            this.coloring = "" + this.text.charAt(2) + this.text.charAt(3);
                            if (this.text.length() >= 6 && (this.text.charAt(4) + "").equals("&")) {
                                this.coloring = "" + this.text.charAt(4) + this.text.charAt(5);
                                if (this.text.length() >= 8 && (this.text.charAt(5) + "").equals("&")) {
                                    this.coloring = "" + this.text.charAt(5) + this.text.charAt(6);
                                }
                            }
                        }
                    }
                    if (this.text.length() - this.coloring.length() <= 1) {
                        packetHologram.setTimeToDestroy(true);
                        packetHologram.createDestroyPacket();
                        continue;
                    }
                    if (this.text.length() - this.coloring.length() == 2) {
                        packetHologram.setCustomName(Common.colorize(this.coloring + this.text.substring(0, this.text.length() - 1)));
                        packetHologram.createMetadataPacket();
                        continue;
                    }
                    this.text = this.text.substring(this.coloring.length(), this.text.length());
                    this.text = this.text.substring(1);
                    if (this.text.length() >= 3 && (this.text.charAt(this.text.length() - 2) + "").equals("&")) {
                        this.text = this.text.substring(0, this.text.length() - 2);
                    }
                    if (this.text.length() >= 2) {
                        this.text = this.text.substring(0, this.text.length() - 1);
                    }
                    if ((this.text.charAt(this.text.length() - 1) + "").equals("&")) {
                        this.text = this.text.substring(0, this.text.length() - 1);
                    }
                    packetHologram.setCustomName(Common.colorize(this.coloring + this.text));
                    packetHologram.createMetadataPacket();
                    this.coloring = "";
                }
            } else {
                for (final ArmorStands armorStands : this.standsReal) {
                    if (armorStands == null || armorStands.getStand() == null) continue;
                    if (armorStands.getStand().getCustomName() == null || armorStands.getStand().getCustomName().length() == 0) {
                        new BukkitRunnable(){

                            public void run() {
                                armorStands.getStand().remove();
                                armorStands.clear();
                            }
                        }.runTask((Plugin)MonthlyCrate.getInstance());
                        continue;
                    }
                    this.text = armorStands.getStand().getCustomName();
                    this.text = this.text.replaceAll("\ufffd", "&");
                    if (this.text.length() <= 1) {
                        new BukkitRunnable(){

                            public void run() {
                                armorStands.getStand().remove();
                                armorStands.clear();
                            }
                        }.runTask((Plugin)MonthlyCrate.getInstance());
                        continue;
                    }
                    if (this.text.length() == 2) {
                        if ((this.text.charAt(this.text.length() - 1) + "").equals("&")) {
                            new BukkitRunnable(){

                                public void run() {
                                    armorStands.getStand().remove();
                                    armorStands.clear();
                                }
                            }.runTask((Plugin)MonthlyCrate.getInstance());
                            continue;
                        }
                        armorStands.getStand().setCustomName(Common.colorize(this.text.substring(0, this.text.length() - 1)));
                        continue;
                    }
                    if ((this.text.charAt(0) + "").equals("&")) {
                        this.coloring = "" + this.text.charAt(0) + this.text.charAt(1);
                        if (this.text.length() >= 4 && (this.text.charAt(2) + "").equals("&")) {
                            this.coloring = "" + this.text.charAt(2) + this.text.charAt(3);
                            if (this.text.length() >= 6 && (this.text.charAt(4) + "").equals("&")) {
                                this.coloring = "" + this.text.charAt(4) + this.text.charAt(5);
                                if (this.text.length() >= 8 && (this.text.charAt(5) + "").equals("&")) {
                                    this.coloring = "" + this.text.charAt(5) + this.text.charAt(6);
                                }
                            }
                        }
                    }
                    if (this.text.length() - this.coloring.length() <= 1) {
                        new BukkitRunnable(){

                            public void run() {
                                armorStands.getStand().remove();
                                armorStands.clear();
                            }
                        }.runTask((Plugin)MonthlyCrate.getInstance());
                        continue;
                    }
                    if (this.text.length() - this.coloring.length() == 2) {
                        armorStands.getStand().setCustomName(Common.colorize(this.coloring + this.text.substring(0, this.text.length() - 1)));
                        continue;
                    }
                    this.text = this.text.substring(this.coloring.length(), this.text.length());
                    this.text = this.text.substring(1);
                    if (this.text.length() >= 3 && (this.text.charAt(this.text.length() - 2) + "").equals("&")) {
                        this.text = this.text.substring(0, this.text.length() - 2);
                    }
                    if (this.text.length() >= 2) {
                        this.text = this.text.substring(0, this.text.length() - 1);
                    }
                    if ((this.text.charAt(this.text.length() - 1) + "").equals("&")) {
                        this.text = this.text.substring(0, this.text.length() - 1);
                    }
                    armorStands.getStand().setCustomName(Common.colorize(this.coloring + this.text));
                    this.coloring = "";
                }
            }
        }
        if (this.playPackets) {
            this.sendPackets();
        }
        if ((this.stands == null || this.stands.isEmpty()) && (this.standsReal == null || this.standsReal.isEmpty()) && this.taskhelper != null) {
            Bukkit.getScheduler().cancelTask(this.taskhelper.getTaskID());
        }
        assert (this.taskhelper != null);
        this.taskhelper.increment();
    }

    public void sendPackets() {
        if (this.timeToSkip) {
            this.timeToSkip = false;
            return;
        }
        this.timeToSkip = true;
        CopyOnWriteArrayList<Player> copyOnWriteArrayList = new CopyOnWriteArrayList<Player>(this.getNearbyEntities());
        if (this.pl != null && this.pl.isOnline()) {
            copyOnWriteArrayList.add(this.pl);
        }
        HashSet hashSet = new HashSet();
        this.processPlayersInBatches(copyOnWriteArrayList, 10, player -> this.processPlayer((Player)player, hashSet));
        List<Object> list = this.getDestroyPackets();
        HashSet<OfflinePlayer> hashSet2 = new HashSet<OfflinePlayer>();
        this.removeOfflinePlayers(this.shownToPlayers, copyOnWriteArrayList, list, hashSet2);
        this.shownToPlayers.removeAll(hashSet2);
        this.stands.removeAll(hashSet);
    }

    private void processPlayersInBatches(List<Player> list, int n, final Consumer<Player> consumer) {
        for (int i = 0; i < list.size(); i += n) {
            final ArrayList<Player> arrayList = new ArrayList<Player>(list.subList(i, Math.min(i + n, list.size())));
            new BukkitRunnable(){

                public void run() {
                    arrayList.forEach(consumer);
                }
            }.runTaskAsynchronously((Plugin)MonthlyCrate.getInstance());
        }
    }

    private void processPlayer(Player player, Set<PacketHologram> set) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.shownToPlayers.contains(player)) {
            this.stands.forEach(packetHologram -> {
                if (packetHologram.isTimeToDestroy()) {
                    this.handler.sendPacket(this.pl, packetHologram.getDestroyPacket());
                    set.add((PacketHologram)packetHologram);
                } else {
                    packetHologram.sendAllPackets(this.pl);
                }
            });
        } else {
            this.stands.forEach(packetHologram -> {
                if (packetHologram.isTimeToDestroy()) {
                    this.handler.sendPacket(this.pl, packetHologram.getDestroyPacket());
                    set.add((PacketHologram)packetHologram);
                } else {
                    packetHologram.sendAllPackets(this.pl, true);
                }
            });
            this.shownToPlayers.add(this.pl);
        }
    }

    private void removeOfflinePlayers(final Set<Player> set, final List<Player> list, final List<Object> list2, final Set<OfflinePlayer> set2) {
        new BukkitRunnable(){

            public void run() {
                set.stream().filter(player -> !list.contains(player) && player != null && player.isOnline()).forEach(player -> {
                    list2.forEach(object -> CosmicAnimationHologramRemove.this.handler.sendPacket((Player)player, object));
                    set2.add(player);
                });
            }
        }.runTaskAsynchronously((Plugin)MonthlyCrate.getInstance());
    }

    public List<Object> getDestroyPackets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.stands.forEach(packetHologram -> arrayList.add(packetHologram.getDestroyPacket()));
        return arrayList;
    }

    public Set<Player> getNearbyEntities() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.targetLoc.getWorld() || !((d = this.targetLoc.distanceSquared(player.getLocation())) < (double)this.howFarShown) || !(d > (double)this.proximityDistance) && !this.all) continue;
            hashSet.add(player);
        }
        return hashSet;
    }
}

