/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.cosmic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CosmicAnimationEndV2
extends AnimationHandler {
    PacketHologram stand;
    PacketHologram smallStand;
    Location standLoc;
    Location smallStandLoc;
    Location smallToWhere;
    final List<Location> locations;
    final List<Location> smallLocations;
    double randNumber = 1.0;
    double correctionText;
    double correctionY = 0.0;
    boolean clear = false;
    boolean timeToSkip = false;
    boolean timeToClear = false;
    private Reward reward;
    private int counter = 0;

    public CosmicAnimationEndV2(AnimationHandler animationHandler, Location location, Location location2, Reward reward) {
        super(animationHandler);
        this.reward = reward;
        ItemStack itemStack = reward.getReward();
        this.smallToWhere = location.clone().add(0.0, 1.2, 0.0);
        this.standLoc = location2.clone();
        this.smallStandLoc = this.standLoc.clone().add(0.0, 1.2, 0.0);
        if (Utils.checkIfContainsTools(itemStack.getType())) {
            this.correctionText = 1.14;
            this.correctionY = -0.41;
        } else if (Utils.checkIfContainsItems(itemStack.getType())) {
            this.correctionText = 0.85;
        } else {
            this.correctionY = 0.765;
            this.correctionText = 0.12;
        }
        this.locations = MonthlyCrate.getLocationsToBlock(this.standLoc, location, (int)(41.0 / this.getCrate().getCosmicAnimationSpeed()));
        this.smallLocations = MonthlyCrate.getLocationsToBlock(this.smallStandLoc, this.smallToWhere, (int)(41.0 / this.getCrate().getCosmicAnimationSpeed()));
    }

    public void executeTasks() {
        if (this.counter < (int)(4.0 / this.getCrate().getCosmicAnimationSpeed())) {
            if (this.counter == (int)(3.0 / this.getCrate().getCosmicAnimationSpeed())) {
                ArrayList<Reward> arrayList = new ArrayList<Reward>();
                arrayList.add(this.reward);
                arrayList.addAll(this.reward.getLinkedRewards());
                for (Reward reward : arrayList) {
                    ItemStack itemStack = reward.getReward();
                    String string = itemStack.getItemMeta().hasDisplayName() ? (itemStack.getItemMeta().getDisplayName().equals("") ? Utils.getDefaultItemName(itemStack) : itemStack.getItemMeta().getDisplayName()) : itemStack.getType().name();
                    try {
                        double d;
                        ItemMeta itemMeta;
                        block17: {
                            itemMeta = itemStack.getItemMeta();
                            String string2 = reward.getPath();
                            double d2 = 1.0;
                            d2 = reward.getRandomNumberMax();
                            double d3 = 1.0;
                            d = d3 = reward.getRandomNumberMin();
                            if (d2 < d3) {
                                MonthlyCrate.Errors.add("RandomNumberMin is bigger than RandomNumberMax, please fix this, otherwise randomNumber will always be RandomNumberMin. (" + string2 + ")");
                            }
                            if (d2 > 0.0 && d2 != d3) {
                                try {
                                    d = reward.isRandomNumberDoubleValue() ? ThreadLocalRandom.current().nextDouble(d3, d2 + 0.01) : (double)ThreadLocalRandom.current().nextLong((long)d3, (long)d2 + 1L);
                                }
                                catch (Exception exception) {
                                    if (MonthlyCrate.debug) {
                                        System.out.println("AMC: " + exception.getStackTrace()[0].getLineNumber());
                                    }
                                    if (!MonthlyCrate.debug) break block17;
                                    System.out.println(exception);
                                }
                            }
                        }
                        itemStack.setItemMeta(itemMeta);
                        this.randNumber = d = Utils.round(d, 2);
                        reward.setRandomNumberValue(d);
                        Location location = Utils.getLocationAroundCircle(this.locations.get(0).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.counter, 1, 0);
                        this.stand = Utils.checkIfContainsTools(itemStack.getType()) ? new PacketHologram("", location, location.getY(), this.getHandler(), 260.0f, 315.0f, 0.0f) : (Utils.checkIfContainsItems(itemStack.getType()) ? new PacketHologram("", location, location.getY(), this.getHandler(), 275.0f, 320.0f, 0.0f) : new PacketHologram("", location, location.getY(), this.getHandler(), 350.0f, 325.0f, 345.0f));
                        this.smallStand = new PacketHologram(Common.colorize(string.replaceAll("\\{random_number\\}", reward.isRandomNumberDoubleValue() ? Double.toString(this.randNumber) : Long.toString((long)d))), this.smallLocations.get(0).clone().add(0.0, this.correctionY + this.correctionText, 0.0), this.smallLocations.get(0).clone().add(0.0, this.correctionY + this.correctionText, 0.0).getY(), this.getHandler());
                        this.stand.createEquipmentPacket(itemStack);
                        this.getPackets().addAll(this.stand.getAllPackets(true));
                        this.getPackets().addAll(this.smallStand.getAllPackets(true));
                        this.getAnimationHolograms().addAll(Arrays.asList(this.stand, this.smallStand));
                    }
                    catch (Exception exception) {
                        if (MonthlyCrate.debug) {
                            System.out.println("AMC: " + exception.getStackTrace()[0].getLineNumber());
                        }
                        System.out.println(exception);
                    }
                }
            }
        } else if (this.counter < (int)(44.0 / this.getCrate().getCosmicAnimationSpeed())) {
            if (this.counter >= (int)(7.0 / this.getCrate().getCosmicAnimationSpeed())) {
                this.sendParticlesAndEffects(this.smallLocations.get(this.counter - (int)(7.0 / this.getCrate().getCosmicAnimationSpeed())).clone().add(0.0, this.correctionY + this.correctionText / 2.0 - 0.15, 0.0), Utils.isVersionOld() ? "FIREWORKS_SPARK" : null, Utils.isVersionOld() ? null : "ITEM_CRACK", 10, this.reward.getReward());
                AnimationSound.GIANT_REWARDS_FLY.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.standLoc);
            }
            if (this.stand == null || this.smallStand == null) {
                return;
            }
            this.stand.teleport(Utils.getLocationAroundCircle(this.locations.get(this.counter - (int)(4.0 / this.getCrate().getCosmicAnimationSpeed())).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.counter, 1, 0));
            this.stand.createTeleportPacket();
            this.getPackets().add(this.stand.getTeleportPacket());
            this.smallStand.teleport(this.smallLocations.get(this.counter - (int)(4.0 / this.getCrate().getCosmicAnimationSpeed())).clone().add(0.0, this.correctionY + this.correctionText, 0.0));
            this.smallStand.createTeleportPacket();
            this.getPackets().add(this.smallStand.getTeleportPacket());
        } else {
            if (this.stand == null || this.smallStand == null) {
                return;
            }
            this.stand.teleport(Utils.getLocationAroundCircle(this.locations.get(this.locations.size() - 1).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.counter, 1, 0));
            this.stand.createTeleportPacket();
            this.smallStand.teleport(this.smallLocations.get(this.smallLocations.size() - 1).clone().add(0.0, this.correctionY + this.correctionText, 0.0));
            this.smallStand.createTeleportPacket();
            this.getPackets().add(this.stand.getTeleportPacket());
            this.getPackets().add(this.smallStand.getTeleportPacket());
        }
        ++this.counter;
    }

    public void clearRunnable() {
        this.timeToSkip = false;
        this.reward.giveReward(this.getPlayer(), this.getCrate(), this.randNumber);
        this.stand.setTimeToDestroy(true);
        this.stand.createDestroyPacket();
        this.smallStand.setTimeToDestroy(true);
        this.smallStand.createDestroyPacket();
        this.timeToSkip = false;
        this.timeToClear = true;
        this.stand.removeEntity();
        this.smallStand.removeEntity();
        this.stand = null;
        this.smallStand = null;
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, object)));
    }
}

