/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.cosmic;

import com.cryptomorin.xseries.advancedcrates.XSound;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.PM2.AdvancedCrates.ArmorStands;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.ArmorStandBuilder;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.SoundData;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;

public class CosmicAnimationEnd
extends BukkitRunnable {
    RepeatingTaskHelper taskhelper;
    String crateName;
    PacketHologram stand;
    PacketHologram smallStand;
    ArmorStands standReal;
    ArmorStands smallStandReal;
    Player pl;
    ItemStack prize;
    Location standLoc;
    Location smallStandLoc;
    Location toWhere;
    Location smallToWhere;
    final List<Location> locations;
    final List<Location> smallLocations;
    Crate crate;
    double randNumber = 1.0;
    double correctionText = 0.0;
    double correctionY = 0.0;
    INMSHandler handler;
    CopyOnWriteArraySet<Player> shownToPlayers = new CopyOnWriteArraySet();
    int howFarShown = MonthlyCrate.howFarShownPackets ^ 2;
    int proximityDistance = 7;
    boolean individual = false;
    boolean all = false;
    boolean isdoublevalue = false;
    boolean clear = false;
    boolean timeToSkip = false;
    boolean timeToClear = false;
    int soundHearingDistance = MonthlyCrate.soundsVolumes.getOrDefault("Sound_Hearing_Distance", 8);
    boolean playPackets;
    private Reward reward;
    private String uniqueOpeningID;

    public CosmicAnimationEnd(RepeatingTaskHelper repeatingTaskHelper, String string, Location location, Player player, Location location2, Reward reward, Crate crate, INMSHandler iNMSHandler, boolean bl) {
        this.taskhelper = repeatingTaskHelper;
        this.uniqueOpeningID = this.taskhelper.getUniqueOpeningID();
        this.reward = reward;
        ItemStack itemStack = reward.getReward();
        this.smallToWhere = bl ? location.clone().add(0.0, 1.2, 0.0) : location.clone().add(0.0, -0.7, 0.0);
        this.crateName = string;
        this.pl = player;
        this.playPackets = bl;
        this.howFarShown = MonthlyCrate.howFarShownPackets * MonthlyCrate.howFarShownPackets;
        this.proximityDistance = crate.getProximity() * crate.getProximity();
        this.crate = crate;
        this.standLoc = location2.clone();
        this.taskhelper.setCosmicEndInstance(this);
        this.individual = crate.getVisibilityOption().equalsIgnoreCase("Individual") || crate.getVisibilityOption().equalsIgnoreCase("Opener");
        this.all = crate.getVisibilityOption().equalsIgnoreCase("All");
        this.shownToPlayers.addAll(repeatingTaskHelper.getShownToPlayers());
        this.smallStandLoc = bl ? this.standLoc.clone().add(0.0, 1.2, 0.0) : this.standLoc.clone().add(0.0, -0.7, 0.0);
        this.handler = iNMSHandler;
        if (Utils.checkIfContainsTools(itemStack.getType())) {
            this.correctionText = 1.14;
            this.correctionY = -0.41;
        } else if (Utils.checkIfContainsItems(itemStack.getType())) {
            this.correctionText = 0.85;
        } else {
            this.correctionY = 0.765;
            this.correctionText = 0.12;
        }
        this.locations = MonthlyCrate.getLocationsToBlock(this.standLoc, location, 41);
        this.smallLocations = MonthlyCrate.getLocationsToBlock(this.smallStandLoc, this.smallToWhere, 41);
        this.prize = itemStack;
        new BukkitRunnable(){

            public void run() {
                if (CosmicAnimationEnd.this.taskhelper != null) {
                    Bukkit.getScheduler().cancelTask(CosmicAnimationEnd.this.taskhelper.getTaskID());
                }
            }
        }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 4200L);
    }

    public void run() {
        if (this.taskhelper.getCounter() < 4) {
            if (this.taskhelper.getCounter() == 3) {
                ArrayList<Reward> arrayList = new ArrayList<Reward>();
                arrayList.add(this.reward);
                arrayList.addAll(this.reward.getLinkedRewards());
                for (final Reward reward : arrayList) {
                    final ItemStack itemStack = reward.getReward();
                    final String string = itemStack.getItemMeta().hasDisplayName() ? (itemStack.getItemMeta().getDisplayName().equals("") ? Utils.getDefaultItemName(itemStack) : itemStack.getItemMeta().getDisplayName()) : itemStack.getType().name();
                    try {
                        double d;
                        ItemMeta itemMeta;
                        block42: {
                            itemMeta = itemStack.getItemMeta();
                            String string2 = reward.getPath();
                            double d2 = 1.0;
                            d2 = reward.getRandomNumberMax();
                            double d3 = 1.0;
                            d = d3 = reward.getRandomNumberMin();
                            if (d2 < d3) {
                                MonthlyCrate.Errors.add("RandomNumberMin is bigger than RandomNumberMax, please fix this, otherwise randomNumber will always be RandomNumberMin. (" + string2 + ")");
                            }
                            if (d2 > 0.0 && d2 != d3) {
                                try {
                                    d = reward.isRandomNumberDoubleValue() ? ThreadLocalRandom.current().nextDouble(d3, d2 + 0.01) : (double)ThreadLocalRandom.current().nextLong((long)d3, (long)d2 + 1L);
                                }
                                catch (Exception exception) {
                                    if (MonthlyCrate.debug) {
                                        System.out.println("AMC: " + exception.getStackTrace()[0].getLineNumber());
                                    }
                                    if (!MonthlyCrate.debug) break block42;
                                    System.out.println(exception);
                                }
                            }
                        }
                        itemStack.setItemMeta(itemMeta);
                        this.randNumber = d = Utils.round(d, 2);
                        this.isdoublevalue = reward.isRandomNumberDoubleValue();
                        final Location location = Utils.getLocationAroundCircle(this.locations.get(0).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.taskhelper.getCounter(), 1, 0);
                        if (Utils.checkIfContainsTools(itemStack.getType())) {
                            if (this.playPackets) {
                                this.stand = new PacketHologram("", location, location.getY(), this.handler, 260.0f, 315.0f, 0.0f);
                            } else {
                                new BukkitRunnable(){

                                    public void run() {
                                        CosmicAnimationEnd.this.standReal = new ArmorStands(new ArmorStandBuilder(location.clone().add(0.0, -0.15, 0.0)).withInvisible().withNoGravity().withRightArmPose(new EulerAngle(Math.toRadians(260.0), Math.toRadians(315.0), Math.toRadians(0.0))).spawn());
                                        CosmicAnimationEnd.this.standReal.getStand().setItemInHand(itemStack);
                                    }
                                }.runTask((Plugin)MonthlyCrate.getInstance());
                            }
                        } else if (Utils.checkIfContainsItems(itemStack.getType())) {
                            if (this.playPackets) {
                                this.stand = new PacketHologram("", location, location.getY(), this.handler, 275.0f, 320.0f, 0.0f);
                            } else {
                                new BukkitRunnable(){

                                    public void run() {
                                        CosmicAnimationEnd.this.standReal = new ArmorStands(new ArmorStandBuilder(location.clone().add(0.0, -0.15, 0.0)).withInvisible().withNoGravity().withRightArmPose(new EulerAngle(Math.toRadians(275.0), Math.toRadians(320.0), Math.toRadians(0.0))).spawn());
                                        CosmicAnimationEnd.this.standReal.getStand().setItemInHand(itemStack);
                                    }
                                }.runTask((Plugin)MonthlyCrate.getInstance());
                            }
                        } else if (itemStack.getType() != null) {
                            if (this.playPackets) {
                                this.stand = new PacketHologram("", location, location.getY(), this.handler, 350.0f, 325.0f, 345.0f);
                            } else {
                                new BukkitRunnable(){

                                    public void run() {
                                        CosmicAnimationEnd.this.standReal = new ArmorStands(new ArmorStandBuilder(location.clone().add(0.0, -0.15, 0.0)).withInvisible().withNoGravity().withRightArmPose(new EulerAngle(Math.toRadians(350.0), Math.toRadians(325.0), Math.toRadians(345.0))).spawn());
                                        CosmicAnimationEnd.this.standReal.getStand().setItemInHand(itemStack);
                                    }
                                }.runTask((Plugin)MonthlyCrate.getInstance());
                            }
                        } else if (this.playPackets) {
                            this.stand = new PacketHologram("", location, location.getY(), this.handler, 275.0f, 320.0f, 0.0f);
                        } else {
                            new BukkitRunnable(){

                                public void run() {
                                    CosmicAnimationEnd.this.standReal = new ArmorStands(new ArmorStandBuilder(location.clone().add(0.0, -0.15, 0.0)).withInvisible().withNoGravity().withRightArmPose(new EulerAngle(Math.toRadians(275.0), Math.toRadians(320.0), Math.toRadians(0.0))).spawn());
                                    CosmicAnimationEnd.this.standReal.getStand().setItemInHand(itemStack);
                                }
                            }.runTask((Plugin)MonthlyCrate.getInstance());
                        }
                        if (this.playPackets) {
                            this.smallStand = new PacketHologram(Common.colorize(string.replaceAll("\\{random_number\\}", reward.isRandomNumberDoubleValue() ? Double.toString(this.randNumber) : Long.toString((long)d))), this.smallLocations.get(0).clone().add(0.0, this.correctionY + this.correctionText, 0.0), this.smallLocations.get(0).clone().add(0.0, this.correctionY + this.correctionText, 0.0).getY(), this.handler);
                            this.stand.createEquipmentPacket(itemStack);
                            continue;
                        }
                        final double d4 = d;
                        new BukkitRunnable(){

                            public void run() {
                                CosmicAnimationEnd.this.smallStandReal = new ArmorStands(new ArmorStandBuilder(CosmicAnimationEnd.this.smallLocations.get(0).clone().add(0.0, CosmicAnimationEnd.this.correctionY + CosmicAnimationEnd.this.correctionText, 0.0)).withCustomName(true, Common.colorize(string.replaceAll("\\{random_number\\}", reward.isRandomNumberDoubleValue() ? Double.toString(CosmicAnimationEnd.this.randNumber) : Long.toString((long)d4)))).withInvisible().withNoGravity().spawn());
                            }
                        }.runTask((Plugin)MonthlyCrate.getInstance());
                    }
                    catch (Exception exception) {
                        if (MonthlyCrate.debug) {
                            System.out.println("AMC: " + exception.getStackTrace()[0].getLineNumber());
                        }
                        System.out.println(exception);
                    }
                }
            }
        } else if (this.taskhelper.getCounter() < 44) {
            if (this.taskhelper.getCounter() >= 7 && this.taskhelper.getCounter() < 44) {
                if (this.playPackets) {
                    this.sendParticlesAndEffects(this.smallLocations.get(this.taskhelper.getCounter() - 7).clone().add(0.0, this.correctionY + this.correctionText / 2.0 - 0.15, 0.0), Utils.isVersionOld() ? "FIREWORKS_SPARK" : null, Utils.isVersionOld() ? null : "ITEM_CRACK", 10, this.prize);
                } else {
                    this.sendParticlesAndEffects(this.smallLocations.get(this.taskhelper.getCounter() - 7).clone().add(0.0, 1.5 + this.correctionY + this.correctionText / 2.0, 0.0), Utils.isVersionOld() ? "FIREWORKS_SPARK" : null, Utils.isVersionOld() ? null : "ITEM_CRACK", 10, this.prize);
                }
                for (String string : MonthlyCrate.sounds.get("Cosmic_Animation_Sounds.While_Individual_Rewards_Fly")) {
                    if (string == null || string.isEmpty()) continue;
                    SoundData soundData = new SoundData(XSound.matchXSound(string).get(), MonthlyCrate.soundsVolumes.get("Cosmic_Animation_Sounds.While_Individual_Rewards_Fly_Volume").intValue(), MonthlyCrate.soundsVolumes.get("Cosmic_Animation_Sounds.While_Individual_Rewards_Fly_Pitch").intValue());
                    HashSet<Player> hashSet = new HashSet<Player>(this.getNearbyEntitiesSounds());
                    if (this.pl != null && this.pl.isOnline()) {
                        hashSet.add(this.pl);
                    }
                    hashSet.forEach(player -> soundData.playTo((Player)player, this.standLoc));
                }
            }
            if (!(this.stand != null && this.smallStand != null || this.standReal != null && this.smallStandReal != null)) {
                return;
            }
            if (this.playPackets) {
                this.stand.teleport(Utils.getLocationAroundCircle(this.locations.get(this.taskhelper.getCounter() - 4).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.taskhelper.getCounter(), 1, 0));
                this.stand.createTeleportPacket();
                this.smallStand.teleport(this.smallLocations.get(this.taskhelper.getCounter() - 4).clone().add(0.0, this.correctionY + this.correctionText, 0.0));
                this.smallStand.createTeleportPacket();
            } else {
                this.standReal.getStand().teleport(Utils.getLocationAroundCircle(this.locations.get(this.taskhelper.getCounter() - 4).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.taskhelper.getCounter(), 1, 0));
                this.smallStandReal.getStand().teleport(this.smallLocations.get(this.taskhelper.getCounter() - 4).clone().add(0.0, this.correctionY + this.correctionText, 0.0));
            }
        } else {
            if (!(this.stand != null && this.smallStand != null || this.standReal != null && this.smallStandReal != null)) {
                return;
            }
            if (this.playPackets) {
                this.stand.teleport(Utils.getLocationAroundCircle(this.locations.get(40).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.taskhelper.getCounter(), 1, 0));
                this.stand.createTeleportPacket();
            } else {
                this.standReal.getStand().teleport(Utils.getLocationAroundCircle(this.locations.get(40).clone().add(0.0, this.correctionY, 0.0), 0.4355f, 0.2176 * (double)this.taskhelper.getCounter(), 1, 0));
            }
        }
        if (this.stand != null && this.smallStand != null && this.playPackets) {
            this.sendPackets();
        }
        this.taskhelper.increment();
        if (this.clear) {
            this.clearRunnable();
        }
    }

    public void cancel() {
        this.crate.getRewardsGiveQueue().put(this.uniqueOpeningID, new GiveOutRewards(this.uniqueOpeningID, this.pl, this.reward, this.randNumber, (Long)System.currentTimeMillis(), this.crate));
        if (this.playPackets) {
            this.stand.setTimeToDestroy(true);
            this.stand.createDestroyPacket();
            this.smallStand.setTimeToDestroy(true);
            this.smallStand.createDestroyPacket();
            this.sendPackets();
            this.stand.removeEntity();
            this.smallStand.removeEntity();
            this.stand = null;
            this.smallStand = null;
        } else {
            this.standReal.getStand().remove();
            this.standReal.clear();
            this.smallStandReal.getStand().remove();
            this.smallStandReal.clear();
        }
    }

    public void sendPackets() {
        if (this.timeToSkip) {
            this.timeToSkip = false;
            return;
        }
        this.timeToSkip = true;
        if (this.stand == null || this.smallStand == null) {
            return;
        }
        CopyOnWriteArrayList<Player> copyOnWriteArrayList = new CopyOnWriteArrayList<Player>(this.getNearbyEntities());
        if (this.pl != null && this.pl.isOnline()) {
            copyOnWriteArrayList.add(this.pl);
        }
        this.processPlayersInBatches(copyOnWriteArrayList, 10, this::processPlayer);
        List<Object> list = this.getDestroyPackets();
        HashSet<OfflinePlayer> hashSet = new HashSet<OfflinePlayer>();
        this.removeOfflinePlayers(this.shownToPlayers, copyOnWriteArrayList, list, hashSet);
        this.shownToPlayers.removeAll(hashSet);
    }

    public List<Object> getDestroyPackets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.stand.getDestroyPacket());
        arrayList.add(this.smallStand.getDestroyPacket());
        return arrayList;
    }

    private void processPlayersInBatches(List<Player> list, int n, final Consumer<Player> consumer) {
        for (int i = 0; i < list.size(); i += n) {
            final ArrayList<Player> arrayList = new ArrayList<Player>(list.subList(i, Math.min(i + n, list.size())));
            new BukkitRunnable(){

                public void run() {
                    arrayList.forEach(consumer);
                }
            }.runTaskAsynchronously((Plugin)MonthlyCrate.getInstance());
        }
    }

    private void processPlayer(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.stand == null) {
            return;
        }
        if (this.shownToPlayers.contains(player)) {
            if (this.stand.isTimeToDestroy()) {
                this.handler.sendPacket(this.pl, this.stand.getDestroyPacket());
            } else {
                this.stand.sendAllPackets(this.pl);
            }
            if (this.smallStand != null) {
                if (this.smallStand.isTimeToDestroy()) {
                    this.handler.sendPacket(this.pl, this.smallStand.getDestroyPacket());
                } else {
                    this.smallStand.sendAllPackets(this.pl);
                }
            }
        } else {
            if (this.stand.isTimeToDestroy()) {
                this.handler.sendPacket(this.pl, this.stand.getDestroyPacket());
            } else {
                this.stand.sendAllPackets(this.pl, true);
            }
            if (this.smallStand != null) {
                if (this.smallStand.isTimeToDestroy()) {
                    this.handler.sendPacket(this.pl, this.smallStand.getDestroyPacket());
                } else {
                    this.smallStand.sendAllPackets(this.pl, true);
                }
            }
            this.shownToPlayers.add(this.pl);
        }
    }

    private void removeOfflinePlayers(Set<Player> set, List<Player> list, List<Object> list2, Set<OfflinePlayer> set2) {
        HashSet<Player> hashSet = new HashSet<Player>(set);
        hashSet.forEach(player -> {
            if (!list.contains(player) && player != null && player.isOnline()) {
                list2.forEach(object -> this.handler.sendPacket((Player)player, object));
                set2.add((OfflinePlayer)player);
            }
        });
    }

    public void clear() {
        this.clear = true;
    }

    public void clearRunnable() {
        this.timeToSkip = false;
        Reward reward = this.reward;
        final String string = reward.getPath();
        final List<String> list = reward.getCommands();
        final int n = list.size();
        if (reward.isGiveConfiguratedItem()) {
            if (this.pl.getInventory().firstEmpty() == -1) {
                this.pl.getWorld().dropItem(this.pl.getLocation(), reward.getConfiguratedItem());
            } else {
                this.pl.getInventory().addItem(new ItemStack[]{reward.getConfiguratedItem()});
            }
        }
        new BukkitRunnable(){

            public void run() {
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)list.get(i);
                    String string2 = "";
                    string2 = CosmicAnimationEnd.this.crate.getPathPermissions().get(string);
                    if (string2 == "" || string2 == null) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string3.replace("%player_name%", CosmicAnimationEnd.this.pl.getName()).replace("%player%", CosmicAnimationEnd.this.pl.getName()).replaceAll("\\{player_name\\}", CosmicAnimationEnd.this.pl.getName()).replaceAll("\\{random_number\\}", CosmicAnimationEnd.this.isdoublevalue ? Double.toString(CosmicAnimationEnd.this.randNumber) : Long.toString((long)CosmicAnimationEnd.this.randNumber)));
                        continue;
                    }
                    if (!CosmicAnimationEnd.this.pl.hasPermission(string2)) continue;
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string3.replace("%player_name%", CosmicAnimationEnd.this.pl.getName()).replace("%player%", CosmicAnimationEnd.this.pl.getName()).replaceAll("\\{player_name\\}", CosmicAnimationEnd.this.pl.getName()).replaceAll("\\{random_number\\}", CosmicAnimationEnd.this.isdoublevalue ? Double.toString(CosmicAnimationEnd.this.randNumber) : Long.toString((long)CosmicAnimationEnd.this.randNumber)));
                }
            }
        }.runTask((Plugin)MonthlyCrate.getInstance());
        if (this.playPackets) {
            this.stand.setTimeToDestroy(true);
            this.stand.createDestroyPacket();
            this.smallStand.setTimeToDestroy(true);
            this.smallStand.createDestroyPacket();
            this.timeToSkip = false;
            this.timeToClear = true;
            this.sendPackets();
            new BukkitRunnable(){

                public void run() {
                    CosmicAnimationEnd.this.stand = null;
                    CosmicAnimationEnd.this.smallStand = null;
                }
            }.runTaskLaterAsynchronously((Plugin)MonthlyCrate.getInstance(), 4L);
            this.stand.removeEntity();
            this.smallStand.removeEntity();
        } else {
            new BukkitRunnable(){

                public void run() {
                    CosmicAnimationEnd.this.standReal.getStand().remove();
                    CosmicAnimationEnd.this.standReal.clear();
                    CosmicAnimationEnd.this.smallStandReal.getStand().remove();
                    CosmicAnimationEnd.this.smallStandReal.clear();
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        }
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.handler.sendPacket((Player)player, object)));
        if (this.taskhelper != null) {
            Bukkit.getScheduler().cancelTask(this.taskhelper.getTaskID());
        }
    }

    public void sendParticlesAndEffects(Location location, String string, String string2, int n, ItemStack itemStack) {
        Set<Player> set = this.getNearbyEntities();
        if (this.pl != null && this.pl.isOnline()) {
            set.add(this.pl);
        }
        set.forEach(player -> {
            if (player != null && player.isOnline()) {
                if (string != null) {
                    Utils.playEffect(player, string, n, location);
                } else if (itemStack == null) {
                    player.spawnParticle(Particle.valueOf((String)string2), location, n);
                } else if (string2.equalsIgnoreCase("ITEM_CRACK")) {
                    player.spawnParticle(Particle.valueOf((String)string2), location, n, 0.0, 0.0, 0.0, 0.0, (Object)itemStack);
                }
            }
        });
    }

    public Set<Player> getNearbyEntities() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.standLoc.getWorld() || !((d = this.standLoc.distanceSquared(player.getLocation())) < (double)this.howFarShown) || !(d > (double)this.proximityDistance) && !this.all) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    public Set<Player> getNearbyEntitiesSounds() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.standLoc.getWorld() || !((d = this.standLoc.distanceSquared(player.getLocation())) < (double)this.soundHearingDistance)) continue;
            hashSet.add(player);
        }
        return hashSet;
    }
}

