/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.chess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ChessBattleAnimationV2
extends AnimationHandler {
    private List<List<PacketHologram>> chessBoard = new ArrayList<List<PacketHologram>>();
    private Map<String, PacketHologram> pieces = new HashMap<String, PacketHologram>();
    private PacketHologram enderEgg;
    private List<PacketHologram> eggShards = new ArrayList<PacketHologram>();
    private boolean boardBroken = false;

    public ChessBattleAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 0.5, 0.5));
        this.createChessBoard();
        this.setupChessPieces();
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
        this.sendPackets();
        this.clearPackets();
    }

    private void createChessBoard() {
        for (int i = 0; i < 8; ++i) {
            ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
            for (int j = 0; j < 8; ++j) {
                Location location = this.getTargetLocation().clone().add(((double)i - 3.5) * 0.6, -0.3, ((double)j - 3.5) * 0.6);
                PacketHologram packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
                Material material = (i + j) % 2 == 0 ? Material.WHITE_WOOL : Material.BLACK_WOOL;
                packetHologram.createEquipmentPacketHelmet(new ItemStack(material));
                arrayList.add(packetHologram);
                this.getAnimationHolograms().add(packetHologram);
                this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
            this.chessBoard.add(arrayList);
        }
    }

    private void setupChessPieces() {
        this.createPiece("WHITE_KING", 4, 7, Material.QUARTZ_BLOCK, "\u00a7f\u2654 King");
        this.createPiece("WHITE_QUEEN", 3, 7, Material.QUARTZ_BLOCK, "\u00a7f\u2655 Queen");
        this.createPiece("WHITE_KNIGHT1", 1, 7, Material.IRON_BLOCK, "\u00a7f\u2658 Knight");
        this.createPiece("WHITE_KNIGHT2", 6, 7, Material.IRON_BLOCK, "\u00a7f\u2658 Knight");
        this.createPiece("WHITE_PAWN1", 4, 6, Material.WHITE_CONCRETE, "\u00a7f\u265f Pawn");
        this.createPiece("WHITE_PAWN2", 3, 6, Material.WHITE_CONCRETE, "\u00a7f\u265f Pawn");
        this.createPiece("BLACK_KING", 4, 0, Material.COAL_BLOCK, "\u00a70\u265a King");
        this.createPiece("BLACK_QUEEN", 3, 0, Material.COAL_BLOCK, "\u00a70\u265b Queen");
        this.createPiece("BLACK_KNIGHT1", 1, 0, Material.BLACKSTONE, "\u00a70\u2658 Knight");
        this.createPiece("BLACK_KNIGHT2", 6, 0, Material.BLACKSTONE, "\u00a70\u2658 Knight");
        this.createPiece("BLACK_PAWN1", 4, 1, Material.BLACK_CONCRETE, "\u00a70\u265f Pawn");
        this.createPiece("BLACK_PAWN2", 3, 1, Material.BLACK_CONCRETE, "\u00a70\u265f Pawn");
    }

    private void createPiece(String string, int n, int n2, Material material, String string2) {
        Location location = this.getTargetLocation().clone().add(((double)n - 3.5) * 0.6, 0.2, ((double)n2 - 3.5) * 0.6);
        PacketHologram packetHologram = new PacketHologram(string2, location, location.getY(), this.getHandler());
        packetHologram.createEquipmentPacketHelmet(new ItemStack(material));
        this.pieces.put(string, packetHologram);
        this.getAnimationHolograms().add(packetHologram);
        this.getPackets().addAll(packetHologram.getAllPackets(true));
    }

    private void movePiece(String string, double d, double d2) {
        PacketHologram packetHologram = this.pieces.get(string);
        if (packetHologram == null || packetHologram.isTimeToDestroy()) {
            return;
        }
        Location location = packetHologram.getLocation();
        Location location2 = this.getTargetLocation().clone().add((d - 3.5) * 0.6, 0.2, (d2 - 3.5) * 0.6);
        for (int i = 0; i <= 10; ++i) {
            int n = i;
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                double d = (double)n / 10.0;
                double d2 = Math.sin(d * Math.PI) * 0.4;
                Location location3 = location.clone().add(location2.clone().subtract(location).multiply(d));
                location3.setY(location3.getY() + d2);
                packetHologram.teleport(location3);
                packetHologram.createTeleportPacket();
                if (n % 3 == 0) {
                    this.sendParticlesAndEffects(location3, Utils.isVersionOld() ? "SPELL" : null, Utils.isVersionOld() ? null : "SPELL", 2);
                }
            }, (long)i);
        }
    }

    @Override
    public void run() {
        if (this.getCounter() == 10) {
            this.movePiece("WHITE_PAWN1", 4.0, 4.0);
            this.getPlayer().playSound(this.getTargetLocation(), Sound.BLOCK_WOOD_PLACE, 0.5f, 1.0f);
        } else if (this.getCounter() == 25) {
            this.movePiece("BLACK_PAWN1", 4.0, 3.0);
            this.getPlayer().playSound(this.getTargetLocation(), Sound.BLOCK_WOOD_PLACE, 0.5f, 0.8f);
        } else if (this.getCounter() == 40) {
            this.movePiece("WHITE_KNIGHT2", 5.0, 5.0);
            this.getPlayer().playSound(this.getTargetLocation(), Sound.ENTITY_HORSE_STEP, 0.5f, 1.2f);
        } else if (this.getCounter() == 55) {
            this.movePiece("BLACK_KNIGHT1", 2.0, 2.0);
            this.getPlayer().playSound(this.getTargetLocation(), Sound.ENTITY_HORSE_STEP, 0.5f, 1.0f);
        } else if (this.getCounter() == 60) {
            this.pieces.values().forEach(packetHologram -> {
                if (!packetHologram.isTimeToDestroy()) {
                    Location location = packetHologram.getLocation().clone().add(0.0, 0.8, 0.0);
                    PacketHologram packetHologram2 = new PacketHologram("\u00a7e\u00a7l?", location, location.getY(), this.getHandler());
                    this.getAnimationHolograms().add(packetHologram2);
                    this.getPackets().addAll(packetHologram2.getAllPackets(true));
                    Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                        packetHologram2.setTimeToDestroy(true);
                        packetHologram2.createDestroyPacket();
                    }, 20L);
                }
            });
            for (int i = 0; i < 20; ++i) {
                int n = i;
                Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                    double d = 0.5 + (double)n * 0.1;
                    for (double d2 = 0.0; d2 < Math.PI * 2; d2 += 0.39269908169872414) {
                        Location location = this.getTargetLocation().clone().add(Math.cos(d2) * d, -0.2, Math.sin(d2) * d);
                        this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "SMOKE_LARGE" : null, Utils.isVersionOld() ? null : "LARGE_SMOKE", 2);
                    }
                }, (long)i);
            }
            this.getPlayer().playSound(this.getTargetLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 0.5f, 0.5f);
        } else if (this.getCounter() == 80) {
            Location location = this.getTargetLocation().clone().add(0.0, 8.0, 0.0);
            this.enderEgg = new PacketHologram("\u00a75\u00a7l\u2726 INCOMING! \u2726", location, location.getY(), this.getHandler());
            this.enderEgg.createEquipmentPacketHelmet(new ItemStack(Material.DRAGON_EGG));
            this.getAnimationHolograms().add(this.enderEgg);
            this.getPackets().addAll(this.enderEgg.getAllPackets(true));
            this.pieces.values().forEach(packetHologram -> {
                if (!packetHologram.isTimeToDestroy()) {
                    double d = Math.random() * Math.PI * 2.0;
                    double d2 = 2.0 + Math.random() * 1.0;
                    Location location = packetHologram.getLocation().clone().add(Math.cos(d) * d2, 0.0, Math.sin(d) * d2);
                    for (int i = 0; i <= 10; ++i) {
                        int n = i;
                        Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                            if (n < 5) {
                                Location location2 = packetHologram.getLocation().clone().add((Math.random() - 0.5) * 0.1, 0.0, (Math.random() - 0.5) * 0.1);
                                packetHologram.teleport(location2);
                            } else {
                                double d = (double)(n - 5) / 5.0;
                                Location location3 = packetHologram.getLocation().clone().add(location.clone().subtract(packetHologram.getLocation()).multiply(d * 0.2));
                                packetHologram.teleport(location3);
                            }
                            packetHologram.createTeleportPacket();
                        }, (long)i * 2L);
                    }
                }
            });
            this.getPlayer().playSound(this.getTargetLocation(), Sound.ENTITY_VILLAGER_HURT, 1.0f, 1.5f);
        } else if (this.getCounter() > 85 && this.getCounter() <= 120) {
            if (this.enderEgg != null && !this.enderEgg.isTimeToDestroy()) {
                double d = (double)(this.getCounter() - 85) / 35.0;
                double d2 = d * d;
                Location location = this.getTargetLocation().clone().add(0.0, 8.0 - 8.3 * d2, 0.0);
                this.enderEgg.teleport(location);
                this.enderEgg.createTeleportPacket();
                this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "PORTAL" : null, Utils.isVersionOld() ? null : "PORTAL", 5);
                if (this.getCounter() % 5 == 0) {
                    this.getPlayer().playSound(location, Sound.ENTITY_ARROW_SHOOT, 0.5f, 0.5f);
                }
            }
        } else if (this.getCounter() == 120) {
            this.boardBroken = true;
            Location location = this.getTargetLocation().clone().add(0.0, -0.3, 0.0);
            this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    double d;
                    PacketHologram packetHologram2 = this.chessBoard.get(i).get(j);
                    Location location2 = packetHologram2.getLocation();
                    double d3 = ((double)i - 3.5) * 0.6;
                    double d4 = ((double)j - 3.5) * 0.6;
                    double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                    if (d5 > 0.0) {
                        d3 /= d5;
                        d4 /= d5;
                    } else {
                        d = Math.random() * Math.PI * 2.0;
                        d3 = Math.cos(d);
                        d4 = Math.sin(d);
                    }
                    d3 = d3 * 0.7 + (Math.random() - 0.5) * 0.6;
                    d4 = d4 * 0.7 + (Math.random() - 0.5) * 0.6;
                    d = 2.5 + Math.random() * 3.5;
                    double d6 = 3.0 + Math.random() * 2.0;
                    double d7 = 9.8;
                    float f = (float)(Math.random() * 60.0 - 30.0);
                    float f2 = (float)(Math.random() * 40.0 - 20.0);
                    int n = (int)(Math.sqrt(((double)i - 3.5) * ((double)i - 3.5) + ((double)j - 3.5) * ((double)j - 3.5)) * 3.0);
                    for (int k = 0; k <= 25; ++k) {
                        int n2 = k;
                        int n3 = i;
                        int n4 = j;
                        double d8 = d3;
                        double d9 = d4;
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MonthlyCrate.getInstance(), () -> {
                            if (packetHologram2.isTimeToDestroy()) {
                                return;
                            }
                            double d6 = (double)n2 / 25.0;
                            double d7 = d6 * 2.5;
                            Location location2 = location2.clone().add(d8 * d * d7, d6 * d7 - d7 * d7 * d7 / 2.0, d9 * d * d7);
                            location2.setYaw(location2.getYaw() + f * (float)n2);
                            location2.setPitch(location2.getPitch() + f2 * (float)n2);
                            packetHologram2.teleport(location2);
                            packetHologram2.createTeleportPacket();
                            if (packetHologram2.getTeleportPacket() != null) {
                                Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, packetHologram2.getTeleportPacket()));
                            }
                            if (n2 % 2 == 0) {
                                boolean bl;
                                boolean bl2 = bl = (n3 + n4) % 2 == 0;
                                if (bl) {
                                    this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "FIREWORKS_SPARK" : null, Utils.isVersionOld() ? null : "FIREWORKS_SPARK", 2);
                                } else {
                                    this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "SMOKE_NORMAL" : null, Utils.isVersionOld() ? null : "SMOKE_NORMAL", 2);
                                }
                            }
                            if (n2 == 25) {
                                this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "EXPLOSION_NORMAL" : null, Utils.isVersionOld() ? null : "EXPLOSION_NORMAL", 1);
                                this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "CLOUD" : null, Utils.isVersionOld() ? null : "CLOUD", 10);
                                packetHologram2.setTimeToDestroy(true);
                                packetHologram2.createDestroyPacket();
                                Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, packetHologram2.getDestroyPacket()));
                            }
                        }, (long)(n + k));
                    }
                }
            }
            this.pieces.values().forEach(packetHologram -> {
                if (!packetHologram.isTimeToDestroy()) {
                    Location location = packetHologram.getLocation();
                    double d = Math.random() * Math.PI * 2.0;
                    double d2 = Math.random() * Math.PI / 4.0 + 0.5235987755982988;
                    double d3 = 4.0 + Math.random() * 4.0;
                    double d4 = Math.cos(d) * Math.sin(d2);
                    double d5 = Math.cos(d2);
                    double d6 = Math.sin(d) * Math.sin(d2);
                    for (int i = 0; i <= 30; ++i) {
                        int n = i;
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MonthlyCrate.getInstance(), () -> {
                            if (packetHologram.isTimeToDestroy()) {
                                return;
                            }
                            double d5 = (double)n / 15.0;
                            double d6 = 5.0;
                            Location location2 = location.clone().add(d4 * d3 * d5, d5 * d3 * d5 - d6 * d5 * d5 / 2.0, d6 * d3 * d5);
                            location2.setYaw((float)(n * 45));
                            location2.setPitch((float)(n * 30));
                            packetHologram.teleport(location2);
                            packetHologram.createTeleportPacket();
                            if (packetHologram.getTeleportPacket() != null) {
                                Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, packetHologram.getTeleportPacket()));
                            }
                            if (n % 3 == 0) {
                                this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "VILLAGER_ANGRY" : null, Utils.isVersionOld() ? null : "VILLAGER_ANGRY", 1);
                            }
                            if (n == 30) {
                                packetHologram.setTimeToDestroy(true);
                                packetHologram.createDestroyPacket();
                                Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, packetHologram.getDestroyPacket()));
                            }
                        }, (long)i);
                    }
                }
            });
            if (this.enderEgg != null) {
                this.enderEgg.setTimeToDestroy(true);
                this.enderEgg.createDestroyPacket();
            }
            this.getPlayer().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.5f);
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> this.getPlayer().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.5f, 0.8f), 3L);
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> this.getPlayer().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.2f), 6L);
            this.getPlayer().playSound(location, Sound.ENTITY_ENDER_DRAGON_HURT, 1.0f, 0.8f);
            this.getLightningPackets().add(this.getHandler().getLightningPacket(location));
        } else if (this.getCounter() == 140) {
            int n;
            Location location = this.getTargetLocation();
            for (n = 0; n < 6; ++n) {
                double d = 1.0471975511965976 * (double)n;
                Location location3 = location.clone().add(Math.cos(d) * 0.3, 0.0, Math.sin(d) * 0.3);
                PacketHologram packetHologram3 = new PacketHologram("", location3, location3.getY(), this.getHandler());
                packetHologram3.createEquipmentPacketHelmet(new ItemStack(Material.OBSIDIAN));
                this.eggShards.add(packetHologram3);
                this.getAnimationHolograms().add(packetHologram3);
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
                for (int i = 0; i <= 20; ++i) {
                    int n5 = i;
                    int n6 = n;
                    Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                        if (packetHologram3.isTimeToDestroy()) {
                            return;
                        }
                        double d2 = (double)n5 / 20.0;
                        double d3 = Math.sin(d2 * Math.PI) * 1.5;
                        Location location2 = location3.clone().add(Math.cos(d) * d2 * 2.0, d3, Math.sin(d) * d2 * 2.0);
                        packetHologram3.teleport(location2);
                        packetHologram3.createTeleportPacket();
                        if (n5 == 20) {
                            packetHologram3.setTimeToDestroy(true);
                            packetHologram3.createDestroyPacket();
                        }
                    }, (long)i);
                }
            }
            this.getPlayer().playSound(location, Sound.ENTITY_TURTLE_EGG_CRACK, 2.0f, 0.5f);
            for (n = 0; n < 3; ++n) {
                int n7 = n;
                Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                    double d = 0.5 + (double)n7 * 0.8;
                    for (double d2 = 0.0; d2 < Math.PI * 2; d2 += 0.2617993877991494) {
                        Location location2 = location.clone().add(Math.cos(d2) * d, 0.2, Math.sin(d2) * d);
                        this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "DRAGON_BREATH" : null, Utils.isVersionOld() ? null : "DRAGON_BREATH", 10);
                    }
                }, (long)n * 3L);
            }
        } else if (this.getCounter() == 160) {
            int n;
            Location location = this.getTargetLocation();
            PacketHologram packetHologram4 = new PacketHologram("\u00a75\u00a7l\u2726 SURPRISE! \u2726", location.clone().add(0.0, 3.0, 0.0), location.getY() + 3.0, this.getHandler());
            this.getAnimationHolograms().add(packetHologram4);
            this.getPackets().addAll(packetHologram4.getAllPackets(true));
            for (n = 0; n < this.getRewards().size(); ++n) {
                Reward reward = this.getRewards().get(n);
                int n8 = n;
                Location location4 = location.clone();
                double d = Math.PI * 2 / (double)this.getRewards().size() * (double)n;
                Location location5 = location.clone().add(Math.cos(d) * 2.5, 0.5, Math.sin(d) * 2.5);
                PacketHologram packetHologram5 = new PacketHologram("\u00a7d\u2726 \u00a7e\u00a7l" + reward.getItemBuilder().getDisplayName() + " \u00a7d\u2726", location4, location4.getY(), this.getHandler());
                packetHologram5.createEquipmentPacket(reward.getReward());
                this.getAnimationHolograms().add(packetHologram5);
                this.getPackets().addAll(packetHologram5.getAllPackets(true));
                for (int i = 0; i <= 30; ++i) {
                    int n9 = i;
                    Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                        double d = (double)n9 / 30.0;
                        double d2 = -4.0 * d * d + 4.0 * d + 0.5;
                        Location location4 = location4.clone().add(location5.clone().subtract(location4).multiply(d));
                        location4.setY(location.getY() + d2);
                        packetHologram5.teleport(location4);
                        packetHologram5.createTeleportPacket();
                        this.sendParticlesAndEffects(location4, Utils.isVersionOld() ? "SPELL_WITCH" : null, Utils.isVersionOld() ? null : "SPELL_WITCH", 3);
                        if (n9 == 30) {
                            this.sendParticlesAndEffects(location4, Utils.isVersionOld() ? "VILLAGER_HAPPY" : null, Utils.isVersionOld() ? null : "VILLAGER_HAPPY", 20);
                            for (int i = 0; i < 10; ++i) {
                                int n2 = i;
                                Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                                    double d = Math.sin((double)n2 * 0.3) * 0.1 * (1.0 - (double)n2 / 10.0);
                                    Location location2 = location5.clone().add(0.0, d, 0.0);
                                    packetHologram5.teleport(location2);
                                    packetHologram5.createTeleportPacket();
                                }, 30L + (long)i * 2L);
                            }
                        }
                    }, (long)(i + n8 * 5));
                }
            }
            this.getPlayer().playSound(location, Sound.ENTITY_ENDER_DRAGON_DEATH, 0.5f, 1.5f);
            this.getPlayer().playSound(location, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            for (n = 0; n < 5; ++n) {
                Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> {
                    Location location2 = location.clone().add((Math.random() - 0.5) * 4.0, Math.random() * 2.0 + 1.0, (Math.random() - 0.5) * 4.0);
                    this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "FIREWORKS_SPARK" : null, Utils.isVersionOld() ? null : "FIREWORKS_SPARK", 30);
                }, (long)n * 10L);
            }
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 200 && this.getCounter() < 220) {
            if (this.getCounter() % 2 == 0) {
                Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 5.0, Math.random() * 3.0, (Math.random() - 0.5) * 5.0);
                this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "PORTAL" : null, Utils.isVersionOld() ? null : "PORTAL", 5);
            }
        } else if (this.getCounter() >= 220) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            if (!packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            }
            packetHologram.removeEntity();
        });
        this.pieces.values().forEach(packetHologram -> {
            if (!packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            }
        });
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, object)));
        this.cancel();
    }
}

