/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.blackhole;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BlackHoleAnimationV2
extends AnimationHandler {
    private PacketHologram blackHoleCore;
    private List<PacketHologram> eventHorizon = new ArrayList<PacketHologram>();
    private List<PacketHologram> accretionDisk = new ArrayList<PacketHologram>();
    private List<PacketHologram> suckedItems = new ArrayList<PacketHologram>();
    private double blackHoleSize = 0.1;
    private boolean collapsing = false;

    public BlackHoleAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        PacketHologram packetHologram;
        int n;
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 3.0, 0.5));
        this.blackHoleCore = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
        this.blackHoleCore.createEquipmentPacketHelmet(new ItemStack(Material.COAL_BLOCK));
        this.getPackets().addAll(this.blackHoleCore.getAllPackets(true));
        this.getAnimationHolograms().add(this.blackHoleCore);
        for (n = 0; n < 30; ++n) {
            packetHologram = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.OBSIDIAN));
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            this.eventHorizon.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
        }
        for (n = 0; n < 40; ++n) {
            packetHologram = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.GLOWSTONE));
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            this.accretionDisk.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 100) {
            Location location;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            int n;
            this.blackHoleSize = Math.min(this.blackHoleSize + 0.02, 2.0);
            for (n = 0; n < this.eventHorizon.size(); ++n) {
                d5 = Math.PI * 2 / (double)this.eventHorizon.size() * (double)n;
                d4 = this.blackHoleSize;
                d3 = Math.sin((double)this.getCounter() * 0.1 + (double)n) * 0.1;
                d2 = Math.cos(d5 + (double)this.getCounter() * 0.05) * (d4 + d3);
                d = Math.sin(d5 + (double)this.getCounter() * 0.05) * (d4 + d3);
                location = this.getTargetLocation().clone().add(d2, 0.0, d);
                this.eventHorizon.get(n).teleport(location);
                this.eventHorizon.get(n).createTeleportPacket();
            }
            for (n = 0; n < this.accretionDisk.size(); ++n) {
                d5 = Math.PI * 2 / (double)this.accretionDisk.size() * (double)n + (double)this.getCounter() * 0.1;
                d4 = this.blackHoleSize * 1.5 + Math.random() * 0.5;
                d3 = Math.sin(d5 * 3.0) * 0.3;
                d2 = Math.cos(d5) * d4;
                d = Math.sin(d5) * d4;
                location = this.getTargetLocation().clone().add(d2, d3, d);
                this.accretionDisk.get(n).teleport(location);
                this.accretionDisk.get(n).createTeleportPacket();
            }
            if (this.getCounter() % 5 == 0) {
                this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "SPELL_WITCH" : null, Utils.isVersionOld() ? null : "SPELL_WITCH", 10);
            }
        } else if (this.getCounter() < 150) {
            if (this.getCounter() % 10 == 0) {
                Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 10.0, (Math.random() - 0.5) * 5.0, (Math.random() - 0.5) * 10.0);
                PacketHologram packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler());
                Material[] materialArray = new Material[]{Material.DIAMOND, Material.GOLD_BLOCK, Material.EMERALD_BLOCK, Material.IRON_BLOCK};
                packetHologram2.createEquipmentPacketHelmet(new ItemStack(materialArray[(int)(Math.random() * (double)materialArray.length)]));
                this.suckedItems.add(packetHologram2);
                this.getPackets().addAll(packetHologram2.getAllPackets(true));
                this.getAnimationHolograms().add(packetHologram2);
            }
            this.suckedItems.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                Location location2 = this.getTargetLocation().clone().subtract(location);
                location2.multiply(0.1);
                packetHologram.teleport(location.add(location2));
                packetHologram.createTeleportPacket();
                if (location.distance(this.getTargetLocation()) < 0.5) {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                }
            });
        } else if (this.getCounter() == 150) {
            this.collapsing = true;
            this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            this.blackHoleCore.setTimeToDestroy(true);
            this.blackHoleCore.createDestroyPacket();
            this.eventHorizon.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.accretionDisk.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            for (int i = 0; i < this.getRewards().size(); ++i) {
                Reward reward = this.getRewards().get(i);
                double d = Math.PI * 2 / (double)this.getRewards().size() * (double)i;
                final Location location = this.getTargetLocation().clone();
                final Location location2 = this.getTargetLocation().clone().add(Math.cos(d) * 3.0, 0.0, Math.sin(d) * 3.0);
                final PacketHologram packetHologram3 = new PacketHologram(reward.getItemBuilder().getDisplayName(), location, location.getY(), this.getHandler());
                packetHologram3.createEquipmentPacket(reward.getReward());
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
                this.getAnimationHolograms().add(packetHologram3);
                new BukkitRunnable(){
                    int ticks = 0;

                    public void run() {
                        if (this.ticks >= 20) {
                            this.cancel();
                            return;
                        }
                        Location location3 = location.clone().add(location2.clone().subtract(location).multiply((double)this.ticks / 20.0));
                        packetHologram3.teleport(location3);
                        packetHologram3.createTeleportPacket();
                        ++this.ticks;
                    }
                }.runTaskTimer((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
            }
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() >= 240) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.cancel();
    }
}

