/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.gui.reroll.RerollReward;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpiralAnimation
extends AnimationHandler {
    private final List<PacketHologram> itemStands = new ArrayList<PacketHologram>();
    private final Location center;
    private final int totalTicks = 60;
    private final int openTick = 50;
    private final int closeTick = 58;
    private final int endTick = 60;

    public SpiralAnimation(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        if (block.getType() == Material.CHEST) {
            this.setChestOpenPacket(iNMSHandler.getOpenChestPacket(block.getLocation(), true));
            this.setChestClosePacket(iNMSHandler.getOpenChestPacket(block.getLocation(), false));
        } else if (block.getType() == Material.ENDER_CHEST || block.getType() == Material.AIR) {
            this.setChestOpenPacket(iNMSHandler.getOpenEnderChestPacket(block.getLocation(), true));
            this.setChestClosePacket(iNMSHandler.getOpenEnderChestPacket(block.getLocation(), false));
        }
        this.center = this.getTargetLocation().clone().add(0.5, -1.0, 0.5);
        this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
        for (Reward reward : this.getRewards()) {
            PacketHologram packetHologram = new PacketHologram("", this.center, this.center.getY(), iNMSHandler);
            packetHologram.createMetadataPacket();
            packetHologram.createEquipmentPacket(reward.getReward());
            packetHologram.setRightArmPose(270.0f, 0.0f, 0.0f);
            this.itemStands.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            this.getPackets().addAll(packetHologram.getEquipmentPacket());
        }
        this.runTaskTimer((Plugin)MonthlyCrate.getInstance(), 0L, 2L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        for (int i = 0; i < this.itemStands.size(); ++i) {
            PacketHologram object2 = this.itemStands.get(i);
            double d = (double)this.getCounter() * 6.0 + 360.0 / (double)this.itemStands.size() * (double)i;
            double d2 = Math.toRadians(d);
            double d3 = 1.5;
            double d4 = 0.03 * (double)this.getCounter() + 0.5 * (double)i;
            Location location = this.center.clone().add(d3 * Math.cos(d2), d4, d3 * Math.sin(d2));
            location.setYaw((float)d);
            object2.teleport(location);
            object2.createTeleportPacket();
        }
        if (this.getCounter() == 50 && this.getChestOpenPacket() != null) {
            this.setTimeToOpen(true);
            for (PacketHologram packetHologram2 : this.itemStands) {
                packetHologram2.createDestroyPacket();
                this.getPackets().add(packetHologram2.getDestroyPacket());
                packetHologram2.setTimeToDestroy(true);
            }
            for (Reward reward : this.getRewards()) {
                Object object2 = this.getHandler().getEntityItem(this.getTargetLocation().clone().add(0.5, 1.2, 0.5), reward.getReward(), false, this.getCrate().getSize() != 1);
                this.getEntityItems().add(object2);
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object2));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object2));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemVelocityPacket(object2));
                this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object2));
            }
            this.setTimeToSpawn(true);
            this.getPackets().addAll(this.getDroppedItemsSpawnPackets());
        }
        if (this.getCounter() == 58 && this.getChestClosePacket() != null) {
            this.setTimeToClose(true);
            this.setDespawnItems(true);
            try {
                this.getEntityItems().forEach(object -> ((Entity)object).remove());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getCounter() >= 60) {
            this.counterIncrement();
            this.clearRunnable();
            this.itemStands.forEach(packetHologram -> packetHologram.setTimeToDestroy(true));
            this.sendPackets();
            return;
        }
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
        this.counterIncrement();
    }

    public void clearRunnable() {
        Bukkit.getOnlinePlayers().forEach(player -> this.getDroppedItemsDestroyPackets().forEach(object -> this.getHandler().sendPacket((Player)player, object)));
        new BukkitRunnable(){

            public void run() {
                if (SpiralAnimation.this.getCrate().isRerollEnabled()) {
                    ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                    SpiralAnimation.this.getRewards().forEach(reward -> arrayList.add(reward.getDisplayBuilder().getItem()));
                    new RerollReward(SpiralAnimation.this.getPlayer(), null, "&eWon Rewards Reroll", SpiralAnimation.this.getCrate(), SpiralAnimation.this.getRewards(), arrayList).openMenu();
                } else {
                    SpiralAnimation.this.getCrate().getRewardsGiveQueue().put("" + SpiralAnimation.super.getTaskId(), new GiveOutRewards("" + SpiralAnimation.super.getTaskId(), SpiralAnimation.this.getPlayer(), SpiralAnimation.this.getRewards(), (Long)System.currentTimeMillis(), SpiralAnimation.this.getCrate()));
                    Utils.sendFinalMessages(SpiralAnimation.this.getCrate(), SpiralAnimation.this.getRewards(), SpiralAnimation.this.getPlayer());
                }
            }
        }.runTask((Plugin)MonthlyCrate.getInstance());
        MonthlyCrate.PlayersOpeningCrate.remove(this.getPlayer());
        --MonthlyCrate.GlobalCratesOpening;
        try {
            Material material = XMaterial.PLAYER_HEAD.parseMaterial();
            if (this.getTargetLocation().getBlock().getType() == material) {
                this.getHandler().sendPlayerHeadTexturePacket(this.getPlayer(), this.getTargetLocation());
            } else {
                this.getPlayer().sendBlockChange(this.getTargetLocation(), this.getTargetLocation().getBlock().getType(), this.getTargetLocation().getBlock().getData());
            }
        }
        catch (Throwable throwable) {
            this.getPlayer().sendBlockChange(this.getTargetLocation(), this.getTargetLocation().getBlock().getType(), this.getTargetLocation().getBlock().getData());
        }
        super.cancel();
    }
}

