/*
 * Decompiled with CFR 0.152.
 */
package de.tr7zw.advancedcrates.nbtapi;

import de.tr7zw.advancedcrates.nbtapi.NBTCompound;
import de.tr7zw.advancedcrates.nbtapi.NBTList;
import de.tr7zw.advancedcrates.nbtapi.NBTType;
import de.tr7zw.advancedcrates.nbtapi.NbtApiException;
import de.tr7zw.advancedcrates.nbtapi.utils.nmsmappings.ClassWrapper;
import de.tr7zw.advancedcrates.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class NBTFloatList
extends NBTList<Float> {
    protected NBTFloatList(NBTCompound nBTCompound, String string, NBTType nBTType, Object object) {
        super(nBTCompound, string, nBTType, object);
    }

    @Override
    protected Object asTag(Float f) {
        try {
            Constructor<?> constructor = ClassWrapper.NMS_NBTTAGFLOAT.getClazz().getDeclaredConstructor(Float.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(f);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new NbtApiException("Error while wrapping the Object " + f + " to it's NMS object!", exception);
        }
    }

    @Override
    public Float get(int n) {
        try {
            Object object = ReflectionMethod.LIST_GET.run(this.listObject, n);
            return Float.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return Float.valueOf(0.0f);
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
    }
}

