/*
 * Decompiled with CFR 0.152.
 */
package de.tr7zw.advancedcrates.nbtapi;

import de.tr7zw.advancedcrates.nbtapi.NBTCompound;
import de.tr7zw.advancedcrates.nbtapi.NBTContainer;
import de.tr7zw.advancedcrates.nbtapi.NBTReflectionUtil;
import de.tr7zw.advancedcrates.nbtapi.iface.NBTFileHandle;
import de.tr7zw.advancedcrates.nbtapi.utils.nmsmappings.ObjectCreator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class NBTFile
extends NBTCompound
implements NBTFileHandle {
    private final File file;
    private Object nbt;

    @Deprecated
    public NBTFile(File file) {
        super(null, null);
        if (file == null) {
            throw new NullPointerException("File can't be null!");
        }
        this.file = file;
        if (file.exists()) {
            this.nbt = NBTReflectionUtil.readNBT(Files.newInputStream(file.toPath(), new OpenOption[0]));
        } else {
            this.nbt = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            this.save();
        }
    }

    @Override
    public void save() {
        try {
            this.getWriteLock().lock();
            NBTFile.saveTo(this.file, this);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Object getCompound() {
        return this.nbt;
    }

    @Override
    protected void setCompound(Object object) {
        this.nbt = object;
    }

    @Deprecated
    public static NBTCompound readFrom(File file) {
        if (!file.exists()) {
            return new NBTContainer();
        }
        return new NBTContainer(NBTReflectionUtil.readNBT(Files.newInputStream(file.toPath(), new OpenOption[0])));
    }

    @Deprecated
    public static void saveTo(File file, NBTCompound nBTCompound) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                throw new IOException("Unable to create file at " + file.getAbsolutePath());
            }
        }
        nBTCompound.writeCompound(Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }
}

