/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.reflection.parser;

import com.cryptomorin.xseries.advancedcrates.reflection.ReflectiveHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.ReflectiveNamespace;
import com.cryptomorin.xseries.advancedcrates.reflection.XReflection;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.ConstructorMemberHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.FieldMemberHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.FlaggedNamedMemberHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.MemberHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.MethodMemberHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.ClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.DynamicClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.PackageHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.StaticClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.UnknownClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftPackage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionParser {
    private final String declaration;
    private Pattern pattern;
    private Matcher matcher;
    private ReflectiveNamespace namespace;
    private Map<String, Class<?>> cachedImports;
    private final Set<Flag> flags = EnumSet.noneOf(Flag.class);
    private static final PackageHandle[] PACKAGE_HANDLES = MinecraftPackage.values();
    @Language(value="RegExp")
    private static final String GENERIC = "(?:\\s*<\\s*[.\\w<>\\[\\], ]+\\s*>)?";
    @Language(value="RegExp")
    private static final String ARRAY = "(?:(?:\\[])*)";
    @Language(value="RegExp")
    private static final String PACKAGE_REGEX = "(?:package\\s+(?<package>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*;\\s*)?";
    @Language(value="RegExp")
    private static final String CLASS_TYPES = "(?<classType>class|interface|enum|record)";
    @Language(value="RegExp")
    private static final String PARAMETERS = "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)";
    @Language(value="RegExp")
    private static final String END_DECL = "\\s*;?\\s*";
    private static final Pattern CLASS = Pattern.compile("(?:package\\s+(?<package>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*;\\s*)?" + Flag.access$000() + "(?<classType>class|interface|enum|record)" + "\\s+" + ReflectionParser.type("className") + "(?:\\(\\))?(?:\\s+extends\\s+" + ReflectionParser.id("superclasses") + ")?(?:\\s+implements\\s+(?<interfaces>(?:" + ReflectionParser.type(null).array(false) + ")(?:\\s*,\\s*" + ReflectionParser.type(null).array(false) + ")*))?(?:\\s*\\{\\s*})?\\s*");
    private static final Pattern METHOD = Pattern.compile(Flag.access$000() + ReflectionParser.type("methodReturnType") + "\\s+" + ReflectionParser.id("methodName") + "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)" + "\\s*;?\\s*");
    private static final Pattern CONSTRUCTOR = Pattern.compile(Flag.access$000() + "\\s+" + ReflectionParser.id("className") + "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)" + "\\s*;?\\s*");
    private static final Pattern FIELD = Pattern.compile(Flag.access$000() + ReflectionParser.type("fieldType") + "\\s+" + ReflectionParser.id("fieldName") + "\\s*;?\\s*");
    private static final Map<String, Class<?>> PREDEFINED_TYPES = new HashMap();

    public ReflectionParser(@Language(value="Java") String string) {
        this.declaration = string;
    }

    private static IDHandler id(@NotNull @Language(value="RegExp") String string) {
        if (string == null) {
            ReflectionParser.$$$reportNull$$$0(0);
        }
        return new IDHandler(string, false);
    }

    private static IDHandler type(@Language(value="RegExp") String string) {
        return new IDHandler(string, true).generic(true).array(true);
    }

    private ClassHandle[] parseTypes(String[] stringArray) {
        ClassHandle[] classHandleArray = new ClassHandle[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = string.trim().substring(0, string.lastIndexOf(32)).trim();
            classHandleArray[i] = this.parseType(string);
        }
        return classHandleArray;
    }

    private ClassHandle parseType(String object) {
        Object object2;
        if (this.cachedImports == null && this.namespace != null) {
            this.cachedImports = this.namespace.getImports();
        }
        String string = object;
        object = ((String)object).replace(" ", "");
        int n = 0;
        if (((String)object).endsWith("[]")) {
            object2 = ((String)object).replace("[]", "");
            n = (((String)object).length() - ((String)object2).length()) / 2;
            object = object2;
        }
        if (((String)object).endsWith(">")) {
            object = ((String)object).substring(0, ((String)object).indexOf(60));
        }
        if ((object2 = this.stringToClass((String)object)) == null) {
            return new UnknownClassHandle(this.getOrCreateNamespace(), string + " -> " + (String)object);
        }
        if (n != 0) {
            object2 = (Class)XReflection.of(object2).asArray(n).unreflect();
        }
        return new StaticClassHandle(this.getOrCreateNamespace(), (Class<?>)object2);
    }

    @Nullable
    private Class<?> stringToClass(String string) {
        Class<?> clazz = null;
        if (!string.contains(".")) {
            if (this.cachedImports != null) {
                clazz = this.cachedImports.get(string);
            }
            if (clazz == null) {
                clazz = PREDEFINED_TYPES.get(string);
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private ReflectiveNamespace getOrCreateNamespace() {
        return this.namespace == null ? XReflection.namespaced() : this.namespace;
    }

    public ReflectionParser imports(ReflectiveNamespace reflectiveNamespace) {
        this.namespace = reflectiveNamespace;
        return this;
    }

    private void pattern(Pattern pattern, ReflectiveHandle<?> reflectiveHandle) {
        this.pattern = pattern;
        this.matcher = pattern.matcher(this.declaration);
        this.start(reflectiveHandle);
    }

    public <T extends DynamicClassHandle> T parseClass(T t) {
        String string;
        this.pattern(CLASS, t);
        String string2 = this.group("package");
        if (string2 != null && !string2.isEmpty()) {
            boolean bl = false;
            for (PackageHandle packageHandle : PACKAGE_HANDLES) {
                String string3 = packageHandle.packageId().toLowerCase(Locale.ENGLISH);
                if (!string2.startsWith(string3)) continue;
                if (string2.indexOf(46) == -1) {
                    t.inPackage(packageHandle);
                } else {
                    t.inPackage(packageHandle, string2.substring(string3.length() + 1));
                }
                bl = true;
                break;
            }
            if (!bl) {
                t.inPackage(string2);
            }
        }
        if ((string = this.group("className")).contains("<")) {
            string = string.substring(0, string.indexOf(60));
        }
        t.named(string);
        return t;
    }

    public <T extends ConstructorMemberHandle> T parseConstructor(T t) {
        this.pattern(CONSTRUCTOR, t);
        if (this.has("className") && !t.getClassHandle().getPossibleNames().contains(this.group("className"))) {
            this.error("Wrong class name associated to constructor, possible names: " + t.getClassHandle().getPossibleNames());
        }
        if (this.has("parameters")) {
            t.parameters(this.parseTypes(this.group("parameters").split(",")));
        }
        return t;
    }

    public <T extends MethodMemberHandle> T parseMethod(T t) {
        this.pattern(METHOD, t);
        t.named(this.group("methodName").split("\\$"));
        t.returns(this.parseType(this.group("methodReturnType")));
        if (this.has("parameters")) {
            t.parameters(this.parseTypes(this.group("parameters").split(",")));
        }
        return t;
    }

    public <T extends FieldMemberHandle> T parseField(T t) {
        this.pattern(FIELD, t);
        t.named(this.group("fieldName").split("\\$"));
        t.returns(this.parseType(this.group("fieldType")));
        return t;
    }

    private String group(String string) {
        return this.matcher.group(string);
    }

    private boolean has(String string) {
        String string2 = this.group(string);
        return string2 != null && !string2.isEmpty();
    }

    private void start(ReflectiveHandle<?> reflectiveHandle) {
        if (!this.matcher.matches()) {
            this.error("Not a " + reflectiveHandle + " declaration");
        }
        this.parseFlags();
        if (reflectiveHandle instanceof MemberHandle) {
            MemberHandle memberHandle = (MemberHandle)reflectiveHandle;
            if (!ReflectionParser.hasOneOf(this.flags, Flag.PUBLIC, Flag.PROTECTED, Flag.PRIVATE)) {
                Class clazz = (Class)memberHandle.getClassHandle().reflectOrNull();
                if (clazz != null && !clazz.isInterface()) {
                    memberHandle.makeAccessible();
                }
            } else if (ReflectionParser.hasOneOf(this.flags, Flag.PRIVATE, Flag.PROTECTED)) {
                memberHandle.makeAccessible();
            }
            if (reflectiveHandle instanceof FieldMemberHandle && this.flags.contains((Object)Flag.FINAL)) {
                ((FieldMemberHandle)reflectiveHandle).asFinal();
            }
            if (reflectiveHandle instanceof FlaggedNamedMemberHandle && this.flags.contains((Object)Flag.STATIC)) {
                ((FlaggedNamedMemberHandle)reflectiveHandle).asStatic();
            }
        }
    }

    private void parseFlags() {
        if (!this.has("flags")) {
            return;
        }
        String string = this.group("flags");
        for (String string2 : string.split("\\s+")) {
            if (this.flags.add(Flag.valueOf(string2.toUpperCase(Locale.ENGLISH)))) continue;
            this.error("Repeated flag: " + string2);
        }
        if (ReflectionParser.containsDuplicates(this.flags, Flag.PUBLIC, Flag.PROTECTED, Flag.PRIVATE)) {
            this.error("Duplicate visibility flags");
        }
    }

    @SafeVarargs
    private static <T> boolean containsDuplicates(Collection<T> collection, T ... TArray) {
        boolean bl = false;
        for (T t : TArray) {
            if (!collection.contains(t)) continue;
            if (bl) {
                return true;
            }
            bl = true;
        }
        return false;
    }

    @SafeVarargs
    private static <T> boolean hasOneOf(Collection<T> collection, T ... TArray) {
        return Arrays.stream(TArray).anyMatch(collection::contains);
    }

    private void error(String string) {
        throw new ReflectionParserException(string + " in: " + this.declaration + " (RegEx: " + this.pattern.pattern() + "), (Imports: " + this.cachedImports + ')');
    }

    static {
        Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Void.TYPE, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class, Void.class, Object.class, String.class, CharSequence.class, StringBuilder.class, StringBuffer.class, UUID.class, Optional.class, Map.class, HashMap.class, ConcurrentHashMap.class, LinkedHashMap.class, WeakHashMap.class, List.class, ArrayList.class, Set.class, HashSet.class, Deque.class, Queue.class, LinkedList.class, Date.class, Calendar.class, Duration.class).forEach(clazz -> PREDEFINED_TYPES.put(clazz.getSimpleName(), (Class<?>)clazz));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/cryptomorin/xseries/advancedcrates/reflection/parser/ReflectionParser", "id"));
    }

    private static enum Flag {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        FINAL,
        TRANSIENT,
        ABSTRACT,
        STATIC,
        NATIVE,
        SYNCHRONIZED,
        STRICTFP,
        VOLATILE;

        private static final String FLAGS_REGEX;

        static /* synthetic */ String access$000() {
            return FLAGS_REGEX;
        }

        static {
            FLAGS_REGEX = "(?<flags>(?:(?:" + Arrays.stream(Flag.values()).map(Enum::name).map(string -> string.toLowerCase(Locale.ENGLISH)).collect(Collectors.joining("|")) + ")\\s*)+)?";
        }
    }

    private static final class IDHandler {
        private boolean generic;
        private boolean array;
        private final String groupName;
        private final boolean isFullyQualified;

        private IDHandler(String string, boolean bl) {
            this.groupName = string;
            this.isFullyQualified = bl;
        }

        public IDHandler generic(boolean bl) {
            this.generic = bl;
            return this;
        }

        public IDHandler array(boolean bl) {
            this.array = bl;
            return this;
        }

        public String toString() {
            String string = (this.isFullyQualified ? "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*" : "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") + (this.generic ? ReflectionParser.GENERIC : "") + (this.array ? ReflectionParser.ARRAY : "");
            if (this.groupName == null) {
                return "(?:" + string + ')';
            }
            return "(?<" + this.groupName + '>' + string + ')';
        }
    }

    public static final class ReflectionParserException
    extends RuntimeException {
        public ReflectionParserException(String string) {
            super(string);
        }
    }
}

