/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.reflection.minecraft;

import com.cryptomorin.xseries.advancedcrates.reflection.XReflection;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.MethodMemberHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftMapping;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftPackage;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecraftConnection {
    public static final MinecraftClassHandle ServerPlayer = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerPlayer").map(MinecraftMapping.SPIGOT, "EntityPlayer");
    public static final MinecraftClassHandle CraftPlayer = XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named("CraftPlayer");
    public static final MinecraftClassHandle ServerPlayerConnection = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.network").map(MinecraftMapping.MOJANG, "ServerPlayerConnection").map(MinecraftMapping.SPIGOT, "PlayerConnection");
    public static final MinecraftClassHandle ServerGamePacketListenerImpl = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.network").map(MinecraftMapping.MOJANG, "ServerGamePacketListenerImpl").map(MinecraftMapping.SPIGOT, "PlayerConnection");
    public static final MinecraftClassHandle Packet = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol").map(MinecraftMapping.SPIGOT, "Packet");
    private static final MethodHandle PLAYER_CONNECTION = (MethodHandle)ServerPlayer.field().getter().returns(ServerGamePacketListenerImpl).map(MinecraftMapping.MOJANG, "connection").map(MinecraftMapping.OBFUSCATED, XReflection.v(21, 2, "f").v(20, "c").v(17, "b").orElse("playerConnection")).unreflect();
    private static final MethodHandle GET_HANDLE = (MethodHandle)CraftPlayer.method().named("getHandle").returns(ServerPlayer).unreflect();
    private static final MethodHandle SEND_PACKET = (MethodHandle)((MethodMemberHandle)ServerPlayerConnection.method().returns((Class)Void.TYPE)).parameters(Packet).map(MinecraftMapping.MOJANG, "send").map(MinecraftMapping.OBFUSCATED, XReflection.v(20, 2, "b").v(18, "a").orElse("sendPacket")).unreflect();

    @NotNull
    public static Object getHandle(@NotNull Player player) {
        Object object;
        if (player == null) {
            MinecraftConnection.$$$reportNull$$$0(0);
        }
        Objects.requireNonNull(player, "Cannot get handle of null player");
        try {
            object = GET_HANDLE.invoke(player);
        }
        catch (Throwable throwable) {
            throw XReflection.throwCheckedException(throwable);
        }
        if (object == null) {
            MinecraftConnection.$$$reportNull$$$0(1);
        }
        return object;
    }

    @Nullable
    public static Object getConnection(@NotNull Player player) {
        if (player == null) {
            MinecraftConnection.$$$reportNull$$$0(2);
        }
        Objects.requireNonNull(player, "Cannot get connection of null player");
        try {
            Object object = GET_HANDLE.invoke(player);
            return PLAYER_CONNECTION.invoke(object);
        }
        catch (Throwable throwable) {
            throw XReflection.throwCheckedException(throwable);
        }
    }

    @NotNull
    public static void sendPacket(@NotNull Player player, Object ... objectArray) {
        if (player == null) {
            MinecraftConnection.$$$reportNull$$$0(3);
        }
        if (objectArray == null) {
            MinecraftConnection.$$$reportNull$$$0(4);
        }
        Objects.requireNonNull(player, () -> "Can't send packet to null player: " + Arrays.toString(objectArray));
        Objects.requireNonNull(objectArray, () -> "Can't send null packets to player: " + player);
        try {
            Object object = GET_HANDLE.invoke(player);
            Object object2 = PLAYER_CONNECTION.invoke(object);
            if (object2 != null) {
                for (Object object3 : objectArray) {
                    Objects.requireNonNull(object3, "Null packet detected between packets array");
                    SEND_PACKET.invoke(object2, object3);
                }
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to send packet to " + player + ": " + Arrays.toString(objectArray), throwable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/reflection/minecraft/MinecraftConnection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/reflection/minecraft/MinecraftConnection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHandle";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendPacket";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

