/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes;

import com.cryptomorin.xseries.advancedcrates.reflection.ReflectiveNamespace;
import com.cryptomorin.xseries.advancedcrates.reflection.XReflection;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.NameableReflectiveHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.ClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.PackageHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftMapping;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DynamicClassHandle
extends ClassHandle
implements NameableReflectiveHandle {
    protected ClassHandle parent;
    protected String packageName;
    protected final Set<String> classNames = new HashSet<String>(5);
    protected int array;
    private static final /* synthetic */ Pattern[] $_PATTERN_CACHE_$;

    public DynamicClassHandle(ReflectiveNamespace reflectiveNamespace) {
        super(reflectiveNamespace);
    }

    public DynamicClassHandle inPackage(@org.intellij.lang.annotations.Pattern(value="(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") @NotNull String string) {
        assert (string == null || $_PATTERN_CACHE_$[0].matcher(string).matches()) : "Argument 0 for @Pattern parameter of com/cryptomorin/xseries/advancedcrates/reflection/jvm/classes/DynamicClassHandle.inPackage does not match pattern (\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        if (string == null) {
            DynamicClassHandle.$$$reportNull$$$0(0);
        }
        Objects.requireNonNull(string, "Null package name");
        this.packageName = string;
        return this;
    }

    public DynamicClassHandle inPackage(@NotNull PackageHandle packageHandle) {
        if (packageHandle == null) {
            DynamicClassHandle.$$$reportNull$$$0(1);
        }
        return this.inPackage(packageHandle, "");
    }

    public DynamicClassHandle inPackage(@NotNull PackageHandle packageHandle, @org.intellij.lang.annotations.Pattern(value="(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") @NotNull String string) {
        assert (string == null || $_PATTERN_CACHE_$[0].matcher(string).matches()) : "Argument 1 for @Pattern parameter of com/cryptomorin/xseries/advancedcrates/reflection/jvm/classes/DynamicClassHandle.inPackage does not match pattern (\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        if (packageHandle == null) {
            DynamicClassHandle.$$$reportNull$$$0(2);
        }
        if (string == null) {
            DynamicClassHandle.$$$reportNull$$$0(3);
        }
        Objects.requireNonNull(packageHandle, "Null package handle type");
        Objects.requireNonNull(string, "Null package handle name");
        if (this.parent != null) {
            throw new IllegalStateException("Cannot change package of an inner class: " + packageHandle + " -> " + string);
        }
        this.packageName = packageHandle.getPackage(string);
        return this;
    }

    @Override
    public DynamicClassHandle map(MinecraftMapping minecraftMapping, String string) {
        return this.named(string);
    }

    @Override
    public DynamicClassHandle named(String ... stringArray) {
        if (stringArray == null) {
            DynamicClassHandle.$$$reportNull$$$0(4);
        }
        Objects.requireNonNull(stringArray);
        for (String string : this.classNames) {
            Objects.requireNonNull(string, () -> "Cannot add null class name from: " + Arrays.toString(stringArray) + " to " + this);
        }
        this.classNames.addAll(Arrays.asList(stringArray));
        return this;
    }

    public String[] reflectClassNames() {
        if (this.parent == null) {
            Objects.requireNonNull(this.packageName, "Package name is null");
        }
        String[] stringArray = new String[this.classNames.size()];
        Class clazz = this.parent == null ? null : (Class)XReflection.of((Class)this.parent.unreflect()).asArray(0).unreflect();
        int n = 0;
        for (String string : this.classNames) {
            String string2 = clazz == null ? this.packageName + '.' + string : clazz.getName() + '$' + string;
            if (this.array != 0) {
                string2 = Strings.repeat((String)"[", (int)this.array) + 'L' + string2 + ';';
            }
            stringArray[n++] = string2;
        }
        return stringArray;
    }

    @Override
    public DynamicClassHandle copy() {
        DynamicClassHandle dynamicClassHandle = new DynamicClassHandle(this.namespace);
        dynamicClassHandle.array = this.array;
        dynamicClassHandle.parent = this.parent;
        dynamicClassHandle.packageName = this.packageName;
        dynamicClassHandle.classNames.addAll(this.classNames);
        return dynamicClassHandle;
    }

    @Override
    public Class<?> reflect() {
        String[] stringArray = this.reflectClassNames();
        if (stringArray.length == 0) {
            throw new IllegalStateException("No class name specified for " + this);
        }
        Throwable throwable = null;
        for (String string : stringArray) {
            try {
                return this.checkConstraints(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (throwable == null) {
                    throwable = new ClassNotFoundException("None of the classes were found");
                }
                throwable.addSuppressed(classNotFoundException);
            }
        }
        throw (ClassNotFoundException)XReflection.relativizeSuppressedExceptions(throwable);
    }

    @Override
    public DynamicClassHandle asArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Array dimension cannot be negative: " + n);
        }
        this.array = n;
        return this;
    }

    @Override
    public boolean isArray() {
        return this.array > 0;
    }

    @Override
    public Set<String> getPossibleNames() {
        return this.classNames;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + (this.parent == null ? "" : this.parent + " -> ") + (this.parent == null ? this.packageName : (this.packageName == null ? "" : this.packageName)) + '(' + String.join((CharSequence)"|", this.classNames) + ')' + (this.array == 0 ? "" : "[" + this.array + ']') + " }";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageHandle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
        }
        objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/reflection/jvm/classes/DynamicClassHandle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "named";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static {
        $_PATTERN_CACHE_$ = new Pattern[1];
        DynamicClassHandle.$_PATTERN_CACHE_$[0] = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    }
}

