/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.reflection.constraint;

import com.cryptomorin.xseries.advancedcrates.reflection.ReflectiveHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.XAccessFlag;
import com.cryptomorin.xseries.advancedcrates.reflection.constraint.ReflectiveConstraint;
import java.lang.reflect.Member;

public enum VisibilityConstraint implements ReflectiveConstraint
{
    PUBLIC(XAccessFlag.PUBLIC),
    PRIVATE(XAccessFlag.PRIVATE),
    PROTECTED(XAccessFlag.PROTECTED);

    private final XAccessFlag accessFlag;

    private VisibilityConstraint(XAccessFlag xAccessFlag) {
        this.accessFlag = xAccessFlag;
    }

    public XAccessFlag getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public ReflectiveConstraint.Result appliesTo(ReflectiveHandle<?> reflectiveHandle, Object object) {
        int n;
        if (object instanceof Class) {
            n = ((Class)object).getModifiers();
            if (this == PRIVATE) {
                return ReflectiveConstraint.Result.INCOMPATIBLE;
            }
            if (this == PROTECTED) {
                return ReflectiveConstraint.Result.of(!XAccessFlag.PUBLIC.isSet(n));
            }
        } else if (object instanceof Member) {
            n = ((Member)object).getModifiers();
        } else {
            return ReflectiveConstraint.Result.INCOMPATIBLE;
        }
        return ReflectiveConstraint.Result.of(this.accessFlag.isSet(n));
    }

    @Override
    public String category() {
        return "Visibility";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "::" + this.name();
    }
}

