/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.reflection;

import com.cryptomorin.xseries.advancedcrates.reflection.ReflectiveHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.ReflectiveNamespace;
import com.cryptomorin.xseries.advancedcrates.reflection.aggregate.AggregateReflectiveHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.aggregate.AggregateReflectiveSupplier;
import com.cryptomorin.xseries.advancedcrates.reflection.aggregate.VersionHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.asm.XReflectASM;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.DynamicClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.jvm.classes.StaticClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftClassHandle;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftMapping;
import com.cryptomorin.xseries.advancedcrates.reflection.minecraft.MinecraftPackage;
import com.cryptomorin.xseries.advancedcrates.reflection.proxy.ReflectiveProxy;
import com.cryptomorin.xseries.advancedcrates.reflection.proxy.ReflectiveProxyObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XReflection {
    @Nullable
    public static final String NMS_VERSION;
    public static final String XSERIES_VERSION = "13.0.0";
    public static final String DISABLE_MINECRAFT_CAPABILITIES_PROPERTY = "xseries.xreflection.disable.minecraft";
    public static final boolean SUPPORTS_ASM;
    public static final int MAJOR_NUMBER;
    public static final int MINOR_NUMBER;
    public static final int PATCH_NUMBER;
    public static final String CRAFTBUKKIT_PACKAGE;
    public static final String NMS_PACKAGE;
    public static final Set<MinecraftMapping> SUPPORTED_MAPPINGS;
    private static final Map<Class<?>, ReflectiveProxyObject> PROXIFIED_CLASSES;

    @Nullable
    public static String findNMSVersionString() {
        String string = null;
        for (Package package_ : Package.getPackages()) {
            String string2 = package_.getName();
            if (!string2.startsWith("org.bukkit.craftbukkit.v")) continue;
            string = package_.getName().split("\\.")[3];
            try {
                Class.forName("org.bukkit.craftbukkit." + string + ".entity.CraftPlayer");
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = null;
            }
        }
        return string;
    }

    private static String isMinecraftDisabled() {
        try {
            return System.getProperty(DISABLE_MINECRAFT_CAPABILITIES_PROPERTY);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    @NotNull
    public static String getVersionInformation() {
        String string = "(NMS: " + (NMS_VERSION == null ? "Unknown NMS" : NMS_VERSION) + " | Parsed: " + MAJOR_NUMBER + '.' + MINOR_NUMBER + '.' + PATCH_NUMBER + " | Minecraft: " + Bukkit.getVersion() + " | Bukkit: " + Bukkit.getBukkitVersion() + ')';
        if (string == null) {
            XReflection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static Integer getLatestPatchNumberOf(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Minor version must be positive: " + n);
        }
        int[] nArray = new int[]{1, 5, 2, 7, 2, 4, 10, 8, 4, 2, 2, 2, 2, 4, 2, 5, 1, 2, 4, 6, 4};
        if (n > nArray.length) {
            return null;
        }
        return nArray[n - 1];
    }

    private XReflection() {
    }

    @NotNull
    public static <T> VersionHandle<T> v(int n, T t) {
        return new VersionHandle<T>(n, t);
    }

    @NotNull
    public static <T> VersionHandle<T> v(int n, int n2, T t) {
        return new VersionHandle<T>(n, n2, t);
    }

    @NotNull
    public static <T> VersionHandle<T> v(int n, Callable<T> callable) {
        return new VersionHandle<T>(n, callable);
    }

    @NotNull
    public static <T> VersionHandle<T> v(int n, int n2, Callable<T> callable) {
        return new VersionHandle<T>(n, n2, callable);
    }

    public static boolean supports(int n) {
        return MINOR_NUMBER >= n;
    }

    public static boolean supports(int n, int n2, int n3) {
        if (n != 1) {
            throw new IllegalArgumentException("Invalid major number: " + n);
        }
        return XReflection.supports(n2, n3);
    }

    public static boolean supports(int n, int n2) {
        return MINOR_NUMBER == n ? PATCH_NUMBER >= n2 : XReflection.supports(n);
    }

    @Deprecated
    public static boolean supportsPatch(int n) {
        return PATCH_NUMBER >= n;
    }

    @Deprecated
    @NotNull
    public static Class<?> getNMSClass(@Nullable String string, @NotNull String string2) {
        Class<?> clazz;
        if (string2 == null) {
            XReflection.$$$reportNull$$$0(1);
        }
        if (string != null && XReflection.supports(17)) {
            string2 = string + '.' + string2;
        }
        try {
            clazz = Class.forName(NMS_PACKAGE + '.' + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
        if (clazz == null) {
            XReflection.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @Deprecated
    @NotNull
    public static Class<?> getNMSClass(@NotNull String string) {
        if (string == null) {
            XReflection.$$$reportNull$$$0(3);
        }
        return XReflection.getNMSClass(null, string);
    }

    @Deprecated
    @NotNull
    public static Class<?> getCraftClass(@NotNull String string) {
        Class<?> clazz;
        if (string == null) {
            XReflection.$$$reportNull$$$0(4);
        }
        try {
            clazz = Class.forName(CRAFTBUKKIT_PACKAGE + '.' + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
        if (clazz == null) {
            XReflection.$$$reportNull$$$0(5);
        }
        return clazz;
    }

    @NotNull
    public static Class<?> toArrayClass(@NotNull Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            XReflection.$$$reportNull$$$0(6);
        }
        Objects.requireNonNull(clazz, "Class is null");
        try {
            clazz2 = Class.forName("[L" + clazz.getName() + ';');
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot find array class for class: " + clazz, classNotFoundException);
        }
        if (clazz2 == null) {
            XReflection.$$$reportNull$$$0(7);
        }
        return clazz2;
    }

    @NotNull
    public static MinecraftClassHandle ofMinecraft() {
        return new MinecraftClassHandle(new ReflectiveNamespace());
    }

    @NotNull
    public static DynamicClassHandle classHandle() {
        return new DynamicClassHandle(new ReflectiveNamespace());
    }

    @NotNull
    public static StaticClassHandle of(Class<?> clazz) {
        return new StaticClassHandle(new ReflectiveNamespace(), clazz);
    }

    @NotNull
    public static ReflectiveNamespace namespaced() {
        return new ReflectiveNamespace();
    }

    @SafeVarargs
    @NotNull
    public static <T, H extends ReflectiveHandle<T>> AggregateReflectiveHandle<T, H> any(H ... HArray) {
        return new AggregateReflectiveHandle(Arrays.stream(HArray).map(reflectiveHandle -> () -> reflectiveHandle).collect(Collectors.toList()));
    }

    @SafeVarargs
    @NotNull
    public static <T, H extends ReflectiveHandle<T>> AggregateReflectiveHandle<T, H> anyOf(Callable<H> ... callableArray) {
        return new AggregateReflectiveHandle(Arrays.asList(callableArray));
    }

    @NotNull
    public static <H extends ReflectiveHandle<?>, O> AggregateReflectiveSupplier<H, O> supply(H h, O o) {
        AggregateReflectiveSupplier<H, O> aggregateReflectiveSupplier = new AggregateReflectiveSupplier<H, O>();
        aggregateReflectiveSupplier.or(h, o);
        AggregateReflectiveSupplier<H, O> aggregateReflectiveSupplier2 = aggregateReflectiveSupplier;
        if (aggregateReflectiveSupplier2 == null) {
            XReflection.$$$reportNull$$$0(8);
        }
        return aggregateReflectiveSupplier2;
    }

    @NotNull
    public static <H extends ReflectiveHandle<?>, O> AggregateReflectiveSupplier<H, O> supply(H h, Supplier<O> supplier) {
        AggregateReflectiveSupplier<H, O> aggregateReflectiveSupplier = new AggregateReflectiveSupplier<H, O>();
        aggregateReflectiveSupplier.or(h, supplier);
        AggregateReflectiveSupplier<H, O> aggregateReflectiveSupplier2 = aggregateReflectiveSupplier;
        if (aggregateReflectiveSupplier2 == null) {
            XReflection.$$$reportNull$$$0(9);
        }
        return aggregateReflectiveSupplier2;
    }

    @NotNull
    public static <T extends Throwable> T relativizeSuppressedExceptions(@NotNull T t) {
        if (t == null) {
            XReflection.$$$reportNull$$$0(10);
        }
        Objects.requireNonNull(t, "Cannot relativize null exception");
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        StackTraceElement[] stackTraceElementArray2 = t.getStackTrace();
        for (Throwable throwable : t.getSuppressed()) {
            StackTraceElement[] stackTraceElementArray3 = throwable.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(10);
            for (int i = 0; i < stackTraceElementArray3.length; ++i) {
                if (stackTraceElementArray2.length <= i) {
                    arrayList = null;
                    break;
                }
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                StackTraceElement stackTraceElement2 = stackTraceElementArray3[i];
                if (stackTraceElement.equals(stackTraceElement2)) break;
                arrayList.add(stackTraceElement2);
            }
            if (arrayList == null) continue;
            throwable.setStackTrace(arrayList.toArray(stackTraceElementArray));
        }
        T t2 = t;
        if (t2 == null) {
            XReflection.$$$reportNull$$$0(11);
        }
        return t2;
    }

    private static <T extends Throwable> void throwException(Throwable throwable) {
        throw throwable;
    }

    public static RuntimeException throwCheckedException(@NotNull Throwable throwable) {
        if (throwable == null) {
            XReflection.$$$reportNull$$$0(12);
        }
        Objects.requireNonNull(throwable, "Cannot throw null exception");
        XReflection.throwException(throwable);
        return null;
    }

    public static <T> CompletableFuture<T> stacktrace(@NotNull CompletableFuture<T> completableFuture) {
        if (completableFuture == null) {
            XReflection.$$$reportNull$$$0(13);
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        return completableFuture.whenComplete((object, throwable) -> {
            if (throwable == null) {
                completableFuture.complete(object);
                return;
            }
            try {
                StackTraceElement[] stackTraceElementArray2;
                StackTraceElement[] stackTraceElementArray3 = throwable.getStackTrace();
                if (stackTraceElementArray3.length >= 3) {
                    stackTraceElementArray2 = new ArrayList(Arrays.asList(stackTraceElementArray3));
                    Collections.reverse(stackTraceElementArray2);
                    Iterator iterator = stackTraceElementArray2.iterator();
                    List<String> list = Arrays.asList("java.util.concurrent.CompletableFuture", "java.util.concurrent.ThreadPoolExecutor", "java.util.concurrent.ForkJoinTask", "java.util.concurrent.ForkJoinWorkerThread", "java.util.concurrent.ForkJoinPool");
                    List<String> list2 = Arrays.asList("postComplete", "encodeThrowable", "completeThrowable", "tryFire", "run", "runWorker", "scan", "exec", "doExec", "topLevelExec", "uniWhenComplete");
                    while (iterator.hasNext()) {
                        StackTraceElement stackTraceElement = (StackTraceElement)iterator.next();
                        String string = stackTraceElement.getClassName();
                        String string2 = stackTraceElement.getMethodName();
                        if (string.equals(Thread.class.getName())) continue;
                        if (!list.stream().anyMatch(string::startsWith)) break;
                        if (!list2.stream().anyMatch(string2::equals)) break;
                        iterator.remove();
                    }
                    Collections.reverse(stackTraceElementArray2);
                    stackTraceElementArray3 = stackTraceElementArray2.toArray(new StackTraceElement[0]);
                }
                stackTraceElementArray2 = (StackTraceElement[])Arrays.stream(stackTraceElementArray).skip(2L).toArray(StackTraceElement[]::new);
                throwable.setStackTrace(XReflection.concatenate(stackTraceElementArray3, stackTraceElementArray2));
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            finally {
                completableFuture.completeExceptionally((Throwable)throwable);
            }
        });
    }

    public static <T> T[] concatenate(T[] TArray, T[] TArray2) {
        int n = TArray.length;
        int n2 = TArray2.length;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n + n2);
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray2, 0, objectArray, n, n2);
        return objectArray;
    }

    @NotNull
    public static <T extends ReflectiveProxyObject> T proxify(@NotNull Class<T> clazz) {
        if (clazz == null) {
            XReflection.$$$reportNull$$$0(14);
        }
        ReflectiveProxy.checkInterfaceClass(clazz);
        ReflectiveProxyObject reflectiveProxyObject = PROXIFIED_CLASSES.get(clazz);
        if (reflectiveProxyObject != null) {
            ReflectiveProxyObject reflectiveProxyObject2 = reflectiveProxyObject;
            if (reflectiveProxyObject2 == null) {
                XReflection.$$$reportNull$$$0(15);
            }
            return (T)reflectiveProxyObject2;
        }
        T t = SUPPORTS_ASM ? XReflectASM.proxify(clazz).create() : ReflectiveProxy.proxify(clazz).proxy();
        PROXIFIED_CLASSES.put(clazz, (ReflectiveProxyObject)t);
        T t2 = t;
        if (t2 == null) {
            XReflection.$$$reportNull$$$0(16);
        }
        return t2;
    }

    static {
        Matcher matcher;
        boolean bl;
        NMS_VERSION = XReflection.findNMSVersionString();
        try {
            Class.forName("org.objectweb.asm.ClassWriter");
            Class.forName("org.objectweb.asm.MethodVisitor");
            Class.forName("org.objectweb.asm.FieldVisitor");
            Class.forName("org.objectweb.asm.Constants");
            Class.forName("org.objectweb.asm.Opcodes");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        SUPPORTS_ASM = bl;
        String string = XReflection.isMinecraftDisabled();
        if (string != null) {
            System.out.println("[XSeries/XReflection] Testing with hardcoded server version: " + (string.isEmpty() ? "Disabled Minecraft Capabilities" : string));
            if (string.isEmpty() || string.equals("true")) {
                string = "1.21.4-R0.1-SNAPSHOT";
            }
        }
        if ((matcher = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?").matcher(string != null ? string : Bukkit.getBukkitVersion())).find()) {
            try {
                String string2 = matcher.group("patch");
                MAJOR_NUMBER = Integer.parseInt(matcher.group("major"));
                MINOR_NUMBER = Integer.parseInt(matcher.group("minor"));
                PATCH_NUMBER = Integer.parseInt(string2 == null || string2.isEmpty() ? "0" : string2);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to parse minor number: " + matcher + ' ' + XReflection.getVersionInformation(), throwable);
            }
        } else {
            throw new IllegalStateException("Cannot parse server version: \"" + Bukkit.getBukkitVersion() + '\"');
        }
        CRAFTBUKKIT_PACKAGE = XReflection.isMinecraftDisabled() != null ? null : Bukkit.getServer().getClass().getPackage().getName();
        NMS_PACKAGE = XReflection.v(17, "net.minecraft").orElse("net.minecraft.server." + NMS_VERSION);
        SUPPORTED_MAPPINGS = XReflection.isMinecraftDisabled() != null ? Collections.unmodifiableSet(EnumSet.noneOf(MinecraftMapping.class)) : Collections.unmodifiableSet(XReflection.supply(XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerPlayer"), () -> EnumSet.of(MinecraftMapping.MOJANG)).or(XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "EntityPlayer"), () -> EnumSet.of(MinecraftMapping.SPIGOT, MinecraftMapping.OBFUSCATED)).get());
        PROXIFIED_CLASSES = new IdentityHashMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/reflection/XReflection";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completableFuture";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionInformation";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/reflection/XReflection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNMSClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCraftClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toArrayClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "supply";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "relativizeSuppressedExceptions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "proxify";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNMSClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCraftClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toArrayClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "relativizeSuppressedExceptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "throwCheckedException";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stacktrace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "proxify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

