/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.profiles.objects.transformer;

import com.cryptomorin.xseries.advancedcrates.profiles.objects.Profileable;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProfileTransformer {
    @NotNull
    public GameProfile transform(@NotNull Profileable var1, @NotNull GameProfile var2);

    public boolean canBeCached();

    @NotNull
    public static ProfileTransformer stackable() {
        RemoveMetadata removeMetadata = RemoveMetadata.INSTANCE;
        if (removeMetadata == null) {
            ProfileTransformer.$$$reportNull$$$0(0);
        }
        return removeMetadata;
    }

    @NotNull
    public static ProfileTransformer nonStackable() {
        MakeNotStackable makeNotStackable = MakeNotStackable.INSTANCE;
        if (makeNotStackable == null) {
            ProfileTransformer.$$$reportNull$$$0(1);
        }
        return makeNotStackable;
    }

    @NotNull
    public static ProfileTransformer removeMetadata() {
        RemoveMetadata removeMetadata = RemoveMetadata.INSTANCE;
        if (removeMetadata == null) {
            ProfileTransformer.$$$reportNull$$$0(2);
        }
        return removeMetadata;
    }

    @NotNull
    public static ProfileTransformer includeOriginalValue() {
        IncludeOriginalValue includeOriginalValue = IncludeOriginalValue.INSTANCE;
        if (includeOriginalValue == null) {
            ProfileTransformer.$$$reportNull$$$0(3);
        }
        return includeOriginalValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/cryptomorin/xseries/advancedcrates/profiles/objects/transformer/ProfileTransformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "stackable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nonStackable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMetadata";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "includeOriginalValue";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class RemoveMetadata
    implements ProfileTransformer {
        private static final RemoveMetadata INSTANCE = new RemoveMetadata();

        @Override
        public GameProfile transform(Profileable profileable, GameProfile gameProfile) {
            try {
                Class<?> clazz = Class.forName("your.package.PlayerProfiles");
                Method method = clazz.getMethod("removeTimestamp", GameProfile.class);
                method.invoke(null, gameProfile);
                Method method2 = GameProfile.class.getMethod("getProperties", new Class[0]);
                Object object = method2.invoke((Object)gameProfile, new Object[0]);
                Method method3 = object.getClass().getMethod("asMap", new Class[0]);
                Object object2 = method3.invoke(object, new Object[0]);
                Method method4 = object2.getClass().getMethod("remove", Object.class);
                method4.invoke(object2, "XSERIES_SIG");
                method4.invoke(object2, "OriginalValue");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return gameProfile;
        }

        @Override
        public boolean canBeCached() {
            return true;
        }
    }

    public static final class MakeNotStackable
    implements ProfileTransformer {
        private static final MakeNotStackable INSTANCE = new MakeNotStackable();
        private static final String PROPERTY_NAME = "XSeriesSeed";
        private static final AtomicLong NEXT_ID = new AtomicLong();

        @Override
        public GameProfile transform(Profileable profileable, GameProfile gameProfile) {
            try {
                long l = System.currentTimeMillis();
                long l2 = NEXT_ID.getAndIncrement();
                String string = l + "-" + l2;
                Class<?> clazz = Class.forName("com.mojang.authlib.properties.Property");
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
                Object obj = constructor.newInstance(PROPERTY_NAME, string);
                Method method = GameProfile.class.getMethod("getProperties", new Class[0]);
                Object object = method.invoke((Object)gameProfile, new Object[0]);
                Method method2 = object.getClass().getMethod("put", Object.class, Object.class);
                method2.invoke(object, PROPERTY_NAME, obj);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return gameProfile;
        }

        @Override
        public boolean canBeCached() {
            return false;
        }
    }

    public static final class IncludeOriginalValue
    implements ProfileTransformer {
        private static final IncludeOriginalValue INSTANCE = new IncludeOriginalValue();
        public static final String PROPERTY_NAME = "OriginalValue";

        @Nullable
        public static String getOriginalValue(@NotNull Object object) {
            if (object == null) {
                IncludeOriginalValue.$$$reportNull$$$0(0);
            }
            try {
                Method method2;
                Object object2;
                Method method3;
                Method method4 = object.getClass().getMethod("getProperties", new Class[0]);
                Object object3 = method4.invoke(object, new Object[0]);
                Method method5 = object3.getClass().getMethod("get", Object.class);
                Object object4 = method5.invoke(object3, "textures");
                Method method6 = object4.getClass().getMethod("isEmpty", new Class[0]);
                boolean bl = (Boolean)method6.invoke(object4, new Object[0]);
                if (bl) {
                    return null;
                }
                Method method7 = object4.getClass().getMethod("iterator", new Class[0]);
                Object object5 = method7.invoke(object4, new Object[0]);
                Method method8 = object5.getClass().getMethod("hasNext", new Class[0]);
                if (((Boolean)method8.invoke(object5, new Object[0])).booleanValue() && (method3 = (Method)Arrays.stream((object2 = (method2 = object5.getClass().getMethod("next", new Class[0])).invoke(object5, new Object[0])).getClass().getDeclaredMethods()).filter(method -> method.getName().equalsIgnoreCase("value")).findFirst().orElse(null)) != null) {
                    return (String)method3.invoke(object2, new Object[0]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        @Override
        public GameProfile transform(Profileable profileable, GameProfile gameProfile) {
            try {
                String string = profileable.getProfileValue();
                Method method = gameProfile.getClass().getMethod("getProperties", new Class[0]);
                Object object = method.invoke((Object)gameProfile, new Object[0]);
                Class<?> clazz = Class.forName("com.mojang.authlib.properties.Property");
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
                Object obj = constructor.newInstance("textures", string);
                Method method2 = object.getClass().getMethod("put", Object.class, Object.class);
                method2.invoke(object, "textures", obj);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return gameProfile;
        }

        @Override
        public boolean canBeCached() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/cryptomorin/xseries/advancedcrates/profiles/objects/transformer/ProfileTransformer$IncludeOriginalValue", "getOriginalValue"));
        }
    }
}

