/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.profiles.objects.cache;

import com.cryptomorin.xseries.advancedcrates.profiles.objects.cache.CacheableProfileable;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public abstract class TimedCacheableProfileable
extends CacheableProfileable {
    private long lastUpdate;

    @NotNull
    protected Duration expiresAfter() {
        Duration duration = Duration.ofHours(6L);
        if (duration == null) {
            TimedCacheableProfileable.$$$reportNull$$$0(0);
        }
        return duration;
    }

    @Override
    public final boolean hasExpired(boolean bl) {
        if (super.hasExpired(bl)) {
            return true;
        }
        if (this.cache == null && this.lastError == null) {
            return true;
        }
        Duration duration = this.expiresAfter();
        if (duration.isZero()) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (this.lastUpdate == 0L) {
            if (bl) {
                this.lastUpdate = l;
            }
            return true;
        }
        long l2 = l - this.lastUpdate;
        if (l2 >= duration.toMillis()) {
            if (bl) {
                this.lastUpdate = l;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/cryptomorin/xseries/advancedcrates/profiles/objects/cache/TimedCacheableProfileable", "expiresAfter"));
    }
}

