/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.profiles.objects;

import com.cryptomorin.xseries.advancedcrates.profiles.PlayerProfiles;
import com.cryptomorin.xseries.advancedcrates.profiles.PlayerUUIDs;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.InvalidProfileException;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.ProfileException;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.UnknownPlayerException;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.MojangAPI;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.PlayerProfileFetcherThread;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.ProfileRequestConfiguration;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.ProfileContainer;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.ProfileInputType;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.cache.TimedCacheableProfileable;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.transformer.ProfileTransformer;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.transformer.TransformableProfile;
import com.cryptomorin.xseries.advancedcrates.reflection.XReflection;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Profileable {
    @Nullable
    public GameProfile getProfile();

    @Nullable
    default public ProfileException test() {
        try {
            this.getProfile();
            return null;
        }
        catch (ProfileException ex) {
            return ex;
        }
    }

    @Nullable
    default public GameProfile getDisposableProfile() {
        GameProfile profile = this.getProfile();
        return profile == null ? null : PlayerProfiles.clone(profile);
    }

    @NotNull
    default public Profileable transform(ProfileTransformer ... transformers) {
        if (transformers == null) {
            Profileable.$$$reportNull$$$0(0);
        }
        return new TransformableProfile(this, Arrays.asList(transformers));
    }

    @Nullable
    default public String getProfileValue() {
        return PlayerProfiles.getOriginalValue(this.getProfile());
    }

    @NotNull
    public static <C extends Collection<Profileable>> CompletableFuture<C> prepare(@NotNull C profileables) {
        if (profileables == null) {
            Profileable.$$$reportNull$$$0(1);
        }
        return Profileable.prepare(profileables, null, null);
    }

    @NotNull
    public static <C extends Collection<Profileable>> CompletableFuture<C> prepare(@NotNull C profileables, @Nullable ProfileRequestConfiguration config, @Nullable Function<Throwable, Boolean> errorHandler) {
        if (profileables == null) {
            Profileable.$$$reportNull$$$0(2);
        }
        Objects.requireNonNull(profileables, "Profile list is null");
        CompletableFuture initial = CompletableFuture.completedFuture(new HashMap());
        ArrayList<String> usernameRequests = new ArrayList<String>();
        if (!PlayerUUIDs.isOnlineMode()) {
            for (Profileable profileable : profileables) {
                String username = null;
                if (profileable instanceof UsernameProfileable) {
                    username = ((UsernameProfileable)profileable).username;
                } else if (profileable instanceof PlayerProfileable) {
                    username = ((PlayerProfileable)profileable).username;
                } else if (profileable instanceof StringProfileable && ((StringProfileable)profileable).determineType().type == ProfileInputType.USERNAME) {
                    username = ((StringProfileable)profileable).string;
                }
                if (username == null) continue;
                usernameRequests.add(username);
            }
            if (!usernameRequests.isEmpty()) {
                initial = CompletableFuture.supplyAsync(() -> MojangAPI.usernamesToUUIDs(usernameRequests, config), PlayerProfileFetcherThread.EXECUTOR);
            }
        }
        CompletableFuture completableFuture = XReflection.stacktrace(((CompletableFuture)initial.thenCompose(a -> {
            ArrayList<CompletableFuture<GameProfile>> requests = new ArrayList<CompletableFuture<GameProfile>>(profileables.size());
            for (Profileable profileable : profileables) {
                CompletionStage<Object> async = CompletableFuture.supplyAsync(profileable::getProfile, PlayerProfileFetcherThread.EXECUTOR);
                if (errorHandler != null) {
                    async = XReflection.stacktrace(async).exceptionally(ex -> {
                        boolean rethrow = (Boolean)errorHandler.apply(ex);
                        if (rethrow) {
                            throw XReflection.throwCheckedException(ex);
                        }
                        return null;
                    });
                }
                requests.add((CompletableFuture<GameProfile>)async);
            }
            return CompletableFuture.allOf(requests.toArray(new CompletableFuture[0]));
        })).thenApply(a -> profileables));
        if (completableFuture == null) {
            Profileable.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    @NotNull
    public static Profileable username(@NotNull String username) {
        if (username == null) {
            Profileable.$$$reportNull$$$0(4);
        }
        return new UsernameProfileable(username);
    }

    @NotNull
    public static Profileable of(@NotNull UUID uuid) {
        if (uuid == null) {
            Profileable.$$$reportNull$$$0(5);
        }
        return new UUIDProfileable(uuid);
    }

    @NotNull
    public static Profileable of(@NotNull GameProfile profile) {
        if (profile == null) {
            Profileable.$$$reportNull$$$0(6);
        }
        return new GameProfileProfileable(profile);
    }

    @NotNull
    public static Profileable of(@NotNull OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            Profileable.$$$reportNull$$$0(7);
        }
        return new PlayerProfileable(offlinePlayer);
    }

    @NotNull
    public static Profileable of(@NotNull BlockState blockState) {
        if (blockState == null) {
            Profileable.$$$reportNull$$$0(8);
        }
        return new ProfileContainer.BlockStateProfileContainer((Skull)blockState);
    }

    @NotNull
    public static Profileable of(@NotNull Block block) {
        if (block == null) {
            Profileable.$$$reportNull$$$0(9);
        }
        return new ProfileContainer.BlockProfileContainer(block);
    }

    @NotNull
    public static Profileable of(@NotNull ItemStack item) {
        if (item == null) {
            Profileable.$$$reportNull$$$0(10);
        }
        return new ProfileContainer.ItemStackProfileContainer(item);
    }

    @NotNull
    public static Profileable of(@NotNull ItemMeta meta) {
        if (meta == null) {
            Profileable.$$$reportNull$$$0(11);
        }
        return new ProfileContainer.ItemMetaProfileContainer((SkullMeta)meta);
    }

    @NotNull
    public static Profileable detect(@NotNull String input) {
        if (input == null) {
            Profileable.$$$reportNull$$$0(12);
        }
        return new StringProfileable(input, null);
    }

    @NotNull
    public static Profileable of(@NotNull ProfileInputType type, @NotNull String input) {
        if (type == null) {
            Profileable.$$$reportNull$$$0(13);
        }
        if (input == null) {
            Profileable.$$$reportNull$$$0(14);
        }
        Objects.requireNonNull(type, () -> "Cannot profile from a null input type: " + input);
        Objects.requireNonNull(input, () -> "Cannot profile from a null input: " + (Object)((Object)type));
        return new StringProfileable(input, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformers";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/profiles/objects/Profileable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlinePlayer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/profiles/objects/Profileable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "username";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class UsernameProfileable
    extends TimedCacheableProfileable {
        private final String username;
        private Boolean valid;

        public UsernameProfileable(String string) {
            this.username = Objects.requireNonNull(string);
        }

        @Override
        public String getProfileValue() {
            return this.username;
        }

        @Override
        protected GameProfile getProfile0() {
            if (this.valid == null) {
                this.valid = ProfileInputType.USERNAME.pattern.matcher(this.username).matches();
            }
            if (!this.valid.booleanValue()) {
                throw new InvalidProfileException(this.username, "Invalid username: '" + this.username + '\'');
            }
            Optional<GameProfile> optional = MojangAPI.getMojangCachedProfileFromUsername(this.username);
            if (!optional.isPresent()) {
                throw new UnknownPlayerException((Object)this.username, "Cannot find player named '" + this.username + '\'');
            }
            GameProfile gameProfile = optional.get();
            if (PlayerProfiles.hasTextures(gameProfile)) {
                return gameProfile;
            }
            return MojangAPI.getOrFetchProfile(gameProfile);
        }
    }

    public static final class PlayerProfileable
    extends TimedCacheableProfileable {
        @Nullable
        private final String username;
        @NotNull
        private final UUID id;

        public PlayerProfileable(OfflinePlayer offlinePlayer) {
            Objects.requireNonNull(offlinePlayer);
            this.username = offlinePlayer.getName();
            this.id = offlinePlayer.getUniqueId();
        }

        @Override
        public String getProfileValue() {
            return Strings.isNullOrEmpty((String)this.username) ? this.id.toString() : this.username;
        }

        @Override
        protected GameProfile getProfile0() {
            if (Strings.isNullOrEmpty((String)this.username)) {
                return new UUIDProfileable(this.id).getProfile();
            }
            return new UsernameProfileable(this.username).getProfile();
        }
    }

    public static final class StringProfileable
    extends TimedCacheableProfileable {
        private final String string;
        @Nullable
        private ProfileInputType type;

        public StringProfileable(String string, @Nullable ProfileInputType profileInputType) {
            this.string = Objects.requireNonNull(string, "Input string is null");
            this.type = profileInputType;
        }

        @Override
        public String getProfileValue() {
            return this.string;
        }

        private StringProfileable determineType() {
            if (this.type == null) {
                this.type = ProfileInputType.typeOf(this.string);
            }
            return this;
        }

        @Override
        protected GameProfile getProfile0() {
            this.determineType();
            if (this.type == null) {
                throw new InvalidProfileException(this.string, "Unknown skull string value: " + this.string);
            }
            return this.type.getProfile(this.string);
        }
    }

    public static final class UUIDProfileable
    extends TimedCacheableProfileable {
        private final UUID id;

        public UUIDProfileable(UUID uUID) {
            this.id = Objects.requireNonNull(uUID, "UUID cannot be null");
        }

        @Override
        public String getProfileValue() {
            return this.id.toString();
        }

        @Override
        protected GameProfile getProfile0() {
            GameProfile gameProfile = MojangAPI.getCachedProfileByUUID(this.id);
            if (PlayerProfiles.hasTextures(gameProfile)) {
                return gameProfile;
            }
            return MojangAPI.getOrFetchProfile(gameProfile);
        }
    }

    public static final class GameProfileProfileable
    extends TimedCacheableProfileable {
        private final GameProfile profile;

        public GameProfileProfileable(GameProfile gameProfile) {
            this.profile = Objects.requireNonNull(gameProfile);
        }

        @Override
        protected GameProfile getProfile0() {
            if (PlayerProfiles.hasTextures(this.profile)) {
                return this.profile;
            }
            return (PlayerUUIDs.isOnlineMode() ? new UUIDProfileable(this.profile.getId()) : new UsernameProfileable(this.profile.getName())).getProfile();
        }
    }
}

