/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.profiles.mojang;

import com.cryptomorin.xseries.advancedcrates.profiles.PlayerProfiles;
import com.cryptomorin.xseries.advancedcrates.profiles.PlayerUUIDs;
import com.cryptomorin.xseries.advancedcrates.profiles.ProfileLogger;
import com.cryptomorin.xseries.advancedcrates.profiles.ProfilesCore;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.MojangAPIException;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.UnknownPlayerException;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.MinecraftClient;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.MojangProfileCache;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.PlayerProfile;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.ProfileRequestConfiguration;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.RateLimiter;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.ProfileInputType;
import com.cryptomorin.xseries.advancedcrates.reflection.XReflection;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MojangAPI {
    private static final MojangProfileCache MOJANG_PROFILE_CACHE = !ProfilesCore.NULLABILITY_RECORD_UPDATE ? new MojangProfileCache.GameProfileCache(ProfilesCore.YggdrasilMinecraftSessionService_insecureProfiles) : new MojangProfileCache.ProfileResultCache(ProfilesCore.YggdrasilMinecraftSessionService_insecureProfiles);
    private static final Cache<UUID, Optional<GameProfile>> INSECURE_PROFILES = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build();
    private static final boolean REQUIRE_SECURE_PROFILES = false;
    private static final MinecraftClient USERNAME_TO_UUID = new MinecraftClient("GET", "https://api.mojang.com/users/profiles/minecraft/", new RateLimiter(600, Duration.ofMinutes(10L)));
    private static final MinecraftClient USERNAMES_TO_UUIDS = new MinecraftClient("POST", "https://api.minecraftservices.com/minecraft/profile/lookup/bulk/byname", new RateLimiter(600, Duration.ofMinutes(10L)));
    private static final MinecraftClient UUID_TO_PROFILE = new MinecraftClient("GET", "https://sessionserver.mojang.com/session/minecraft/profile/", new RateLimiter(200, Duration.ofMinutes(1L)));

    @Nullable
    public static UUID requestUsernameToUUID(@NotNull String string) {
        JsonElement jsonElement;
        if (string == null) {
            MojangAPI.$$$reportNull$$$0(0);
        }
        if ((jsonElement = USERNAME_TO_UUID.session(null).append(string).request()) == null) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement jsonElement2 = jsonObject.get("id");
        if (jsonElement2 == null) {
            throw new IllegalArgumentException("No 'id' field for UUID request for '" + string + "': " + jsonObject);
        }
        return PlayerUUIDs.UUIDFromDashlessString(jsonElement2.getAsString());
    }

    private static GameProfile getCachedProfileByUsername(String string) {
        try {
            Object object = ProfilesCore.GameProfileCache_get$profileByName$.invoke(ProfilesCore.USER_CACHE, string);
            if (object instanceof Optional) {
                object = ((Optional)object).orElse(null);
            }
            Object object2 = object == null ? PlayerProfiles.createGameProfile(PlayerUUIDs.IDENTITY_UUID, string) : PlayerProfiles.sanitizeProfile((GameProfile)object);
            ProfileLogger.debug("The cached profile for {} -> {}", string, object);
            return object2;
        }
        catch (Throwable throwable) {
            ProfileLogger.LOGGER.error("Unable to get cached profile by username: {}", (Object)string, (Object)throwable);
            return null;
        }
    }

    public static Optional<GameProfile> getMojangCachedProfileFromUsername(String string) {
        try {
            return MojangAPI.getMojangCachedProfileFromUsername0(string);
        }
        catch (Throwable throwable) {
            throw XReflection.throwCheckedException(throwable);
        }
    }

    private static Optional<GameProfile> getMojangCachedProfileFromUsername0(String string) {
        Optional<GameProfile> optional;
        String string2 = string.toLowerCase(Locale.ENGLISH);
        Object object = ProfilesCore.UserCache_profilesByName.get(string2);
        if (object != null) {
            if (ProfilesCore.UserCacheEntry_setLastAccess != null && ProfilesCore.UserCache_getNextOperation != null) {
                long l = ProfilesCore.UserCache_getNextOperation.invoke(ProfilesCore.USER_CACHE);
                ProfilesCore.UserCacheEntry_setLastAccess.invoke(object, l);
            }
            optional = Optional.of(ProfilesCore.UserCacheEntry_getProfile.invoke(object));
        } else {
            UUID uUID = PlayerUUIDs.getRealUUIDOfPlayer(string);
            if (uUID == null) {
                return Optional.empty();
            }
            GameProfile gameProfile = PlayerProfiles.createGameProfile(PlayerUUIDs.isOnlineMode() ? uUID : PlayerUUIDs.getOfflineUUID(string), string);
            optional = Optional.of(gameProfile);
            MojangAPI.cacheProfile(gameProfile);
        }
        return optional;
    }

    public static Map<UUID, String> usernamesToUUIDs(@NotNull Collection<String> collection, @Nullable ProfileRequestConfiguration profileRequestConfiguration) {
        Object object;
        Object object2;
        if (collection == null) {
            MojangAPI.$$$reportNull$$$0(1);
        }
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Usernames are null or empty");
        }
        for (String object32 : collection) {
            if (object32 != null && ProfileInputType.USERNAME.pattern.matcher(object32).matches()) continue;
            throw new IllegalArgumentException("One of the requested usernames is invalid: " + object32 + " in " + collection);
        }
        HashMap hashMap = new HashMap(collection.size());
        HashSet<String> hashSet = new HashSet<String>(collection);
        Iterator bl = hashSet.iterator();
        while (bl.hasNext()) {
            object2 = (String)bl.next();
            object = PlayerUUIDs.USERNAME_TO_ONLINE.get(object2);
            if (object == null) continue;
            bl.remove();
            hashMap.put(object, object2);
        }
        if (hashSet.isEmpty()) {
            return hashMap;
        }
        boolean bl2 = PlayerUUIDs.isOnlineMode();
        object2 = Iterables.partition(hashSet, (int)10);
        object = object2.iterator();
        while (object.hasNext()) {
            JsonArray jsonArray;
            List list = (List)object.next();
            try {
                jsonArray = USERNAMES_TO_UUIDS.session(profileRequestConfiguration).body(list).request().getAsJsonArray();
            }
            catch (IOException iOException) {
                throw new MojangAPIException("Failed to request UUIDs for username batch: " + list, iOException);
            }
            for (JsonElement jsonElement : jsonArray) {
                String string;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String string2 = jsonObject.get("name").getAsString();
                UUID uUID = PlayerUUIDs.UUIDFromDashlessString(jsonObject.get("id").getAsString());
                UUID uUID2 = PlayerUUIDs.getOfflineUUID(string2);
                PlayerUUIDs.USERNAME_TO_ONLINE.put(string2, uUID);
                PlayerUUIDs.ONLINE_TO_OFFLINE.put(uUID, uUID2);
                PlayerUUIDs.OFFLINE_TO_ONLINE.put(uUID2, uUID);
                if (!ProfilesCore.UserCache_profilesByName.containsKey(string2)) {
                    MojangAPI.cacheProfile(PlayerProfiles.createGameProfile(bl2 ? uUID : uUID2, string2));
                }
                if ((string = hashMap.put(uUID, string2)) == null) continue;
                throw new IllegalArgumentException("Got duplicate usernames for UUID: " + uUID + " (" + string + " -> " + string2 + ')');
            }
        }
        return hashMap;
    }

    @NotNull
    public static GameProfile getCachedProfileByUUID(UUID uUID) {
        GameProfile gameProfile;
        uUID = PlayerUUIDs.isOnlineMode() ? uUID : PlayerUUIDs.ONLINE_TO_OFFLINE.getOrDefault(uUID, uUID);
        try {
            Object object = ProfilesCore.GameProfileCache_get$profileByUUID$.invoke(ProfilesCore.USER_CACHE, uUID);
            if (object instanceof Optional) {
                object = ((Optional)object).orElse(null);
            }
            ProfileLogger.debug("The cached profile for {} -> {}", uUID, object);
            gameProfile = (GameProfile)(object == null ? PlayerProfiles.createNamelessGameProfile(uUID) : PlayerProfiles.sanitizeProfile((GameProfile)object));
        }
        catch (Throwable throwable) {
            ProfileLogger.LOGGER.error("Unable to get cached profile by UUID: {}", (Object)uUID, (Object)throwable);
            GameProfile gameProfile2 = (GameProfile)PlayerProfiles.createNamelessGameProfile(uUID);
            if (gameProfile2 == null) {
                MojangAPI.$$$reportNull$$$0(3);
            }
            return gameProfile2;
        }
        if (gameProfile == null) {
            MojangAPI.$$$reportNull$$$0(2);
        }
        return gameProfile;
    }

    private static void cacheProfile(GameProfile gameProfile) {
        try {
            ProfilesCore.CACHE_PROFILE.invoke(ProfilesCore.USER_CACHE, gameProfile);
            ProfileLogger.debug("Profile is now cached: {}", gameProfile);
        }
        catch (Throwable throwable) {
            ProfileLogger.LOGGER.error("Unable to cache profile {}", (Object)gameProfile);
            throwable.printStackTrace();
        }
    }

    @NotNull
    public static GameProfile getOrFetchProfile(@NotNull GameProfile gameProfile) {
        UUID uUID;
        if (gameProfile == null) {
            MojangAPI.$$$reportNull$$$0(4);
        }
        if (gameProfile.getName().equals("XSeries")) {
            uUID = gameProfile.getId();
        } else {
            uUID = PlayerUUIDs.getRealUUIDOfPlayer(gameProfile.getName(), gameProfile.getId());
            if (uUID == null) {
                throw new UnknownPlayerException((Object)gameProfile.getName(), "Player with the given properties not found: " + gameProfile);
            }
        }
        GameProfile gameProfile2 = MojangAPI.handleCache(gameProfile, uUID);
        if (gameProfile2 != null) {
            GameProfile gameProfile3 = gameProfile2;
            if (gameProfile3 == null) {
                MojangAPI.$$$reportNull$$$0(5);
            }
            return gameProfile3;
        }
        JsonElement jsonElement = MojangAPI.requestProfile(gameProfile, uUID);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ArrayList<String> arrayList = new ArrayList<String>();
        GameProfile gameProfile4 = MojangAPI.createGameProfile(jsonObject, arrayList);
        gameProfile4 = (GameProfile)PlayerProfiles.sanitizeProfile(gameProfile4);
        MojangAPI.cacheProfile(gameProfile4);
        INSECURE_PROFILES.put((Object)uUID, Optional.of(gameProfile4));
        MOJANG_PROFILE_CACHE.cache(new PlayerProfile(uUID, gameProfile, gameProfile4, arrayList));
        GameProfile gameProfile5 = gameProfile4;
        if (gameProfile5 == null) {
            MojangAPI.$$$reportNull$$$0(6);
        }
        return gameProfile5;
    }

    @Nullable
    private static GameProfile handleCache(@NotNull GameProfile gameProfile, UUID uUID) {
        Optional optional;
        if (gameProfile == null) {
            MojangAPI.$$$reportNull$$$0(7);
        }
        if ((optional = (Optional)INSECURE_PROFILES.getIfPresent((Object)uUID)) != null) {
            ProfileLogger.debug("Found cached profile from UUID ({}): {} -> {}", uUID, gameProfile, optional);
            if (optional.isPresent()) {
                return (GameProfile)optional.get();
            }
            throw new UnknownPlayerException(uUID, "Player with the given properties not found: " + gameProfile);
        }
        Optional<GameProfile> optional2 = MOJANG_PROFILE_CACHE.get(uUID, gameProfile);
        if (optional2 != null) {
            INSECURE_PROFILES.put((Object)uUID, optional2);
            if (optional2.isPresent()) {
                return optional2.get();
            }
            throw new UnknownPlayerException(uUID, "Player with the given properties not found: " + gameProfile);
        }
        return null;
    }

    @NotNull
    private static JsonElement requestProfile(@NotNull GameProfile gameProfile, UUID uUID) {
        JsonElement jsonElement;
        if (gameProfile == null) {
            MojangAPI.$$$reportNull$$$0(8);
        }
        try {
            jsonElement = UUID_TO_PROFILE.session(null).append(PlayerUUIDs.toUndashedUUID(uUID) + "?unsigned=" + true).request();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to request profile: " + gameProfile + " with real UUID: " + uUID, iOException);
        }
        if (jsonElement == null) {
            INSECURE_PROFILES.put((Object)uUID, Optional.empty());
            MOJANG_PROFILE_CACHE.cache(new PlayerProfile(uUID, gameProfile, null, null));
            throw new UnknownPlayerException(uUID, "Player with the given properties not found: " + gameProfile);
        }
        JsonElement jsonElement2 = jsonElement;
        if (jsonElement2 == null) {
            MojangAPI.$$$reportNull$$$0(9);
        }
        return jsonElement2;
    }

    @NotNull
    private static GameProfile createGameProfile(JsonObject jsonObject, List<String> list) {
        GameProfile gameProfile;
        try {
            JsonArray jsonArray;
            UUID uUID = PlayerUUIDs.UUIDFromDashlessString(jsonObject.get("id").getAsString());
            String string = jsonObject.get("name").getAsString();
            Class<?> clazz = Class.forName("com.mojang.authlib.GameProfile");
            Constructor<?> constructor = clazz.getConstructor(UUID.class, String.class);
            GameProfile gameProfile2 = (GameProfile)constructor.newInstance(uUID, string);
            JsonElement jsonElement = jsonObject.get("properties");
            if (jsonElement != null) {
                jsonArray = jsonElement.getAsJsonArray();
                Method method = clazz.getMethod("getProperties", new Class[0]);
                Object object = method.invoke((Object)gameProfile2, new Object[0]);
                Class<?> clazz2 = Class.forName("com.mojang.authlib.properties.Property");
                Constructor<?> constructor2 = clazz2.getConstructor(String.class, String.class, String.class);
                Constructor<?> constructor3 = clazz2.getConstructor(String.class, String.class);
                for (JsonElement jsonElement2 : jsonArray) {
                    JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
                    String string2 = jsonObject2.get("name").getAsString();
                    String string3 = jsonObject2.get("value").getAsString();
                    JsonElement jsonElement3 = jsonObject2.get("signature");
                    Object obj = jsonElement3 != null ? constructor2.newInstance(string2, string3, jsonElement3.getAsString()) : constructor3.newInstance(string2, string3);
                    Method method2 = object.getClass().getMethod("put", Object.class, Object.class);
                    method2.invoke(object, string2, obj);
                }
            }
            if ((jsonArray = jsonObject.get("profileActions")) != null) {
                for (Object object : jsonArray.getAsJsonArray()) {
                    list.add(object.getAsString());
                }
            }
            gameProfile = gameProfile2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to create GameProfile", exception);
        }
        if (gameProfile == null) {
            MojangAPI.$$$reportNull$$$0(10);
        }
        return gameProfile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usernames";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/profiles/mojang/MojangAPI";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/profiles/mojang/MojangAPI";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedProfileByUUID";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrFetchProfile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "requestProfile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGameProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestUsernameToUUID";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "usernamesToUUIDs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrFetchProfile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleCache";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requestProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

