/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.profiles.builder;

import com.cryptomorin.xseries.advancedcrates.profiles.ProfileLogger;
import com.cryptomorin.xseries.advancedcrates.profiles.builder.ProfileFallback;
import com.cryptomorin.xseries.advancedcrates.profiles.builder.XSkull;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.InvalidProfileException;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.ProfileChangeException;
import com.cryptomorin.xseries.advancedcrates.profiles.exceptions.ProfileException;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.PlayerProfileFetcherThread;
import com.cryptomorin.xseries.advancedcrates.profiles.mojang.ProfileRequestConfiguration;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.DelegateProfileable;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.ProfileContainer;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.Profileable;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfileInstruction<T>
implements DelegateProfileable {
    private final ProfileContainer<T> profileContainer;
    private Profileable profileable;
    private final List<Profileable> fallbacks = new ArrayList<Profileable>();
    private Consumer<ProfileFallback<T>> onFallback;
    private ProfileRequestConfiguration profileRequestConfiguration;
    private boolean lenient = false;

    protected ProfileInstruction(ProfileContainer<T> profileContainer) {
        this.profileContainer = profileContainer;
    }

    @NotNull
    public T removeProfile() {
        this.profileContainer.setProfile(null);
        T t = this.profileContainer.getObject();
        if (t == null) {
            ProfileInstruction.$$$reportNull$$$0(0);
        }
        return t;
    }

    @NotNull
    public ProfileInstruction<T> profileRequestConfiguration(ProfileRequestConfiguration profileRequestConfiguration) {
        this.profileRequestConfiguration = profileRequestConfiguration;
        ProfileInstruction profileInstruction = this;
        if (profileInstruction == null) {
            ProfileInstruction.$$$reportNull$$$0(1);
        }
        return profileInstruction;
    }

    @NotNull
    public ProfileInstruction<T> lenient() {
        this.lenient = true;
        ProfileInstruction profileInstruction = this;
        if (profileInstruction == null) {
            ProfileInstruction.$$$reportNull$$$0(2);
        }
        return profileInstruction;
    }

    @Override
    @Nullable
    public GameProfile getProfile() {
        return this.profileContainer.getProfile();
    }

    @Override
    public Profileable getDelegateProfile() {
        return this.profileContainer;
    }

    @NotNull
    public ProfileInstruction<T> profile(@NotNull Profileable profileable) {
        if (profileable == null) {
            ProfileInstruction.$$$reportNull$$$0(3);
        }
        this.profileable = Objects.requireNonNull(profileable, "Profileable is null");
        ProfileInstruction profileInstruction = this;
        if (profileInstruction == null) {
            ProfileInstruction.$$$reportNull$$$0(4);
        }
        return profileInstruction;
    }

    @NotNull
    public ProfileInstruction<T> fallback(Profileable ... profileableArray) {
        if (profileableArray == null) {
            ProfileInstruction.$$$reportNull$$$0(5);
        }
        Objects.requireNonNull(profileableArray, "fallbacks array is null");
        this.fallbacks.addAll(Arrays.asList(profileableArray));
        ProfileInstruction profileInstruction = this;
        if (profileInstruction == null) {
            ProfileInstruction.$$$reportNull$$$0(6);
        }
        return profileInstruction;
    }

    @NotNull
    public ProfileInstruction<T> onFallback(@Nullable Consumer<ProfileFallback<T>> consumer) {
        this.onFallback = consumer;
        ProfileInstruction profileInstruction = this;
        if (profileInstruction == null) {
            ProfileInstruction.$$$reportNull$$$0(7);
        }
        return profileInstruction;
    }

    @NotNull
    public ProfileInstruction<T> onFallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProfileInstruction.$$$reportNull$$$0(8);
        }
        Objects.requireNonNull(runnable, "onFallback runnable is null");
        this.onFallback = profileFallback -> runnable.run();
        ProfileInstruction profileInstruction = this;
        if (profileInstruction == null) {
            ProfileInstruction.$$$reportNull$$$0(9);
        }
        return profileInstruction;
    }

    @NotNull
    public T apply() {
        Objects.requireNonNull(this.profileable, "No profile was set");
        Throwable throwable = null;
        ArrayList<Profileable> arrayList = new ArrayList<Profileable>(2 + this.fallbacks.size());
        arrayList.add(this.profileable);
        arrayList.addAll(this.fallbacks);
        if (this.lenient) {
            arrayList.add(XSkull.getDefaultProfile());
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Profileable object : arrayList) {
            try {
                GameProfile profileException = object.getDisposableProfile();
                if (profileException != null) {
                    this.profileContainer.setProfile(profileException);
                    bl = true;
                    break;
                }
                if (throwable == null) {
                    throwable = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                throwable.addSuppressed(new InvalidProfileException(object.toString(), "Profile doesn't have a value: " + object));
                bl2 = true;
            }
            catch (ProfileException profileException) {
                if (throwable == null) {
                    throwable = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                throwable.addSuppressed(profileException);
                bl2 = true;
            }
        }
        if (throwable != null) {
            if (bl || this.lenient) {
                ProfileLogger.debug("apply() silenced exception {}", throwable);
            } else {
                throw throwable;
            }
        }
        Iterator<Object> iterator = this.profileContainer.getObject();
        if (bl2 && this.onFallback != null) {
            ProfileFallback profileFallback = new ProfileFallback(this, iterator, (ProfileChangeException)throwable);
            this.onFallback.accept(profileFallback);
            iterator = profileFallback.getObject();
        }
        Iterator<Object> iterator2 = iterator;
        if (iterator2 == null) {
            ProfileInstruction.$$$reportNull$$$0(10);
        }
        return (T)iterator2;
    }

    @NotNull
    public CompletableFuture<T> applyAsync() {
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(this::apply, PlayerProfileFetcherThread.EXECUTOR);
        if (completableFuture == null) {
            ProfileInstruction.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/profiles/builder/ProfileInstruction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbacks";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removeProfile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "profileRequestConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "lenient";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/profiles/builder/ProfileInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "profile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fallback";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "onFallback";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAsync";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "profile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onFallback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

