/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.profiles;

import com.cryptomorin.xseries.advancedcrates.profiles.PlayerUUIDs;
import com.cryptomorin.xseries.advancedcrates.profiles.ProfilesCore;
import com.cryptomorin.xseries.advancedcrates.profiles.objects.transformer.ProfileTransformer;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerProfiles {
    public static final String XSERIES_SIG = "XSeries";
    private static final Object XSERIES_GAMEPROFILE_SIGNATURE;
    private static final String TEXTURES_PROPERTY = "textures";
    public static final Object NIL;
    private static final Gson GSON;
    public static final String TEXTURES_NBT_PROPERTY_PREFIX = "{\"textures\":{\"SKIN\":{\"url\":\"";
    public static final String TEXTURES_BASE_URL = "http://textures.minecraft.net/texture/";

    public static Optional<Object> getTextureProperty(Object object) {
        try {
            Method method = object.getClass().getMethod("getProperties", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("get", Object.class);
            Object object3 = method2.invoke(object2, TEXTURES_PROPERTY);
            Method method3 = object3.getClass().getMethod("iterator", new Class[0]);
            Object object4 = method3.invoke(object3, new Object[0]);
            Method method4 = object4.getClass().getMethod("hasNext", new Class[0]);
            if (((Boolean)method4.invoke(object4, new Object[0])).booleanValue()) {
                Method method5 = object4.getClass().getMethod("next", new Class[0]);
                return Optional.ofNullable(method5.invoke(object4, new Object[0]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return Optional.empty();
    }

    @Nullable
    public static String getTextureValue(@NotNull GameProfile gameProfile) {
        if (gameProfile == null) {
            PlayerProfiles.$$$reportNull$$$0(0);
        }
        Objects.requireNonNull(gameProfile, "Game profile cannot be null");
        return PlayerProfiles.getTextureProperty(gameProfile).map(PlayerProfiles::getPropertyValue).orElse(null);
    }

    @Nullable
    public static String getOriginalValue(@Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        String string = ProfileTransformer.IncludeOriginalValue.getOriginalValue(gameProfile);
        if (string != null) {
            return string;
        }
        return PlayerProfiles.getTextureValue(gameProfile);
    }

    @NotNull
    public static String getPropertyValue(@NotNull Object object) {
        String string;
        if (object == null) {
            PlayerProfiles.$$$reportNull$$$0(1);
        }
        try {
            Field field = object.getClass().getDeclaredField("value");
            field.setAccessible(true);
            string = (String)field.get(object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to access the 'value' field of property: " + object, exception);
        }
        if (string == null) {
            PlayerProfiles.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean hasTextures(GameProfile gameProfile) {
        return PlayerProfiles.getTextureProperty(gameProfile).isPresent();
    }

    @NotNull
    public static Object profileFromHashAndBase64(String string, String string2) {
        Object object;
        try {
            UUID uUID = UUID.nameUUIDFromBytes(string.getBytes(StandardCharsets.UTF_8));
            Object object2 = PlayerProfiles.createNamelessGameProfile(uUID);
            PlayerProfiles.setTexturesProperty(object2, string2);
            object = object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to create profile from hash and Base64", exception);
        }
        if (object == null) {
            PlayerProfiles.$$$reportNull$$$0(3);
        }
        return object;
    }

    public static void removeTimestamp(GameProfile gameProfile) {
        JsonObject jsonObject = Optional.ofNullable(PlayerProfiles.getTextureValue(gameProfile)).map(PlayerProfiles::decodeBase64).map(string -> new JsonParser().parse(string).getAsJsonObject()).orElse(null);
        if (jsonObject == null || !jsonObject.has("timestamp")) {
            return;
        }
        jsonObject.remove("timestamp");
        PlayerProfiles.setTexturesProperty(gameProfile, PlayerProfiles.encodeBase64(GSON.toJson((JsonElement)jsonObject)));
    }

    @Nullable
    public static GameProfile unwrapProfile(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof GameProfile) && ProfilesCore.ResolvableProfile_gameProfile != null) {
            object = ProfilesCore.ResolvableProfile_gameProfile.invoke(object);
        }
        return (GameProfile)object;
    }

    @Nullable
    public static Object wrapProfile(@Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        if (ProfilesCore.ResolvableProfile$bukkitSupports) {
            return ProfilesCore.ResolvableProfile$constructor.invoke(gameProfile);
        }
        return gameProfile;
    }

    public static Object sanitizeProfile(Object object) {
        try {
            if (PlayerUUIDs.isOnlineMode()) {
                return object;
            }
            Method method = object.getClass().getMethod("getName", new Class[0]);
            String string = (String)method.invoke(object, new Object[0]);
            Method method2 = object.getClass().getMethod("getId", new Class[0]);
            UUID uUID = (UUID)method2.invoke(object, new Object[0]);
            UUID uUID2 = PlayerUUIDs.getOfflineUUID(string);
            PlayerUUIDs.ONLINE_TO_OFFLINE.put(uUID, uUID2);
            GameProfile gameProfile = PlayerProfiles.createGameProfile(uUID2, string);
            Method method3 = object.getClass().getMethod("getProperties", new Class[0]);
            Object object2 = method3.invoke(object, new Object[0]);
            Object object3 = method3.invoke((Object)gameProfile, new Object[0]);
            Method method4 = object3.getClass().getMethod("putAll", object2.getClass());
            method4.invoke(object3, object2);
            return gameProfile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to sanitize GameProfile", exception);
        }
    }

    public static GameProfile clone(GameProfile gameProfile) {
        GameProfile gameProfile2 = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile2.getProperties().putAll((Multimap)gameProfile.getProperties());
        return gameProfile2;
    }

    public static void setTexturesProperty(Object object, String string) {
        try {
            Class<?> clazz = Class.forName("com.mojang.authlib.properties.Property");
            Object obj = clazz.getConstructor(String.class, String.class).newInstance(TEXTURES_PROPERTY, string);
            Method method = object.getClass().getMethod("getProperties", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("asMap", new Class[0]);
            Object object3 = method2.invoke(object2, new Object[0]);
            Method method3 = object3.getClass().getMethod("remove", Object.class);
            method3.invoke(object3, TEXTURES_PROPERTY);
            Method method4 = object2.getClass().getMethod("put", Object.class, Object.class);
            method4.invoke(object2, TEXTURES_PROPERTY, obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String encodeBase64(String string) {
        return Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public static String decodeBase64(String string) {
        Objects.requireNonNull(string, "Cannot decode null string");
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            return new String(byArray, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static GameProfile createGameProfile(UUID uUID, String string) {
        try {
            Class<?> clazz = Class.forName("com.mojang.authlib.GameProfile");
            Constructor<?> constructor = clazz.getConstructor(UUID.class, String.class);
            Object obj = constructor.newInstance(uUID, string);
            return (GameProfile)PlayerProfiles.signXSeries(obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to create GameProfile", exception);
        }
    }

    public static Object signXSeries(Object object) {
        try {
            Method method = object.getClass().getMethod("getProperties", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("put", Object.class, Object.class);
            method2.invoke(object2, XSERIES_SIG, XSERIES_GAMEPROFILE_SIGNATURE);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to sign XSeries profile", exception);
        }
    }

    public static Object createNamelessGameProfile(UUID uUID) {
        try {
            return PlayerProfiles.createGameProfile(uUID, XSERIES_SIG);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to create nameless GameProfile", exception);
        }
    }

    static {
        GameProfile gameProfile;
        try {
            gameProfile = Class.forName("com.mojang.authlib.properties.Property");
            XSERIES_GAMEPROFILE_SIGNATURE = gameProfile.getConstructor(String.class, String.class).newInstance(XSERIES_SIG, "13.0.0");
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize XSERIES_GAMEPROFILE_SIGNATURE", exception);
        }
        try {
            gameProfile = PlayerProfiles.createGameProfile(PlayerUUIDs.IDENTITY_UUID, XSERIES_SIG);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            gameProfile = null;
        }
        NIL = gameProfile;
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/profiles/PlayerProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/profiles/PlayerProfiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "profileFromHashAndBase64";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextureValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

