/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates.base;

import com.cryptomorin.xseries.advancedcrates.base.XBase;
import com.cryptomorin.xseries.advancedcrates.base.annotations.XMerge;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XRegistry<XForm extends XBase<XForm, BukkitForm>, BukkitForm>
implements Iterable<XForm> {
    private static boolean PERFORM_AUTO_ADD = true;
    private static final boolean KEYED_EXISTS;
    private final Map<String, XForm> nameMappings = new HashMap<String, XForm>(20);
    private final Map<BukkitForm, XForm> bukkitToX = new IdentityHashMap<BukkitForm, XForm>(20);
    private final Class<BukkitForm> bukkitFormClass;
    private final Class<XForm> xFormClass;
    private final Supplier<Object> registrySupplier;
    private final BiFunction<BukkitForm, String[], XForm> creator;
    private final Function<Integer, XForm[]> createArray;
    private final String registryName;
    private final boolean supportsRegistry;
    private final ClassType bukkitClassType;
    private boolean pulled = false;

    public XRegistry(Class<BukkitForm> clazz, Class<XForm> clazz2, Supplier<Object> supplier, BiFunction<BukkitForm, String[], XForm> biFunction, Function<Integer, XForm[]> function) {
        boolean bl;
        try {
            supplier.get();
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        this.bukkitFormClass = Objects.requireNonNull(clazz);
        this.xFormClass = Objects.requireNonNull(clazz2);
        this.registryName = this.bukkitFormClass.getSimpleName();
        this.registrySupplier = supplier;
        this.createArray = Objects.requireNonNull(function);
        this.creator = biFunction;
        this.supportsRegistry = bl;
        this.bukkitClassType = clazz.isEnum() ? ClassType.ENUM : (Modifier.isAbstract(clazz.getModifiers()) ? ClassType.ABSTRACTION : null);
        if (!this.supportsRegistry && this.bukkitClassType == null) {
            throw new IllegalStateException("Bukkit form is not an enum, abstraction or a registry " + clazz);
        }
    }

    public XRegistry(Class<BukkitForm> clazz, Class<XForm> clazz2, Function<Integer, XForm[]> function) {
        this(clazz, clazz2, null, null, function);
    }

    @NotNull
    public Map<String, XForm> nameMapping() {
        Map<String, XForm> map = this.nameMappings;
        if (map == null) {
            XRegistry.$$$reportNull$$$0(0);
        }
        return map;
    }

    @NotNull
    public Map<BukkitForm, XForm> bukkitMapping() {
        Map<BukkitForm, XForm> map = this.bukkitToX;
        if (map == null) {
            XRegistry.$$$reportNull$$$0(1);
        }
        return map;
    }

    public Class<BukkitForm> getBukkitFormClass() {
        return this.bukkitFormClass;
    }

    public Class<XForm> getXFormClass() {
        return this.xFormClass;
    }

    public String getName() {
        return this.registryName;
    }

    private void pullValues() {
        if (!this.pulled) {
            this.pulled = true;
            if (this.creator == null) {
                return;
            }
            this.pullFieldNames();
            if (PERFORM_AUTO_ADD) {
                this.pullSystemValues();
            }
        }
    }

    private static <T> void processEnumLikeFields(Class<T> clazz, BiConsumer<Field, T> biConsumer) {
        for (Field field : clazz.getDeclaredFields()) {
            int n = field.getModifiers();
            if (field.getType() != clazz || !Modifier.isPublic(n) || !Modifier.isStatic(n) || !Modifier.isFinal(n)) continue;
            try {
                biConsumer.accept(field, (Field)field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Cannot process enum-like fields of: " + clazz, illegalAccessException);
            }
        }
    }

    public void registerName(String string, XForm XForm) {
        this.nameMappings.put(XRegistry.normalizeName(string), XForm);
    }

    private void pullFieldNames() {
        XRegistry.processEnumLikeFields(this.xFormClass, (field, xBase) -> this.registerMerged((XForm)xBase, (Field)field));
    }

    private void pullSystemValues() {
        if (this.bukkitClassType == ClassType.ENUM) {
            for (BukkitForm BukkitForm : this.bukkitFormClass.getEnumConstants()) {
                this.std(((Enum)BukkitForm).name(), BukkitForm);
            }
        } else {
            XRegistry.processEnumLikeFields(this.bukkitFormClass, (field, object) -> {
                if (object == null) {
                    return;
                }
                this.std(field.getName(), object);
            });
        }
        if (this.supportsRegistry) {
            for (Keyed keyed : this.bukkitRegistry()) {
                this.std((XForm)keyed);
            }
        }
    }

    private BukkitForm valueOf(String string) {
        string = string.toUpperCase(Locale.ENGLISH).replace('.', '_');
        Class<BukkitForm> clazz = this.bukkitFormClass;
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private BukkitForm fieldOf(String string) {
        try {
            return (BukkitForm)this.bukkitFormClass.getDeclaredField(string).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    @NotNull
    private Registry<?> bukkitRegistry() {
        Registry registry = (Registry)this.registrySupplier.get();
        if (registry == null) {
            XRegistry.$$$reportNull$$$0(2);
        }
        return registry;
    }

    @Nullable
    protected BukkitForm getBukkit(String[] stringArray) {
        for (String string : stringArray) {
            Object object;
            if (this.supportsRegistry) {
                NamespacedKey namespacedKey = (string = string.toLowerCase(Locale.ENGLISH)).contains(":") ? NamespacedKey.fromString((String)string) : NamespacedKey.minecraft((String)string);
                Keyed keyed = this.bukkitRegistry().get(namespacedKey);
                object = keyed != null ? keyed : null;
            } else if (this.bukkitClassType == ClassType.ENUM) {
                object = this.valueOf(string);
            } else if (this.bukkitClassType == ClassType.ABSTRACTION) {
                object = this.fieldOf(string);
            } else {
                throw new AssertionError((Object)("None of the class strategies worked for " + this));
            }
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @NotNull
    public Collection<XForm> getValues() {
        this.pullValues();
        Collection<XForm> collection = Collections.unmodifiableCollection(this.bukkitToX.values());
        if (collection == null) {
            XRegistry.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Deprecated
    public XForm[] values() {
        this.pullValues();
        Collection<XForm> collection = this.bukkitToX.values();
        return collection.toArray((XBase[])this.createArray.apply(collection.size()));
    }

    @Override
    @NotNull
    public Iterator<XForm> iterator() {
        Iterator<XForm> iterator = this.getValues().iterator();
        if (iterator == null) {
            XRegistry.$$$reportNull$$$0(4);
        }
        return iterator;
    }

    @NotNull
    public XForm getByBukkitForm(BukkitForm BukkitForm) {
        Objects.requireNonNull(BukkitForm, () -> "Cannot match null " + this.registryName);
        XBase xBase = (XBase)this.bukkitToX.get(BukkitForm);
        if (xBase == null) {
            if (!PERFORM_AUTO_ADD) {
                throw new UnsupportedOperationException("Unknown standard bukkit form (no auto-add) for " + this.registryName + ": " + BukkitForm);
            }
            if (this.creator == null) {
                throw new UnsupportedOperationException("Unsupported value for " + this.registryName + ": " + BukkitForm);
            }
            BukkitForm BukkitForm2 = this.std((XForm)BukkitForm);
            if (BukkitForm2 == null) {
                throw new IllegalStateException("Unknown " + this.registryName + ": " + BukkitForm);
            }
        }
        XBase xBase2 = xBase;
        if (xBase2 == null) {
            XRegistry.$$$reportNull$$$0(5);
        }
        return (XForm)xBase2;
    }

    public Optional<XForm> getByName(@NotNull String string) {
        if (string == null) {
            XRegistry.$$$reportNull$$$0(6);
        }
        Objects.requireNonNull(string, () -> "Cannot match null " + this.registryName);
        if (string.isEmpty()) {
            return Optional.empty();
        }
        this.pullValues();
        return Optional.ofNullable((XBase)this.nameMappings.get(XRegistry.normalizeName(string)));
    }

    @NotNull
    public static String getBukkitName(@NotNull Object object) {
        if (object == null) {
            XRegistry.$$$reportNull$$$0(7);
        }
        Objects.requireNonNull(object, "Cannot get name of a null bukkit form");
        if (object instanceof Enum) {
            String string = ((Enum)object).name();
            if (string == null) {
                XRegistry.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (KEYED_EXISTS && object instanceof Keyed) {
            String string = ((Keyed)object).getKey().toString();
            if (string == null) {
                XRegistry.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (object instanceof PotionEffectType) {
            String string = ((PotionEffectType)object).getName();
            if (string == null) {
                XRegistry.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (object instanceof Enchantment) {
            String string = ((Enchantment)object).getName();
            if (string == null) {
                XRegistry.$$$reportNull$$$0(11);
            }
            return string;
        }
        throw new AssertionError((Object)("Unknown xform type: " + object + " (" + object.getClass() + ')'));
    }

    @NotNull
    private static String format(@NotNull String string) {
        if (string == null) {
            XRegistry.$$$reportNull$$$0(12);
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(bl || n2 == 0 || c != '-' && c != ' ' && c != '_' || cArray[n2] == '_')) {
                bl = true;
                continue;
            }
            boolean bl2 = false;
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && !(bl2 = c >= '0' && c <= '9')) continue;
            if (bl) {
                cArray[n2++] = 95;
                bl = false;
            }
            cArray[n2++] = bl2 ? c : (char)(c & 0x5F);
        }
        return new String(cArray, 0, n2);
    }

    private static String normalizeName(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
            string = string.substring("minecraft:".length());
        }
        string = string.replace('.', '_');
        return string;
    }

    private XForm std(BukkitForm BukkitForm) {
        return this.std(null, BukkitForm);
    }

    private XForm std(@Nullable String string, BukkitForm BukkitForm) {
        String[] stringArray;
        XBase xBase = (XBase)this.bukkitToX.get(BukkitForm);
        if (xBase != null) {
            return (XForm)xBase;
        }
        String string2 = XRegistry.getBukkitName(BukkitForm);
        if (this.getBukkit(new String[]{string2}) == null && string == null) {
            throw new IllegalArgumentException("Unknown standard bukkit form for " + this.registryName + ": " + BukkitForm + (BukkitForm.toString().equals(string2) ? "" : " (" + string2 + ')'));
        }
        if (string == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string;
            stringArray = stringArray3;
            stringArray3[1] = string2;
        }
        xBase = (XBase)this.creator.apply(BukkitForm, stringArray);
        if (!PERFORM_AUTO_ADD) {
            return (XForm)xBase;
        }
        this.registerName(string2, xBase);
        if (string != null) {
            this.registerName(string, xBase);
        }
        this.bukkitToX.put(BukkitForm, xBase);
        return (XForm)xBase;
    }

    public XForm std(String[] stringArray) {
        BukkitForm BukkitForm = this.getBukkit(stringArray);
        XBase xBase = (XBase)this.creator.apply(BukkitForm, stringArray);
        return (XForm)this.std((XForm)xBase);
    }

    public BukkitForm stdEnum(XForm XForm, String[] stringArray) {
        String string = XForm.name();
        boolean bl = false;
        BukkitForm BukkitForm = this.getBukkit(new String[]{string});
        if (BukkitForm == null) {
            BukkitForm = this.getBukkit(stringArray);
        }
        if (BukkitForm == null) {
            BukkitForm = this.registerMerged(XForm);
            bl = true;
        }
        return this.stdEnum0(XForm, stringArray, BukkitForm, bl);
    }

    public BukkitForm stdEnum(XForm XForm, String[] stringArray, BukkitForm BukkitForm) {
        return this.stdEnum0(XForm, stringArray, BukkitForm, false);
    }

    private BukkitForm stdEnum0(XForm XForm, String[] stringArray, BukkitForm BukkitForm, boolean bl) {
        String string = XForm.name();
        if (!bl) {
            this.registerMerged(XForm);
        }
        this.registerName(string, XForm);
        for (String string2 : stringArray) {
            this.registerName(string2, XForm);
        }
        if (BukkitForm != null) {
            this.bukkitToX.put(BukkitForm, XForm);
        }
        return BukkitForm;
    }

    private BukkitForm registerMerged(XForm XForm) {
        Field field;
        try {
            field = XForm.getClass().getDeclaredField(XForm.name());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("Cannot find field for XForm: " + XForm, noSuchFieldException);
        }
        return this.registerMerged(XForm, field);
    }

    private BukkitForm registerMerged(XForm XForm, Field field) {
        XMerge[] xMergeArray = (XMerge[])field.getAnnotationsByType(XMerge.class);
        Object k = null;
        for (XMerge xMerge : xMergeArray) {
            k = this.getBukkit(new String[]{xMerge.name()});
            this.registerName(xMerge.name(), XForm);
            if (k == null) continue;
            this.bukkitToX.put(k, XForm);
        }
        return (BukkitForm)k;
    }

    public XForm std(Function<BukkitForm, XForm> function, String[] stringArray) {
        BukkitForm BukkitForm = this.getBukkit(stringArray);
        return (XForm)this.std((XForm)((XBase)function.apply(BukkitForm)));
    }

    public XForm std(Function<BukkitForm, XForm> function, XForm XForm, String[] stringArray) {
        BukkitForm BukkitForm = this.getBukkit(stringArray);
        if (BukkitForm == null) {
            BukkitForm = XForm.get();
        }
        return (XForm)this.std((XForm)((XBase)function.apply(BukkitForm)));
    }

    public XForm std(XForm XForm) {
        for (String string : XForm.getNames()) {
            this.registerName(string, XForm);
        }
        if (XForm.isSupported()) {
            this.bukkitToX.put(XForm.get(), XForm);
        }
        return XForm;
    }

    public String toString() {
        return "XRegistry<" + this.registryName + ">(nameMappings=" + this.nameMappings.size() + ", bukkitToX=" + this.bukkitToX.size() + ", bukkitFormClass=" + this.bukkitFormClass.getName() + ", xFormClass=" + this.xFormClass.getName() + ", supportsRegistry=" + this.supportsRegistry + ", bukkitFormClassType=" + (Object)((Object)this.bukkitClassType) + ", pulled=" + this.pulled + ", values=[" + this.bukkitToX.values().stream().limit(10L).map(XBase::name).collect(Collectors.joining(", ")) + ']' + ')';
    }

    static {
        boolean bl = false;
        try {
            Class.forName("org.bukkit.Keyed");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        KEYED_EXISTS = bl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/cryptomorin/xseries/advancedcrates/base/XRegistry";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bukkitForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nameMapping";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "bukkitMapping";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "bukkitRegistry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getByBukkitForm";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/cryptomorin/xseries/advancedcrates/base/XRegistry";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBukkitName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBukkitName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ClassType {
        ENUM,
        ABSTRACTION;

    }
}

