/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.advancedcrates;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.PM2.AdvancedCrates.utils.ReflectionUtils;
import me.PM2.AdvancedCrates.utils.SkullCreator;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullUtils {
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_GETTER;
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_SETTER;
    protected static final MethodHandle CRAFT_META_SKULL_BLOCK_SETTER;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String INVALID_BASE64 = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzEwNTkxZTY5MDllNmEyODFiMzcxODM2ZTQ2MmQ2N2EyYzc4ZmEwOTUyZTkxMGYzMmI0MWEyNmM0OGMxNzU3YyJ9fX0=";
    private static final Pattern MOJANG_SHA256_APPROX;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";
    private static final boolean USES_RESOLVABLE_PROFILE;
    private static final boolean HAS_PLAYER_PROFILE_API;
    private static Class<?> playerProfileClass;
    private static Class<?> playerTexturesClass;
    private static Method createPlayerProfileMethod;
    private static Method getTexturesMethod;
    private static Method setSkinMethod;
    private static Method setTexturesMethod;
    private static Method setOwnerProfileMethod;
    private static Method getOwnerProfileMethod;
    private static Method getSkinMethod;

    @Nonnull
    public static ItemMeta getSkull(@Nonnull UUID uUID, ItemMeta itemMeta) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (SUPPORTS_UUID) {
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uUID));
        } else {
            skullMeta.setOwner(Bukkit.getOfflinePlayer((UUID)uUID).getName());
        }
        return skullMeta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull OfflinePlayer offlinePlayer) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (SUPPORTS_UUID) {
            skullMeta.setOwningPlayer(offlinePlayer);
        } else {
            skullMeta.setOwner(offlinePlayer.getName());
        }
        return skullMeta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull UUID uUID) {
        return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((UUID)uUID));
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull String string) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        switch (SkullUtils.detectSkullValueType(string).ordinal()) {
            case 1: {
                return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((UUID)UUID.fromString(string)));
            }
            case 0: {
                return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((String)string));
            }
            case 2: {
                return SkullCreator.mutateSkullMeta(skullMeta, string);
            }
            case 3: {
                return SkullUtils.setSkullBase64(skullMeta, SkullUtils.encodeTexturesURL(string));
            }
            case 4: {
                return SkullUtils.setSkullBase64(skullMeta, SkullUtils.encodeTexturesURL(TEXTURES + string));
            }
            case 5: {
                return SkullUtils.setSkullBase64(skullMeta, INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @Nonnull
    protected static SkullMeta setSkullBase64(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        URL uRL;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Skull value cannot be null or empty");
        }
        if (HAS_PLAYER_PROFILE_API) {
            try {
                uRL = SkullUtils.extractSkinUrl(string);
                if (uRL != null) {
                    UUID uUID = UUID.nameUUIDFromBytes(string.getBytes());
                    Object object = createPlayerProfileMethod.invoke(null, uUID, "Player");
                    Object object2 = getTexturesMethod.invoke(object, new Object[0]);
                    setSkinMethod.invoke(object2, uRL);
                    setTexturesMethod.invoke(object, object2);
                    setOwnerProfileMethod.invoke((Object)skullMeta, object);
                    return skullMeta;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (USES_RESOLVABLE_PROFILE) {
            return SkullCreator.mutateSkullMeta(skullMeta, string);
        }
        uRL = SkullUtils.profileFromBase64(string);
        try {
            if (CRAFT_META_SKULL_PROFILE_SETTER != null) {
                CRAFT_META_SKULL_PROFILE_SETTER.invoke(skullMeta, (GameProfile)uRL);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return skullMeta;
    }

    @Nullable
    private static URL extractSkinUrl(String string) {
        try {
            String string2 = new String(Base64.getDecoder().decode(string));
            int n = string2.indexOf("\"SKIN\"");
            if (n < 0) {
                return null;
            }
            int n2 = string2.indexOf("\"url\"", n);
            if (n2 < 0) {
                return null;
            }
            int n3 = string2.indexOf(58, n2);
            if (n3 < 0) {
                return null;
            }
            int n4 = string2.indexOf(34, n3 + 1);
            int n5 = string2.indexOf(34, n4 + 1);
            if (n4 < 0 || n5 < 0) {
                return null;
            }
            String string3 = string2.substring(n4 + 1, n5);
            if (string3.startsWith("http://textures.minecraft.net")) {
                string3 = string3.replace("http://", "https://");
            }
            return new URL(string3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nonnull
    public static GameProfile profileFromBase64(String string) {
        GameProfile gameProfile = new GameProfile(UUID.fromString("86bfd9c3-77f3-4a92-8762-e940aa96e28b"), "PM2");
        try {
            Class<?> clazz = Class.forName("com.mojang.authlib.properties.Property");
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
            Object obj = constructor.newInstance("textures", string);
            Method method = GameProfile.class.getMethod("getProperties", new Class[0]);
            Object object = method.invoke((Object)gameProfile, new Object[0]);
            Method method2 = object.getClass().getMethod("put", Object.class, Object.class);
            method2.invoke(object, "textures", obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return gameProfile;
    }

    @Nonnull
    public static GameProfile profileFromPlayer(OfflinePlayer offlinePlayer) {
        return new GameProfile(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    @Nonnull
    public static GameProfile detectProfileFromString(String string) {
        switch (SkullUtils.detectSkullValueType(string).ordinal()) {
            case 1: {
                return new GameProfile(UUID.fromString(string), null);
            }
            case 0: {
                return new GameProfile(null, string);
            }
            case 2: {
                return SkullUtils.profileFromBase64(string);
            }
            case 3: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(string));
            }
            case 4: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(TEXTURES + string));
            }
            case 5: {
                return SkullUtils.profileFromBase64(INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    public static ValueType detectSkullValueType(String string) {
        if (string == null) {
            return ValueType.UNKNOWN;
        }
        try {
            UUID.fromString(string);
            return ValueType.UUID;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (SkullUtils.isUsername(string)) {
                return ValueType.NAME;
            }
            if (string.contains("textures.minecraft.net")) {
                return ValueType.TEXTURE_URL;
            }
            if (string.length() > 100 && SkullUtils.isBase64(string)) {
                return ValueType.BASE64;
            }
            if (MOJANG_SHA256_APPROX.matcher(string).matches()) {
                return ValueType.TEXTURE_HASH;
            }
            return ValueType.UNKNOWN;
        }
    }

    public static void setSkin(@Nonnull Block block, @Nonnull String string) {
        Object object;
        Object object2;
        Skull skull;
        block20: {
            Objects.requireNonNull(block, "Can't set skin of null block");
            BlockState blockState = block.getState();
            if (!(blockState instanceof Skull)) {
                return;
            }
            skull = (Skull)blockState;
            if (HAS_PLAYER_PROFILE_API) {
                try {
                    object2 = null;
                    object = SkullUtils.detectSkullValueType(string);
                    if (object == ValueType.BASE64) {
                        object2 = SkullUtils.extractSkinUrl(string);
                    } else if (object == ValueType.TEXTURE_URL) {
                        object2 = new URL(string);
                    } else if (object == ValueType.TEXTURE_HASH) {
                        object2 = new URL(TEXTURES + string);
                    }
                    if (object2 == null) break block20;
                    UUID uUID = UUID.nameUUIDFromBytes(string.getBytes());
                    Object object3 = createPlayerProfileMethod.invoke(null, uUID, "Player");
                    Object object4 = getTexturesMethod.invoke(object3, new Object[0]);
                    setSkinMethod.invoke(object4, object2);
                    setTexturesMethod.invoke(object3, object4);
                    Method method = null;
                    try {
                        method = skull.getClass().getMethod("setOwnerProfile", playerProfileClass);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            method = skull.getClass().getMethod("setPlayerProfile", playerProfileClass);
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            // empty catch block
                        }
                    }
                    if (method != null) {
                        method.invoke((Object)skull, object3);
                        skull.update(true);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        object2 = SkullUtils.detectProfileFromString(string);
        try {
            if (USES_RESOLVABLE_PROFILE) {
                object = SkullUtils.makeResolvableProfile(object2);
                if (CRAFT_META_SKULL_BLOCK_SETTER != null) {
                    CRAFT_META_SKULL_BLOCK_SETTER.invoke(skull, object);
                }
            } else if (CRAFT_META_SKULL_BLOCK_SETTER != null) {
                CRAFT_META_SKULL_BLOCK_SETTER.invoke(skull, (GameProfile)object2);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error while setting block skin with value: " + string, throwable);
        }
        skull.update(true);
    }

    private static Object makeResolvableProfile(GameProfile gameProfile) {
        Class<?> clazz = Class.forName("net.minecraft.world.item.component.ResolvableProfile");
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != 1 || !classArray[0].getName().equals("com.mojang.authlib.GameProfile")) continue;
            constructor.setAccessible(true);
            return constructor.newInstance(gameProfile);
        }
        try {
            Method method = GameProfile.class.getMethod("getProperties", new Class[0]);
            Object object = method.invoke((Object)gameProfile, new Object[0]);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 3 || !classArray[0].equals(Optional.class) || !classArray[1].equals(Optional.class)) continue;
                constructor.setAccessible(true);
                return constructor.newInstance(Optional.ofNullable(gameProfile.getId()), Optional.ofNullable(gameProfile.getName()), object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalStateException("Could not create ResolvableProfile");
    }

    public static String encodeTexturesURL(String string) {
        return SkullUtils.encodeBase64(VALUE_PROPERTY + string + "\"}}}");
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    private static boolean isBase64(@Nonnull String string) {
        try {
            Base64.getDecoder().decode(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Nullable
    public static String getSkinValue(@Nonnull ItemMeta itemMeta) {
        block31: {
            if (!(itemMeta instanceof SkullMeta)) {
                return null;
            }
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            try {
                Object object;
                Method method;
                Object object2;
                Object object3;
                Object object4;
                if (HAS_PLAYER_PROFILE_API) {
                    try {
                        object4 = getOwnerProfileMethod.invoke((Object)skullMeta, new Object[0]);
                        if (object4 != null && (object3 = (URL)getSkinMethod.invoke(object2 = getTexturesMethod.invoke(object4, new Object[0]), new Object[0])) != null) {
                            String string = VALUE_PROPERTY + ((URL)object3).toString() + "\"}}}";
                            return Base64.getEncoder().encodeToString(string.getBytes());
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                object4 = null;
                try {
                    object4 = skullMeta.getClass().getDeclaredField("profile");
                    ((Field)object4).setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    for (Field object5 : skullMeta.getClass().getDeclaredFields()) {
                        String string = object5.getType().getName();
                        if (!string.equals("com.mojang.authlib.GameProfile") && !string.equals("net.minecraft.world.item.component.ResolvableProfile")) continue;
                        object5.setAccessible(true);
                        object4 = object5;
                        break;
                    }
                }
                if (object4 == null) {
                    return null;
                }
                object2 = ((Field)object4).get(skullMeta);
                if (object2 == null) {
                    return null;
                }
                if (object2.getClass().getName().equals("net.minecraft.world.item.component.ResolvableProfile")) {
                    try {
                        object3 = object2.getClass().getMethod("gameProfile", new Class[0]);
                        object2 = ((Method)object3).invoke(object2, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Field[] fieldArray = object2.getClass().getDeclaredFields();
                        int n = fieldArray.length;
                        boolean bl = false;
                        while (noSuchFieldException < n) {
                            Field field = fieldArray[noSuchFieldException];
                            if (field.getType().getName().equals("com.mojang.authlib.GameProfile")) {
                                field.setAccessible(true);
                                object2 = field.get(object2);
                                break;
                            }
                            ++noSuchFieldException;
                        }
                    }
                }
                if (object2 == null) break block31;
                object3 = null;
                try {
                    method = object2.getClass().getMethod("getProperties", new Class[0]);
                    object3 = method.invoke(object2, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Method method2 = object2.getClass().getMethod("properties", new Class[0]);
                        object3 = method2.invoke(object2, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            Field field = object2.getClass().getDeclaredField("properties");
                            field.setAccessible(true);
                            object3 = field.get(object2);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                }
                if (object3 != null && (object = (method = object3.getClass().getMethod("get", Object.class)).invoke(object3, "textures")) instanceof Iterable) {
                    for (Object t : (Iterable)object) {
                        try {
                            Method method2 = t.getClass().getMethod("getValue", new Class[0]);
                            return (String)method2.invoke(t, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            try {
                                Method method3 = t.getClass().getMethod("value", new Class[0]);
                                return (String)method3.invoke(t, new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException2) {
                                try {
                                    Field field = t.getClass().getDeclaredField("value");
                                    field.setAccessible(true);
                                    return (String)field.get(t);
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static String getBase64Texture(Player player) {
        try {
            Method method2 = player.getClass().getMethod("getProfile", new Class[0]);
            Object object = method2.invoke((Object)player, new Object[0]);
            if (object != null) {
                Method method3 = object.getClass().getMethod("getProperties", new Class[0]);
                Object object2 = method3.invoke(object, new Object[0]);
                Method method4 = object2.getClass().getMethod("containsKey", Object.class);
                boolean bl = (Boolean)method4.invoke(object2, "textures");
                if (bl) {
                    Method method5 = object2.getClass().getMethod("get", Object.class);
                    Object object3 = method5.invoke(object2, "textures");
                    Method method6 = object3.getClass().getMethod("iterator", new Class[0]);
                    Object object4 = method6.invoke(object3, new Object[0]);
                    Method method7 = object4.getClass().getMethod("hasNext", new Class[0]);
                    boolean bl2 = (Boolean)method7.invoke(object4, new Object[0]);
                    if (bl2) {
                        Method method8 = object4.getClass().getMethod("next", new Class[0]);
                        Object object5 = method8.invoke(object4, new Object[0]);
                        Method method9 = null;
                        try {
                            method9 = object5.getClass().getMethod("getValue", new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            method9 = Arrays.stream(object5.getClass().getDeclaredMethods()).filter(method -> method.getName().equalsIgnoreCase("value")).findFirst().orElse(null);
                        }
                        if (method9 != null) {
                            String string = (String)method9.invoke(object5, new Object[0]);
                            return string;
                        }
                    }
                }
            }
            return "ewogICJ0aW1lc3RhbXAiIDogMTcwOTg1MjYyNDc3MiwKICAicHJvZmlsZUlkIiA6ICI4NmJmZDljMzc3ZjM0YTkyODc2MmU5NDBhYTk2ZTI4YiIsCiAgInByb2ZpbGVOYW1lIiA6ICJQTTIiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjhhY2I3ZjNkNDU2NzZlNmNlZjQwZGZmODY2YTJmMWZmMjM0MjFhMTJkOTQ1NjEwZDEyZDBmNWQ3YTRmYmU0MSIKICAgIH0KICB9Cn0=";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isUsername(@Nonnull String string) {
        int n = string.length();
        if (n > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)string).iterator();
        while (unmodifiableIterator.hasNext()) {
            char c = ((Character)unmodifiableIterator.next()).charValue();
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        Field field;
        Class<?> clazz;
        SUPPORTS_UUID = MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_12_R1);
        MOJANG_SHA256_APPROX = Pattern.compile("[0-9a-z]{60,70}");
        boolean bl = false;
        try {
            Class.forName("net.minecraft.world.item.component.ResolvableProfile");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USES_RESOLVABLE_PROFILE = bl;
        boolean bl2 = false;
        try {
            playerProfileClass = Class.forName("org.bukkit.profile.PlayerProfile");
            playerTexturesClass = Class.forName("org.bukkit.profile.PlayerTextures");
            createPlayerProfileMethod = Bukkit.class.getMethod("createPlayerProfile", UUID.class, String.class);
            getTexturesMethod = playerProfileClass.getMethod("getTextures", new Class[0]);
            setTexturesMethod = playerProfileClass.getMethod("setTextures", playerTexturesClass);
            setSkinMethod = playerTexturesClass.getMethod("setSkin", URL.class);
            getSkinMethod = playerTexturesClass.getMethod("getSkin", new Class[0]);
            try {
                setOwnerProfileMethod = SkullMeta.class.getMethod("setOwnerProfile", playerProfileClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    setOwnerProfileMethod = SkullMeta.class.getMethod("setPlayerProfile", playerProfileClass);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            try {
                getOwnerProfileMethod = SkullMeta.class.getMethod("getOwnerProfile", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    getOwnerProfileMethod = SkullMeta.class.getMethod("getPlayerProfile", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    // empty catch block
                }
            }
            bl2 = setOwnerProfileMethod != null && getOwnerProfileMethod != null;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        HAS_PLAYER_PROFILE_API = bl2;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        try {
            clazz = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            field = clazz.getDeclaredField("profile");
            field.setAccessible(true);
            methodHandle2 = lookup.unreflectGetter(field);
            try {
                Method method = clazz.getDeclaredMethod("setProfile", GameProfile.class);
                method.setAccessible(true);
                methodHandle = lookup.unreflect(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!USES_RESOLVABLE_PROFILE) {
                    methodHandle = lookup.unreflectSetter(field);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        try {
            clazz = ReflectionUtils.getCraftClass("block.CraftSkull");
            field = clazz.getDeclaredField("profile");
            field.setAccessible(true);
            methodHandle3 = lookup.unreflectSetter(field);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        CRAFT_META_SKULL_PROFILE_SETTER = methodHandle;
        CRAFT_META_SKULL_PROFILE_GETTER = methodHandle2;
        CRAFT_META_SKULL_BLOCK_SETTER = methodHandle3;
    }

    public static enum ValueType {
        NAME,
        UUID,
        BASE64,
        TEXTURE_URL,
        TEXTURE_HASH,
        UNKNOWN;

    }
}

