/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.v1_21_9to1_21_11.rewriter;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.data.AttackRange;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_21_5;
import com.viaversion.viaversion.protocols.v1_21_4to1_21_5.rewriter.RecipeDisplayRewriter1_21_5;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPacket1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ServerboundPacket1_21_9;
import com.viaversion.viaversion.protocols.v1_21_9to1_21_11.Protocol1_21_9To1_21_11;
import com.viaversion.viaversion.protocols.v1_21_9to1_21_11.storage.GameTimeStorage;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.rewriter.StructuredItemRewriter;

public final class BlockItemPacketRewriter1_21_11
extends StructuredItemRewriter<ClientboundPacket1_21_9, ServerboundPacket1_21_9, Protocol1_21_9To1_21_11> {
    public BlockItemPacketRewriter1_21_11(Protocol1_21_9To1_21_11 protocol) {
        super(protocol);
    }

    @Override
    public void registerPackets() {
        BlockRewriter<ClientboundPackets1_21_9> blockRewriter = BlockRewriter.for1_20_2(this.protocol);
        blockRewriter.registerBlockEvent(ClientboundPackets1_21_9.BLOCK_EVENT);
        blockRewriter.registerBlockUpdate(ClientboundPackets1_21_9.BLOCK_UPDATE);
        blockRewriter.registerSectionBlocksUpdate1_20(ClientboundPackets1_21_9.SECTION_BLOCKS_UPDATE);
        blockRewriter.registerLevelEvent1_21(ClientboundPackets1_21_9.LEVEL_EVENT, 2001);
        blockRewriter.registerLevelChunk1_19(ClientboundPackets1_21_9.LEVEL_CHUNK_WITH_LIGHT, ChunkType1_21_5::new);
        blockRewriter.registerBlockEntityData(ClientboundPackets1_21_9.BLOCK_ENTITY_DATA);
        this.registerSetCursorItem(ClientboundPackets1_21_9.SET_CURSOR_ITEM);
        this.registerSetPlayerInventory(ClientboundPackets1_21_9.SET_PLAYER_INVENTORY);
        this.registerCooldown1_21_2(ClientboundPackets1_21_9.COOLDOWN);
        this.registerSetContent1_21_2(ClientboundPackets1_21_9.CONTAINER_SET_CONTENT);
        this.registerSetSlot1_21_2(ClientboundPackets1_21_9.CONTAINER_SET_SLOT);
        this.registerAdvancements1_20_3(ClientboundPackets1_21_9.UPDATE_ADVANCEMENTS);
        this.registerSetEquipment(ClientboundPackets1_21_9.SET_EQUIPMENT);
        this.registerMerchantOffers1_20_5(ClientboundPackets1_21_9.MERCHANT_OFFERS);
        this.registerContainerClick1_21_5(ServerboundPackets1_21_6.CONTAINER_CLICK);
        this.registerSetCreativeModeSlot1_21_5(ServerboundPackets1_21_6.SET_CREATIVE_MODE_SLOT);
        RecipeDisplayRewriter1_21_5<ClientboundPackets1_21_9> recipeRewriter = new RecipeDisplayRewriter1_21_5<ClientboundPackets1_21_9>(this.protocol);
        recipeRewriter.registerUpdateRecipes(ClientboundPackets1_21_9.UPDATE_RECIPES);
        recipeRewriter.registerRecipeBookAdd(ClientboundPackets1_21_9.RECIPE_BOOK_ADD);
        recipeRewriter.registerPlaceGhostRecipe(ClientboundPackets1_21_9.PLACE_GHOST_RECIPE);
        ((Protocol1_21_9To1_21_11)this.protocol).registerClientbound(ClientboundPackets1_21_9.SET_BORDER_LERP_SIZE, wrapper -> {
            wrapper.passthrough(Types.DOUBLE);
            wrapper.passthrough(Types.DOUBLE);
            wrapper.write(Types.VAR_LONG, wrapper.read(Types.VAR_LONG) / 50L);
        });
        ((Protocol1_21_9To1_21_11)this.protocol).registerClientbound(ClientboundPackets1_21_9.INITIALIZE_BORDER, wrapper -> {
            wrapper.passthrough(Types.DOUBLE);
            wrapper.passthrough(Types.DOUBLE);
            wrapper.passthrough(Types.DOUBLE);
            wrapper.passthrough(Types.DOUBLE);
            wrapper.write(Types.VAR_LONG, wrapper.read(Types.VAR_LONG) / 50L);
        });
        ((Protocol1_21_9To1_21_11)this.protocol).registerClientbound(ClientboundPackets1_21_9.SET_TIME, wrapper -> {
            long gameTime = wrapper.passthrough(Types.LONG);
            wrapper.user().get(GameTimeStorage.class).setGameTime(gameTime);
        });
        ((Protocol1_21_9To1_21_11)this.protocol).registerServerbound(ServerboundPackets1_21_6.CLIENT_TICK_END, wrapper -> wrapper.user().get(GameTimeStorage.class).incrementGameTime());
    }

    @Override
    protected void handleItemDataComponentsToClient(UserConnection connection, Item item, StructuredDataContainer container) {
        BlockItemPacketRewriter1_21_11.upgradeData(item, container);
        this.appendItemDataFixComponents(connection, item);
        super.handleItemDataComponentsToClient(connection, item, container);
    }

    @Override
    protected void handleItemDataComponentsToServer(UserConnection connection, Item item, StructuredDataContainer container) {
        BlockItemPacketRewriter1_21_11.downgradeData(item, container);
        super.handleItemDataComponentsToServer(connection, item, container);
    }

    private void appendItemDataFixComponents(UserConnection connection, Item item) {
        ProtocolVersion serverVersion = connection.getProtocolInfo().serverProtocolVersion();
        if (Via.getConfig().use1_8HitboxMargin() && serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_8)) {
            item.dataContainer().set(StructuredDataKey.ATTACK_RANGE, new AttackRange(0.0f, 3.0f, 0.0f, 4.0f, 0.1f, 1.0f));
        }
    }

    public static void upgradeData(Item item, StructuredDataContainer container) {
    }

    public static void downgradeData(Item item, StructuredDataContainer container) {
        container.remove(StructuredDataKey.SWING_ANIMATION);
        container.remove(StructuredDataKey.KINETIC_WEAPON);
        container.remove(StructuredDataKey.PIERCING_WEAPON);
        container.remove(StructuredDataKey.DAMAGE_TYPE);
        container.remove(StructuredDataKey.MINIMUM_ATTACK_CHARGE);
        container.remove(StructuredDataKey.USE_EFFECTS);
        container.remove(StructuredDataKey.ZOMBIE_NAUTILUS_VARIANT);
        container.remove(StructuredDataKey.ATTACK_RANGE);
    }
}

