/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.type.OptionalType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public record KineticWeapon(int contactCooldownTicks, int delayTicks, @Nullable Condition dismountConditions, @Nullable Condition knockbackConditions, @Nullable Condition damageConditions, float forwardMovement, float damageMultiplier, @Nullable Holder<SoundEvent> sound, @Nullable Holder<SoundEvent> hitSound) {
    public static final Type<KineticWeapon> TYPE = new Type<KineticWeapon>(KineticWeapon.class){

        @Override
        public KineticWeapon read(ByteBuf buffer) {
            int contactCooldownTicks = Types.VAR_INT.readPrimitive(buffer);
            int delayTicks = Types.VAR_INT.readPrimitive(buffer);
            Condition dismountConditions = (Condition)Condition.OPTIONAL_TYPE.read(buffer);
            Condition knockbackConditions = (Condition)Condition.OPTIONAL_TYPE.read(buffer);
            Condition damageConditions = (Condition)Condition.OPTIONAL_TYPE.read(buffer);
            float forwardMovement = Types.FLOAT.readPrimitive(buffer);
            float damageMultiplier = Types.FLOAT.readPrimitive(buffer);
            Object sound = Types.OPTIONAL_SOUND_EVENT.read(buffer);
            Object hitSound = Types.OPTIONAL_SOUND_EVENT.read(buffer);
            return new KineticWeapon(contactCooldownTicks, delayTicks, dismountConditions, knockbackConditions, damageConditions, forwardMovement, damageMultiplier, (Holder<SoundEvent>)sound, (Holder<SoundEvent>)hitSound);
        }

        @Override
        public void write(ByteBuf buffer, KineticWeapon value) {
            Types.VAR_INT.writePrimitive(buffer, value.contactCooldownTicks);
            Types.VAR_INT.writePrimitive(buffer, value.delayTicks);
            Condition.OPTIONAL_TYPE.write(buffer, value.dismountConditions);
            Condition.OPTIONAL_TYPE.write(buffer, value.knockbackConditions);
            Condition.OPTIONAL_TYPE.write(buffer, value.damageConditions);
            Types.FLOAT.writePrimitive(buffer, value.forwardMovement);
            Types.FLOAT.writePrimitive(buffer, value.damageMultiplier);
            Types.OPTIONAL_SOUND_EVENT.write(buffer, value.sound);
            Types.OPTIONAL_SOUND_EVENT.write(buffer, value.hitSound);
        }

        @Override
        public void write(Ops ops, KineticWeapon value) {
            ops.writeMap(map -> map.writeOptional("contact_cooldown_ticks", Types.INT, value.contactCooldownTicks, 10).writeOptional("delay_ticks", Types.INT, value.delayTicks, 0).writeOptional("dismount_conditions", Condition.TYPE, value.dismountConditions).writeOptional("knockback_conditions", Condition.TYPE, value.knockbackConditions).writeOptional("damage_conditions", Condition.TYPE, value.damageConditions).writeOptional("forward_movement", Types.FLOAT, Float.valueOf(value.forwardMovement), Float.valueOf(0.0f)).writeOptional("damage_multiplier", Types.FLOAT, Float.valueOf(value.damageMultiplier), Float.valueOf(1.0f)).writeOptional("sound", Types.SOUND_EVENT, value.sound).writeOptional("hit_sound", Types.SOUND_EVENT, value.hitSound));
        }
    };

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static final Type<Condition> TYPE = new Type<Condition>(Condition.class){

            @Override
            public Condition read(ByteBuf buffer) {
                int maxDurationTicks = Types.VAR_INT.readPrimitive(buffer);
                float minSpeed = Types.FLOAT.readPrimitive(buffer);
                float minRelativeSpeed = Types.FLOAT.readPrimitive(buffer);
                return new Condition(maxDurationTicks, minSpeed, minRelativeSpeed);
            }

            @Override
            public void write(ByteBuf buffer, Condition value) {
                Types.VAR_INT.writePrimitive(buffer, value.maxDurationTicks);
                Types.FLOAT.writePrimitive(buffer, value.minSpeed);
                Types.FLOAT.writePrimitive(buffer, value.minRelativeSpeed);
            }

            @Override
            public void write(Ops ops, Condition value) {
                ops.writeMap(map -> map.write("max_duration_ticks", Types.INT, value.maxDurationTicks).writeOptional("min_speed", Types.FLOAT, Float.valueOf(value.minSpeed), Float.valueOf(0.0f)).writeOptional("min_relative_speed", Types.FLOAT, Float.valueOf(value.minRelativeSpeed), Float.valueOf(0.0f)));
            }
        };
        public static final Type<Condition> OPTIONAL_TYPE = new OptionalType<Condition>(TYPE){};
    }
}

