/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.util.Copyable;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.Rewritable;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public record AttributeModifiers1_21(AttributeModifier[] modifiers, boolean showInTooltip) implements Copyable,
Rewritable
{
    public static final Type<AttributeModifiers1_21> TYPE1_21 = new Type<AttributeModifiers1_21>(AttributeModifiers1_21.class){

        @Override
        public AttributeModifiers1_21 read(ByteBuf buffer) {
            AttributeModifier[] modifiers = (AttributeModifier[])AttributeModifier.ARRAY_TYPE1_21.read(buffer);
            boolean showInTooltip = buffer.readBoolean();
            return new AttributeModifiers1_21(modifiers, showInTooltip);
        }

        @Override
        public void write(ByteBuf buffer, AttributeModifiers1_21 value) {
            AttributeModifier.ARRAY_TYPE1_21.write(buffer, value.modifiers());
            buffer.writeBoolean(value.showInTooltip());
        }
    };
    public static final Type<AttributeModifiers1_21> TYPE1_21_5 = new Type<AttributeModifiers1_21>(AttributeModifiers1_21.class){

        @Override
        public AttributeModifiers1_21 read(ByteBuf buffer) {
            AttributeModifier[] modifiers = (AttributeModifier[])AttributeModifier.ARRAY_TYPE1_21.read(buffer);
            return new AttributeModifiers1_21(modifiers);
        }

        @Override
        public void write(ByteBuf buffer, AttributeModifiers1_21 value) {
            AttributeModifier.ARRAY_TYPE1_21.write(buffer, value.modifiers());
        }

        @Override
        public void write(Ops ops, AttributeModifiers1_21 value) {
            ops.write(AttributeModifier.ARRAY_TYPE1_21, value.modifiers);
        }
    };
    public static final Type<AttributeModifiers1_21> TYPE1_21_6 = new Type<AttributeModifiers1_21>(AttributeModifiers1_21.class){

        @Override
        public AttributeModifiers1_21 read(ByteBuf buffer) {
            AttributeModifier[] modifiers = (AttributeModifier[])AttributeModifier.ARRAY_TYPE1_21_6.read(buffer);
            return new AttributeModifiers1_21(modifiers);
        }

        @Override
        public void write(ByteBuf buffer, AttributeModifiers1_21 value) {
            AttributeModifier.ARRAY_TYPE1_21_6.write(buffer, value.modifiers());
        }

        @Override
        public void write(Ops ops, AttributeModifiers1_21 value) {
            ops.write(AttributeModifier.ARRAY_TYPE1_21_6, value.modifiers);
        }
    };

    public AttributeModifiers1_21(AttributeModifier[] modifiers) {
        this(modifiers, true);
    }

    public AttributeModifiers1_21 rewrite(Int2IntFunction rewriteFunction) {
        AttributeModifier[] modifiers = new AttributeModifier[this.modifiers.length];
        for (int i = 0; i < this.modifiers.length; ++i) {
            AttributeModifier modifier = this.modifiers[i];
            modifiers[i] = new AttributeModifier(rewriteFunction.applyAsInt(modifier.attribute()), modifier.modifier(), modifier.slotType(), modifier.display());
        }
        return new AttributeModifiers1_21(modifiers, this.showInTooltip);
    }

    @Override
    public AttributeModifiers1_21 copy() {
        return new AttributeModifiers1_21(Copyable.copy(this.modifiers), this.showInTooltip);
    }

    @Override
    public AttributeModifiers1_21 rewrite(UserConnection connection, Protocol<?, ?, ?, ?> protocol, boolean clientbound) {
        FullMappings mappings = protocol.getMappingData().getAttributeMappings();
        if (mappings == null) {
            return this;
        }
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(this.modifiers.length);
        for (AttributeModifier modifier : this.modifiers) {
            int mappedId;
            int n = mappedId = clientbound ? mappings.getNewId(modifier.attribute()) : mappings.inverse().getNewId(modifier.attribute());
            if (mappedId == -1) continue;
            modifiers.add(new AttributeModifier(mappedId, modifier.modifier(), modifier.slotType(), modifier.display()));
        }
        return new AttributeModifiers1_21((AttributeModifier[])modifiers.toArray(AttributeModifier[]::new), this.showInTooltip);
    }

    public record AttributeModifier(int attribute, ModifierData modifier, int slotType, Display display) {
        private static final String[] EQUIPMENT_SLOT_GROUPS = new String[]{"any", "mainhand", "offhand", "hand", "feet", "legs", "chest", "head", "armor", "body", "saddle"};
        private static final String[] OPERATION = new String[]{"add_value", "add_multiplied_base", "add_multiplied_total"};
        public static final Type<AttributeModifier> TYPE1_21 = new Type<AttributeModifier>(AttributeModifier.class){

            @Override
            public AttributeModifier read(ByteBuf buffer) {
                int attribute = Types.VAR_INT.readPrimitive(buffer);
                ModifierData modifier = (ModifierData)ModifierData.TYPE.read(buffer);
                int slot = Types.VAR_INT.readPrimitive(buffer);
                return new AttributeModifier(attribute, modifier, slot);
            }

            @Override
            public void write(ByteBuf buffer, AttributeModifier value) {
                Types.VAR_INT.writePrimitive(buffer, value.attribute);
                ModifierData.TYPE.write(buffer, value.modifier);
                Types.VAR_INT.writePrimitive(buffer, value.slotType);
            }

            @Override
            public void write(Ops ops, AttributeModifier value) {
                Key attribute = ops.context().registryAccess().attributeModifier(value.attribute);
                ops.writeMap(map -> map.write("type", Types.IDENTIFIER, attribute).write("id", Types.IDENTIFIER, Key.of(value.modifier.id())).write("amount", Types.DOUBLE, value.modifier.amount).write("operation", Types.STRING, OPERATION[value.modifier.operation()]).writeOptional("slot", Types.STRING, EQUIPMENT_SLOT_GROUPS[value.slotType()], "any"));
            }
        };
        public static final Type<AttributeModifier[]> ARRAY_TYPE1_21 = new ArrayType<AttributeModifier>(TYPE1_21);
        public static final Type<AttributeModifier> TYPE1_21_6 = new Type<AttributeModifier>(AttributeModifier.class){

            @Override
            public AttributeModifier read(ByteBuf buffer) {
                int attribute = Types.VAR_INT.readPrimitive(buffer);
                ModifierData modifier = (ModifierData)ModifierData.TYPE.read(buffer);
                int slot = Types.VAR_INT.readPrimitive(buffer);
                int displayType = Types.VAR_INT.readPrimitive(buffer);
                Display display = displayType == 2 ? new OverrideText((Tag)Types.TAG.read(buffer)) : new Display(displayType);
                return new AttributeModifier(attribute, modifier, slot, display);
            }

            @Override
            public void write(ByteBuf buffer, AttributeModifier value) {
                Types.VAR_INT.writePrimitive(buffer, value.attribute);
                ModifierData.TYPE.write(buffer, value.modifier);
                Types.VAR_INT.writePrimitive(buffer, value.slotType);
                value.display.write(buffer);
            }

            @Override
            public void write(Ops ops, AttributeModifier value) {
                Key attribute = ops.context().registryAccess().attributeModifier(value.attribute);
                ops.writeMap(map -> {
                    map.write("type", Types.IDENTIFIER, attribute).write("id", Types.IDENTIFIER, Key.of(value.modifier.id())).write("amount", Types.DOUBLE, value.modifier.amount).write("operation", Types.STRING, OPERATION[value.modifier.operation()]).writeOptional("slot", Types.STRING, EQUIPMENT_SLOT_GROUPS[value.slotType()], "any");
                    if (value.display.equals(Display.DEFAULT)) {
                        return;
                    }
                    map.writeMap("display", display -> {
                        display.write("type", Types.STRING, Display.DISPLAY_TYPES[value.display.id()]);
                        Display patt10282$temp = value.display;
                        if (patt10282$temp instanceof OverrideText) {
                            OverrideText overrideText = (OverrideText)patt10282$temp;
                            display.write("value", Types.TEXT_COMPONENT_TAG, overrideText.component);
                        }
                    });
                });
            }
        };
        public static final Type<AttributeModifier[]> ARRAY_TYPE1_21_6 = new ArrayType<AttributeModifier>(TYPE1_21_6);

        public AttributeModifier(int attribute, ModifierData modifier, int slotType) {
            this(attribute, modifier, slotType, Display.DEFAULT);
        }
    }

    public record ModifierData(String id, double amount, int operation) {
        public static final Type<ModifierData> TYPE = new Type<ModifierData>(ModifierData.class){

            @Override
            public ModifierData read(ByteBuf buffer) {
                String id = (String)Types.STRING.read(buffer);
                double amount = buffer.readDouble();
                int operation = Types.VAR_INT.readPrimitive(buffer);
                return new ModifierData(id, amount, operation);
            }

            @Override
            public void write(ByteBuf buffer, ModifierData value) {
                Types.STRING.write(buffer, value.id);
                buffer.writeDouble(value.amount);
                Types.VAR_INT.writePrimitive(buffer, value.operation);
            }
        };
    }

    public static class Display
    implements Copyable {
        public static final String[] DISPLAY_TYPES = new String[]{"default", "hidden", "override_text"};
        public static final Display DEFAULT = new Display(0);
        private final int id;

        public Display(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public void write(ByteBuf buf) {
            Types.VAR_INT.writePrimitive(buf, this.id);
        }

        @Override
        public Display copy() {
            return this;
        }
    }

    public static final class OverrideText
    extends Display {
        public static final int ID = 2;
        private final Tag component;

        public OverrideText(Tag component) {
            super(2);
            this.component = component;
        }

        public Tag component() {
            return this.component;
        }

        @Override
        public void write(ByteBuf buf) {
            super.write(buf);
            Types.TAG.write(buf, this.component);
        }

        @Override
        public OverrideText copy() {
            return new OverrideText(this.component.copy());
        }
    }
}

