/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.data.predicate;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import io.netty.buffer.ByteBuf;

public record DataComponentPredicate(PredicateType type, Tag predicate) {
    public static final Type<DataComponentPredicate> TYPE1_21_5 = new Type<DataComponentPredicate>(DataComponentPredicate.class){

        @Override
        public DataComponentPredicate read(ByteBuf buffer) {
            int id = Types.VAR_INT.readPrimitive(buffer);
            Tag predicate = (Tag)Types.TAG.read(buffer);
            return new DataComponentPredicate(id, predicate);
        }

        @Override
        public void write(ByteBuf buffer, DataComponentPredicate value) {
            Types.VAR_INT.writePrimitive(buffer, value.type().id());
            Types.TAG.write(buffer, value.predicate());
        }
    };
    public static final Type<DataComponentPredicate[]> ARRAY_TYPE1_21_5 = new ArrayType<DataComponentPredicate>(TYPE1_21_5, 64);
    public static final Type<DataComponentPredicate> TYPE1_21_11 = new Type<DataComponentPredicate>(DataComponentPredicate.class){

        @Override
        public DataComponentPredicate read(ByteBuf buffer) {
            boolean isPredicateType = Types.BOOLEAN.read(buffer);
            PredicateType type = new PredicateType(Types.VAR_INT.readPrimitive(buffer), isPredicateType);
            Tag predicate = (Tag)Types.TAG.read(buffer);
            return new DataComponentPredicate(type, predicate);
        }

        @Override
        public void write(ByteBuf buffer, DataComponentPredicate value) {
            Types.BOOLEAN.write(buffer, (Boolean)value.type().isPredicateType());
            Types.VAR_INT.writePrimitive(buffer, value.type().id());
            Types.TAG.write(buffer, value.predicate());
        }
    };
    public static final Type<DataComponentPredicate[]> ARRAY_TYPE1_21_11 = new ArrayType<DataComponentPredicate>(TYPE1_21_11, 64);

    public DataComponentPredicate(int predicateType, Tag predicate) {
        this(PredicateType.ofPredicateType(predicateType), predicate);
    }

    public record PredicateType(int id, boolean isPredicateType) {
        public static PredicateType ofPredicateType(int id) {
            return new PredicateType(id, true);
        }

        public static PredicateType ofDataComponentType(int id) {
            return new PredicateType(id, false);
        }
    }
}

