/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final String currentVersion;
    private String latestVersion;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.checkForUpdate();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("skript-itemsadder.update.check") && this.latestVersion != null && !this.currentVersion.equals(this.latestVersion)) {
            player.sendMessage(" ");
            player.sendRichMessage("<dark_red>[<red>skript-itemsadder<dark_red>] <white>skript-itemsadder is <red><bold>OUTDATED</bold><white>!");
            player.sendRichMessage("<dark_red>[<red>skript-itemsadder<dark_red>] <white>New version: <gold>" + this.latestVersion);
            player.sendRichMessage("<dark_red>[<red>skript-itemsadder<dark_red>] <white>Download <gold><click:open_url:https://github.com/Asleeepp/skript-itemsadder/releases><hover:show_text:'<red>Click here to get the latest version!'>here<white>!</click>");
            player.sendMessage(" ");
        }
    }

    private void checkForUpdate() {
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/asleeepp/skript-itemsadder/releases/latest")).build();
        CompletableFuture<HttpResponse<String>> responseFuture = httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        ((CompletableFuture)((CompletableFuture)responseFuture.thenApply(HttpResponse::body)).thenAccept(body -> {
            JsonObject jsonResponse = (JsonObject)new Gson().fromJson(body, JsonObject.class);
            if (jsonResponse != null && jsonResponse.has("tag_name")) {
                this.latestVersion = jsonResponse.get("tag_name").getAsString();
                if (!this.currentVersion.equals(this.latestVersion)) {
                    SkriptItemsAdder.getInstance().getLogger().warning("An update for skript-itemsadder is available: " + this.latestVersion + " (current version: " + this.currentVersion + ")");
                } else {
                    SkriptItemsAdder.getInstance().getLogger().info("skript-itemsadder is up to date!");
                }
            } else {
                SkriptItemsAdder.getInstance().getLogger().severe("Failed to check for updates: Unexpected JSON format.");
            }
        })).exceptionally(e -> {
            SkriptItemsAdder.getInstance().getLogger().severe("Failed to check for updates: " + e.getMessage());
            return null;
        });
    }
}

