/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import dev.lone.itemsadder.api.FontImages.TexturedInventoryWrapper;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.aliases.CustomItemType;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.Action;
import org.jetbrains.annotations.NotNull;

public class Types {
    public static Map<String, TexturedInventoryWrapper> inventoryMap = new HashMap<String, TexturedInventoryWrapper>();

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(CustomItemType.class, "customitemtype").user(new String[]{"customitemtypes?"}).name("Custom Item Type").description(new String[]{"Represents a custom item type using aliases."}).serializer((Serializer)new Serializer<CustomItemType>(){
            private static final String FIELD_NAME = "namespacedID";

            @NotNull
            public Fields serialize(CustomItemType customItemType) {
                Fields fields = new Fields();
                fields.putObject(FIELD_NAME, (Object)customItemType.getNamespacedID());
                return fields;
            }

            public void deserialize(CustomItemType customItemType, @NotNull Fields fields) {
                try {
                    String namespacedID = (String)fields.getObject(FIELD_NAME);
                    if (namespacedID != null) {
                        customItemType.setNamespacedID(namespacedID);
                    }
                }
                catch (StreamCorruptedException e) {
                    e.printStackTrace();
                }
            }

            @Nullable
            public CustomItemType deserialize(@NotNull Fields fields) {
                try {
                    String namespacedID = (String)fields.getObject(FIELD_NAME);
                    return namespacedID != null ? new CustomItemType(namespacedID) : null;
                }
                catch (StreamCorruptedException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            public boolean canBeInstantiated() {
                return true;
            }
        }).parser((Parser)new Parser<CustomItemType>(){

            @Nullable
            public CustomItemType parse(@NotNull String s, @NotNull ParseContext context) {
                AliasesGenerator aliasesGenerator = SkriptItemsAdder.getInstance().getAliasesGenerator();
                String namespacedID = aliasesGenerator.getNamespacedId(s.toLowerCase().replace("_", " "));
                return namespacedID == null ? null : new CustomItemType(namespacedID);
            }

            @NotNull
            public String toString(CustomItemType customItemType, int flags) {
                return customItemType.getNamespacedID();
            }

            @NotNull
            public String toVariableNameString(CustomItemType customItemType) {
                return customItemType.getNamespacedID();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(TexturedInventoryWrapper.class, "texturedinventorywrapper").user(new String[]{"texturedinventorywrappers?"}).name("Textured Inventory Wrapper").description(new String[]{"Represents a TexturedInventoryWrapper."}).since("1.0").parser((Parser)new Parser<TexturedInventoryWrapper>(){

            public TexturedInventoryWrapper parse(@NotNull String s, @NotNull ParseContext context) {
                return inventoryMap.get(s);
            }

            public String toString(TexturedInventoryWrapper texturedInventoryWrapper, int flags) {
                for (Map.Entry<String, TexturedInventoryWrapper> entry : inventoryMap.entrySet()) {
                    if (!entry.getValue().equals(texturedInventoryWrapper)) continue;
                    return entry.getKey();
                }
                return "";
            }

            @NotNull
            public String toVariableNameString(TexturedInventoryWrapper texturedInventoryWrapper) {
                return this.toString(texturedInventoryWrapper, 0);
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        if (Classes.getExactClassInfo(Action.class) == null) {
            Classes.registerClass((ClassInfo)new EnumClassInfo(Action.class, "action", "actions").user(new String[]{"actions?"}).name("Action").description(new String[]{"The action taken in an event."}).since("1.6"));
        }
        if (Classes.getExactClassInfo(BlockFace.class) == null) {
            Classes.registerClass((ClassInfo)new EnumClassInfo(BlockFace.class, "blockface", "block faces").user(new String[]{"block ?faces?"}).name("Block faces").description(new String[]{"The block face clicked in an event."}).since("1.6"));
        }
    }
}

