/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.Events.ResourcePackSendEvent;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Get URL of Resource Pack")
@Description(value={"Gets the URL of a resource pack."})
@Examples(value={"set {_t} to resource pack url"})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class ExprGetURL
extends SimpleExpression<String> {
    protected String[] get(Event e) {
        if (e instanceof ResourcePackSendEvent) {
            ResourcePackSendEvent rpEvent = (ResourcePackSendEvent)e;
            return new String[]{rpEvent.getUrl()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "resource pack url";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    static {
        Skript.registerExpression(ExprGetURL.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [ia|itemsadder] (texture|resource) pack (url|URL)"});
    }
}

