/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomEntity;
import dev.lone.itemsadder.api.CustomStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import jdk.jfr.Description;
import jdk.jfr.Name;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Get ID")
@Description(value="Gets the Namespaced:ID of your blocks, furnitures, or items.")
@Examples(value={"send id of itemsadder item player's tool"})
@Since(value="1.6")
@RequiredPlugins(value={"ItemsAdder"})
public class ExprGetID
extends SimpleExpression<String> {
    private Expression<?> expr;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[0];
        return true;
    }

    protected String[] get(Event event) {
        Object[] objects = this.expr.getArray(event);
        ArrayList<String> ids = new ArrayList<String>();
        for (Object object : objects) {
            CustomEntity customEntity;
            if (object instanceof ItemStack) {
                CustomStack customStack = CustomStack.byItemStack((ItemStack)((ItemStack)object));
                if (customStack == null) continue;
                ids.add(customStack.getNamespacedID());
                continue;
            }
            if (object instanceof Block) {
                CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)((Block)object));
                if (customBlock == null) continue;
                ids.add(customBlock.getNamespacedID());
                continue;
            }
            if (!(object instanceof Entity) || (customEntity = CustomEntity.byAlreadySpawned((Entity)((Entity)object))) == null) continue;
            ids.add(customEntity.getNamespacedID());
        }
        return ids.toArray(new String[0]);
    }

    public boolean isSingle() {
        return this.expr.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "id of [custom] (ia|itemsadder) " + this.expr.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprGetID.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"id of [custom] (ia|itemsadder) [item|block|furniture] %itemstacks/blocks/entities%"});
    }
}

