/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.FontImages.FontImageWrapper;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Get ItemsAdder Font Image")
@Description(value={"Gets ItemsAdder font image(s) with optional offset"})
@Examples(value={"send font image \"emojis:crying_emoji\"", "set {_t::*} to font images \"emojis:laughing_emoji\" and \"emojis:crying_emoji\" with x offset 2"})
@Since(value="1.0, 1.5 (Multiple Images), 1.6 (With Offset)")
@RequiredPlugins(value={"ItemsAdder"})
public class ExprGetFontImage
extends SimpleExpression<String> {
    private Expression<String> fontImageNames;
    private Expression<Integer> offset;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fontImageNames = exprs[0];
        this.offset = exprs[1];
        return true;
    }

    @Nullable
    protected String[] get(@NotNull Event e) {
        if (this.fontImageNames == null || this.fontImageNames.getArray(e) == null) {
            return null;
        }
        String[] strArray = (String[])this.fontImageNames.getArray(e);
        Integer offsetValue = this.offset != null ? (Integer)this.offset.getSingle(e) : 0;
        ArrayList<String> fontImages = new ArrayList<String>();
        for (String str : strArray) {
            FontImageWrapper fontImageWrapper = new FontImageWrapper(str);
            if (!fontImageWrapper.exists()) continue;
            fontImages.add(fontImageWrapper.applyPixelsOffset(offsetValue.intValue()));
        }
        return fontImages.toArray(new String[0]);
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return this.fontImageNames.isSingle();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "font images " + this.fontImageNames.toString(e, debug) + (String)(this.offset != null ? " with offset " + this.offset.toString(e, debug) : "");
    }

    static {
        Skript.registerExpression(ExprGetFontImage.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[font|custom|ia|itemsadder] image[s] %strings% [with [x] offset %-integer%]"});
    }
}

