/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.ItemsAdder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.aliases.CustomItemType;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="ItemsAdder Item")
@Description(value={"Gets an ItemsAdder item, or items."})
@Examples(value={"give player itemsadder item \"_iainternal:icon_arrow_chest\"", "give player itemsadder items \"_iainternal:icon_back_orange\" and \"_iainternal:icon_cancel\"", "send all itemsadder items to player", "set {_paperItems::*} to all itemsadder items that uses material paper"})
@Since(value="1.0, 1.5 (multiple items)")
@RequiredPlugins(value={"ItemsAdder"})
public class ExprGetCustomItem
extends SimpleExpression<ItemType> {
    private Expression<Object> itemTypes;
    private Expression<ItemStack> itemStacks;
    private boolean usesItemMaterial;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1) {
            boolean bl = this.usesItemMaterial = parseResult.mark == 1;
            if (this.usesItemMaterial) {
                this.itemStacks = exprs[0];
            } else {
                this.itemTypes = exprs[0];
            }
        } else {
            this.itemTypes = exprs[0];
        }
        return true;
    }

    protected ItemType[] get(Event e) {
        ArrayList<ItemType> items;
        block8: {
            block6: {
                block7: {
                    CustomStack customStack;
                    items = new ArrayList<ItemType>();
                    if (this.itemTypes == null) break block6;
                    if (!this.itemTypes.isSingle()) break block7;
                    Object itemType = this.itemTypes.getSingle(e);
                    if (itemType == null || (customStack = this.getCustomStack(itemType)) == null) break block8;
                    items.add(new ItemType(customStack.getItemStack()));
                    break block8;
                }
                for (Object itemType : this.itemTypes.getArray(e)) {
                    CustomStack customStack = this.getCustomStack(itemType);
                    if (customStack == null) continue;
                    items.add(new ItemType(customStack.getItemStack()));
                }
                break block8;
            }
            if (this.itemStacks != null) {
                for (ItemStack itemStack : (ItemStack[])this.itemStacks.getArray(e)) {
                    Material material = itemStack.getType();
                    List customStacks = ItemsAdder.getAllItems((Material)material);
                    for (CustomStack customStack : customStacks) {
                        items.add(new ItemType(customStack.getItemStack()));
                    }
                }
            } else {
                List customStacks = ItemsAdder.getAllItems();
                for (CustomStack customStack : customStacks) {
                    items.add(new ItemType(customStack.getItemStack()));
                }
            }
        }
        return items.toArray(new ItemType[0]);
    }

    private CustomStack getCustomStack(Object itemType) {
        if (itemType instanceof CustomItemType) {
            return CustomStack.getInstance((String)((CustomItemType)itemType).getNamespacedID());
        }
        if (itemType instanceof String) {
            return CustomStack.getInstance((String)((String)itemType));
        }
        return null;
    }

    public boolean isSingle() {
        return this.itemTypes != null && this.itemTypes.isSingle();
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.usesItemMaterial) {
            return "ItemsAdder items that use item material " + this.itemStacks.toString(e, debug);
        }
        return "ItemsAdder items " + this.itemTypes.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprGetCustomItem.class, ItemType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[custom] (ia|itemsadder) item[s] %customitemtypes/strings%", "(all [[of] the]) [custom] (ia|itemsadder) item[s] [1:(that uses|using) [item[s]|material[s]] %-itemstacks%]"});
    }
}

