/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.lone.itemsadder.api.CustomCrop;
import javax.annotation.Nullable;
import jdk.jfr.Description;
import jdk.jfr.Name;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Crop Age")
@Description(value="Get or Set the age of a crop, or get the maximum age of one.")
@Examples(value={"send maximum age of custom itemsadder block {_crop}"})
@Since(value="1.6")
@RequiredPlugins(value={"ItemsAdder"})
public class ExprCropAge
extends SimpleExpression<Number> {
    private Expression<Block> block;
    private boolean maxAge;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.block = exprs[0];
        this.maxAge = parseResult.hasTag("max");
        return true;
    }

    @Nullable
    protected Number[] get(Event e) {
        Block[] bs = (Block[])this.block.getArray(e);
        Number[] ages = new Number[bs.length];
        for (int i = 0; i < bs.length; ++i) {
            CustomCrop crop = CustomCrop.byAlreadyPlaced((Block)bs[i]);
            if (crop == null) continue;
            ages[i] = this.maxAge ? crop.getMaxAge() : crop.getAge();
        }
        return ages;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "age of " + this.block.toString(e, debug);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return new Class[]{Number.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta.length != 0) {
            Block[] bs;
            int age = ((Number)delta[0]).intValue();
            block5: for (Block b : bs = (Block[])this.block.getArray(e)) {
                CustomCrop crop = CustomCrop.byAlreadyPlaced((Block)b);
                if (crop == null) continue;
                switch (mode) {
                    case SET: {
                        crop.setAge(age);
                        continue block5;
                    }
                    case ADD: {
                        crop.setAge(crop.getAge() + age);
                        continue block5;
                    }
                    case REMOVE: {
                        crop.setAge(crop.getAge() - age);
                    }
                }
            }
        }
    }

    static {
        Skript.registerExpression(ExprCropAge.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [:max[imum]] age of [custom] (ia|itemsadder) %blocks%", "[custom] (ia|itemsadder) %blocks%'[s] [:max[imum]] age"});
    }
}

