/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.events.other;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import dev.lone.itemsadder.api.Events.CustomEntityDeathEvent;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="On Custom Entity Death")
@Description(value={"Fires when a ItemsAdder Entity dies."})
@Examples(value={"on custom entity death:"})
@Since(value="1.0")
@RequiredPlugins(value={"ItemsAdder"})
public class EvtCustomEntityDeath
extends SkriptEvent {
    private Literal<String> mobID;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.mobID = args[0];
        return true;
    }

    public boolean check(Event e) {
        if (e instanceof CustomEntityDeathEvent) {
            CustomEntityDeathEvent event = (CustomEntityDeathEvent)e;
            if (this.mobID == null) {
                return true;
            }
            String id = event.getNamespacedID();
            return id.equals(this.mobID.getSingle(e));
        }
        return false;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "ItemsAdder custom entity " + (this.mobID != null ? this.mobID.toString(e, debug) : "") + " death";
    }

    static {
        Skript.registerEvent((String)"Custom Entity Death", EvtCustomEntityDeath.class, CustomEntityDeathEvent.class, (String[])new String[]{"[custom] (ia|itemsadder) entity death [of %string%]"}).description(new String[]{"Fires when a ItemsAdder Entity dies."}).examples(new String[]{"on itemsadder entity death:"}).since("1.0").requiredPlugins(new String[]{"ItemsAdder"});
        EventValues.registerEventValue(CustomEntityDeathEvent.class, Entity.class, (Getter)new Getter<Entity, CustomEntityDeathEvent>(){

            @Nullable
            public Entity get(CustomEntityDeathEvent customEntityDeathEvent) {
                return customEntityDeathEvent.getEntity();
            }
        }, (int)0);
        EventValues.registerEventValue(CustomEntityDeathEvent.class, Location.class, (Getter)new Getter<Location, CustomEntityDeathEvent>(){

            @Nullable
            public Location get(CustomEntityDeathEvent customEntityDeathEvent) {
                return customEntityDeathEvent.getEntity().getLocation();
            }
        }, (int)0);
        EventValues.registerEventValue(CustomEntityDeathEvent.class, Entity.class, (Getter)new Getter<Entity, CustomEntityDeathEvent>(){

            @Nullable
            public Entity get(CustomEntityDeathEvent customEntityDeathEvent) {
                return customEntityDeathEvent.getKiller();
            }
        }, (int)0);
    }
}

