/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.events.furniture;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import dev.lone.itemsadder.api.CustomFurniture;
import dev.lone.itemsadder.api.Events.FurnitureBreakEvent;
import dev.lone.itemsadder.api.Events.FurniturePlaceSuccessEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EvtCustomFurnitureSuccessEvent
extends SkriptEvent {
    private Literal<?>[] furnitureIDs;
    private List<String> aliases;
    private AliasesGenerator aliasesGenerator = SkriptItemsAdder.getInstance().getAliasesGenerator();

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.furnitureIDs = args;
        if (this.furnitureIDs != null) {
            this.aliases = Arrays.stream(this.furnitureIDs).flatMap(literal -> {
                if (literal != null) {
                    return Arrays.stream(literal.getArray()).map(Util::getCustomBlockId);
                }
                return Stream.empty();
            }).filter(name -> name != null).collect(Collectors.toList());
        }
        return true;
    }

    public boolean check(Event event) {
        if (event instanceof FurnitureBreakEvent) {
            FurnitureBreakEvent furnEvent = (FurnitureBreakEvent)event;
            if (this.aliases != null && !this.aliases.isEmpty()) {
                String actualFurnitureName = Util.getCustomBlockId(furnEvent.getNamespacedID());
                return this.aliases.contains(actualFurnitureName);
            }
            return !furnEvent.isCancelled();
        }
        return false;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Furniture Place Success event" + (String)(this.furnitureIDs != null ? " with id " + Arrays.toString(this.furnitureIDs) : "");
    }

    static {
        Skript.registerEvent((String)"Custom Furniture Success", EvtCustomFurnitureSuccessEvent.class, FurniturePlaceSuccessEvent.class, (String[])new String[]{"success[fully] plac(e|ing) [a] [custom] (ia|itemsadder) furniture [%customitemtypes/strings%]", "place success [of] [custom] (ia|itemsadder) furniture [%customitemtypes/strings%]"}).description(new String[]{"This event is called when a furniture is successfully placed into the world, use this event instead if you would like to know the location."}).examples(new String[]{"on place success of custom itemsadder furniture:", "on successfully placing a custom itemsadder furniture:"}).since("1.5").requiredPlugins(new String[]{"ItemsAdder"});
        EventValues.registerEventValue(FurniturePlaceSuccessEvent.class, Location.class, (Getter)new Getter<Location, FurniturePlaceSuccessEvent>(){

            public Location get(FurniturePlaceSuccessEvent arg) {
                return arg.getBukkitEntity().getLocation();
            }
        }, (int)0);
        EventValues.registerEventValue(FurniturePlaceSuccessEvent.class, CustomFurniture.class, (Getter)new Getter<CustomFurniture, FurniturePlaceSuccessEvent>(){

            @Nullable
            public CustomFurniture get(FurniturePlaceSuccessEvent event) {
                return event.getFurniture();
            }
        }, (int)0);
    }
}

