/*
 * Decompiled with CFR 0.152.
 */
package me.asleepp.SkriptItemsAdder.elements.events.furniture;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import dev.lone.itemsadder.api.Events.FurnitureBreakEvent;
import dev.lone.itemsadder.api.Events.FurniturePlaceEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.asleepp.SkriptItemsAdder.SkriptItemsAdder;
import me.asleepp.SkriptItemsAdder.aliases.AliasesGenerator;
import me.asleepp.SkriptItemsAdder.util.Util;
import org.bukkit.event.Event;

public class EvtCustomFurniturePlace
extends SkriptEvent {
    private Literal<?>[] furnitureIDs;
    private List<String> aliases;
    private AliasesGenerator aliasesGenerator = SkriptItemsAdder.getInstance().getAliasesGenerator();

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.furnitureIDs = args;
        if (this.furnitureIDs != null) {
            this.aliases = Arrays.stream(this.furnitureIDs).flatMap(literal -> {
                if (literal != null) {
                    return Arrays.stream(literal.getArray()).map(Util::getCustomBlockId);
                }
                return Stream.empty();
            }).filter(name -> name != null).collect(Collectors.toList());
        }
        return true;
    }

    public boolean check(Event event) {
        if (event instanceof FurnitureBreakEvent) {
            FurnitureBreakEvent furnEvent = (FurnitureBreakEvent)event;
            if (this.aliases != null && !this.aliases.isEmpty()) {
                String actualFurnitureName = Util.getCustomBlockId(furnEvent.getNamespacedID());
                return this.aliases.contains(actualFurnitureName);
            }
            return !furnEvent.isCancelled();
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Custom Furniture Place event";
    }

    static {
        Skript.registerEvent((String)"Custom Furniture Place", EvtCustomFurniturePlace.class, FurniturePlaceEvent.class, (String[])new String[]{"place [of] [custom] (ia|itemsadder) furniture [%customitemtypes/strings%]"}).description(new String[]{"Fires when a ItemsAdder furniture gets placed."}).examples(new String[]{"on place of itemsadder furniture:"}).since("1.0").requiredPlugins(new String[]{"ItemsAdder"});
    }
}

